/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.DatatypeReasonerImpl;
import com.clarkparsia.pellet.utils.PropertiesBuilder;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.ontology.AllValuesFromRestriction;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.CardinalityRestriction;
import com.hp.hpl.jena.ontology.ComplementClass;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.EnumeratedClass;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.IntersectionClass;
import com.hp.hpl.jena.ontology.InverseFunctionalProperty;
import com.hp.hpl.jena.ontology.MaxCardinalityRestriction;
import com.hp.hpl.jena.ontology.MinCardinalityRestriction;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.UnionClass;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import junit.framework.JUnit4TestAdapter;
import junit.textui.TestRunner;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.ModelExtractor;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasoner;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.ATermUtils;

public class JenaTests {
    public static String base = "file:" + PelletTestSuite.base + "misc/";

    public static void main(String[] args) {
        TestRunner.run((junit.framework.Test)JenaTests.suite());
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(JenaTests.class);
    }

    @Test
    public void testIncrementalABoxAddition() throws MalformedURLException {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        ObjectProperty p = model.createObjectProperty("p");
        ObjectProperty t = model.createObjectProperty("t");
        DatatypeProperty q = model.createDatatypeProperty("q");
        AnnotationProperty r = model.createAnnotationProperty("r");
        Individual a = model.createIndividual("a", OWL.Thing);
        Individual b = model.createIndividual("b", OWL.Thing);
        model.add((Resource)t, RDF.type, (RDFNode)OWL.TransitiveProperty);
        model.prepare();
        Resource bnode1 = model.createResource();
        Resource bnode2 = model.createResource();
        Resource c = ResourceFactory.createResource();
        Resource d = ResourceFactory.createResource();
        model.add((Resource)a, (Property)p, (RDFNode)b);
        model.add(d, (Property)p, (RDFNode)b);
        model.add((Resource)a, (Property)p, (RDFNode)c);
        model.add((Resource)a, (Property)q, (RDFNode)model.createLiteral("l"));
        model.add((Resource)a, (Property)t, (RDFNode)bnode1);
        model.add(bnode1, (Property)t, (RDFNode)bnode2);
        Assert.assertTrue((boolean)model.contains((Resource)a, (Property)t, (RDFNode)bnode2));
        model.prepare();
        model.add((Resource)a, (Property)r, (RDFNode)model.createLiteral("l"));
        model.add((Resource)a, (Property)r, (RDFNode)model.createResource());
        Assert.assertTrue((boolean)model.validate().isValid());
        model.prepare();
        model.add((Resource)p, RDF.type, (RDFNode)OWL.FunctionalProperty);
        model.add((Resource)b, OWL.differentFrom, (RDFNode)c);
        model.prepare();
        Assert.assertFalse((boolean)model.validate().isValid());
        model.remove((Resource)b, OWL.differentFrom, (RDFNode)c);
        Assert.assertTrue((boolean)model.validate().isValid());
        model.prepare();
        model.add((Resource)p, RDF.type, (RDFNode)OWL.InverseFunctionalProperty);
        model.add((Resource)a, OWL.differentFrom, (RDFNode)d);
        Assert.assertFalse((boolean)model.validate().isValid());
    }

    @Test
    public void testInverse() {
        String ns = "http://www.example.org/test#";
        OntModel ont = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        ObjectProperty p1 = ont.createObjectProperty(ns + "p1");
        ObjectProperty p2 = ont.createObjectProperty(ns + "p2");
        ObjectProperty p3 = ont.createObjectProperty(ns + "p3");
        p2.addSubProperty((Property)p1);
        p2.addInverseOf((Property)p3);
        Individual s1 = ont.createIndividual(ns + "s1", OWL.Thing);
        Individual o1 = ont.createIndividual(ns + "o1", OWL.Thing);
        Individual s2 = ont.createIndividual(ns + "s2", OWL.Thing);
        Individual o2 = ont.createIndividual(ns + "o2", OWL.Thing);
        Individual s3 = ont.createIndividual(ns + "s3", OWL.Thing);
        Individual o3 = ont.createIndividual(ns + "o3", OWL.Thing);
        s1.addProperty((Property)p1, (RDFNode)o1);
        s2.addProperty((Property)p2, (RDFNode)o2);
        s3.addProperty((Property)p3, (RDFNode)o3);
        Statement stmt = ont.createStatement((Resource)o1, (Property)p3, (RDFNode)s1);
        PelletTestCase.assertIteratorContains(o1.listPropertyValues((Property)p3), s1);
        Assert.assertTrue((boolean)ont.contains(stmt));
        PelletTestCase.assertIteratorContains(ont.listStatements(null, (Property)p3, (RDFNode)null), stmt);
        PelletTestCase.assertIteratorContains(ont.listStatements((Resource)o1, null, (RDFNode)null), stmt);
        PelletTestCase.assertIteratorContains(ont.listStatements(), stmt);
        Assert.assertFalse((boolean)ont.contains((Resource)o3, (Property)p1, (RDFNode)s3));
        Assert.assertTrue((boolean)p2.isInverseOf((Property)p3));
        PelletTestCase.assertIteratorValues(p2.listInverseOf(), new Property[]{p3});
        Assert.assertTrue((boolean)p3.isInverseOf((Property)p2));
        PelletTestCase.assertIteratorValues(p3.listInverseOf(), new Property[]{p2});
    }

    @Test
    public void testOWL2() {
        String ns = "http://www.example.org/test#";
        OntModel factory = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "owl2.owl");
        OntClass C = model.getOntClass(ns + "C");
        OntClass D = model.getOntClass(ns + "D");
        OntClass D1 = model.getOntClass(ns + "D1");
        OntClass D2 = model.getOntClass(ns + "D2");
        OntClass D3 = model.getOntClass(ns + "D3");
        OntClass test1 = model.getOntClass(ns + "test1");
        OntClass test2 = model.getOntClass(ns + "test2");
        OntClass test3 = model.getOntClass(ns + "test3");
        OntClass OlderThan10 = model.getOntClass(ns + "OlderThan10");
        OntClass YoungerThan20 = model.getOntClass(ns + "youngerThan20");
        OntClass Teenager = model.getOntClass(ns + "Teenager");
        OntClass Teen = model.getOntClass(ns + "Teen");
        Individual ind1 = model.getIndividual(ns + "ind1");
        Individual ind3 = model.getIndividual(ns + "ind3");
        Individual ind4 = model.getIndividual(ns + "ind4");
        Individual ind5 = model.getIndividual(ns + "ind5");
        Individual ind6 = model.getIndividual(ns + "ind6");
        Individual ind7 = model.getIndividual(ns + "ind7");
        Individual ind8 = model.getIndividual(ns + "ind8");
        DatatypeProperty dp = model.getDatatypeProperty(ns + "dp");
        ObjectProperty p = model.getObjectProperty(ns + "p");
        ObjectProperty r = model.getObjectProperty(ns + "r");
        ObjectProperty invR = model.getObjectProperty(ns + "invR");
        ObjectProperty ir = model.getObjectProperty(ns + "ir");
        ObjectProperty as = model.getObjectProperty(ns + "as");
        ObjectProperty d1 = model.getObjectProperty(ns + "d1");
        ObjectProperty d2 = model.getObjectProperty(ns + "d2");
        model.prepare();
        Assert.assertTrue((boolean)r.hasRDFType(OWL2.ReflexiveProperty));
        Assert.assertTrue((boolean)invR.hasRDFType(OWL2.ReflexiveProperty));
        Assert.assertTrue((boolean)ir.hasRDFType(OWL2.IrreflexiveProperty));
        Assert.assertTrue((boolean)as.hasRDFType(OWL2.AsymmetricProperty));
        UnionClass union = factory.createUnionClass(null, factory.createList(new RDFNode[]{D1, D2, D3}));
        Assert.assertTrue((boolean)model.listStatements((Resource)D, OWL.equivalentClass, (RDFNode)union, (Model)factory).hasNext());
        Assert.assertTrue((boolean)model.contains((Resource)D, OWL.equivalentClass, (RDFNode)test1));
        Assert.assertTrue((boolean)D1.isDisjointWith((Resource)D2));
        Assert.assertTrue((boolean)D1.isDisjointWith((Resource)D3));
        Assert.assertTrue((boolean)D2.isDisjointWith((Resource)D3));
        Assert.assertTrue((boolean)model.contains((Resource)d1, OWL2.propertyDisjointWith, (RDFNode)d2));
        Assert.assertTrue((boolean)model.contains((Resource)d2, OWL2.propertyDisjointWith, (RDFNode)d1));
        Assert.assertTrue((boolean)model.contains((Resource)ind1, (Property)r, (RDFNode)ind1));
        Assert.assertTrue((boolean)model.contains((Resource)ind1, (Property)invR, (RDFNode)ind1));
        Assert.assertTrue((boolean)model.contains((Resource)ind1, OWL.differentFrom, (RDFNode)ind3));
        Assert.assertTrue((boolean)model.contains((Resource)ind1, OWL.differentFrom, (RDFNode)ind4));
        Assert.assertTrue((boolean)model.contains((Resource)ind5, OWL.differentFrom, (RDFNode)ind6));
        Assert.assertTrue((boolean)model.contains((Resource)ind1, (Property)p, (RDFNode)ind1));
        Assert.assertTrue((boolean)model.contains((Resource)ind1, RDF.type, (RDFNode)test2));
        Assert.assertTrue((boolean)model.contains((Resource)ind1, RDF.type, (RDFNode)test3));
        Assert.assertTrue((boolean)model.contains((Resource)ind7, OWL.differentFrom, (RDFNode)ind8));
        Assert.assertTrue((boolean)model.contains((Resource)ind8, OWL.differentFrom, (RDFNode)ind7));
        Assert.assertTrue((boolean)model.contains((Resource)ind1, (Property)dp, (RDFNode)model.createTypedLiteral(false)));
        PelletTestCase.assertIteratorValues(ind1.listRDFTypes(false), new Object[]{OWL.Thing, C, test2, test3});
        Assert.assertTrue((boolean)model.contains((Resource)Teenager, RDFS.subClassOf, (RDFNode)OlderThan10));
        Assert.assertTrue((boolean)model.contains((Resource)Teenager, RDFS.subClassOf, (RDFNode)YoungerThan20));
        Assert.assertTrue((boolean)model.contains((Resource)Teenager, OWL.equivalentClass, (RDFNode)Teen));
    }

    @Test
    public void testUncle() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "uncle.owl");
        Individual Bob = model.getIndividual(ns + "Bob");
        Individual Sam = model.getIndividual(ns + "Sam");
        Property uncleOf = model.getProperty(ns + "uncleOf");
        Model uncleValues = ModelFactory.createDefaultModel();
        PelletTestCase.addStatements(uncleValues, (Resource)Bob, uncleOf, new RDFNode[]{Sam});
        PelletTestCase.assertPropertyValues((Model)model, uncleOf, uncleValues);
    }

    @Test
    public void testQualifiedCardinality1() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "qcr.owl");
        OntClass sub = model.getOntClass(ns + "sub");
        OntClass sup = model.getOntClass(ns + "sup");
        Assert.assertTrue((boolean)sub.hasSuperClass((Resource)sup));
        PelletTestCase.assertIteratorContains(sub.listSuperClasses(), sup);
        PelletTestCase.assertIteratorContains(sup.listSubClasses(), sub);
    }

    @Test
    public void testInvalidTransitivity() {
        OntModel ont = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass C = ont.createClass("C");
        ObjectProperty p1 = ont.createObjectProperty("p1");
        p1.addRDFType(OWL.TransitiveProperty);
        ObjectProperty p2 = ont.createObjectProperty("p2");
        Individual x = ont.createIndividual(OWL.Thing);
        Individual y = ont.createIndividual(OWL.Thing);
        Individual z = ont.createIndividual(OWL.Thing);
        x.addRDFType((Resource)ont.createAllValuesFromRestriction(null, (Property)p1, (Resource)C));
        x.addProperty((Property)p1, (RDFNode)y);
        y.addProperty((Property)p1, (RDFNode)z);
        ont.prepare();
        OntModel pellet = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)ont);
        Assert.assertTrue((boolean)pellet.contains((Resource)y, RDF.type, (RDFNode)C));
        Assert.assertTrue((boolean)pellet.contains((Resource)z, RDF.type, (RDFNode)C));
        Statement[] statements = new Statement[]{ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL.FunctionalProperty), ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL.InverseFunctionalProperty), ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL2.IrreflexiveProperty), ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL2.AsymmetricProperty), ont.createStatement((Resource)p1, OWL2.propertyDisjointWith, (RDFNode)p2), ont.createStatement((Resource)C, RDFS.subClassOf, (RDFNode)ont.createMinCardinalityRestriction(null, (Property)p1, 2)), ont.createStatement((Resource)x, RDF.type, (RDFNode)ont.createMaxCardinalityRestriction(null, (Property)p1, 3)), ont.createStatement((Resource)C, OWL.disjointWith, (RDFNode)ont.createCardinalityRestriction(null, (Property)p1, 2))};
        for (int i = 0; i < statements.length; ++i) {
            ont.add(statements[i]);
            pellet = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)ont);
            Assert.assertTrue((String)statements[i].toString(), (boolean)pellet.contains((Resource)y, RDF.type, (RDFNode)C));
            Assert.assertFalse((String)statements[i].toString(), (boolean)pellet.contains((Resource)z, RDF.type, (RDFNode)C));
            ont.remove(statements[i]);
        }
    }

    @Test
    public void testInvalidComplexSubRole() {
        OntModel ont = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass C = ont.createClass("C");
        ObjectProperty p1 = ont.createObjectProperty("p1");
        ObjectProperty p2 = ont.createObjectProperty("p2");
        RDFList pChain = ont.createList(new RDFNode[]{p1, p2});
        ont.add((Resource)p1, OWL2.propertyChainAxiom, (RDFNode)pChain);
        Individual x = ont.createIndividual(OWL.Thing);
        Individual y = ont.createIndividual(OWL.Thing);
        Individual z = ont.createIndividual(OWL.Thing);
        x.addProperty((Property)p1, (RDFNode)y);
        y.addProperty((Property)p2, (RDFNode)z);
        ont.prepare();
        OntModel pellet = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)ont);
        Assert.assertTrue((boolean)pellet.contains((Resource)x, (Property)p1, (RDFNode)y));
        Assert.assertTrue((boolean)pellet.contains((Resource)x, (Property)p1, (RDFNode)z));
        MinCardinalityRestriction min = ont.createMinCardinalityRestriction(null, (Property)p1, 2);
        MaxCardinalityRestriction max = ont.createMaxCardinalityRestriction(null, (Property)p1, 3);
        CardinalityRestriction card = ont.createCardinalityRestriction(null, (Property)p1, 2);
        Statement[] statements = new Statement[]{ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL.FunctionalProperty), ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL.InverseFunctionalProperty), ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL2.IrreflexiveProperty), ont.createStatement((Resource)p1, RDF.type, (RDFNode)OWL2.AsymmetricProperty), ont.createStatement((Resource)p1, OWL2.propertyDisjointWith, (RDFNode)p2), ont.createStatement((Resource)C, RDFS.subClassOf, (RDFNode)min), ont.createStatement((Resource)x, RDF.type, (RDFNode)max), ont.createStatement((Resource)C, OWL.disjointWith, (RDFNode)card)};
        for (int i = 0; i < statements.length; ++i) {
            ont.add(statements[i]);
            pellet = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)ont);
            Assert.assertTrue((String)statements[i].toString(), (boolean)pellet.contains((Resource)x, (Property)p1, (RDFNode)y));
            Assert.assertFalse((String)statements[i].toString(), (boolean)pellet.contains((Resource)x, (Property)p1, (RDFNode)z));
            ont.remove(statements[i]);
        }
    }

    @Test
    public void testReflexive2() {
        String ns = "http://www.example.org/test#";
        String foaf = "http://xmlns.com/foaf/0.1/";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "reflexive.owl");
        ObjectProperty[] knows = new ObjectProperty[]{model.getObjectProperty(foaf + "knows"), model.getObjectProperty(ns + "knows2"), model.getObjectProperty(ns + "knows3")};
        Individual[] people = new Individual[5];
        for (int j = 0; j < knows.length; ++j) {
            Model knowsRelations = ModelFactory.createDefaultModel();
            for (int i = 0; i < people.length; ++i) {
                people[i] = model.getIndividual(ns + "P" + (i + 1));
                knowsRelations.add((Resource)people[i], (Property)knows[j], (RDFNode)people[i]);
            }
            PelletTestCase.assertPropertyValues((Model)model, (Property)knows[j], knowsRelations);
        }
    }

    @Test
    public void testEscher1() {
        String ns = "foo://bla/names#";
        String source = "@prefix owl: <http://www.w3.org/2002/07/owl#>.\r\n@prefix owl11: <http://www.w3.org/2006/12/owl11#>.\r\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>.\r\n@prefix : <foo://bla/names#>.\r\n\r\n:Corner owl:oneOf (:a :b :c);\r\n  rdfs:subClassOf\r\n  [a owl:Restriction; owl:onProperty :higher; owl:cardinality 1].\r\nowl:AllDifferent owl:distinctMembers (:a :b :c).\r\n:higher rdfs:domain :Corner; rdfs:range :Corner.\r\n:higher a owl:FunctionalProperty. ## redundant, note cardinality 1\r\n:higher a owl:AsymmetricProperty.\r\n:higher a owl11:IrreflexiveProperty.\r\n:a :higher :b.\r\n";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read((Reader)new StringReader(source), "", "N3");
        model.prepare();
        Resource a = model.getResource(ns + "a");
        Resource b = model.getResource(ns + "b");
        Resource c = model.getResource(ns + "c");
        OntProperty higher = model.getOntProperty(ns + "higher");
        PelletTestCase.assertIteratorValues(model.listStatements(null, (Property)higher, (RDFNode)null), new Statement[]{model.createStatement(a, (Property)higher, (RDFNode)b), model.createStatement(b, (Property)higher, (RDFNode)c), model.createStatement(c, (Property)higher, (RDFNode)a)});
    }

    @Test
    public void testEscher2() {
        String ns = "foo://bla/names#";
        String source = "@prefix owl: <http://www.w3.org/2002/07/owl#>.\r\n@prefix owl11: <http://www.w3.org/2006/12/owl11#>.\r\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>.\r\n@prefix : <foo://bla/names#>.\r\n\r\n:Corner owl:oneOf (:a :b :c);\r\n  rdfs:subClassOf\r\n  [a owl:Restriction; owl:onProperty :higher; owl:cardinality 1].\r\nowl:AllDifferent owl:distinctMembers (:a :b :c).\r\n:higher rdfs:domain :Corner; rdfs:range :Corner.\r\n:higher a owl:FunctionalProperty. ## redundant, note cardinality 1\r\n:higher a owl:AsymmetricProperty.\r\n:higher a owl11:IrreflexiveProperty.\r\n:a :higher :b.\r\n:b :higher :d. :d a :Corner.\r\n:c a owl:Thing.\r\n";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read((Reader)new StringReader(source), "", "N3");
        model.prepare();
        Individual a = model.getIndividual(ns + "a");
        Individual b = model.getIndividual(ns + "b");
        Individual c = model.getIndividual(ns + "c");
        Individual d = model.getIndividual(ns + "d");
        OntProperty higher = model.getOntProperty(ns + "higher");
        PelletTestCase.assertIteratorValues(model.listStatements(null, (Property)higher, (RDFNode)null), new Statement[]{model.createStatement((Resource)a, (Property)higher, (RDFNode)b), model.createStatement((Resource)b, (Property)higher, (RDFNode)c), model.createStatement((Resource)b, (Property)higher, (RDFNode)d), model.createStatement((Resource)c, (Property)higher, (RDFNode)a), model.createStatement((Resource)d, (Property)higher, (RDFNode)a)});
        Assert.assertTrue((boolean)c.isSameAs((Resource)d));
        Assert.assertTrue((boolean)d.isSameAs((Resource)c));
    }

    @Test
    public void testDatatypeCardinality() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass C1 = model.createClass(ns + "C1");
        OntClass C2 = model.createClass(ns + "C2");
        DatatypeProperty p = model.createDatatypeProperty(ns + "p");
        p.addRange(XSD.xboolean);
        C1.addSuperClass((Resource)model.createMinCardinalityRestriction(null, (Property)p, 2));
        C2.addSuperClass((Resource)model.createMinCardinalityRestriction(null, (Property)p, 3));
        model.prepare();
        Assert.assertTrue((boolean)((PelletInfGraph)model.getGraph()).getKB().isConsistent());
        Assert.assertTrue((!model.contains((Resource)C1, RDFS.subClassOf, (RDFNode)OWL.Nothing) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)model.contains((Resource)C2, RDFS.subClassOf, (RDFNode)OWL.Nothing));
    }

    @Test
    public void testIFDP1() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Individual a = model.createIndividual(ns + "a", OWL.Thing);
        Individual b = model.createIndividual(ns + "b", OWL.Thing);
        Individual c = model.createIndividual(ns + "c", OWL.Thing);
        ObjectProperty op = model.createObjectProperty(ns + "op");
        DatatypeProperty dp = model.createDatatypeProperty(ns + "dp");
        dp.convertToInverseFunctionalProperty();
        a.addProperty((Property)op, (RDFNode)c);
        Literal one = model.createTypedLiteral((Object)1);
        a.addProperty((Property)dp, (RDFNode)one);
        b.addProperty((Property)dp, (RDFNode)one);
        model.prepare();
        Assert.assertTrue((boolean)a.isSameAs((Resource)b));
        PelletTestCase.assertIteratorValues(a.listSameAs(), new Resource[]{a, b});
        Assert.assertTrue((boolean)b.hasProperty((Property)op, (RDFNode)c));
        PelletTestCase.assertIteratorValues(b.listPropertyValues((Property)op), new Resource[]{c});
    }

    @Ignore(value="Inverse functional datatype properties are only supported with asserted literals")
    @Test
    public void testIFDP2() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.setStrictMode(false);
        DatatypeProperty p = model.createDatatypeProperty(ns + "p");
        p.addRDFType(OWL.InverseFunctionalProperty);
        p.addRange(XSD.xboolean);
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)p, 1));
        OntClass D = model.createClass(ns + "D");
        OntClass E = model.createClass(ns + "E");
        D.addDisjointWith((Resource)E);
        Individual i1 = model.createIndividual(ns + "i1", (Resource)C);
        i1.addRDFType((Resource)D);
        Individual i2 = model.createIndividual(ns + "i2", (Resource)C);
        i2.addRDFType((Resource)D);
        Individual i3 = model.createIndividual(ns + "i3", (Resource)C);
        i3.addRDFType((Resource)E);
        model.prepare();
        Assert.assertTrue((boolean)i1.isSameAs((Resource)i2));
        PelletTestCase.assertIteratorValues(i1.listSameAs(), new Resource[]{i1, i2});
        Assert.assertTrue((!i1.isSameAs((Resource)i3) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)i1.listProperties((Property)p).hasNext());
        Assert.assertFalse((boolean)i2.listProperties((Property)p).hasNext());
        Assert.assertFalse((boolean)i3.listProperties((Property)p).hasNext());
    }

    @Test
    public void testIFDP3() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        DatatypeProperty dp = model.createDatatypeProperty(ns + "dp");
        dp.addRange(XSD.nonNegativeInteger);
        dp.convertToInverseFunctionalProperty();
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createMinCardinalityRestriction(null, (Property)dp, 1));
        Individual a = model.createIndividual(ns + "a", (Resource)C);
        Individual b = model.createIndividual(ns + "b", (Resource)C);
        Individual c = model.createIndividual(ns + "c", (Resource)C);
        Literal zero = model.createTypedLiteral((Object)0);
        a.addProperty((Property)dp, (RDFNode)zero);
        b.addRDFType((Resource)model.createAllValuesFromRestriction(null, (Property)dp, XSD.nonPositiveInteger));
        Literal one = model.createTypedLiteral((Object)1);
        c.addProperty((Property)dp, (RDFNode)one);
        model.prepare();
        Assert.assertTrue((boolean)a.isSameAs((Resource)b));
        Assert.assertTrue((boolean)b.isSameAs((Resource)a));
        PelletTestCase.assertIteratorValues(a.listSameAs(), new Resource[]{a, b});
        PelletTestCase.assertIteratorValues(b.listSameAs(), new Resource[]{a, b});
        Assert.assertTrue((!c.isSameAs((Resource)a) ? 1 : 0) != 0);
        Assert.assertTrue((!c.isSameAs((Resource)b) ? 1 : 0) != 0);
    }

    @Test
    public void testDuplicateLiterals() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        DatatypeProperty dp = model.createDatatypeProperty(ns + "dp");
        OntClass C = model.createClass(ns + "C");
        Individual a = model.createIndividual(ns + "a", (Resource)C);
        Literal one = model.createTypedLiteral("1", TypeMapper.getInstance().getTypeByName(XSD.positiveInteger.getURI()));
        a.addProperty((Property)dp, (RDFNode)one);
        model.prepare();
        Literal oneDecimal = model.createTypedLiteral("1", TypeMapper.getInstance().getTypeByName(XSD.decimal.getURI()));
        PelletTestCase.assertIteratorValues(a.listPropertyValues((Property)dp), new Literal[]{one});
        Assert.assertTrue((boolean)a.hasProperty((Property)dp, (RDFNode)oneDecimal));
    }

    @Test
    public void testClosedUniverse() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "ClosedUniverse.owl");
        model.prepare();
        OntClass Unsat = model.getOntClass(ns + "Unsat");
        Assert.assertTrue((boolean)Unsat.hasSuperClass(OWL.Nothing));
    }

    @Test
    public void deprecatedSelfRestrictionSyntax() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "/deprecatedSelf.owl");
        model.prepare();
        Assert.assertTrue((boolean)((PelletInfGraph)model.getGraph()).getKB().isConsistent());
        Property knows = model.getProperty(ns + "knows");
        Individual p1 = model.getIndividual(ns + "P1");
        Individual p2 = model.getIndividual(ns + "P2");
        Assert.assertTrue((boolean)model.contains((Resource)p1, knows, (RDFNode)p1));
        Assert.assertFalse((boolean)model.contains((Resource)p2, knows, (RDFNode)p2));
    }

    @Test
    public void entityDeclarations() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "/entityDeclarations.owl");
        model.prepare();
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isIndividual((ATerm)ATermUtils.makeTermAppl((String)(ns + "a"))));
        Assert.assertEquals((long)1L, (long)kb.getIndividuals().size());
        Assert.assertTrue((boolean)kb.isClass((ATerm)ATermUtils.makeTermAppl((String)(ns + "C"))));
        Assert.assertEquals((long)1L, (long)kb.getClasses().size());
        Assert.assertFalse((boolean)kb.isDatatype(ATermUtils.makeTermAppl((String)(ns + "C"))));
        Assert.assertFalse((boolean)kb.isClass((ATerm)ATermUtils.makeTermAppl((String)(ns + "D"))));
        Assert.assertTrue((boolean)kb.isDatatype(ATermUtils.makeTermAppl((String)(ns + "D"))));
        Assert.assertTrue((boolean)kb.isAnnotationProperty((ATerm)ATermUtils.makeTermAppl((String)(ns + "p"))));
        Assert.assertEquals((long)9L, (long)kb.getAnnotationProperties().size());
        Assert.assertFalse((boolean)kb.isDatatypeProperty((ATerm)ATermUtils.makeTermAppl((String)(ns + "p"))));
        Assert.assertFalse((boolean)kb.isObjectProperty((ATerm)ATermUtils.makeTermAppl((String)(ns + "p"))));
        Assert.assertTrue((boolean)kb.isObjectProperty((ATerm)ATermUtils.makeTermAppl((String)(ns + "q"))));
        Assert.assertEquals((long)3L, (long)kb.getObjectProperties().size());
        Assert.assertFalse((boolean)kb.isAnnotationProperty((ATerm)ATermUtils.makeTermAppl((String)(ns + "q"))));
        Assert.assertFalse((boolean)kb.isDatatypeProperty((ATerm)ATermUtils.makeTermAppl((String)(ns + "q"))));
        Assert.assertTrue((boolean)kb.isDatatypeProperty((ATerm)ATermUtils.makeTermAppl((String)(ns + "r"))));
        Assert.assertEquals((long)3L, (long)kb.getDataProperties().size());
        Assert.assertFalse((boolean)kb.isAnnotationProperty((ATerm)ATermUtils.makeTermAppl((String)(ns + "r"))));
        Assert.assertFalse((boolean)kb.isObjectProperty((ATerm)ATermUtils.makeTermAppl((String)(ns + "r"))));
    }

    @Test
    public void test3Sat() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "3Sat.owl");
        String solution = "101";
        int n = solution.length();
        Individual T = model.getIndividual(ns + "T");
        Individual F = model.getIndividual(ns + "F");
        model.prepare();
        Assert.assertTrue((boolean)((PelletInfGraph)model.getGraph()).getKB().isConsistent());
        Individual[] positives = new Individual[n + 1];
        Individual[] negatives = new Individual[n + 1];
        positives[0] = T;
        negatives[0] = F;
        for (int i = 1; i <= n; ++i) {
            boolean t;
            boolean bl = t = solution.charAt(i - 1) == '1';
            if (t) {
                positives[i] = model.getIndividual(ns + "plus" + i);
                negatives[i] = model.getIndividual(ns + "minus" + i);
            } else {
                positives[i] = model.getIndividual(ns + "minus" + i);
                negatives[i] = model.getIndividual(ns + "plus" + i);
            }
            Assert.assertTrue((String)(T + " = " + positives[i]), (boolean)T.isSameAs((Resource)positives[i]));
            Assert.assertTrue((String)(F + " = " + negatives[i]), (boolean)F.isSameAs((Resource)negatives[i]));
        }
        PelletTestCase.assertIteratorValues(T.listSameAs(), positives);
        PelletTestCase.assertIteratorValues(F.listSameAs(), negatives);
    }

    @Test
    public void testPropertyRestrictionsInSuperclasses() {
        String ns = "urn:test:";
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)new PelletReasoner());
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass X = model.createClass(ns + "X");
        ObjectProperty hasX = model.createObjectProperty(ns + "hasX");
        AllValuesFromRestriction AllX = model.createAllValuesFromRestriction(null, (Property)hasX, (Resource)X);
        IntersectionClass Y = model.createIntersectionClass(ns + "Y", model.createList(new RDFNode[]{X, AllX}));
        Assert.assertTrue((String)"AllX is not a superclass of Y", (boolean)Y.hasSuperClass((Resource)AllX));
    }

    @Test
    public void testListStatementsDifferentFrom() {
        String ns = "http://www.example.org/test#";
        OntModel ont = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        InverseFunctionalProperty p = ont.createInverseFunctionalProperty(ns + "p1", true);
        Individual s1 = ont.createIndividual(ns + "s1", OWL.Thing);
        Individual s2 = ont.createIndividual(ns + "s2", OWL.Thing);
        s1.addDifferentFrom((Resource)s2);
        Individual o1 = ont.createIndividual(ns + "o1", OWL.Thing);
        Individual o2 = ont.createIndividual(ns + "o2", OWL.Thing);
        s1.addProperty((Property)p, (RDFNode)o1);
        s2.addProperty((Property)p, (RDFNode)o2);
        Model values = ModelFactory.createDefaultModel();
        PelletTestCase.addStatements(values, (Resource)s1, OWL.differentFrom, new RDFNode[]{s2});
        PelletTestCase.addStatements(values, (Resource)s2, OWL.differentFrom, new RDFNode[]{s1});
        PelletTestCase.addStatements(values, (Resource)o1, OWL.differentFrom, new RDFNode[]{o2});
        PelletTestCase.addStatements(values, (Resource)o2, OWL.differentFrom, new RDFNode[]{o1});
        PelletTestCase.assertPropertyValues((Model)ont, OWL.differentFrom, values);
    }

    @Test
    public void testListStatementsSameAs() {
        String ns = "http://www.example.org/test#";
        OntModel ont = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        ObjectProperty p = ont.createObjectProperty(ns + "p", true);
        Individual s = ont.createIndividual(ns + "s", OWL.Thing);
        Individual o1 = ont.createIndividual(ns + "o1", OWL.Thing);
        Individual o2 = ont.createIndividual(ns + "o2", OWL.Thing);
        s.addProperty((Property)p, (RDFNode)o1);
        s.addProperty((Property)p, (RDFNode)o2);
        ont.prepare();
        Model values = ModelFactory.createDefaultModel();
        PelletTestCase.addStatements(values, (Resource)s, OWL.sameAs, new RDFNode[]{s});
        PelletTestCase.addStatements(values, (Resource)o1, OWL.sameAs, new RDFNode[]{o1, o2});
        PelletTestCase.addStatements(values, (Resource)o2, OWL.sameAs, new RDFNode[]{o1, o2});
        PelletTestCase.assertPropertyValues((Model)ont, OWL.sameAs, values);
    }

    @Test
    public void testAnonTypes() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass c = model.createClass(ns + "C");
        Individual anon = model.createIndividual((Resource)c);
        Individual x = model.createIndividual(ns + "x", (Resource)c);
        model.contains(OWL.Nothing, RDF.type, (RDFNode)OWL.Class);
        PelletTestCase.assertIteratorValues(model.listStatements((Resource)x, RDF.type, (RDFNode)((Resource)null)), new Object[]{model.createStatement((Resource)x, RDF.type, (RDFNode)OWL.Thing), model.createStatement((Resource)x, RDF.type, (RDFNode)c)});
        PelletTestCase.assertIteratorValues(model.listStatements((Resource)anon, RDF.type, (RDFNode)((Resource)null)), new Object[]{model.createStatement((Resource)anon, RDF.type, (RDFNode)OWL.Thing), model.createStatement((Resource)anon, RDF.type, (RDFNode)c)});
        PelletTestCase.assertIteratorValues(model.listStatements(null, RDF.type, (RDFNode)OWL.Thing), new Object[]{model.createStatement((Resource)anon, RDF.type, (RDFNode)OWL.Thing), model.createStatement((Resource)x, RDF.type, (RDFNode)OWL.Thing)});
        PelletTestCase.assertIteratorValues(model.listStatements(null, RDF.type, (RDFNode)c), new Object[]{model.createStatement((Resource)anon, RDF.type, (RDFNode)c), model.createStatement((Resource)x, RDF.type, (RDFNode)c)});
    }

    @Test
    public void testAnonInverse() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "anon_inverse.owl");
        model.prepare();
        OntClass C = model.getOntClass(ns + "C");
        OntClass D = model.getOntClass(ns + "D");
        ObjectProperty r = model.getObjectProperty(ns + "r");
        OntModel posit = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        Resource invR = posit.createResource();
        invR.addProperty(OWL.inverseOf, (RDFNode)r);
        Resource restr = posit.createResource();
        restr.addProperty(OWL.onProperty, (RDFNode)invR);
        restr.addProperty(OWL.someValuesFrom, (RDFNode)D);
        Assert.assertTrue((boolean)model.listStatements((Resource)C, RDFS.subClassOf, (RDFNode)restr, (Model)posit).hasNext());
        Assert.assertTrue((boolean)model.contains((Resource)model.getProperty(ns + "functionalP"), RDF.type, (RDFNode)OWL.InverseFunctionalProperty));
        Assert.assertTrue((boolean)model.contains((Resource)model.getProperty(ns + "inverseFunctionalP"), RDF.type, (RDFNode)OWL.FunctionalProperty));
        Assert.assertTrue((boolean)model.contains((Resource)model.getProperty(ns + "transitiveP"), RDF.type, (RDFNode)OWL.TransitiveProperty));
        Assert.assertTrue((boolean)model.contains((Resource)model.getProperty(ns + "symmetricP"), RDF.type, (RDFNode)OWL.SymmetricProperty));
        Assert.assertTrue((boolean)model.contains((Resource)model.getProperty(ns + "reflexiveP"), RDF.type, (RDFNode)OWL2.ReflexiveProperty));
        Assert.assertTrue((boolean)model.contains((Resource)model.getProperty(ns + "irreflexiveP"), RDF.type, (RDFNode)OWL2.IrreflexiveProperty));
        Assert.assertTrue((boolean)model.contains((Resource)model.getProperty(ns + "asymmetricP"), RDF.type, (RDFNode)OWL2.AsymmetricProperty));
        ObjectProperty p1 = model.getObjectProperty(ns + "p1");
        ObjectProperty p2 = model.getObjectProperty(ns + "p2");
        ObjectProperty p3 = model.getObjectProperty(ns + "p3");
        Assert.assertTrue((boolean)model.contains((Resource)p1, OWL.equivalentProperty, (RDFNode)p2));
        Assert.assertTrue((boolean)model.contains((Resource)p1, OWL.equivalentProperty, (RDFNode)p3));
        Assert.assertTrue((boolean)model.contains((Resource)p2, OWL.equivalentProperty, (RDFNode)p3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnnotationLookup() {
        boolean oldUA = PelletOptions.USE_ANNOTATION_SUPPORT;
        try {
            PelletOptions.USE_ANNOTATION_SUPPORT = true;
            String ns = "http://www.example.org#";
            OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
            Resource x = model.createResource(ns + "x");
            Resource y = model.createResource(ns + "y");
            model.add(x, RDFS.seeAlso, (RDFNode)y);
            PelletTestCase.assertIteratorValues(model.listSubjectsWithProperty(RDFS.seeAlso, (RDFNode)y), new Resource[]{x});
        }
        finally {
            PelletOptions.USE_ANNOTATION_SUPPORT = oldUA;
        }
    }

    @Test
    public void testAnonClasses() {
        OntModel ontmodel = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        String nc = "urn:test:";
        OntClass class1 = ontmodel.createClass(nc + "C1");
        OntClass class2 = ontmodel.createClass(nc + "C2");
        Individual[] inds = new Individual[6];
        for (int j = 0; j < 6; ++j) {
            inds[j] = ontmodel.createIndividual(nc + "Ind" + j, OWL.Thing);
        }
        inds[0].addRDFType((Resource)class1);
        inds[1].addRDFType((Resource)class1);
        inds[2].addRDFType((Resource)class1);
        inds[3].addRDFType((Resource)class1);
        inds[2].addRDFType((Resource)class2);
        inds[3].addRDFType((Resource)class2);
        inds[4].addRDFType((Resource)class2);
        inds[5].addRDFType((Resource)class2);
        PelletTestCase.assertIteratorValues(class1.listInstances(), new Resource[]{inds[0], inds[1], inds[2], inds[3]});
        PelletTestCase.assertIteratorValues(class2.listInstances(), new Resource[]{inds[2], inds[3], inds[4], inds[5]});
        RDFList list = ontmodel.createList(new RDFNode[]{class1, class2});
        IntersectionClass class3 = ontmodel.createIntersectionClass(null, list);
        UnionClass class4 = ontmodel.createUnionClass(null, list);
        PelletTestCase.assertIteratorValues(class3.listInstances(), new Resource[]{inds[2], inds[3]});
        PelletTestCase.assertIteratorValues(class4.listInstances(), new Resource[]{inds[0], inds[1], inds[2], inds[3], inds[4], inds[5]});
    }

    @Test
    public void testDelete() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel();
        OntClass A = model.createClass(ns + "A");
        ObjectProperty P = model.createObjectProperty(ns + "P");
        P.addDomain((Resource)A);
        Individual x = model.createIndividual(ns + "x", OWL.Thing);
        Individual y = model.createIndividual(ns + "y", OWL.Thing);
        x.addProperty((Property)P, (RDFNode)y);
        Assert.assertTrue((boolean)x.hasRDFType((Resource)A));
        x.removeRDFType((Resource)A);
        Assert.assertTrue((boolean)x.hasRDFType((Resource)A));
    }

    @Test
    public void testDeclaredProperties() {
        String ns = "urn:test:";
        Reasoner r = PelletReasonerFactory.theInstance().create();
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner(r);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass A = model.createClass(ns + "A");
        OntClass B = model.createClass(ns + "B");
        ObjectProperty P = model.createObjectProperty(ns + "P");
        P.addDomain((Resource)model.createUnionClass(null, model.createList(new RDFNode[]{A, B})));
        OntClass oc = model.getOntClass(ns + "B");
        PelletTestCase.assertIteratorValues(oc.listDeclaredProperties(), new Resource[]{P});
    }

    @Test
    public void testDifferentFrom1() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass C = model.createClass(ns + "C");
        OntClass D = model.createClass(ns + "D");
        Individual a = model.createIndividual(ns + "a", (Resource)C);
        Individual b = model.createIndividual(ns + "b", (Resource)C);
        Individual c = model.createIndividual(ns + "c", (Resource)D);
        Individual d = model.createIndividual(ns + "d", OWL.Thing);
        ObjectProperty p = model.createObjectProperty(ns + "p");
        C.addDisjointWith((Resource)D);
        a.addProperty((Property)p, (RDFNode)b);
        d.addRDFType((Resource)model.createAllValuesFromRestriction(null, (Property)p, OWL.Nothing));
        model.prepare();
        PelletTestCase.assertIteratorValues(a.listDifferentFrom(), new Resource[]{c, d});
        PelletTestCase.assertIteratorValues(model.listSubjectsWithProperty(OWL.differentFrom, (RDFNode)a), new Resource[]{c, d});
        PelletTestCase.assertIteratorValues(b.listDifferentFrom(), new Resource[]{c});
        PelletTestCase.assertIteratorValues(model.listSubjectsWithProperty(OWL.differentFrom, (RDFNode)b), new Resource[]{c});
    }

    @Test
    public void testSameAs1() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Individual a = model.createIndividual(ns + "a", OWL.Thing);
        Individual b = model.createIndividual(ns + "b", OWL.Thing);
        Individual c = model.createIndividual(ns + "c", OWL.Thing);
        ObjectProperty p = model.createObjectProperty(ns + "p");
        ObjectProperty q = model.createObjectProperty(ns + "q");
        a.addProperty((Property)p, (RDFNode)c);
        b.addProperty((Property)p, (RDFNode)b);
        c.addProperty((Property)q, (RDFNode)a);
        c.addSameAs((Resource)b);
        a.addProperty((Property)q, (RDFNode)c);
        model.prepare();
        PelletTestCase.assertIteratorValues(a.listPropertyValues((Property)p), new Resource[]{b, c});
        PelletTestCase.assertIteratorValues(a.listPropertyValues((Property)q), new Resource[]{b, c});
        PelletTestCase.assertIteratorValues(b.listPropertyValues((Property)p), new Resource[]{b, c});
        PelletTestCase.assertIteratorValues(b.listPropertyValues((Property)q), new Resource[]{a});
        PelletTestCase.assertIteratorValues(c.listPropertyValues((Property)p), new Resource[]{b, c});
        PelletTestCase.assertIteratorValues(c.listPropertyValues((Property)q), new Resource[]{a});
    }

    @Test
    public void testSameAs2() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM_RULE_INF);
        ontModelSpec.setReasoner((Reasoner)new PelletReasoner());
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec);
        Individual i1 = model.createIndividual("http://test#i1", OWL.Thing);
        Individual i2 = model.createIndividual("http://test#i2", OWL.Thing);
        Property prop = model.createProperty("http://test#prop");
        i1.addProperty(prop, "test");
        i1.addSameAs((Resource)i2);
        Assert.assertTrue((boolean)i1.isSameAs((Resource)i2));
        Assert.assertTrue((boolean)i2.isSameAs((Resource)i1));
        Assert.assertTrue((boolean)i1.hasProperty(prop, "test"));
        PelletTestCase.assertIteratorContains(i1.listProperties(), model.createStatement((Resource)i1, prop, "test"));
        Assert.assertTrue((boolean)i2.hasProperty(prop, "test"));
        PelletTestCase.assertIteratorContains(i2.listProperties(), model.createStatement((Resource)i2, prop, "test"));
    }

    @Test
    public void testSameAs3() {
        OntModelSpec ontModelSpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM_RULE_INF);
        ontModelSpec.setReasoner((Reasoner)new PelletReasoner());
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)ontModelSpec);
        Individual i1 = model.createIndividual("http://test#i1", OWL.Thing);
        Individual i2 = model.createIndividual("http://test#i2", OWL.Thing);
        EnumeratedClass c = model.createEnumeratedClass("http://test#C", model.createList(new RDFNode[]{i1, i2}));
        Individual i3 = model.createIndividual("http://test#i3", (Resource)c);
        Assert.assertTrue((!i1.isSameAs((Resource)i2) ? 1 : 0) != 0);
        Assert.assertTrue((!i1.isSameAs((Resource)i3) ? 1 : 0) != 0);
        PelletTestCase.assertIteratorValues(i1.listSameAs(), new Resource[]{i1});
        Assert.assertTrue((!i2.isSameAs((Resource)i1) ? 1 : 0) != 0);
        Assert.assertTrue((!i2.isSameAs((Resource)i3) ? 1 : 0) != 0);
        PelletTestCase.assertIteratorValues(i2.listSameAs(), new Resource[]{i2});
        Assert.assertTrue((!i3.isSameAs((Resource)i1) ? 1 : 0) != 0);
        Assert.assertTrue((!i3.isSameAs((Resource)i2) ? 1 : 0) != 0);
        PelletTestCase.assertIteratorValues(i3.listSameAs(), new Resource[]{i3});
    }

    @Test
    public void testSudaku() {
        String ns = "http://sudoku.owl#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "sudaku.owl");
        OntClass[][] C = new OntClass[4][4];
        Individual[][] V = new Individual[4][4];
        Individual[] N = new Individual[4];
        for (int i = 1; i < 4; ++i) {
            N[i] = model.getIndividual(ns + i);
            for (int j = 1; j < 4; ++j) {
                V[i][j] = model.getIndividual(ns + "V" + i + j);
                C[i][j] = model.getOntClass(ns + "C" + i + j);
            }
        }
        V[2][1].setSameAs((Resource)N[2]);
        V[1][2].setSameAs((Resource)N[3]);
        Individual[][] eq = new Individual[][]{{V[1][1], V[2][2], V[3][3], N[1]}, {V[1][3], V[2][1], V[3][2], N[2]}, {V[1][2], V[2][3], V[3][1], N[3]}};
        for (int k = 0; k < 3; ++k) {
            for (int i = 0; i < 4; ++i) {
                Individual ind = eq[k][i];
                for (int j = 0; j < 4; ++j) {
                    Assert.assertTrue((boolean)ind.isSameAs((Resource)eq[k][j]));
                }
                PelletTestCase.assertIteratorValues(ind.listSameAs(), eq[k]);
            }
        }
    }

    @Test
    public void testFuncProp() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Individual a = model.createIndividual(ns + "a", OWL.Thing);
        Individual b = model.createIndividual(ns + "b", OWL.Thing);
        Individual c = model.createIndividual(ns + "c", OWL.Thing);
        Individual d = model.createIndividual(ns + "d", OWL.Thing);
        ObjectProperty p = model.createObjectProperty(ns + "p");
        a.addProperty((Property)p, (RDFNode)b);
        ObjectProperty q = model.createObjectProperty(ns + "q", true);
        a.addProperty((Property)q, (RDFNode)b);
        a.addProperty((Property)q, (RDFNode)d);
        c.addSameAs((Resource)b);
        PelletTestCase.assertIteratorValues(a.listPropertyValues((Property)p), new Resource[]{b, c, d});
        Model values = ModelFactory.createDefaultModel();
        PelletTestCase.addStatements(values, (Resource)a, OWL.sameAs, new RDFNode[]{a});
        PelletTestCase.addStatements(values, (Resource)b, OWL.sameAs, new RDFNode[]{b, c, d});
        PelletTestCase.addStatements(values, (Resource)c, OWL.sameAs, new RDFNode[]{b, c, d});
        PelletTestCase.addStatements(values, (Resource)d, OWL.sameAs, new RDFNode[]{b, c, d});
        PelletTestCase.assertPropertyValues((Model)model, OWL.sameAs, values);
    }

    @Test
    public void testHasValueReasoning() {
        String ns = "urn:test:";
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner((Reasoner)new PelletReasoner());
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        OntClass HomeOwner = model.createClass(ns + "HomeOwner");
        Individual bob = model.createIndividual(ns + "bob", (Resource)HomeOwner);
        ObjectProperty hasNeighbor = model.createObjectProperty(ns + "hasNeighbor");
        OntClass NeighborOfBob = model.createClass(ns + "NeighborOfBob");
        NeighborOfBob.addEquivalentClass((Resource)model.createHasValueRestriction(null, (Property)hasNeighbor, (RDFNode)bob));
        Individual susan = model.createIndividual(ns + "susan", (Resource)HomeOwner);
        susan.setPropertyValue((Property)hasNeighbor, (RDFNode)bob);
        Assert.assertTrue((String)"susan is not a NeighborOfBob", (boolean)susan.hasRDFType((Resource)NeighborOfBob));
    }

    @Test
    public void testInfiniteChain() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.setStrictMode(false);
        model.read(base + "infiniteChain.owl");
        model.prepare();
        Assert.assertFalse((boolean)((PelletInfGraph)model.getGraph()).getKB().isConsistent());
        String ns = "http://www.example.org/test#";
        Property prop = model.getBaseModel().getProperty(ns + "ssn");
        prop.removeAll(RDFS.range);
        model.rebind();
        Assert.assertTrue((boolean)((PelletInfGraph)model.getGraph()).isConsistent());
    }

    @Ignore(value="Inverse functional datatype property support conflicts with changes in r2442 and 2443")
    @Test
    public void testInfiniteChainDP() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "infiniteChainDP.owl");
        Assert.assertFalse((boolean)((PelletInfGraph)model.getGraph()).isConsistent());
        String ns = "http://www.example.org/test#";
        Property prop = model.getBaseModel().getProperty(ns + "ssn");
        prop.removeAll(RDFS.range);
        model.rebind();
        Assert.assertTrue((boolean)((PelletInfGraph)model.getGraph()).isConsistent());
    }

    @Test
    public void testParents() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "parents.owl");
        Individual Bob = model.getIndividual(ns + "Bob");
        Individual Mom = model.getIndividual(ns + "Mom");
        Individual Dad = model.getIndividual(ns + "Dad");
        ObjectProperty hasParent = model.getObjectProperty(ns + "hasParent");
        ObjectProperty hasFather = model.getObjectProperty(ns + "hasFather");
        ObjectProperty hasMother = model.getObjectProperty(ns + "hasMother");
        ObjectProperty topObjProp = model.getObjectProperty(OWL2.topObjectProperty.getURI());
        model.prepare();
        Assert.assertTrue((boolean)((PelletInfGraph)model.getGraph()).getKB().isConsistent());
        PelletTestCase.assertIteratorValues(model.listObjectsOfProperty((Resource)Bob, (Property)hasParent), new Resource[]{Mom, Dad});
        PelletTestCase.assertIteratorValues(model.listObjectsOfProperty((Property)hasFather), new Object[]{Dad});
        PelletTestCase.assertIteratorValues(model.listObjectsOfProperty((Property)hasMother), new Object[]{Mom});
        PelletTestCase.assertIteratorValues(model.listStatements(null, (Property)hasParent, (RDFNode)((Resource)null)), new Statement[]{ResourceFactory.createStatement((Resource)Bob, (Property)hasParent, (RDFNode)Mom), ResourceFactory.createStatement((Resource)Bob, (Property)hasParent, (RDFNode)Dad)});
        PelletTestCase.assertIteratorValues(model.listStatements((Resource)Bob, null, (RDFNode)Dad), new Statement[]{ResourceFactory.createStatement((Resource)Bob, (Property)topObjProp, (RDFNode)Dad), ResourceFactory.createStatement((Resource)Bob, (Property)hasParent, (RDFNode)Dad), ResourceFactory.createStatement((Resource)Bob, (Property)hasFather, (RDFNode)Dad)});
        PelletTestCase.assertIteratorValues(model.listObjectsOfProperty((Resource)Bob, (Property)hasFather), new Resource[]{Dad});
        PelletTestCase.assertIteratorValues(model.listObjectsOfProperty((Resource)Bob, (Property)hasMother), new Resource[]{Mom});
    }

    @Test
    public void testTeams() {
        String ns = "http://owl.man.ac.uk/2005/sssw/teams#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "teams.owl");
        Individual t1 = model.getIndividual(ns + "OntologyFC");
        OntClass Male = model.getOntClass(ns + "Male");
        OntClass Female = model.getOntClass(ns + "Female");
        Individual Sam = model.getIndividual(ns + "Sam");
        Individual Chris = model.getIndividual(ns + "Chris");
        OntClass Team = model.getOntClass(ns + "Team");
        OntClass MixedTeam = model.getOntClass(ns + "MixedTeam");
        OntClass NonSingletonTeam = model.getOntClass(ns + "NonSingletonTeam");
        OntClass SingletonTeam = model.getOntClass(ns + "SingletonTeam");
        model.prepare();
        Assert.assertTrue((boolean)Sam.isDifferentFrom((Resource)Chris));
        Assert.assertTrue((boolean)Chris.isDifferentFrom((Resource)Sam));
        Assert.assertTrue((boolean)MixedTeam.hasSuperClass((Resource)Team));
        Assert.assertFalse((boolean)MixedTeam.hasSuperClass((Resource)SingletonTeam));
        PelletTestCase.assertIteratorValues(MixedTeam.listSuperClasses(), new Resource[]{Team, NonSingletonTeam, OWL.Thing});
        PelletTestCase.assertIteratorValues(MixedTeam.listSuperClasses(true), new Resource[]{NonSingletonTeam});
        Assert.assertTrue((boolean)NonSingletonTeam.hasSubClass((Resource)MixedTeam));
        PelletTestCase.assertIteratorValues(NonSingletonTeam.listSubClasses(), new Resource[]{MixedTeam, OWL.Nothing});
        PelletTestCase.assertIteratorValues(NonSingletonTeam.listSubClasses(true), new Resource[]{MixedTeam});
        Assert.assertTrue((boolean)t1.hasRDFType((Resource)MixedTeam));
        Assert.assertTrue((boolean)t1.hasRDFType((Resource)MixedTeam, true));
        PelletTestCase.assertIteratorValues(t1.listRDFTypes(false), new Resource[]{Team, NonSingletonTeam, MixedTeam, OWL.Thing});
        PelletTestCase.assertIteratorValues(t1.listRDFTypes(true), new Resource[]{MixedTeam});
        Male.removeDisjointWith((Resource)Female);
        Female.removeDisjointWith((Resource)Male);
        Sam.removeDifferentFrom((Resource)Chris);
        Chris.removeDifferentFrom((Resource)Sam);
        Assert.assertTrue((!Sam.isDifferentFrom((Resource)Chris) ? 1 : 0) != 0);
        Assert.assertTrue((!Chris.isDifferentFrom((Resource)Sam) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)MixedTeam.hasSuperClass((Resource)Team));
        PelletTestCase.assertIteratorValues(MixedTeam.listSuperClasses(), new Resource[]{Team, OWL.Thing});
        Assert.assertTrue((!NonSingletonTeam.hasSuperClass((Resource)MixedTeam) ? 1 : 0) != 0);
        PelletTestCase.assertIteratorValues(NonSingletonTeam.listSuperClasses(), new Resource[]{Team, OWL.Thing});
        PelletTestCase.assertIteratorValues(NonSingletonTeam.listSuperClasses(true), new Resource[]{Team});
        Assert.assertTrue((boolean)t1.hasRDFType((Resource)MixedTeam));
        Assert.assertTrue((boolean)t1.hasRDFType((Resource)MixedTeam, true));
        PelletTestCase.assertIteratorValues(t1.listRDFTypes(false), new Resource[]{Team, MixedTeam, OWL.Thing});
        PelletTestCase.assertIteratorValues(t1.listRDFTypes(true), new Resource[]{MixedTeam});
    }

    @Test
    public void testPropertyAssertions2() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass Person = model.createClass(ns + "Person");
        ObjectProperty hasFather = model.createObjectProperty(ns + "hasFather");
        ObjectProperty hasBioFather = model.createObjectProperty(ns + "hasBioFather", true);
        hasBioFather.addSuperProperty((Property)hasFather);
        Person.addSuperClass((Resource)model.createMinCardinalityRestriction(null, (Property)hasBioFather, 1));
        Individual Bob = model.createIndividual(ns + "Bob", (Resource)Person);
        Individual Dad = model.createIndividual(ns + "Dad", (Resource)Person);
        Bob.addProperty((Property)hasBioFather, (RDFNode)Dad);
        Bob.addRDFType((Resource)model.createCardinalityRestriction(null, (Property)hasFather, 1));
        model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)model);
        PelletTestCase.assertIteratorValues(model.listObjectsOfProperty((Resource)Bob, (Property)hasFather), new Resource[]{Dad});
        PelletTestCase.assertIteratorValues(model.listObjectsOfProperty((Resource)Bob, (Property)hasBioFather), new Resource[]{Dad});
    }

    @Test
    public void testTransitive1() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "agencies.owl");
        model.prepare();
        String ns = "http://www.owl-ontologies.com/unnamed.owl#";
        Individual Forest_Service = model.getIndividual(ns + "Forest_Service");
        ObjectProperty comprises = model.getObjectProperty(ns + "comprises");
        Individual Executive = model.getIndividual(ns + "Executive");
        Individual USDA = model.getIndividual(ns + "USDA");
        Assert.assertTrue((String)"Forest_Service, comprises, Executive", (boolean)model.contains((Resource)Forest_Service, (Property)comprises, (RDFNode)Executive));
        PelletTestCase.assertIteratorValues(model.listObjectsOfProperty((Resource)Forest_Service, (Property)comprises), new Resource[]{USDA, Executive});
        PelletTestCase.assertIteratorValues(model.listSubjectsWithProperty((Property)comprises, (RDFNode)Executive), new Resource[]{model.getIndividual(ns + "USDA"), model.getIndividual(ns + "DOE"), model.getIndividual(ns + "DHS"), model.getIndividual(ns + "HHS"), model.getIndividual(ns + "HUD"), model.getIndividual(ns + "DOC"), model.getIndividual(ns + "DOD"), model.getIndividual(ns + "DOI"), model.getIndividual(ns + "Research__Economics___Education"), model.getIndividual(ns + "Forest_Service"), model.getIndividual(ns + "Rural_Development"), model.getIndividual(ns + "Natural_Resources_Conservation_Service"), model.getIndividual(ns + "Economic_Research_Service"), model.getIndividual(ns + "Farm_Service_Agency"), model.getIndividual(ns + "Cooperative_State_Research__Education__and_Extension_Service"), model.getIndividual(ns + "Animal___Plant_Health_Inspection_Service"), model.getIndividual(ns + "Agricultural_Research_Service"), model.getIndividual(ns + "National_Agricultural_Library")});
    }

    @Test
    public void testTransitive2() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "cyclic_transitive.owl");
        model.prepare();
        String ns = "http://www.example.org/test#";
        OntClass Probe = model.getOntClass(ns + "Probe");
        Individual Instance1 = model.getIndividual(ns + "Instance1");
        Individual Instance2 = model.getIndividual(ns + "Instance2");
        Individual Instance3 = model.getIndividual(ns + "Instance3");
        PelletTestCase.assertIteratorValues(Probe.listInstances(), new Resource[]{Instance1, Instance2, Instance3});
    }

    @Test
    public void testTransitiveSubProperty1() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        ObjectProperty knows = model.createObjectProperty(ns + "knows");
        ObjectProperty hasRelative = model.createObjectProperty(ns + "hasRelative");
        hasRelative.addSuperProperty((Property)knows);
        hasRelative.addRDFType(OWL.TransitiveProperty);
        ObjectProperty hasParent = model.createObjectProperty(ns + "hasParent");
        hasParent.addSuperProperty((Property)hasRelative);
        OntClass cls = model.createClass(ns + "cls");
        Individual a = cls.createIndividual(ns + "a");
        Individual b = cls.createIndividual(ns + "b");
        Individual c = cls.createIndividual(ns + "c");
        Individual d = cls.createIndividual(ns + "d");
        Individual e = cls.createIndividual(ns + "e");
        Individual f = cls.createIndividual(ns + "f");
        Individual g = cls.createIndividual(ns + "g");
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_DL_MEM);
        spec.setReasoner(PelletReasonerFactory.theInstance().create());
        model = ModelFactory.createOntologyModel((OntModelSpec)spec, (Model)model);
        model.add((Resource)a, (Property)hasParent, (RDFNode)b);
        model.add((Resource)b, (Property)hasParent, (RDFNode)c);
        model.add((Resource)a, (Property)knows, (RDFNode)d);
        model.add((Resource)d, (Property)knows, (RDFNode)e);
        model.add((Resource)b, (Property)knows, (RDFNode)e);
        model.add((Resource)c, (Property)hasRelative, (RDFNode)f);
        model.add((Resource)d, (Property)hasRelative, (RDFNode)g);
        Assert.assertTrue((boolean)model.contains((Resource)a, (Property)hasRelative, (RDFNode)b));
        Assert.assertTrue((boolean)model.contains((Resource)a, (Property)knows, (RDFNode)b));
        Assert.assertTrue((boolean)model.contains((Resource)b, (Property)hasRelative, (RDFNode)c));
        Assert.assertTrue((boolean)model.contains((Resource)b, (Property)knows, (RDFNode)c));
        Assert.assertTrue((boolean)model.contains((Resource)a, (Property)hasRelative, (RDFNode)c));
        Assert.assertTrue((boolean)model.contains((Resource)a, (Property)knows, (RDFNode)c));
        Assert.assertTrue((boolean)model.contains((Resource)b, (Property)hasRelative, (RDFNode)f));
        Assert.assertTrue((boolean)model.contains((Resource)b, (Property)knows, (RDFNode)f));
        Assert.assertTrue((boolean)model.contains((Resource)a, (Property)hasRelative, (RDFNode)f));
        Assert.assertTrue((boolean)model.contains((Resource)a, (Property)knows, (RDFNode)f));
        Assert.assertTrue((!model.contains((Resource)a, (Property)hasRelative, (RDFNode)e) ? 1 : 0) != 0);
        Assert.assertTrue((!model.contains((Resource)a, (Property)knows, (RDFNode)e) ? 1 : 0) != 0);
        Assert.assertTrue((!model.contains((Resource)a, (Property)knows, (RDFNode)g) ? 1 : 0) != 0);
        Assert.assertTrue((!model.contains((Resource)a, (Property)hasRelative, (RDFNode)g) ? 1 : 0) != 0);
        PelletTestCase.assertIteratorValues(model.listObjectsOfProperty((Resource)a, (Property)hasRelative), new Resource[]{b, c, f});
        PelletTestCase.assertIteratorValues(model.listObjectsOfProperty((Resource)a, (Property)knows), new Resource[]{b, c, d, f});
        PelletTestCase.assertIteratorValues(model.listObjectsOfProperty((Resource)b, (Property)knows), new Resource[]{c, e, f});
        PelletTestCase.assertIteratorValues(model.listSubjectsWithProperty((Property)knows, (RDFNode)e), new Resource[]{b, d});
        PelletTestCase.assertIteratorValues(model.listSubjectsWithProperty((Property)hasRelative, (RDFNode)f), new Resource[]{a, b, c});
    }

    @Test
    public void testTransitiveSubProperty2() {
        String ns = "http://www.co-ode.org/ontologies/test/pellet/transitive.owl#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "transitiveSub.owl");
        OntClass ThingsThatpSomeC = model.getOntClass(ns + "ThingsThatpSomeC");
        OntClass A = model.getOntClass(ns + "A");
        OntClass B = model.getOntClass(ns + "B");
        Assert.assertTrue((boolean)A.hasSuperClass((Resource)ThingsThatpSomeC));
        Assert.assertTrue((boolean)B.hasSuperClass((Resource)ThingsThatpSomeC));
        PelletTestCase.assertIteratorContains(A.listSuperClasses(), ThingsThatpSomeC);
        PelletTestCase.assertIteratorContains(B.listSuperClasses(), ThingsThatpSomeC);
    }

    @Test
    public void testNominals() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "nominals.owl");
        OntClass Color2 = model.getOntClass(ns + "Color");
        Individual red = model.getIndividual(ns + "red");
        OntClass PrimaryColors = model.getOntClass(ns + "PrimaryColors");
        OntClass MyFavoriteColors = model.getOntClass(ns + "MyFavoriteColors");
        OntClass HasFourPrimaryColors = model.getOntClass(ns + "HasFourPrimaryColors");
        model.prepare();
        Assert.assertTrue((boolean)model.contains((Resource)red, RDF.type, (RDFNode)MyFavoriteColors));
        Assert.assertTrue((boolean)model.contains((Resource)HasFourPrimaryColors, RDFS.subClassOf, (RDFNode)OWL.Nothing));
        PelletTestCase.assertIteratorValues(Color2.listSubClasses(), new Resource[]{PrimaryColors, MyFavoriteColors, HasFourPrimaryColors, OWL.Nothing});
    }

    @Test
    public void testDatatypeProperties() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass Person = model.createClass(ns + "Person");
        Individual john = model.createIndividual(ns + "JohnDoe", (Resource)Person);
        DatatypeProperty email = model.createDatatypeProperty(ns + "email", false);
        john.addProperty((Property)email, "john.doe@unknown.org");
        john.addProperty((Property)email, "jdoe@unknown.org");
        Assert.assertTrue((boolean)model.validate().isValid());
        PelletTestCase.assertIteratorValues(model.listSubjectsWithProperty((Property)email, "john.doe@unknown.org"), new Resource[]{john});
        Assert.assertTrue((boolean)model.contains(null, (Property)email, "john.doe@unknown.org"));
        Assert.assertTrue((!model.contains(null, (Property)email, (RDFNode)john) ? 1 : 0) != 0);
        DatatypeProperty name1 = model.createDatatypeProperty(ns + "name1", true);
        john.addProperty((Property)name1, "Name", "en");
        john.addProperty((Property)name1, "Nom", "fr");
        Assert.assertTrue((boolean)model.validate().isValid());
        DatatypeProperty name2 = model.createDatatypeProperty(ns + "name2", true);
        john.addProperty((Property)name2, "Name");
        john.addProperty((Property)name2, "Nom");
        Assert.assertTrue((!model.validate().isValid() ? 1 : 0) != 0);
    }

    @Test
    public void testDatatypeHierarchy() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "all_datatypes.owl");
        OntModel hierarchy = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        model.read(base + "datatype_hierarchy.owl");
        ExtendedIterator i = hierarchy.listClasses();
        while (i.hasNext()) {
            OntClass cls = (OntClass)i.next();
            PelletTestCase.assertIteratorValues(model.getOntClass(cls.getURI()).listSubClasses(true), cls.listSubClasses());
        }
    }

    @Test
    public void testDataPropCard1() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        DatatypeProperty prop = model.createDatatypeProperty(ns + "prop");
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)prop, 2));
        Individual x = model.createIndividual(ns + "x", (Resource)C);
        x.addProperty((Property)prop, "literal");
        model.prepare();
        Assert.assertTrue((boolean)((PelletInfGraph)model.getGraph()).isConsistent());
    }

    @Test
    public void testDataPropCard2() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        DatatypeProperty prop = model.createDatatypeProperty(ns + "prop");
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)prop, 2));
        Individual x = model.createIndividual(ns + "x", (Resource)C);
        x.addProperty((Property)prop, "literal1");
        x.addProperty((Property)prop, "literal2");
        x.addProperty((Property)prop, "literal3");
        Assert.assertTrue((!model.validate().isValid() ? 1 : 0) != 0);
    }

    @Test
    public void testSubDataPropCard() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        DatatypeProperty prop = model.createDatatypeProperty(ns + "prop");
        DatatypeProperty sub = model.createDatatypeProperty(ns + "sub");
        sub.addSuperProperty((Property)prop);
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)prop, 2));
        Individual x = model.createIndividual(ns + "x", (Resource)C);
        Literal val1 = model.createLiteral("val1");
        x.addProperty((Property)prop, (RDFNode)val1);
        Literal val2 = model.createLiteral("val2");
        x.addProperty((Property)sub, (RDFNode)val2);
        Assert.assertTrue((boolean)model.validate().isValid());
        PelletTestCase.assertPropertyValues((Model)model, (Resource)x, (Property)prop, new RDFNode[]{val1, val2});
    }

    @Test
    public void testUniqueNameAssumption() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass Country = model.createClass(ns + "Country");
        Individual USA = model.createIndividual(ns + "USA", (Resource)Country);
        Individual UnitedStates = model.createIndividual(ns + "UnitedStates", (Resource)Country);
        ObjectProperty livesIn = model.createObjectProperty(ns + "livesIn");
        livesIn.convertToFunctionalProperty();
        OntClass Person = model.createClass(ns + "Person");
        Individual JohnDoe = model.createIndividual(ns + "JohnDoe", (Resource)Person);
        JohnDoe.addProperty((Property)livesIn, (RDFNode)USA);
        JohnDoe.addProperty((Property)livesIn, (RDFNode)UnitedStates);
        Assert.assertTrue((boolean)model.contains((Resource)JohnDoe, RDF.type, (RDFNode)Person));
        Assert.assertTrue((boolean)model.contains((Resource)USA, OWL.sameAs, (RDFNode)UnitedStates));
        PelletTestCase.assertIteratorValues(model.listObjectsOfProperty((Resource)JohnDoe, (Property)livesIn), new Resource[]{USA, UnitedStates});
    }

    @Test
    public void testESG() {
        String ns = "http://www.csm.ornl.gov/~7lp/onto-library/esg1.1#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.getDocumentManager().setProcessImports(false);
        model.read(base + "ESG1.1.owl");
        model.prepare();
        Assert.assertTrue((boolean)((PelletInfGraph)model.getGraph()).getKB().isConsistent());
        Individual jdl62 = model.getIndividual(ns + "JDL_00062");
        Individual jdl63 = model.getIndividual(ns + "JDL_00063");
        Assert.assertTrue((boolean)jdl62.isSameAs((Resource)jdl63));
        Assert.assertTrue((boolean)jdl63.isSameAs((Resource)jdl62));
        PelletTestCase.assertIteratorValues(jdl62.listSameAs(), new Resource[]{jdl62, jdl63});
        PelletTestCase.assertIteratorValues(jdl63.listSameAs(), new Resource[]{jdl62, jdl63});
        model.getDocumentManager().setProcessImports(true);
    }

    @Test
    public void testDatapropertyRange() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "datataype_range.owl");
        model.prepare();
        ExtendedIterator i = model.listDatatypeProperties();
        while (i.hasNext()) {
            DatatypeProperty p = (DatatypeProperty)i.next();
            ExtendedIterator j = p.listRange();
            while (j.hasNext()) {
                Resource range = (Resource)j.next();
                Assert.assertTrue((TypeMapper.getInstance().getTypeByName(range.getURI()) != null ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testMultipleDatatypes() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        DatatypeProperty f = model.createDatatypeProperty(ns + "f");
        f.addRange(XSD.xfloat);
        DatatypeProperty d = model.createDatatypeProperty(ns + "d");
        d.addRange(XSD.xdouble);
        OntClass C = model.createClass(ns + "C");
        C.addSuperClass((Resource)model.createMinCardinalityRestriction(null, (Property)f, 5));
        C.addSuperClass((Resource)model.createMinCardinalityRestriction(null, (Property)d, 5));
        model.prepare();
        Assert.assertFalse((boolean)C.hasSuperClass(OWL.Nothing));
    }

    @Test
    public void testUserDefinedFloatDatatypes() {
        String ns = "http://www.lancs.ac.uk/ug/dobsong/owl/float_test.owl#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "float_test.owl");
        model.prepare();
        Assert.assertTrue((boolean)model.validate().isValid());
        OntClass ThingWithFloatValue = model.getOntClass(ns + "ThingWithFloatValue");
        OntClass ThingWithFloatProbability = model.getOntClass(ns + "ThingWithProbabilityValue");
        Individual exampleThingWithFloatValue = model.getIndividual(ns + "exampleThingWithFloatValue");
        Individual exampleThingWithFloatProbability = model.getIndividual(ns + "exampleThingWithProbabilityValue");
        Assert.assertTrue((boolean)ThingWithFloatValue.hasSubClass((Resource)ThingWithFloatProbability));
        Assert.assertTrue((!ThingWithFloatProbability.hasSubClass((Resource)ThingWithFloatValue) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)exampleThingWithFloatValue.hasRDFType((Resource)ThingWithFloatValue));
        Assert.assertTrue((!exampleThingWithFloatValue.hasRDFType((Resource)ThingWithFloatProbability) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)exampleThingWithFloatProbability.hasRDFType((Resource)ThingWithFloatValue));
        Assert.assertTrue((boolean)exampleThingWithFloatProbability.hasRDFType((Resource)ThingWithFloatProbability));
    }

    @Test
    public void testUserDefinedDecimalDatatypes() {
        String ns = "http://www.lancs.ac.uk/ug/dobsong/owl/decimal_test.owl#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "decimal_test.owl");
        model.prepare();
        Assert.assertTrue((boolean)model.validate().isValid());
        OntClass ThingWithDecimalValue = model.getOntClass(ns + "ThingWithDecimalValue");
        OntClass ThingWithDecimalProbability = model.getOntClass(ns + "ThingWithDecimalProbability");
        OntClass ThingWithIntegerValue = model.getOntClass(ns + "ThingWithIntegerValue");
        Individual exampleThingWithDecimalValue = model.getIndividual(ns + "exampleThingWithDecimalValue");
        Individual exampleThingWithDecimalProbability = model.getIndividual(ns + "exampleThingWithDecimalProbability");
        Assert.assertTrue((boolean)ThingWithDecimalValue.hasSubClass((Resource)ThingWithIntegerValue));
        Assert.assertTrue((boolean)ThingWithDecimalValue.hasSubClass((Resource)ThingWithDecimalProbability));
        Assert.assertTrue((boolean)exampleThingWithDecimalValue.hasRDFType((Resource)ThingWithDecimalValue));
        Assert.assertTrue((boolean)exampleThingWithDecimalProbability.hasRDFType((Resource)ThingWithIntegerValue));
        Assert.assertTrue((boolean)exampleThingWithDecimalProbability.hasRDFType((Resource)ThingWithDecimalProbability));
        Assert.assertTrue((boolean)exampleThingWithDecimalProbability.hasRDFType((Resource)ThingWithDecimalValue));
        Assert.assertTrue((!ThingWithDecimalValue.hasSuperClass((Resource)ThingWithIntegerValue) ? 1 : 0) != 0);
        Assert.assertTrue((!ThingWithIntegerValue.hasSubClass((Resource)ThingWithDecimalProbability) ? 1 : 0) != 0);
    }

    @Test
    public void testBuiltinDatatypesWithValidValues() {
        String ns = "urn:test:";
        Object[] datatypes = new Object[]{XSD.anyURI, "http://www.w3.com", "\nhttp://www.w3.com\r", XSD.xboolean, "true", "1", "\ntrue", XSD.xbyte, "8", "\t\r\n8 ", XSD.date, "2004-03-15", XSD.dateTime, "2003-12-25T08:30:00", "2003-12-25T08:30:00.001", "2003-12-25T08:30:00-05:00", "2003-12-25T08:30:00Z", XSD.decimal, "3.1415292", XSD.xdouble, "3.1415292", "INF", "NaN", XSD.duration, "P8M3DT7H33M2S", "P1Y", "P1M", "P1Y2MT2H", XSD.xfloat, "3.1415292", "-1E4", "12.78e-2", "INF", "NaN", XSD.gDay, "---11", XSD.gMonth, "--02", XSD.gMonthDay, "--02-14", XSD.gYear, "0001", "1999", XSD.gYearMonth, "1972-08", XSD.xint, "77", XSD.integer, "77", XSD.xlong, "214", XSD.negativeInteger, "-123", XSD.nonNegativeInteger, "2", XSD.nonPositiveInteger, "0", XSD.positiveInteger, "500", XSD.xshort, "476", XSD.xstring, "Test", XSD.time, "13:02:00"};
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Individual ind = model.createIndividual(ns + "test", OWL.Thing);
        int i = 0;
        while (i < datatypes.length) {
            Resource datatype = (Resource)datatypes[i++];
            DatatypeProperty p = model.createDatatypeProperty(ns + "prop_" + datatype.getLocalName());
            p.addRange(datatype);
            while (i < datatypes.length && datatypes[i] instanceof String) {
                Literal value = model.createTypedLiteral((String)datatypes[i], datatype.getURI());
                ind.addProperty((Property)p, (RDFNode)value);
                ++i;
            }
        }
        model.prepare();
        Assert.assertTrue((boolean)model.validate().isValid());
    }

    @Test
    public void testBuiltinDatatypesWithInvalidValues() {
        String ns = "urn:test:";
        Object[] datatypes = new Object[]{XSD.anyURI, "http://www.w3.com\\invalid", XSD.xboolean, "True", "01", XSD.xbyte, "-12093421034", "257", "2147483648", XSD.date, "2004-15-03", "2004/03/15", "03-15-2004", XSD.dateTime, "2003-12-25", XSD.decimal, "x3.1415292", XSD.xdouble, "Inf", XSD.duration, "P-8M", XSD.xfloat, "3.1g-1", XSD.gDay, "11", "Monday", "Mon", XSD.gMonth, "02", "Feb", "February", XSD.gMonthDay, "02-14", "02/14", XSD.gYear, "0000", "542", XSD.gYearMonth, "1972/08", "197208", XSD.xint, "2147483648", "9223372036854775808", XSD.integer, "1.1", XSD.xlong, "9223372036854775808", XSD.negativeInteger, "0", "1", XSD.nonNegativeInteger, "-1", XSD.nonPositiveInteger, "1", XSD.positiveInteger, "-1", XSD.xshort, "32768", "1.1"};
        for (boolean addRangeRestriction : new boolean[]{false, true}) {
            int i = 0;
            while (i < datatypes.length) {
                Resource datatype = (Resource)datatypes[i++];
                while (i < datatypes.length && datatypes[i] instanceof String) {
                    OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
                    Individual ind = model.createIndividual(ns + "test", OWL.Thing);
                    DatatypeProperty p = model.createDatatypeProperty(ns + "prop_" + datatype.getLocalName());
                    if (addRangeRestriction) {
                        p.addRange(datatype);
                    }
                    Literal value = model.createTypedLiteral((String)datatypes[i], datatype.getURI());
                    ind.addProperty((Property)p, (RDFNode)value);
                    Assert.assertFalse((String)(value.getLexicalForm() + " should not belong to " + datatype.getLocalName()), (boolean)model.validate().isValid());
                    ++i;
                }
            }
        }
    }

    @Test
    public void testBuiltinDatatypesWithCardinalityRestriction() {
        String ns = "urn:test:";
        DatatypeReasonerImpl dtReasoner = new DatatypeReasonerImpl();
        for (ATermAppl uri : dtReasoner.listDataRanges()) {
            OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
            DatatypeProperty prop = model.createDatatypeProperty(ns + "prop");
            Resource datatype = model.createResource(uri.getName());
            prop.addRange(datatype);
            OntClass C = model.createClass(ns + "C");
            int cardinality = datatype.equals((Object)XSD.xboolean) ? 2 : 10;
            C.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)prop, cardinality));
            model.createIndividual(ns + "x", (Resource)C);
            model.prepare();
            Assert.assertTrue((boolean)((PelletInfGraph)model.getGraph()).isConsistent());
        }
    }

    @Test
    public void testBuiltinDatatypesWithHasValueRestriction() {
        String ns = "urn:test:";
        Object[] datatypes = new Object[]{XSD.anyURI, "http://www.w3.com", XSD.xboolean, "true", "1", XSD.xbyte, "8", XSD.date, "2004-03-15", XSD.dateTime, "2003-12-25T08:30:00", "2003-12-25T08:30:00.001", "2003-12-25T08:30:00-05:00", "2003-12-25T08:30:00Z", XSD.decimal, "3.1415292", XSD.xdouble, "3.1415292", "INF", "NaN", XSD.duration, "P8M3DT7H33M2S", "P1Y", "P1M", "P1Y2MT2H", XSD.xfloat, "3.1415292", "-1E4", "12.78e-2", "INF", "NaN", XSD.gDay, "---11", XSD.gMonth, "--02", XSD.gMonthDay, "--02-14", XSD.gYear, "0001", "1999", XSD.gYearMonth, "1972-08", XSD.xint, "77", XSD.integer, "77", XSD.xlong, "214", XSD.negativeInteger, "-123", XSD.nonNegativeInteger, "2", XSD.nonPositiveInteger, "0", XSD.positiveInteger, "500", XSD.xshort, "476", XSD.xstring, "Test", XSD.time, "13:02:00"};
        int i = 0;
        while (i < datatypes.length) {
            Resource datatype = (Resource)datatypes[i++];
            OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
            DatatypeProperty p = model.createDatatypeProperty(ns + "prop");
            p.addRange(datatype);
            int start = i;
            while (i < datatypes.length && datatypes[i] instanceof String) {
                Individual ind = model.createIndividual(ns + "testInd" + i, OWL.Thing);
                Literal value = model.createTypedLiteral((String)datatypes[i], datatype.getURI());
                ind.addProperty((Property)p, (RDFNode)value);
                OntClass c = model.createClass(ns + "testCls" + i);
                c.addEquivalentClass((Resource)model.createHasValueRestriction(null, (Property)p, (RDFNode)value));
                ++i;
            }
            model.prepare();
            for (int j = start; j < i; ++j) {
                Assert.assertTrue((String)(datatype.getLocalName() + " " + datatypes[j]), (boolean)model.getIndividual(ns + "testInd" + j).hasRDFType((Resource)model.getIndividual(ns + "testCls" + j)));
            }
        }
    }

    @Test
    public void testFamily() {
        String ns = "http://www.example.org/family#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        model.read(base + "family.owl");
        ObjectProperty hasBrother = model.getObjectProperty(ns + "hasBrother");
        ObjectProperty hasSon = model.getObjectProperty(ns + "hasSon");
        ObjectProperty hasFather = model.getObjectProperty(ns + "hasFather");
        ObjectProperty hasParent = model.getObjectProperty(ns + "hasParent");
        ObjectProperty hasChild = model.getObjectProperty(ns + "hasChild");
        ObjectProperty hasMother = model.getObjectProperty(ns + "hasMother");
        ObjectProperty hasDaughter = model.getObjectProperty(ns + "hasDaughter");
        ObjectProperty hasAncestor = model.getObjectProperty(ns + "hasAncestor");
        ObjectProperty likes = model.getObjectProperty(ns + "likes");
        ObjectProperty isMarriedTo = model.getObjectProperty(ns + "isMarriedTo");
        ObjectProperty dislikes = model.getObjectProperty(ns + "dislikes");
        ObjectProperty hasSister = model.getObjectProperty(ns + "hasSister");
        ObjectProperty hasDescendant = model.getObjectProperty(ns + "hasDescendant");
        ObjectProperty hasSibling = model.getObjectProperty(ns + "hasSibling");
        OntClass Child = model.getOntClass(ns + "Child");
        OntClass Person = model.getOntClass(ns + "Person");
        OntClass PersonWithAtLeastTwoMaleChildren = model.getOntClass(ns + "PersonWithAtLeastTwoMaleChildren");
        OntClass PersonWithAtLeastTwoFemaleChildren = model.getOntClass(ns + "PersonWithAtLeastTwoFemaleChildren");
        OntClass PersonWithAtLeastTwoChildren = model.getOntClass(ns + "PersonWithAtLeastTwoChildren");
        OntClass PersonWithAtLeastFourChildren = model.getOntClass(ns + "PersonWithAtLeastFourChildren");
        OntClass Teen = model.getOntClass(ns + "Teen");
        OntClass Teenager = model.getOntClass(ns + "Teenager");
        OntClass Male = model.getOntClass(ns + "Male");
        OntClass Adult = model.getOntClass(ns + "Adult");
        OntClass Female = model.getOntClass(ns + "Female");
        OntClass Senior = model.getOntClass(ns + "Senior");
        Individual grandmother = model.getIndividual(ns + "grandmother");
        Individual grandfather = model.getIndividual(ns + "grandfather");
        Individual father = model.getIndividual(ns + "father");
        Individual son = model.getIndividual(ns + "son");
        Individual mother = model.getIndividual(ns + "mother");
        Individual daughter = model.getIndividual(ns + "daughter");
        Individual personX = model.getIndividual(ns + "personX");
        Individual personY = model.getIndividual(ns + "personY");
        Individual personZ = model.getIndividual(ns + "personZ");
        model.prepare();
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        for (int test = 0; test < 2; ++test) {
            if (test != 0) {
                kb.realize();
            }
            Assert.assertTrue((boolean)hasAncestor.hasRDFType(OWL2.TransitiveProperty));
            Assert.assertTrue((boolean)hasDescendant.hasRDFType(OWL2.TransitiveProperty));
            Assert.assertTrue((boolean)isMarriedTo.hasRDFType(OWL2.SymmetricProperty));
            Assert.assertTrue((boolean)isMarriedTo.hasRDFType(OWL2.IrreflexiveProperty));
            Assert.assertTrue((boolean)hasParent.hasSuperProperty((Property)hasAncestor, false));
            Assert.assertTrue((boolean)hasFather.hasSuperProperty((Property)hasAncestor, false));
            Assert.assertTrue((boolean)hasMother.hasSuperProperty((Property)hasAncestor, false));
            Assert.assertTrue((boolean)hasChild.hasSuperProperty((Property)hasDescendant, false));
            Assert.assertTrue((boolean)likes.hasProperty(OWL2.propertyDisjointWith, (RDFNode)dislikes));
            Assert.assertTrue((boolean)dislikes.hasProperty(OWL2.propertyDisjointWith, (RDFNode)likes));
            Assert.assertTrue((boolean)hasFather.hasProperty(OWL2.propertyDisjointWith, (RDFNode)hasMother));
            Assert.assertTrue((boolean)hasMother.hasProperty(OWL2.propertyDisjointWith, (RDFNode)hasFather));
            Assert.assertTrue((boolean)grandfather.hasRDFType((Resource)Person));
            Assert.assertTrue((boolean)grandfather.hasRDFType((Resource)Male));
            Assert.assertTrue((boolean)grandfather.hasRDFType((Resource)Senior));
            Assert.assertTrue((boolean)grandfather.hasRDFType((Resource)PersonWithAtLeastTwoChildren));
            Assert.assertTrue((boolean)grandfather.hasRDFType((Resource)PersonWithAtLeastTwoMaleChildren));
            Assert.assertTrue((boolean)grandfather.hasProperty((Property)isMarriedTo, (RDFNode)grandmother));
            Assert.assertTrue((boolean)grandfather.hasProperty((Property)hasChild, (RDFNode)father));
            Assert.assertTrue((boolean)grandfather.hasProperty((Property)hasSon, (RDFNode)father));
            Assert.assertTrue((boolean)grandfather.isDifferentFrom((Resource)grandmother));
            Assert.assertTrue((boolean)grandfather.isDifferentFrom((Resource)father));
            Assert.assertTrue((boolean)grandfather.isDifferentFrom((Resource)mother));
            Assert.assertTrue((boolean)grandfather.isDifferentFrom((Resource)son));
            Assert.assertTrue((boolean)grandfather.isDifferentFrom((Resource)daughter));
            Assert.assertTrue((boolean)grandmother.hasRDFType((Resource)Person));
            Assert.assertTrue((boolean)grandmother.hasRDFType((Resource)Female));
            Assert.assertTrue((boolean)grandmother.hasRDFType((Resource)Senior));
            Assert.assertTrue((boolean)grandmother.hasProperty((Property)isMarriedTo, (RDFNode)grandfather));
            Assert.assertTrue((boolean)grandmother.hasProperty((Property)hasChild, (RDFNode)father));
            Assert.assertFalse((boolean)grandmother.hasProperty((Property)hasSon, (RDFNode)father));
            Assert.assertTrue((boolean)father.hasRDFType((Resource)Person));
            Assert.assertTrue((boolean)father.hasRDFType((Resource)Male));
            Assert.assertTrue((boolean)father.hasRDFType((Resource)Adult));
            Assert.assertTrue((boolean)father.hasProperty((Property)hasParent, (RDFNode)grandfather));
            Assert.assertTrue((boolean)father.hasProperty((Property)hasParent, (RDFNode)grandmother));
            Assert.assertTrue((boolean)father.hasProperty((Property)hasFather, (RDFNode)grandfather));
            Assert.assertTrue((boolean)father.hasProperty((Property)hasMother, (RDFNode)grandmother));
            Assert.assertTrue((boolean)father.hasProperty((Property)hasChild, (RDFNode)son));
            Assert.assertTrue((boolean)father.hasProperty((Property)hasSon, (RDFNode)son));
            Assert.assertTrue((boolean)father.hasProperty((Property)hasChild, (RDFNode)daughter));
            Assert.assertFalse((boolean)father.hasProperty((Property)hasDaughter, (RDFNode)daughter));
            Assert.assertTrue((boolean)mother.hasRDFType((Resource)Person));
            Assert.assertTrue((boolean)mother.hasRDFType((Resource)Female));
            Assert.assertTrue((boolean)son.hasRDFType((Resource)Male));
            Assert.assertTrue((boolean)son.hasRDFType((Resource)Teenager));
            Assert.assertTrue((boolean)son.hasRDFType((Resource)Teen));
            Assert.assertTrue((boolean)son.hasProperty((Property)hasParent, (RDFNode)father));
            Assert.assertTrue((boolean)son.hasProperty((Property)hasFather, (RDFNode)father));
            Assert.assertTrue((boolean)son.hasProperty((Property)hasSibling, (RDFNode)daughter));
            Assert.assertTrue((boolean)son.hasProperty((Property)hasSister, (RDFNode)daughter));
            Assert.assertTrue((boolean)daughter.hasRDFType((Resource)Female));
            Assert.assertTrue((boolean)daughter.hasRDFType((Resource)Child));
            Assert.assertTrue((boolean)daughter.hasProperty((Property)hasAncestor, (RDFNode)grandfather));
            Assert.assertTrue((boolean)daughter.hasProperty((Property)hasAncestor, (RDFNode)grandmother));
            Assert.assertTrue((boolean)daughter.hasProperty((Property)hasParent, (RDFNode)father));
            Assert.assertTrue((boolean)daughter.hasProperty((Property)hasFather, (RDFNode)father));
            Assert.assertTrue((boolean)daughter.hasProperty((Property)hasParent, (RDFNode)mother));
            Assert.assertTrue((boolean)daughter.hasProperty((Property)hasMother, (RDFNode)mother));
            Assert.assertTrue((boolean)daughter.hasProperty((Property)hasSibling, (RDFNode)son));
            Assert.assertFalse((boolean)daughter.hasProperty((Property)hasBrother, (RDFNode)son));
            Assert.assertTrue((boolean)personX.isDifferentFrom((Resource)personY));
            Assert.assertTrue((boolean)personX.isDifferentFrom((Resource)personZ));
            Assert.assertTrue((boolean)personY.isDifferentFrom((Resource)personZ));
            Assert.assertTrue((boolean)Teen.hasEquivalentClass((Resource)Teenager));
            Assert.assertTrue((boolean)Senior.hasSuperClass((Resource)Adult));
            Assert.assertTrue((boolean)Adult.hasSubClass((Resource)Senior));
            Assert.assertTrue((boolean)Person.hasSubClass((Resource)PersonWithAtLeastTwoMaleChildren));
            Assert.assertTrue((boolean)Person.hasSubClass((Resource)PersonWithAtLeastTwoFemaleChildren));
            Assert.assertTrue((boolean)Person.hasSubClass((Resource)PersonWithAtLeastTwoChildren));
            Assert.assertTrue((boolean)Person.hasSubClass((Resource)PersonWithAtLeastFourChildren));
            Assert.assertTrue((boolean)PersonWithAtLeastTwoChildren.hasSubClass((Resource)PersonWithAtLeastFourChildren));
            Assert.assertTrue((boolean)PersonWithAtLeastTwoChildren.hasSubClass((Resource)PersonWithAtLeastTwoMaleChildren));
            Assert.assertTrue((boolean)PersonWithAtLeastTwoChildren.hasSubClass((Resource)PersonWithAtLeastTwoFemaleChildren));
            Assert.assertFalse((boolean)PersonWithAtLeastTwoFemaleChildren.hasSubClass((Resource)PersonWithAtLeastTwoMaleChildren));
            Assert.assertFalse((boolean)PersonWithAtLeastTwoMaleChildren.hasSubClass((Resource)PersonWithAtLeastTwoFemaleChildren));
        }
    }

    @Test
    public void testSibling() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "sibling.owl");
        Individual Bob = model.getIndividual(ns + "Bob");
        Individual John = model.getIndividual(ns + "John");
        Individual Jane = model.getIndividual(ns + "Jane");
        Property hasBrother = model.getProperty(ns + "hasBrother");
        Property hasSister = model.getProperty(ns + "hasSister");
        PelletTestCase.assertPropertyValues((Model)model, (Resource)Bob, hasBrother, new RDFNode[]{John});
        PelletTestCase.assertPropertyValues((Model)model, (Resource)Bob, hasSister, new RDFNode[]{Jane});
    }

    @Test
    public void testDLSafeRules() {
        String ns = "http://owldl.com/ontologies/dl-safe.owl#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        model.read(base + "dl-safe.owl");
        ObjectProperty hates = model.getObjectProperty(ns + "hates");
        ObjectProperty sibling = model.getObjectProperty(ns + "sibling");
        OntClass BadChild = model.getOntClass(ns + "BadChild");
        OntClass Child = model.getOntClass(ns + "Child");
        OntClass Grandchild = model.getOntClass(ns + "Grandchild");
        OntClass Person = model.getOntClass(ns + "Person");
        Individual Abel = model.getIndividual(ns + "Abel");
        Individual Cain = model.getIndividual(ns + "Cain");
        Individual Oedipus = model.getIndividual(ns + "Oedipus");
        Individual Remus = model.getIndividual(ns + "Remus");
        Individual Romulus = model.getIndividual(ns + "Romulus");
        model.prepare();
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        for (int test = 0; test < 1; ++test) {
            if (test != 0) {
                kb.realize();
            }
            Assert.assertTrue((boolean)Abel.hasProperty((Property)sibling, (RDFNode)Cain));
            PelletTestCase.assertIteratorValues(Abel.listPropertyValues((Property)sibling), new Resource[]{Cain});
            Assert.assertTrue((boolean)Cain.hasProperty((Property)sibling, (RDFNode)Abel));
            PelletTestCase.assertIteratorValues(Cain.listPropertyValues((Property)sibling), new Resource[]{Abel});
            Assert.assertTrue((boolean)Cain.hasProperty((Property)hates, (RDFNode)Abel));
            Assert.assertTrue((boolean)Cain.hasRDFType((Resource)Grandchild));
            Assert.assertTrue((boolean)Cain.hasRDFType((Resource)BadChild));
            Assert.assertFalse((boolean)Romulus.hasProperty((Property)sibling, (RDFNode)Remus));
            Assert.assertTrue((boolean)Romulus.hasProperty((Property)hates, (RDFNode)Remus));
            Assert.assertTrue((boolean)Romulus.hasRDFType((Resource)Grandchild));
            Assert.assertFalse((boolean)Romulus.hasRDFType((Resource)BadChild));
            Assert.assertTrue((boolean)Oedipus.hasRDFType((Resource)Child));
        }
        PelletTestCase.assertIteratorValues(Cain.listRDFTypes(true), new Object[]{BadChild, Child, Person});
    }

    @Test
    public void testDLSafeConstants() {
        String ns = "http://owldl.com/ontologies/dl-safe-constants.owl#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        model.read(base + "dl-safe-constants.owl");
        OntClass DreamTeamMember = model.getOntClass(ns + "DreamTeamMember");
        OntClass DreamTeamMember1 = model.getOntClass(ns + "DreamTeamMember1");
        OntClass DreamTeamMember2 = model.getOntClass(ns + "DreamTeamMember2");
        Individual Alice = model.getIndividual(ns + "Alice");
        Individual Bob = model.getIndividual(ns + "Bob");
        Individual Charlie = model.getIndividual(ns + "Charlie");
        model.prepare();
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        for (int test = 0; test < 1; ++test) {
            if (test != 0) {
                kb.realize();
            }
            PelletTestCase.assertIteratorValues(DreamTeamMember.listInstances(), new Object[]{Alice, Bob, Charlie});
            PelletTestCase.assertIteratorValues(DreamTeamMember1.listInstances(), new Object[]{Alice, Bob, Charlie});
            PelletTestCase.assertIteratorValues(DreamTeamMember2.listInstances(), new Object[]{Alice, Bob, Charlie});
        }
    }

    @Test
    public void testMergeRestore() {
        String src = "@prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>.\r\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>.\r\n@prefix owl: <http://www.w3.org/2002/07/owl#>.\r\n@prefix : <foo:bla#>.\r\n\r\n:one a :NoLeft .\r\n:one :right :two .\r\n:two :right :three .\r\n:three :right :four .\r\n:four :right :five .\r\n:five a :NoRight .\r\n\r\n:NoRight a owl:Class;\r\n      owl:intersectionOf (       [         a owl:Restriction;          owl:onProperty :right;          owl:cardinality 0       ] \r\n      [         a owl:Restriction;          owl:onProperty :neighbor;          owl:cardinality 1       ] ) .\r\n\r\n:NoLeft a owl:Class;\r\n      owl:intersectionOf (       [         a owl:Restriction;          owl:onProperty :left;          owl:cardinality 0       ] \r\n      [         a owl:Restriction;          owl:onProperty :neighbor;          owl:cardinality 1       ] ) .\r\n\r\n:left a owl:FunctionalProperty; owl:inverseOf :right;\r\n      rdfs:subPropertyOf :neighbor .\r\n:right a owl:FunctionalProperty; \r\n      rdfs:subPropertyOf :neighbor .\r\n\r\n:Universe a owl:Class;\r\n   owl:oneOf (:one :two :three :four :five );\r\n   rdfs:subClassOf [          a owl:Restriction;           owl:onProperty :neighbor;\r\n          owl:maxCardinality 2 ] .\r\n\r\n:neighbor rdfs:domain :Universe; rdfs:range :Universe .\r\n\r\n:x :neighbor :y . \r\n";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read((Reader)new StringReader(src), null, "Turtle");
        model.prepare();
        String ns = "foo:bla#";
        Property left = model.getProperty(ns + "left");
        Property right = model.getProperty(ns + "right");
        Resource[] r = new Resource[6];
        r[1] = model.getProperty(ns + "one");
        r[2] = model.getProperty(ns + "two");
        r[3] = model.getProperty(ns + "three");
        r[4] = model.getProperty(ns + "four");
        r[5] = model.getProperty(ns + "five");
        Assert.assertTrue((boolean)model.contains(r[5], left, (RDFNode)r[4]));
        Model rightValues = ModelFactory.createDefaultModel();
        Model leftValues = ModelFactory.createDefaultModel();
        for (int i = 1; i <= 5; ++i) {
            if (i != 5) {
                PelletTestCase.addStatements(rightValues, r[i], right, new RDFNode[]{r[i + 1]});
            }
            if (i == 1) continue;
            PelletTestCase.addStatements(leftValues, r[i], left, new RDFNode[]{r[i - 1]});
        }
        PelletTestCase.assertPropertyValues((Model)model, left, leftValues);
        PelletTestCase.assertPropertyValues((Model)model, right, rightValues);
    }

    @Test
    public void testDisjunction() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass A = model.createClass(ns + "A");
        OntClass B = model.createClass(ns + "B");
        ComplementClass notA = model.createComplementClass(null, (Resource)A);
        ComplementClass notB = model.createComplementClass(null, (Resource)B);
        UnionClass AorB = model.createUnionClass(null, model.createList((RDFNode[])new OntClass[]{A, B}));
        UnionClass AorNotB = model.createUnionClass(null, model.createList((RDFNode[])new OntClass[]{A, notB}));
        UnionClass notAorB = model.createUnionClass(null, model.createList((RDFNode[])new OntClass[]{notA, B}));
        Individual x = model.createIndividual(ns + "x", OWL.Thing);
        x.addRDFType((Resource)AorB);
        x.addRDFType((Resource)AorNotB);
        x.addRDFType((Resource)notAorB);
        Assert.assertTrue((boolean)x.hasRDFType((Resource)A));
        Assert.assertTrue((boolean)x.hasRDFType((Resource)B));
    }

    @Test
    public void testListDirectSubProps() {
        String ns = "urn:test:";
        OntModel reasoner = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        ObjectProperty p = reasoner.createObjectProperty(ns + "p");
        ObjectProperty subP = reasoner.createObjectProperty(ns + "subP");
        ObjectProperty subSubP = reasoner.createObjectProperty(ns + "subSubP");
        DatatypeProperty q = reasoner.createDatatypeProperty(ns + "q");
        DatatypeProperty subQ = reasoner.createDatatypeProperty(ns + "subQ");
        DatatypeProperty subSubQ = reasoner.createDatatypeProperty(ns + "subSubQ");
        Model assertions = ModelFactory.createDefaultModel();
        assertions.add((Resource)subP, RDFS.subPropertyOf, (RDFNode)p);
        assertions.add((Resource)subSubP, RDFS.subPropertyOf, (RDFNode)subP);
        assertions.add((Resource)subQ, RDFS.subPropertyOf, (RDFNode)q);
        assertions.add((Resource)subSubQ, RDFS.subPropertyOf, (RDFNode)subQ);
        reasoner.add(assertions);
        Model inferences = ModelFactory.createDefaultModel();
        inferences.add(assertions);
        for (Property op : new Property[]{p, subP, subSubP, q, subQ, subSubQ}) {
            inferences.add((Resource)op, RDFS.subPropertyOf, (RDFNode)op);
        }
        for (Property op : new Property[]{p, subP, subSubP, OWL2.topObjectProperty, OWL2.bottomObjectProperty}) {
            inferences.add((Resource)op, RDFS.subPropertyOf, (RDFNode)OWL2.topObjectProperty);
            inferences.add((Resource)OWL2.bottomObjectProperty, RDFS.subPropertyOf, (RDFNode)op);
        }
        for (Property dp : new Property[]{q, subQ, subSubQ, OWL2.topDataProperty, OWL2.bottomDataProperty}) {
            inferences.add((Resource)dp, RDFS.subPropertyOf, (RDFNode)OWL2.topDataProperty);
            inferences.add((Resource)OWL2.bottomDataProperty, RDFS.subPropertyOf, (RDFNode)dp);
        }
        inferences.add((Resource)subSubP, RDFS.subPropertyOf, (RDFNode)p);
        inferences.add((Resource)subSubQ, RDFS.subPropertyOf, (RDFNode)q);
        PelletTestCase.assertPropertyValues((Model)reasoner, RDFS.subPropertyOf, inferences);
        PelletTestCase.assertIteratorValues(p.listSubProperties(true), new RDFNode[]{subP});
        PelletTestCase.assertIteratorValues(subP.listSuperProperties(true), new RDFNode[]{p});
        PelletTestCase.assertIteratorValues(subP.listSubProperties(true), new RDFNode[]{subSubP});
        PelletTestCase.assertIteratorValues(subSubP.listSuperProperties(true), new RDFNode[]{subP});
        PelletTestCase.assertIteratorValues(q.listSubProperties(true), new RDFNode[]{subQ});
        PelletTestCase.assertIteratorValues(subQ.listSuperProperties(true), new RDFNode[]{q});
        PelletTestCase.assertIteratorValues(subQ.listSubProperties(true), new RDFNode[]{subSubQ});
        PelletTestCase.assertIteratorValues(subSubQ.listSuperProperties(true), new RDFNode[]{subQ});
    }

    @Test
    public void testTicket96() {
        OntModel pellet = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        pellet.read(base + "ticket-96-test-case.rdf");
        Assert.assertTrue((boolean)pellet.validate().isValid());
    }

    @Test
    public void testNaryDisjointness() {
        int i;
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "disjoints.owl");
        Model inferences = ModelFactory.createDefaultModel();
        PelletTestCase.addStatements(inferences, OWL.Nothing, OWL.disjointWith, new RDFNode[]{OWL.Nothing});
        PelletTestCase.addStatements(inferences, OWL.Nothing, OWL.disjointWith, new RDFNode[]{OWL.Thing});
        PelletTestCase.addStatements(inferences, OWL.Thing, OWL.disjointWith, new RDFNode[]{OWL.Nothing});
        for (int k = 1; k < 6; k += 3) {
            for (i = k; i < k + 3; ++i) {
                Resource c1 = model.getResource(ns + "C" + i);
                PelletTestCase.addStatements(inferences, c1, OWL.disjointWith, new RDFNode[]{OWL.Nothing});
                PelletTestCase.addStatements(inferences, OWL.Nothing, OWL.disjointWith, new RDFNode[]{c1});
                for (int j = k; j < k + 3; ++j) {
                    if (i == j) continue;
                    Resource c2 = model.getResource(ns + "C" + j);
                    PelletTestCase.addStatements(inferences, c1, OWL.disjointWith, new RDFNode[]{c2});
                }
            }
        }
        PelletTestCase.assertPropertyValues((Model)model, OWL.disjointWith, inferences);
        inferences = ModelFactory.createDefaultModel();
        PelletTestCase.addStatements(inferences, (Resource)OWL2.bottomObjectProperty, OWL2.propertyDisjointWith, new RDFNode[]{OWL2.bottomObjectProperty});
        PelletTestCase.addStatements(inferences, (Resource)OWL2.topObjectProperty, OWL2.propertyDisjointWith, new RDFNode[]{OWL2.bottomObjectProperty});
        PelletTestCase.addStatements(inferences, (Resource)OWL2.bottomObjectProperty, OWL2.propertyDisjointWith, new RDFNode[]{OWL2.topObjectProperty});
        PelletTestCase.addStatements(inferences, (Resource)OWL2.bottomDataProperty, OWL2.propertyDisjointWith, new RDFNode[]{OWL2.bottomDataProperty});
        PelletTestCase.addStatements(inferences, (Resource)OWL2.topDataProperty, OWL2.propertyDisjointWith, new RDFNode[]{OWL2.bottomDataProperty});
        PelletTestCase.addStatements(inferences, (Resource)OWL2.bottomDataProperty, OWL2.propertyDisjointWith, new RDFNode[]{OWL2.topDataProperty});
        String[] k = new String[]{"op", "dp"};
        i = k.length;
        for (int c1 = 0; c1 < i; ++c1) {
            String prefix = k[c1];
            for (int k2 = 1; k2 < 6; k2 += 3) {
                for (int i2 = k2; i2 < k2 + 3; ++i2) {
                    Resource c12 = model.getResource(ns + prefix + i2);
                    if (prefix.equals("op")) {
                        PelletTestCase.addStatements(inferences, c12, OWL2.propertyDisjointWith, new RDFNode[]{OWL2.bottomObjectProperty});
                        PelletTestCase.addStatements(inferences, (Resource)OWL2.bottomObjectProperty, OWL2.propertyDisjointWith, new RDFNode[]{c12});
                    } else {
                        PelletTestCase.addStatements(inferences, c12, OWL2.propertyDisjointWith, new RDFNode[]{OWL2.bottomDataProperty});
                        PelletTestCase.addStatements(inferences, (Resource)OWL2.bottomDataProperty, OWL2.propertyDisjointWith, new RDFNode[]{c12});
                    }
                    for (int j = k2; j < k2 + 3; ++j) {
                        if (i2 == j) continue;
                        Resource c2 = model.getResource(ns + prefix + j);
                        PelletTestCase.addStatements(inferences, c12, OWL2.propertyDisjointWith, new RDFNode[]{c2});
                    }
                }
            }
        }
        PelletTestCase.assertPropertyValues((Model)model, OWL2.propertyDisjointWith, inferences);
        inferences = ModelFactory.createDefaultModel();
        for (int k3 = 1; k3 < 6; k3 += 3) {
            for (i = k3; i < k3 + 3; ++i) {
                Resource c1 = model.getResource(ns + "ind" + i);
                for (int j = k3; j < k3 + 3; ++j) {
                    if (i == j) continue;
                    Resource c2 = model.getResource(ns + "ind" + j);
                    PelletTestCase.addStatements(inferences, c1, OWL.differentFrom, new RDFNode[]{c2});
                }
            }
        }
        PelletTestCase.assertPropertyValues((Model)model, OWL2.differentFrom, inferences);
    }

    @Test
    public void testHasKey1() {
        String ns = "http://www.example.org#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass C = model.createClass(ns + "C");
        Resource i = model.createResource(ns + "i");
        Resource j = model.createResource(ns + "j");
        Resource k = model.createResource(ns + "k");
        ObjectProperty p = model.createObjectProperty(ns + "p");
        RDFList list = model.createList(new RDFNode[]{p});
        model.add((Resource)C, OWL2.hasKey, (RDFNode)list);
        model.add(i, RDF.type, (RDFNode)C);
        model.add(i, (Property)p, (RDFNode)k);
        model.add(j, RDF.type, (RDFNode)C);
        model.add(j, (Property)p, (RDFNode)k);
        model.prepare();
        Assert.assertTrue((boolean)model.contains(i, OWL.sameAs, (RDFNode)j));
        Assert.assertTrue((boolean)model.contains(j, OWL.sameAs, (RDFNode)i));
    }

    @Test
    public void testHasKey2() {
        String ns = "http://www.example.org#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass C = model.createClass(ns + "C");
        Resource i = model.createResource(ns + "i");
        Resource j = model.createResource(ns + "j");
        Resource k = model.createResource(ns + "k");
        Resource l = model.createResource(ns + "l");
        ObjectProperty p1 = model.createObjectProperty(ns + "p1");
        ObjectProperty p2 = model.createObjectProperty(ns + "p2");
        RDFList list = model.createList(new RDFNode[]{p1, p2});
        model.add((Resource)C, OWL2.hasKey, (RDFNode)list);
        model.add(i, RDF.type, (RDFNode)C);
        model.add(i, (Property)p1, (RDFNode)k);
        model.add(i, (Property)p2, (RDFNode)l);
        model.add(j, RDF.type, (RDFNode)C);
        model.add(j, (Property)p1, (RDFNode)k);
        model.add(j, (Property)p2, (RDFNode)l);
        model.prepare();
        Assert.assertTrue((boolean)model.contains(i, OWL.sameAs, (RDFNode)j));
        Assert.assertTrue((boolean)model.contains(j, OWL.sameAs, (RDFNode)i));
    }

    @Test
    public void testHasKey3() {
        String ns = "http://www.example.org#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass C = model.createClass(ns + "C");
        Resource i = model.createResource(ns + "i");
        Resource j = model.createResource(ns + "j");
        Literal k = model.createLiteral("k");
        DatatypeProperty p = model.createDatatypeProperty(ns + "p");
        RDFList list = model.createList(new RDFNode[]{p});
        model.add((Resource)C, OWL2.hasKey, (RDFNode)list);
        model.add(i, RDF.type, (RDFNode)C);
        model.add(i, (Property)p, (RDFNode)k);
        model.add(j, RDF.type, (RDFNode)C);
        model.add(j, (Property)p, (RDFNode)k);
        model.prepare();
        Assert.assertTrue((boolean)model.contains(i, OWL.sameAs, (RDFNode)j));
        Assert.assertTrue((boolean)model.contains(j, OWL.sameAs, (RDFNode)i));
    }

    @Test
    public void testHasKey4() {
        String ns = "http://www.example.org#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass C = model.createClass(ns + "C");
        OntClass D = model.createClass(ns + "D");
        Resource i = model.createResource(ns + "i");
        Resource j = model.createResource(ns + "j");
        Resource k = model.createResource(ns + "k");
        ObjectProperty p = model.createObjectProperty(ns + "p");
        RDFList list = model.createList(new RDFNode[]{p});
        model.add((Resource)C, OWL2.hasKey, (RDFNode)list);
        model.add(i, RDF.type, (RDFNode)C);
        model.add(i, (Property)p, (RDFNode)k);
        model.add(j, RDF.type, (RDFNode)D);
        model.add(j, (Property)p, (RDFNode)k);
        model.prepare();
        Assert.assertFalse((boolean)model.contains(i, OWL.sameAs, (RDFNode)j));
        Assert.assertFalse((boolean)model.contains(j, OWL.sameAs, (RDFNode)i));
    }

    @Test
    public void testHasKey5() {
        String ns = "http://www.example.org#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass C = model.createClass(ns + "C");
        Resource i = model.createResource(ns + "i");
        Resource j = model.createResource(ns + "j");
        Resource k = model.createResource(ns + "k");
        Resource l = model.createResource(ns + "l");
        ObjectProperty p = model.createObjectProperty(ns + "p");
        RDFList list = model.createList(new RDFNode[]{p});
        model.add((Resource)C, OWL2.hasKey, (RDFNode)list);
        model.add(i, RDF.type, (RDFNode)C);
        model.add(i, (Property)p, (RDFNode)k);
        model.add(j, RDF.type, (RDFNode)C);
        model.add(j, (Property)p, (RDFNode)l);
        model.prepare();
        Assert.assertFalse((boolean)model.contains(i, OWL.sameAs, (RDFNode)j));
        Assert.assertFalse((boolean)model.contains(j, OWL.sameAs, (RDFNode)i));
    }

    @Test
    public void testHasKey6() {
        String ns = "http://www.example.org#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass C = model.createClass(ns + "C");
        Resource i = model.createResource(ns + "i");
        Resource j = model.createResource(ns + "j");
        Resource k = model.createResource(ns + "k");
        ObjectProperty p = model.createObjectProperty(ns + "p");
        ObjectProperty q = model.createObjectProperty(ns + "q");
        RDFList list = model.createList(new RDFNode[]{p});
        model.add((Resource)C, OWL2.hasKey, (RDFNode)list);
        model.add(i, RDF.type, (RDFNode)C);
        model.add(i, (Property)p, (RDFNode)k);
        model.add(j, RDF.type, (RDFNode)C);
        model.add(j, (Property)q, (RDFNode)k);
        model.prepare();
        Assert.assertFalse((boolean)model.contains(i, OWL.sameAs, (RDFNode)j));
        Assert.assertFalse((boolean)model.contains(j, OWL.sameAs, (RDFNode)i));
    }

    @Test
    public void testHasKey7() {
        String ns = "http://www.example.org#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntClass D = model.createClass(ns + "D");
        OntClass E = model.createClass(ns + "E");
        IntersectionClass C = model.createIntersectionClass(null, model.createList(new RDFNode[]{D, E}));
        Resource i = model.createResource(ns + "i");
        Resource j = model.createResource(ns + "j");
        Resource k = model.createResource(ns + "k");
        ObjectProperty p = model.createObjectProperty(ns + "p");
        RDFList list = model.createList(new RDFNode[]{p});
        model.add((Resource)C, OWL2.hasKey, (RDFNode)list);
        model.add(i, RDF.type, (RDFNode)C);
        model.add(i, (Property)p, (RDFNode)k);
        model.add(j, RDF.type, (RDFNode)C);
        model.add(j, (Property)p, (RDFNode)k);
        model.prepare();
        Assert.assertTrue((boolean)model.contains(i, OWL.sameAs, (RDFNode)j));
        Assert.assertTrue((boolean)model.contains(j, OWL.sameAs, (RDFNode)i));
    }

    @Test
    public void testHasKey8() {
        String ns = "http://www.example.org#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Resource i = model.createResource(ns + "i");
        Resource j = model.createResource(ns + "j");
        Resource k = model.createResource(ns + "k");
        ObjectProperty p = model.createObjectProperty(ns + "p");
        RDFList list = model.createList(new RDFNode[]{p});
        model.add(OWL.Thing, OWL2.hasKey, (RDFNode)list);
        model.add(i, RDF.type, (RDFNode)OWL.Thing);
        model.add(i, (Property)p, (RDFNode)k);
        model.add(j, RDF.type, (RDFNode)OWL.Thing);
        model.add(j, (Property)p, (RDFNode)k);
        model.prepare();
        Assert.assertTrue((boolean)model.contains(i, OWL.sameAs, (RDFNode)j));
        Assert.assertTrue((boolean)model.contains(j, OWL.sameAs, (RDFNode)i));
    }

    @Test
    public void testDataPropertyDefinition() {
        String ns = "foo://example#";
        String source1 = "@prefix owl: <http://www.w3.org/2002/07/owl#>.\r\n@prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#>.\r\n@prefix : <foo://example#>.\r\n:C rdfs:subClassOf [\n      a owl:Class; \n      owl:intersectionOf( [\n                  a owl:Restriction;\n                  owl:onProperty :p ;\n                  owl:minCardinality \"1\"\n                ] ) ] .";
        String source2 = "@prefix owl: <http://www.w3.org/2002/07/owl#>.\n@prefix : <foo://example#>.\n:p a owl:DatatypeProperty .\n";
        Model model1 = ModelFactory.createDefaultModel();
        model1.read((Reader)new StringReader(source1), "", "N3");
        Model model2 = ModelFactory.createDefaultModel();
        model2.read((Reader)new StringReader(source2), "", "N3");
        Model ordered = ModelFactory.createModelForGraph((Graph)new Union(model1.getGraph(), model2.getGraph()));
        OntModel pellet = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)ordered);
        Property p = pellet.getProperty(ns + "p");
        Assert.assertTrue((boolean)pellet.contains((Resource)p, RDFS.range, (RDFNode)RDFS.Literal));
    }

    @Test
    public void testRemoveSubModel() {
        String ns = "http://www.example.org#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        OntModel subModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass C = model.createClass(ns + "C");
        Resource a = model.createResource(ns + "a");
        Resource b = model.createResource(ns + "b");
        model.add(a, RDF.type, (RDFNode)C);
        subModel.add(b, RDF.type, (RDFNode)C);
        PelletTestCase.assertIteratorValues(model.listIndividuals((Resource)C), new Resource[]{a});
        model.addSubModel((Model)subModel);
        PelletTestCase.assertIteratorValues(model.listIndividuals((Resource)C), new Resource[]{a, b});
        model.removeSubModel((Model)subModel);
        PelletTestCase.assertIteratorValues(model.listIndividuals((Resource)C), new Resource[]{a});
    }

    @Test
    public void testCardinalityParsing() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "cardinality_parsing.owl");
        model.prepare();
        Assert.assertTrue((boolean)((PelletInfGraph)model.getGraph()).getLoader().getUnpportedFeatures().isEmpty());
    }

    @Test
    public void testAnnotationPropertyQuery() {
        String ns = "http://www.example.org#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        AnnotationProperty p = model.createAnnotationProperty(ns + "p");
        model.prepare();
        Assert.assertTrue((boolean)model.contains((Resource)p, RDF.type, (RDFNode)OWL.AnnotationProperty));
        PelletTestCase.assertIteratorContains(model.listObjectsOfProperty((Resource)p, RDF.type), OWL.AnnotationProperty);
        PelletTestCase.assertIteratorContains(model.listObjectsOfProperty((Resource)p, null), OWL.AnnotationProperty);
        Assert.assertTrue((boolean)model.contains((Resource)RDFS.label, RDF.type, (RDFNode)OWL.AnnotationProperty));
        PelletTestCase.assertIteratorContains(model.listObjectsOfProperty((Resource)RDFS.label, RDF.type), OWL.AnnotationProperty);
        PelletTestCase.assertIteratorContains(model.listObjectsOfProperty((Resource)RDFS.label, null), OWL.AnnotationProperty);
    }

    @Test
    public void testTopBottomPropertyAssertion() throws MalformedURLException {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        Resource a = model.createResource("a", OWL.Thing);
        Resource b = model.createResource("b", OWL.Thing);
        Literal lit = model.createLiteral("l");
        Statement[] stats = new Statement[]{model.createStatement(a, OWL2.topObjectProperty, (RDFNode)b), model.createStatement(a, OWL2.topDataProperty, (RDFNode)lit), model.createStatement(a, OWL2.bottomObjectProperty, (RDFNode)b), model.createStatement(a, OWL2.bottomDataProperty, (RDFNode)lit)};
        for (int i = 0; i < stats.length; ++i) {
            model.add(stats[i]);
            model.prepare();
            Assert.assertEquals((Object)(i < 2 ? 1 : 0), (Object)((PelletInfGraph)model.getGraph()).isConsistent());
            model.remove(stats[i]);
        }
    }

    @Test
    public void testTopBottomPropertyInferences() throws MalformedURLException {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        Resource a = model.createResource("a", OWL.Thing);
        Resource b = model.createResource("b", OWL.Thing);
        Literal lit = model.createLiteral("l");
        Property p = model.createProperty("p");
        Property dp = model.createProperty("dp");
        model.add(a, p, (RDFNode)b);
        model.add(a, dp, (RDFNode)lit);
        Assert.assertTrue((boolean)model.contains(a, p, (RDFNode)b));
        Assert.assertFalse((boolean)model.contains(b, p, (RDFNode)a));
        Assert.assertTrue((boolean)model.contains(a, OWL2.topObjectProperty, (RDFNode)b));
        Assert.assertTrue((boolean)model.contains(b, OWL2.topObjectProperty, (RDFNode)a));
        Assert.assertTrue((boolean)model.contains(a, dp, (RDFNode)lit));
        Assert.assertFalse((boolean)model.contains(b, dp, (RDFNode)lit));
        Assert.assertTrue((boolean)model.contains(a, OWL2.topDataProperty, (RDFNode)lit));
        Assert.assertTrue((boolean)model.contains(b, OWL2.topDataProperty, (RDFNode)lit));
    }

    @Test
    public void testBooleanDatatypeConstructors() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Resource nni = XSD.nonNegativeInteger;
        Resource npi = XSD.nonPositiveInteger;
        Resource ni = XSD.negativeInteger;
        Resource pi = XSD.positiveInteger;
        Resource i = XSD.integer;
        Resource f = XSD.xfloat;
        DatatypeProperty s = model.createDatatypeProperty(ns + "s");
        OntClass c1 = model.createClass(ns + "c1");
        c1.addEquivalentClass((Resource)model.createSomeValuesFromRestriction(null, (Property)s, pi));
        Assert.assertFalse((boolean)model.contains((Resource)c1, RDFS.subClassOf, (RDFNode)OWL2.Nothing));
        OntClass c2 = model.createClass(ns + "c2");
        Resource b2 = model.createResource();
        model.add(b2, RDF.type, (RDFNode)OWL2.DataRange);
        model.add(b2, OWL2.datatypeComplementOf, (RDFNode)pi);
        c2.addEquivalentClass((Resource)model.createSomeValuesFromRestriction(null, (Property)s, b2));
        Assert.assertFalse((boolean)model.contains((Resource)c2, RDFS.subClassOf, (RDFNode)OWL2.Nothing));
        OntClass c3 = model.createClass(ns + "c3");
        RDFNode[] l3 = new RDFNode[]{pi, ni};
        c3.addEquivalentClass((Resource)model.createSomeValuesFromRestriction(null, (Property)s, (Resource)model.createIntersectionClass(null, model.createList(l3))));
        Assert.assertTrue((boolean)model.contains((Resource)c3, RDFS.subClassOf, (RDFNode)OWL2.Nothing));
        OntClass c4 = model.createClass(ns + "c4");
        RDFNode[] l41 = new RDFNode[]{pi, ni};
        RDFNode[] l42 = new RDFNode[]{f, model.createUnionClass(null, model.createList(l41))};
        c4.addEquivalentClass((Resource)model.createSomeValuesFromRestriction(null, (Property)s, (Resource)model.createIntersectionClass(null, model.createList(l42))));
        Assert.assertTrue((boolean)model.contains((Resource)c4, RDFS.subClassOf, (RDFNode)OWL2.Nothing));
        OntClass c5 = model.createClass(ns + "c5");
        RDFNode[] l5 = new RDFNode[]{npi, ni};
        c5.addEquivalentClass((Resource)model.createSomeValuesFromRestriction(null, (Property)s, (Resource)model.createIntersectionClass(null, model.createList(l5))));
        Assert.assertFalse((boolean)model.contains((Resource)c5, RDFS.subClassOf, (RDFNode)OWL2.Nothing));
        OntClass c6 = model.createClass(ns + "c6");
        RDFNode[] l6 = new RDFNode[]{nni, pi};
        c6.addEquivalentClass((Resource)model.createSomeValuesFromRestriction(null, (Property)s, (Resource)model.createIntersectionClass(null, model.createList(l6))));
        Assert.assertFalse((boolean)model.contains((Resource)c6, RDFS.subClassOf, (RDFNode)OWL2.Nothing));
        OntClass c7 = model.createClass(ns + "c7");
        RDFNode[] l7 = new RDFNode[]{nni, npi};
        c7.addEquivalentClass((Resource)model.createSomeValuesFromRestriction(null, (Property)s, (Resource)model.createUnionClass(null, model.createList(l7))));
        Assert.assertFalse((boolean)model.contains((Resource)c7, RDFS.subClassOf, (RDFNode)OWL2.Nothing));
        OntClass c8 = model.createClass(ns + "c8");
        RDFNode[] l8 = new RDFNode[]{nni, npi};
        c8.addEquivalentClass((Resource)model.createSomeValuesFromRestriction(null, (Property)s, (Resource)model.createIntersectionClass(null, model.createList(l8))));
        Assert.assertFalse((boolean)model.contains((Resource)c8, RDFS.subClassOf, (RDFNode)OWL2.Nothing));
        OntClass c9 = model.createClass(ns + "c9");
        Resource fr9 = model.createResource();
        model.add(fr9, OWL2.maxExclusive, (RDFNode)model.createTypedLiteral(0));
        Resource b9 = model.createResource();
        model.add(b9, RDF.type, (RDFNode)RDFS.Datatype);
        model.add(b9, OWL2.onDatatype, (RDFNode)i);
        model.add(b9, OWL2.withRestrictions, (RDFNode)model.createList(new RDFNode[]{fr9}));
        RDFNode[] l9 = new RDFNode[]{pi, b9};
        c9.addEquivalentClass((Resource)model.createSomeValuesFromRestriction(null, (Property)s, (Resource)model.createIntersectionClass(null, model.createList(l9))));
        Assert.assertTrue((boolean)model.contains((Resource)c9, RDFS.subClassOf, (RDFNode)OWL2.Nothing));
        OntClass c10 = model.createClass(ns + "c10");
        DatatypeProperty p = model.createDatatypeProperty(ns + "p");
        Resource b10 = model.createResource();
        model.add(b10, RDF.type, (RDFNode)RDFS.Datatype);
        model.add(b10, OWL.unionOf, (RDFNode)model.createList(new RDFNode[]{pi, ni}));
        model.add((Resource)p, RDFS.range, (RDFNode)b10);
        c10.addEquivalentClass((Resource)model.createSomeValuesFromRestriction(null, (Property)p, XSD.anyURI));
        Assert.assertTrue((boolean)model.contains((Resource)c10, RDFS.subClassOf, (RDFNode)OWL2.Nothing));
    }

    @Test
    public void datatypeDefinition() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "/datatypeDefinition.ttl", "TTL");
        model.prepare();
        Resource a = model.getResource(ns + "a");
        Resource b = model.getResource(ns + "b");
        Resource A = model.getResource(ns + "A");
        Resource B = model.getResource(ns + "B");
        Assert.assertTrue((boolean)model.contains(B, RDFS.subClassOf, (RDFNode)A));
        Assert.assertTrue((boolean)model.contains(a, RDF.type, (RDFNode)A));
        Assert.assertFalse((boolean)model.contains(a, RDF.type, (RDFNode)B));
        Assert.assertTrue((boolean)model.contains(b, RDF.type, (RDFNode)A));
        Assert.assertTrue((boolean)model.contains(b, RDF.type, (RDFNode)B));
    }

    @Test
    public void testDirectType() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        String ns = "urn:test:";
        OntClass C1 = model.createClass(ns + "C1");
        OntClass C2 = model.createClass(ns + "C2");
        C1.addSubClass((Resource)C2);
        Individual ind = model.createIndividual(ns + "ind", (Resource)C2);
        Assert.assertFalse((boolean)model.contains((Resource)ind, ReasonerVocabulary.directRDFType, (RDFNode)C1));
        Assert.assertTrue((boolean)model.contains((Resource)ind, ReasonerVocabulary.directRDFType, (RDFNode)C2));
        Assert.assertTrue((boolean)model.contains((Resource)C1, ReasonerVocabulary.directSubClassOf, (RDFNode)OWL.Thing));
        Assert.assertFalse((boolean)model.contains((Resource)C2, ReasonerVocabulary.directSubClassOf, (RDFNode)OWL.Thing));
        Assert.assertTrue((boolean)model.contains((Resource)C2, ReasonerVocabulary.directSubClassOf, (RDFNode)C1));
    }

    @Test
    public void testListStatementsWithNullPredicate() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.prepare();
        String ns = "urn:test:";
        Resource c = model.createResource(ns + "C");
        Property p1 = model.createProperty(ns + "P1");
        Property p2 = model.createProperty(ns + "P2");
        Literal l = model.createLiteral("VAL");
        StatementImpl s1 = new StatementImpl(c, p1, (RDFNode)l);
        StatementImpl s2 = new StatementImpl(c, p2, (RDFNode)l);
        model.add((Statement)s1);
        model.add((Statement)new StatementImpl((Resource)p2, RDF.type, (RDFNode)OWL.DatatypeProperty));
        model.add((Statement)new StatementImpl((Resource)p2, OWL.equivalentProperty, (RDFNode)p1));
        StmtIterator iter = model.listStatements(c, null, (RDFNode)l);
        ArrayList<Object> results = new ArrayList<Object>();
        while (iter.hasNext()) {
            results.add(iter.next());
        }
        Assert.assertTrue((results.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)results.contains(s1));
        Assert.assertTrue((boolean)results.contains(s2));
    }

    @Test
    public void testUntypedProperty() {
        String ns = "http://www.example.org#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Resource C = model.createResource(ns + "C");
        Resource p = model.createResource(ns + "p");
        model.add(p, RDFS.domain, (RDFNode)C);
        PelletTestCase.assertIteratorContains(model.listStatements(p, null, (RDFNode)null), model.createStatement(p, RDF.type, (RDFNode)OWL.ObjectProperty));
    }

    @Test
    public void closeModel() {
        Model baseModel = ModelFactory.createDefaultModel();
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)baseModel);
        model.close();
        Assert.assertTrue((boolean)model.isClosed());
        Assert.assertTrue((boolean)baseModel.isClosed());
    }

    @Test
    public void closeRecursive() {
        Model baseModel = ModelFactory.createDefaultModel();
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)baseModel);
        ((PelletInfGraph)model.getGraph()).close(true);
        Assert.assertTrue((boolean)model.isClosed());
        Assert.assertTrue((boolean)baseModel.isClosed());
    }

    @Test
    public void closeNonRecursive() {
        Model baseModel = ModelFactory.createDefaultModel();
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)baseModel);
        ((PelletInfGraph)model.getGraph()).close(false);
        Assert.assertTrue((boolean)model.isClosed());
        Assert.assertFalse((boolean)baseModel.isClosed());
    }

    @Test
    public void closeMultiple() {
        Model baseModel = ModelFactory.createDefaultModel();
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)baseModel);
        ((PelletInfGraph)model.getGraph()).close(false);
        Assert.assertTrue((boolean)model.isClosed());
        Assert.assertFalse((boolean)baseModel.isClosed());
        ((PelletInfGraph)model.getGraph()).close(false);
        Assert.assertTrue((boolean)model.isClosed());
        Assert.assertFalse((boolean)baseModel.isClosed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveIndividual() {
        Properties newOptions = PropertiesBuilder.singleton((String)"PROCESS_JENA_UPDATES_INCREMENTALLY", (String)"false");
        Properties oldOptions = PelletOptions.setOptions((Properties)newOptions);
        try {
            String ns = "http://www.example.org/test#";
            OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
            OntClass C = model.createClass(ns + "C");
            ObjectProperty p = model.createObjectProperty(ns + "p");
            Resource i1 = model.createResource(ns + "i1");
            Resource i2 = model.createResource(ns + "i2");
            model.add(i1, RDF.type, (RDFNode)C);
            model.add(i1, (Property)p, (RDFNode)i2);
            model.prepare();
            model.remove(i1, (Property)p, (RDFNode)i2);
            Assert.assertTrue((boolean)model.contains(i1, RDF.type, (RDFNode)OWL.Thing));
            Assert.assertFalse((boolean)model.contains(i2, RDF.type, (RDFNode)OWL.Thing));
            model.remove(i1, RDF.type, (RDFNode)C);
            Assert.assertFalse((boolean)model.contains(i1, RDF.type, (RDFNode)OWL.Thing));
        }
        finally {
            PelletOptions.setOptions((Properties)oldOptions);
        }
    }

    @Test
    public void testLoadingOrder() {
        String NS = "urn:test:";
        Property p1 = ResourceFactory.createProperty((String)(NS + "p1"));
        Resource C1 = ResourceFactory.createResource((String)(NS + "C1"));
        Property p2 = ResourceFactory.createProperty((String)(NS + "p2"));
        Resource C2 = ResourceFactory.createResource((String)(NS + "C2"));
        OntModel m1 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        m1.add((Resource)p1, RDF.type, (RDFNode)OWL.DatatypeProperty);
        m1.add(C1, RDFS.subClassOf, (RDFNode)m1.createMinCardinalityRestriction(null, p2, 1));
        OntModel m2 = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        m2.add((Resource)p2, RDF.type, (RDFNode)OWL.DatatypeProperty);
        m2.add(C2, RDFS.subClassOf, (RDFNode)m2.createMinCardinalityRestriction(null, p1, 1));
        OntModel reasoner = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        reasoner.addSubModel((Model)m1);
        reasoner.addSubModel((Model)m2);
        PelletInfGraph pellet = (PelletInfGraph)reasoner.getGraph();
        pellet.prepare();
        Assert.assertEquals(Collections.emptySet(), (Object)pellet.getLoader().getUnpportedFeatures());
    }

    @Test
    public void retrieveSubjectsOfBnode() {
        String NS = "urn:test:";
        Resource s = ResourceFactory.createResource((String)(NS + "s"));
        Property p = ResourceFactory.createProperty((String)(NS + "p"));
        Property q = ResourceFactory.createProperty((String)(NS + "q"));
        Resource o = ResourceFactory.createResource();
        OntModel pelletModel = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        pelletModel.add((Resource)q, RDFS.subPropertyOf, (RDFNode)p);
        pelletModel.add(s, q, (RDFNode)o);
        Assert.assertEquals(Collections.singletonList(s), (Object)pelletModel.listSubjectsWithProperty(p, (RDFNode)o).toList());
    }

    @Test
    public void test549() {
        String ns = "urn:test:";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "/float_intervals.ttl", "TTL");
        model.prepare();
        Resource C1 = model.getResource(ns + "46-60");
        Resource C2 = model.getResource(ns + "76-80");
        Resource i1 = model.getResource(ns + "mark1");
        Resource i2 = model.getResource(ns + "mark2");
        PelletTestCase.assertIteratorValues(model.listSubjectsWithProperty(RDF.type, (RDFNode)C1), new Resource[]{i1});
        PelletTestCase.assertIteratorValues(model.listSubjectsWithProperty(RDF.type, (RDFNode)C2), new Resource[]{i2});
    }

    @Test
    public void testExtractor() {
        String ns = "urn:test:";
        Model rawModel = ModelFactory.createDefaultModel();
        Resource C = rawModel.createResource(ns + "C");
        Resource D = rawModel.createResource(ns + "C");
        Resource a = rawModel.createResource(ns + "a");
        rawModel.add(a, RDF.type, (RDFNode)C);
        rawModel.add(C, RDFS.subClassOf, (RDFNode)D);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)rawModel);
        ModelExtractor extractor = new ModelExtractor((Model)model);
        Model inferences = extractor.extractModel();
        Assert.assertTrue((boolean)inferences.contains(a, RDF.type, (RDFNode)D));
    }

    @Test
    public void testSubmodelUpdate1() {
        String ns = "urn:test:";
        Resource a = ResourceFactory.createResource((String)(ns + "a"));
        Resource A = ResourceFactory.createResource((String)(ns + "A"));
        Resource B = ResourceFactory.createResource((String)(ns + "B"));
        Model m1 = ModelFactory.createDefaultModel();
        m1.add(a, RDF.type, (RDFNode)A);
        Model m2 = ModelFactory.createDefaultModel();
        m2.add(B, RDF.type, (RDFNode)OWL.Class);
        Model union = ModelFactory.createUnion((Model)m1, (Model)m2);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)union);
        ((PelletInfGraph)model.getGraph()).setAutoDetectChanges(true);
        Assert.assertTrue((boolean)model.contains(a, RDF.type, (RDFNode)A));
        Assert.assertFalse((boolean)model.contains(a, RDF.type, (RDFNode)B));
        m2.add(A, RDFS.subClassOf, (RDFNode)B);
        Assert.assertTrue((boolean)model.contains(a, RDF.type, (RDFNode)A));
        Assert.assertTrue((boolean)model.contains(a, RDF.type, (RDFNode)B));
    }

    @Test
    public void testSubmodelUpdate2() {
        String ns = "urn:test:";
        Resource a = ResourceFactory.createResource((String)(ns + "a"));
        Resource A = ResourceFactory.createResource((String)(ns + "A"));
        Resource B = ResourceFactory.createResource((String)(ns + "B"));
        Model m1 = ModelFactory.createDefaultModel();
        m1.add(a, RDF.type, (RDFNode)A);
        Model m2 = ModelFactory.createDefaultModel();
        m2.add(B, RDF.type, (RDFNode)OWL.Class);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        ((PelletInfGraph)model.getGraph()).setAutoDetectChanges(true);
        Assert.assertFalse((boolean)model.contains(a, RDF.type, (RDFNode)A));
        Assert.assertFalse((boolean)model.contains(a, RDF.type, (RDFNode)B));
        model.addSubModel(m1);
        model.addSubModel(m2);
        Assert.assertTrue((boolean)model.contains(a, RDF.type, (RDFNode)A));
        Assert.assertFalse((boolean)model.contains(a, RDF.type, (RDFNode)B));
        m2.add(A, RDFS.subClassOf, (RDFNode)B);
        Assert.assertTrue((boolean)model.contains(a, RDF.type, (RDFNode)A));
        Assert.assertTrue((boolean)model.contains(a, RDF.type, (RDFNode)B));
    }

    @Test
    public void testSubmodelUpdate3() {
        String ns = "urn:test:";
        Resource a = ResourceFactory.createResource((String)(ns + "a"));
        Resource A = ResourceFactory.createResource((String)(ns + "A"));
        Resource B = ResourceFactory.createResource((String)(ns + "B"));
        Resource C = ResourceFactory.createResource((String)(ns + "C"));
        Model m1 = ModelFactory.createDefaultModel();
        m1.add(a, RDF.type, (RDFNode)A);
        Model m2 = ModelFactory.createDefaultModel();
        m2.add(B, RDF.type, (RDFNode)OWL.Class);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Assert.assertFalse((boolean)model.contains(a, RDF.type, (RDFNode)A));
        Assert.assertFalse((boolean)model.contains(a, RDF.type, (RDFNode)B));
        model.addSubModel(m1);
        model.addSubModel(m2);
        Assert.assertTrue((boolean)model.contains(a, RDF.type, (RDFNode)A));
        Assert.assertFalse((boolean)model.contains(a, RDF.type, (RDFNode)B));
        ((PelletInfGraph)model.getGraph()).setAutoDetectChanges(false);
        m2.add(A, RDFS.subClassOf, (RDFNode)B);
        Assert.assertTrue((boolean)model.contains(a, RDF.type, (RDFNode)A));
        Assert.assertFalse((boolean)model.contains(a, RDF.type, (RDFNode)B));
        ((PelletInfGraph)model.getGraph()).setAutoDetectChanges(true);
        m2.add(B, RDFS.subClassOf, (RDFNode)C);
        Assert.assertTrue((boolean)model.contains(a, RDF.type, (RDFNode)A));
        Assert.assertTrue((boolean)model.contains(a, RDF.type, (RDFNode)B));
        Assert.assertTrue((boolean)model.contains(a, RDF.type, (RDFNode)C));
    }

    @Test
    public void testSkipBuiltinPredicates() {
        String ns = "urn:test:";
        Resource a = ResourceFactory.createResource((String)(ns + "a"));
        Resource b = ResourceFactory.createResource((String)(ns + "b"));
        Resource c = ResourceFactory.createResource((String)(ns + "c"));
        Resource A = ResourceFactory.createResource((String)(ns + "A"));
        Resource B = ResourceFactory.createResource((String)(ns + "B"));
        Property p = ResourceFactory.createProperty((String)(ns + "p"));
        Property q = ResourceFactory.createProperty((String)(ns + "q"));
        Literal l = ResourceFactory.createPlainLiteral((String)"literal");
        Statement[] stmts = new Statement[]{ResourceFactory.createStatement((Resource)a, (Property)RDF.type, (RDFNode)A), ResourceFactory.createStatement((Resource)a, (Property)p, (RDFNode)b), ResourceFactory.createStatement((Resource)a, (Property)q, (RDFNode)l), ResourceFactory.createStatement((Resource)a, (Property)RDF.type, (RDFNode)OWL.Thing), ResourceFactory.createStatement((Resource)a, (Property)RDF.type, (RDFNode)B), ResourceFactory.createStatement((Resource)a, (Property)OWL.sameAs, (RDFNode)a), ResourceFactory.createStatement((Resource)a, (Property)OWL.sameAs, (RDFNode)c)};
        Model m = ModelFactory.createDefaultModel();
        m.add(stmts[0]);
        m.add(stmts[1]);
        m.add(stmts[2]);
        m.add(c, OWL.sameAs, (RDFNode)a);
        m.add(A, RDFS.subClassOf, (RDFNode)B);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)m);
        PelletTestCase.assertIteratorValues(model.listStatements(a, null, (RDFNode)null), stmts);
        ((PelletInfGraph)model.getGraph()).setSkipBuiltinPredicates(true);
        PelletTestCase.assertIteratorValues(model.listStatements(a, null, (RDFNode)null), new Statement[]{stmts[0], stmts[1], stmts[2]});
    }

    @Test
    public void testAutoRealizeEnabled() {
        this.testAutoRealize(true);
    }

    @Test
    public void testAutoRealizeDisabled() {
        this.testAutoRealize(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAutoRealize(boolean autoRealize) {
        Properties newOptions = PropertiesBuilder.singleton((String)"AUTO_REALIZE", (String)String.valueOf(autoRealize));
        Properties oldOptions = PelletOptions.setOptions((Properties)newOptions);
        try {
            String ns = "urn:test:";
            Resource a = ResourceFactory.createResource((String)(ns + "a"));
            Resource b = ResourceFactory.createResource((String)(ns + "b"));
            Resource A = ResourceFactory.createResource((String)(ns + "A"));
            Resource B = ResourceFactory.createResource((String)(ns + "B"));
            Resource C = ResourceFactory.createResource((String)(ns + "C"));
            Model m = ModelFactory.createDefaultModel();
            m.add(A, RDFS.subClassOf, (RDFNode)C);
            m.add(B, RDFS.subClassOf, (RDFNode)A);
            m.add(a, RDF.type, (RDFNode)A);
            m.add(b, RDF.type, (RDFNode)B);
            OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)m);
            PelletTestCase.assertIteratorValues(model.listObjectsOfProperty(a, RDF.type), new RDFNode[]{A, C, OWL.Thing});
            PelletTestCase.assertIteratorValues(model.getIndividual(b.getURI()).listRDFTypes(true), new Resource[]{B});
        }
        finally {
            PelletOptions.setOptions((Properties)oldOptions);
        }
    }
}

