/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.DNF;
import com.clarkparsia.pellet.datatypes.Datatypes;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.ArrayList;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Comparators;

public class ATermTests {
    public static ATermAppl a = TermFactory.term((String)"a");
    public static ATermAppl b = TermFactory.term((String)"b");
    public static ATermAppl c = TermFactory.term((String)"c");
    public static ATermAppl d = TermFactory.term((String)"d");
    public static ATermAppl p = TermFactory.term((String)"p");
    public static ATermAppl q = TermFactory.term((String)"q");
    public static ATermAppl r = TermFactory.term((String)"r");
    public static ATermAppl d1 = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)1))});
    public static ATermAppl d2 = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.maxExclusive((ATermAppl)TermFactory.literal((int)2))});
    public static ATermAppl d3 = Datatypes.INTEGER;

    public static Test suite() {
        return new JUnit4TestAdapter(ATermTests.class);
    }

    @org.junit.Test
    public void testComparator() {
        ATermAppl a = TermFactory.term((String)"http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#Carboplatin_Paclitaxel_ZD-6474");
        ATermAppl b = TermFactory.term((String)"http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#Henna");
        ATermAppl c = TermFactory.term((String)"c");
        Assert.assertTrue((a.hashCode() == b.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((a.hashCode() == c.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((0 == Comparators.termComparator.compare(a, a) ? 1 : 0) != 0);
        Assert.assertFalse((0 == Comparators.termComparator.compare(a, b) ? 1 : 0) != 0);
        Assert.assertFalse((0 == Comparators.termComparator.compare(a, c) ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testNNF() {
        this.testNNF(TermFactory.not((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)c)), TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)c)));
        this.testNNF(TermFactory.not((ATermAppl)TermFactory.all((ATermAppl)p, (ATermAppl)c)), TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)c)));
        this.testNNF(TermFactory.not((ATermAppl)TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)c)), TermFactory.max((ATermAppl)p, (int)0, (ATermAppl)c));
        this.testNNF(TermFactory.not((ATermAppl)TermFactory.max((ATermAppl)p, (int)0, (ATermAppl)c)), TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)c));
        this.testNNF(TermFactory.not((ATermAppl)TermFactory.max((ATermAppl)p, (int)1, (ATermAppl)TermFactory.not((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)c)))), TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)c))));
        this.testNNF(TermFactory.and((ATermAppl[])new ATermAppl[]{d1, d2, d3}), TermFactory.and((ATermAppl[])new ATermAppl[]{d1, d2, d3}));
        this.testNNF(TermFactory.not((ATermAppl)TermFactory.and((ATermAppl[])new ATermAppl[]{d1, d2, d3})), TermFactory.or((ATermAppl[])new ATermAppl[]{TermFactory.not((ATermAppl)d1), TermFactory.not((ATermAppl)d2), TermFactory.not((ATermAppl)d3)}));
        this.testNNF(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)d1, (ATermAppl)d3)), TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)d1, (ATermAppl)d3)));
        this.testNNF(TermFactory.not((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)d1, (ATermAppl)d3))), TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.or((ATermAppl)TermFactory.not((ATermAppl)d1), (ATermAppl)TermFactory.not((ATermAppl)d3))));
    }

    private void testNNF(ATermAppl c, ATermAppl expected) {
        junit.framework.Assert.assertEquals((Object)expected, (Object)ATermUtils.nnf((ATermAppl)c));
    }

    @org.junit.Test
    public void testNormalize() {
        this.testNormalize(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)c)), TermFactory.not((ATermAppl)TermFactory.all((ATermAppl)p, (ATermAppl)c)));
        this.testNormalize(TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)c)), TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)c)));
        this.testNormalize(TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)c)), TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)TermFactory.all((ATermAppl)q, (ATermAppl)TermFactory.not((ATermAppl)c)))));
        this.testNormalize(TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)TermFactory.not((ATermAppl)TermFactory.not((ATermAppl)c))), TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)c));
        this.testNormalize(TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)c)), TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)TermFactory.not((ATermAppl)TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)c)))));
        this.testNormalize(TermFactory.min((ATermAppl)p, (int)0, (ATermAppl)c), ATermUtils.TOP);
        this.testNormalize(TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)ATermUtils.BOTTOM), ATermUtils.BOTTOM);
        this.testNormalize(TermFactory.max((ATermAppl)p, (int)0, (ATermAppl)c), TermFactory.not((ATermAppl)TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)c)));
        this.testNormalize(TermFactory.max((ATermAppl)p, (int)1, (ATermAppl)c), TermFactory.not((ATermAppl)TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)c)));
        this.testNormalize(TermFactory.max((ATermAppl)p, (int)1, (ATermAppl)TermFactory.not((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)TermFactory.not((ATermAppl)c))))), TermFactory.not((ATermAppl)TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)c)))));
        this.testNormalize(TermFactory.max((ATermAppl)p, (int)1, (ATermAppl)ATermUtils.BOTTOM), ATermUtils.TOP);
        this.testNormalize(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)TermFactory.value((ATermAppl)a))), TermFactory.not((ATermAppl)TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.value((ATermAppl)a))));
        this.testNormalize(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)d1)), TermFactory.not((ATermAppl)TermFactory.all((ATermAppl)p, (ATermAppl)d1)));
        this.testNormalize(TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)d1)), TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)d1)));
        this.testNormalize(TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)d1)), TermFactory.all((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)TermFactory.all((ATermAppl)q, (ATermAppl)TermFactory.not((ATermAppl)d1)))));
    }

    private void testNormalize(ATermAppl c, ATermAppl expected) {
        junit.framework.Assert.assertEquals((Object)expected, (Object)ATermUtils.normalize((ATermAppl)c));
    }

    @org.junit.Test
    public void testDoubleNormalize() {
        this.testDoubleNormalize(TermFactory.and((ATermAppl[])new ATermAppl[]{a, b, c, d}), TermFactory.and((ATermAppl[])new ATermAppl[]{d, c, a, b}));
        this.testDoubleNormalize(TermFactory.and((ATermAppl[])new ATermAppl[]{a, b, c, d}), TermFactory.and((ATermAppl[])new ATermAppl[]{d, c, a, b, b, d, a, c}));
        this.testDoubleNormalize(TermFactory.and((ATermAppl)a, (ATermAppl)TermFactory.and((ATermAppl)b, (ATermAppl)c)), TermFactory.and((ATermAppl[])new ATermAppl[]{a, b, c}));
        this.testDoubleNormalize(TermFactory.or((ATermAppl[])new ATermAppl[]{a, b, c, d}), TermFactory.or((ATermAppl[])new ATermAppl[]{d, c, a, b}));
        this.testDoubleNormalize(TermFactory.or((ATermAppl[])new ATermAppl[]{a, b, c, d}), TermFactory.or((ATermAppl[])new ATermAppl[]{d, c, a, b, b, d, a, c}));
        this.testDoubleNormalize(TermFactory.or((ATermAppl)a, (ATermAppl)TermFactory.or((ATermAppl)b, (ATermAppl)c)), TermFactory.or((ATermAppl[])new ATermAppl[]{a, b, c}));
    }

    private void testDoubleNormalize(ATermAppl c1, ATermAppl c2) {
        junit.framework.Assert.assertEquals((Object)ATermUtils.normalize((ATermAppl)c1), (Object)ATermUtils.normalize((ATermAppl)c2));
    }

    @org.junit.Test
    public void testDNF() {
        this.testDNF(a, a);
        this.testDNF(TermFactory.not((ATermAppl)a), TermFactory.not((ATermAppl)a));
        this.testDNF(TermFactory.and((ATermAppl)a, (ATermAppl)b), TermFactory.and((ATermAppl)a, (ATermAppl)b));
        this.testDNF(TermFactory.or((ATermAppl)a, (ATermAppl)b), TermFactory.or((ATermAppl)a, (ATermAppl)b));
        this.testDNF(TermFactory.or((ATermAppl)a, (ATermAppl)TermFactory.and((ATermAppl)b, (ATermAppl)c)), TermFactory.or((ATermAppl)a, (ATermAppl)TermFactory.and((ATermAppl)b, (ATermAppl)c)));
        this.testDNF(TermFactory.and((ATermAppl)a, (ATermAppl)TermFactory.or((ATermAppl)b, (ATermAppl)c)), TermFactory.or((ATermAppl)TermFactory.and((ATermAppl)a, (ATermAppl)b), (ATermAppl)TermFactory.and((ATermAppl)a, (ATermAppl)c)));
        this.testDNF(TermFactory.and((ATermAppl)TermFactory.or((ATermAppl)a, (ATermAppl)b), (ATermAppl)TermFactory.or((ATermAppl)b, (ATermAppl)c)), TermFactory.or((ATermAppl[])new ATermAppl[]{TermFactory.and((ATermAppl)a, (ATermAppl)b), TermFactory.and((ATermAppl)a, (ATermAppl)c), b, TermFactory.and((ATermAppl)b, (ATermAppl)c)}));
        this.testDNF(TermFactory.and((ATermAppl)TermFactory.or((ATermAppl)a, (ATermAppl)b), (ATermAppl)TermFactory.or((ATermAppl)c, (ATermAppl)d)), TermFactory.or((ATermAppl[])new ATermAppl[]{TermFactory.and((ATermAppl)a, (ATermAppl)c), TermFactory.and((ATermAppl)a, (ATermAppl)d), TermFactory.and((ATermAppl)b, (ATermAppl)c), TermFactory.and((ATermAppl)b, (ATermAppl)d)}));
        this.testDNF(TermFactory.and((ATermAppl)a, (ATermAppl)TermFactory.or((ATermAppl)TermFactory.and((ATermAppl)b, (ATermAppl)c), (ATermAppl)d)), TermFactory.or((ATermAppl)TermFactory.and((ATermAppl[])new ATermAppl[]{a, b, c}), (ATermAppl)TermFactory.and((ATermAppl)a, (ATermAppl)d)));
    }

    private void testDNF(ATermAppl c, ATermAppl expected) {
        junit.framework.Assert.assertEquals((Object)this.canonicalize(expected), (Object)DNF.dnf((ATermAppl)c));
    }

    private ATermAppl canonicalize(ATermAppl term) {
        if (ATermUtils.isAnd((ATermAppl)term) || ATermUtils.isOr((ATermAppl)term)) {
            ArrayList<ATermAppl> list = new ArrayList<ATermAppl>();
            ATermList l = (ATermList)term.getArgument(0);
            while (!l.isEmpty()) {
                list.add(this.canonicalize((ATermAppl)l.getFirst()));
                l = l.getNext();
            }
            ATermList args = ATermUtils.toSet(list);
            if (ATermUtils.isAnd((ATermAppl)term)) {
                return ATermUtils.makeAnd((ATermList)args);
            }
            return ATermUtils.makeOr((ATermList)args);
        }
        return term;
    }

    @org.junit.Test
    public void testFindPrimitives() {
        this.testFindPrimitives(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)c)), new ATermAppl[]{c});
        this.testFindPrimitives(TermFactory.and((ATermAppl[])new ATermAppl[]{c, b, TermFactory.all((ATermAppl)p, (ATermAppl)a)}), new ATermAppl[]{a, b, c});
        this.testFindPrimitives(TermFactory.max((ATermAppl)p, (int)1, (ATermAppl)TermFactory.not((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.or((ATermAppl)a, (ATermAppl)b)))), new ATermAppl[]{a, b});
        this.testFindPrimitives(TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)TermFactory.or((ATermAppl)a, (ATermAppl)TermFactory.and((ATermAppl)b, (ATermAppl)TermFactory.not((ATermAppl)c)))), new ATermAppl[]{a, b, c});
        this.testFindPrimitives(TermFactory.and((ATermAppl[])new ATermAppl[]{TermFactory.some((ATermAppl)p, (ATermAppl)ATermUtils.TOP), TermFactory.all((ATermAppl)p, (ATermAppl)a), TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.value((ATermAppl)r)), (ATermAppl)TermFactory.or((ATermAppl)TermFactory.self((ATermAppl)p), (ATermAppl)TermFactory.max((ATermAppl)p, (int)1, (ATermAppl)b)))}), new ATermAppl[]{ATermUtils.TOP, a, b});
        this.testFindPrimitives(TermFactory.and((ATermAppl[])new ATermAppl[]{d1, d2, d3}), new ATermAppl[]{d3});
        this.testFindPrimitives(TermFactory.not((ATermAppl)TermFactory.and((ATermAppl[])new ATermAppl[]{TermFactory.not((ATermAppl)d1), d2, d3})), new ATermAppl[]{d3});
        this.testFindPrimitives(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)d1, (ATermAppl)d3)), new ATermAppl[]{d3});
    }

    private void testFindPrimitives(ATermAppl c, ATermAppl[] expected) {
        PelletTestCase.assertIteratorValues(ATermUtils.findPrimitives((ATermAppl)c).iterator(), expected);
    }
}

