/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.sparqlowl.parser.test;

import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.parser.ARQParser;
import com.clarkparsia.sparqlowl.parser.arq.ARQTerpParser;
import com.clarkparsia.sparqlowl.parser.arq.TerpSyntax;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.JUnit4TestAdapter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.JenaLoader;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.FileUtils;

@RunWith(value=Parameterized.class)
public class ParserTestParentQueries {
    public static final String base = PelletTestSuite.base + "/sparqldl-tests/simple/";
    private static KnowledgeBase kb;
    private static ARQParser parser;
    private String sparqlFile;
    private String sparqlOWLFile;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(ParserTestParentQueries.class);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{"parent1.rq", "parent1.sparqlowl"});
        parameters.add(new Object[]{"parent2.rq", "parent2.sparqlowl"});
        parameters.add(new Object[]{"parent3.rq", "parent3.sparqlowl"});
        parameters.add(new Object[]{"parent4.rq", "parent4.sparqlowl"});
        parameters.add(new Object[]{"parent5.rq", "parent5.sparqlowl"});
        parameters.add(new Object[]{"parent6.rq", "parent6.sparqlowl"});
        parameters.add(new Object[]{"parent7.rq", "parent7.sparqlowl"});
        parameters.add(new Object[]{"parent8.rq", "parent8.sparqlowl"});
        parameters.add(new Object[]{"parent9.rq", "parent9.sparqlowl"});
        return parameters;
    }

    public ParserTestParentQueries(String sparqlFile, String sparqlOWLFile) {
        this.sparqlFile = sparqlFile;
        this.sparqlOWLFile = sparqlOWLFile;
    }

    @BeforeClass
    public static void beforeClass() {
        ARQTerpParser.registerFactory();
        JenaLoader loader = new JenaLoader();
        kb = loader.createKB(new String[]{base + "parent.ttl"});
        parser = new ARQParser();
    }

    @AfterClass
    public static void afterClass() {
        ARQTerpParser.unregisterFactory();
        kb = null;
        parser = null;
    }

    @Test
    public void compareQuery() throws FileNotFoundException, IOException {
        com.hp.hpl.jena.query.Query sparql = QueryFactory.create((String)FileUtils.readFile((String)(base + this.sparqlFile)), (Syntax)Syntax.syntaxSPARQL);
        Query expected = parser.parse(sparql, kb);
        com.hp.hpl.jena.query.Query sparqlOWL = QueryFactory.create((String)FileUtils.readFile((String)(base + this.sparqlOWLFile)), (Syntax)TerpSyntax.getInstance());
        Query actual = parser.parse(sparqlOWL, kb);
        Assert.assertEquals((Object)expected.getAtoms(), (Object)actual.getAtoms());
    }
}

