/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern.ontology;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellint.lintpattern.ontology.ExistentialExplosionPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.test.PellintTestCase;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class ExistentialExplosionPatternTest
extends PellintTestCase {
    private ExistentialExplosionPattern m_Pattern;

    @Override
    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Pattern = new ExistentialExplosionPattern();
    }

    @Test
    public void testStage1SimpleCycle() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[0], (OWLClassExpression)this.m_Cls[1])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)OWL.and((OWLClassExpression[])new OWLClassExpression[]{OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[1]), OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[2])})));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[2], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[3])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[3], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[0])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[2], (OWLClassExpression)this.m_Cls[1]), (OWLClassExpression)this.m_Cls[3]));
        boolean EXPECTED_SIZE = true;
        this.m_Pattern.setMaxTreeSize(1);
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)0L, (long)lints.size());
        Assert.assertFalse((boolean)this.m_Pattern.isFixable());
    }

    @Test
    public void testStage1ZeroCard() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{OWL.min((OWLObjectPropertyExpression)this.m_Pro[0], (int)0, (OWLClassExpression)this.m_Cls[1]), OWL.min((OWLObjectPropertyExpression)this.m_Pro[0], (int)0, (OWLClassExpression)this.m_Cls[2])})));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)OWL.max((OWLObjectPropertyExpression)this.m_Pro[0], (int)0, (OWLClassExpression)this.m_Cls[0])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)OWL.max((OWLObjectPropertyExpression)this.m_Pro[0], (int)0, (OWLClassExpression)this.m_Cls[3])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[2], (OWLClassExpression)OWL.exactly((OWLObjectProperty)this.m_Pro[0], (int)0, (OWLClassExpression)this.m_Cls[3])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[2], (OWLClassExpression)OWL.exactly((OWLObjectProperty)this.m_Pro[0], (int)0, (OWLClassExpression)this.m_Cls[4])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[3], (OWLClassExpression)OWL.exactly((OWLObjectProperty)this.m_Pro[0], (int)0, (OWLClassExpression)this.m_Cls[0])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[4], (OWLClassExpression)OWL.exactly((OWLObjectProperty)this.m_Pro[0], (int)0, (OWLClassExpression)this.m_Cls[0])));
        boolean EXPECTED_SIZE = false;
        this.m_Pattern.setMaxTreeSize(0);
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)0L, (long)lints.size());
    }

    @Test
    public void testStage1Depth2() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[1])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[2])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)OWL.min((OWLObjectPropertyExpression)this.m_Pro[0], (int)2, (OWLClassExpression)this.m_Cls[0])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)OWL.min((OWLObjectPropertyExpression)this.m_Pro[0], (int)5, (OWLClassExpression)this.m_Cls[3])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[2], (OWLClassExpression)OWL.exactly((OWLObjectProperty)this.m_Pro[0], (int)1, (OWLClassExpression)this.m_Cls[3])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[2], (OWLClassExpression)OWL.exactly((OWLObjectProperty)this.m_Pro[0], (int)1, (OWLClassExpression)this.m_Cls[4])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[3], (OWLClassExpression)OWL.exactly((OWLObjectProperty)this.m_Pro[0], (int)1, (OWLClassExpression)this.m_Cls[0])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[4], (OWLClassExpression)OWL.exactly((OWLObjectProperty)this.m_Pro[0], (int)1, (OWLClassExpression)this.m_Cls[0])));
        int EXPECTED_SIZE = 8;
        this.m_Pattern.setMaxTreeSize(8);
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)0L, (long)lints.size());
        this.m_Pattern.setMaxTreeSize(7);
        lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)1L, (long)lints.size());
        Lint lint = (Lint)lints.get(0);
        Assert.assertEquals((double)8.0, (double)lint.getSeverity().doubleValue(), (double)1.0E-6);
        Assert.assertEquals((long)5L, (long)lint.getParticipatingClasses().size());
        Assert.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
    }

    @Test
    public void testStage2IndirectCycle1() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[0], (OWLClassExpression)this.m_Cls[1])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[2])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[2], (OWLClassExpression)this.m_Cls[0]));
        boolean EXPECTED_SIZE = true;
        this.m_Pattern.setMaxTreeSize(1);
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)0L, (long)lints.size());
        this.m_Pattern.setMaxTreeSize(0);
        lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)1L, (long)lints.size());
    }

    @Test
    public void testStage2IndirectCycle2() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[0], (OWLClassExpression)this.m_Cls[1])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[2])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[3])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[2], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[3])));
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((OWLClassExpression)this.m_Cls[3], (OWLClassExpression)this.m_Cls[4]));
        this.addAxiom((OWLAxiom)OWL.equivalentClasses((OWLClassExpression)this.m_Cls[4], (OWLClassExpression)this.m_Cls[0]));
        int EXPECTED_SIZE = 2;
        this.m_Pattern.setMaxTreeSize(2);
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)0L, (long)lints.size());
        this.m_Pattern.setMaxTreeSize(1);
        lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)1L, (long)lints.size());
    }

    @Test
    public void testStage3Individuals() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[0], (OWLClassExpression)this.m_Cls[1])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[2])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[2], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[0])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[3], (OWLClassExpression)this.m_Cls[0]));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[4], (OWLClassExpression)this.m_Cls[1]));
        for (int i = 0; i < this.m_Cls.length; ++i) {
            this.addAxiom((OWLAxiom)OWL.classAssertion((OWLIndividual)this.m_Ind[i], (OWLClassExpression)this.m_Cls[i]));
        }
        int EXPECTED_SIZE = 5;
        this.m_Pattern.setMaxTreeSize(4);
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)1L, (long)lints.size());
        Lint lint = (Lint)lints.get(0);
        Assert.assertEquals((double)5.0, (double)lint.getSeverity().doubleValue(), (double)1.0E-6);
        Assert.assertEquals((long)3L, (long)lint.getParticipatingClasses().size());
    }

    @Ignore(value="See ticket #288")
    @Test
    public void testStage4RemoveCycles() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[0], (OWLClassExpression)this.m_Cls[1])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[2])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[2], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[0])));
        for (int i = 0; i < this.m_Cls.length; ++i) {
            this.addAxiom((OWLAxiom)OWL.classAssertion((OWLIndividual)this.m_Ind[i], (OWLClassExpression)this.m_Cls[i]));
        }
        int EXPECTED_SIZE = 10;
        this.m_Pattern.setMaxTreeSize(9);
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)1L, (long)lints.size());
        Lint lint = (Lint)lints.get(0);
        Assert.assertEquals((double)10.0, (double)lint.getSeverity().doubleValue(), (double)1.0E-6);
        Assert.assertEquals((long)3L, (long)lint.getParticipatingClasses().size());
    }

    @Test
    public void testStage4Tree() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[0], (OWLClassExpression)this.m_Cls[1])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[1])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.min((OWLObjectPropertyExpression)this.m_Pro[0], (int)1, (OWLClassExpression)this.m_Cls[2])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)OWL.min((OWLObjectPropertyExpression)this.m_Pro[1], (int)1, (OWLClassExpression)this.m_Cls[2])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.m_Pro[1], (OWLClassExpression)this.m_Cls[3])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)OWL.exactly((OWLObjectProperty)this.m_Pro[0], (int)1, (OWLClassExpression)this.m_Cls[4])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)OWL.exactly((OWLObjectProperty)this.m_Pro[1], (int)1, (OWLClassExpression)this.m_Cls[4])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)OWL.exactly((OWLObjectProperty)this.m_Pro[2], (int)1, (OWLClassExpression)this.m_Cls[4])));
        this.addAxiom((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.m_Cls[2], (OWLClassExpression)OWL.exactly((OWLObjectProperty)this.m_Pro[3], (int)1, (OWLClassExpression)this.m_Cls[4])));
        this.addAxiom((OWLAxiom)OWL.classAssertion((OWLIndividual)this.m_Ind[0], (OWLClassExpression)this.m_Cls[0]));
        int EXPECTED_SIZE_C2 = 2;
        int EXPECTED_SIZE_C1 = 5;
        int EXPECTED_SIZE_C0 = 15;
        this.m_Pattern.setMaxTreeSize(15);
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)0L, (long)lints.size());
        this.m_Pattern.setMaxTreeSize(14);
        lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)1L, (long)lints.size());
    }
}

