/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern;

import com.clarkparsia.pellint.lintpattern.LintPatternLoader;
import com.clarkparsia.pellint.test.lintpattern.axiom.MockAxiomLintPattern;
import com.clarkparsia.pellint.test.lintpattern.ontology.MockOntologyLintPattern;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;

public class LintPatternLoaderTest {
    private static final String MOCK_AXIOM_LINT_PATTERN_NAME = MockAxiomLintPattern.class.getName();
    private static final String MOCK_ONTOLOGY_LINT_PATTERN_NAME = MockOntologyLintPattern.class.getName();
    private static final String INT_PARAM = "IntParam";
    private static final String STRING_PARAM = "StringParam";

    @Test
    public void testAxiomLintPatternSuccess() {
        int EXPECTED_INT_PARAM = 5;
        String EXPECTED_STRING_PARAM = "HERE";
        Properties prop = new Properties();
        prop.setProperty(MOCK_AXIOM_LINT_PATTERN_NAME, "ON");
        prop.setProperty(MOCK_AXIOM_LINT_PATTERN_NAME + "." + INT_PARAM, String.valueOf(5));
        prop.setProperty(MOCK_AXIOM_LINT_PATTERN_NAME + "." + STRING_PARAM, "HERE");
        LintPatternLoader loader = new LintPatternLoader(prop);
        Assert.assertEquals((long)1L, (long)loader.getAxiomLintPatterns().size());
        Assert.assertEquals((long)0L, (long)loader.getOntologyLintPatterns().size());
        MockAxiomLintPattern pattern = (MockAxiomLintPattern)((Object)loader.getAxiomLintPatterns().get(0));
        Assert.assertEquals((long)5L, (long)pattern.getIntParam());
        Assert.assertEquals((Object)"HERE", (Object)pattern.getStringParam());
    }

    @Test
    public void testOntologyLintPatternSuccess() {
        int EXPECTED_INT_PARAM = 5;
        String EXPECTED_STRING_PARAM = "HERE";
        Properties prop = new Properties();
        prop.setProperty(MOCK_ONTOLOGY_LINT_PATTERN_NAME, "ON");
        prop.setProperty(MOCK_ONTOLOGY_LINT_PATTERN_NAME + "." + INT_PARAM, String.valueOf(5));
        prop.setProperty(MOCK_ONTOLOGY_LINT_PATTERN_NAME + "." + STRING_PARAM, "HERE");
        LintPatternLoader loader = new LintPatternLoader(prop);
        Assert.assertEquals((long)1L, (long)loader.getOntologyLintPatterns().size());
        Assert.assertEquals((long)0L, (long)loader.getAxiomLintPatterns().size());
        MockOntologyLintPattern pattern = (MockOntologyLintPattern)loader.getOntologyLintPatterns().get(0);
        Assert.assertEquals((long)5L, (long)pattern.getIntParam());
        Assert.assertEquals((Object)"HERE", (Object)pattern.getStringParam());
    }

    @Test
    public void testOff() {
        Properties prop = new Properties();
        prop.setProperty(MOCK_AXIOM_LINT_PATTERN_NAME, "OFF");
        prop.setProperty(MOCK_ONTOLOGY_LINT_PATTERN_NAME, "XXX");
        LintPatternLoader loader = new LintPatternLoader(prop);
        Assert.assertEquals((Object)LintPatternLoader.DEFAULT_AXIOM_LINT_PATTERNS, (Object)loader.getAxiomLintPatterns());
        Assert.assertEquals((Object)LintPatternLoader.DEFAULT_ONTOLOGY_LINT_PATTERNS, (Object)loader.getOntologyLintPatterns());
    }

    @Test
    public void testPatternNotFound() {
        Properties prop = new Properties();
        prop.setProperty("com.foo", "on");
        prop.setProperty("com.foo", "off");
        LintPatternLoader loader = new LintPatternLoader(prop);
        Assert.assertEquals((Object)LintPatternLoader.DEFAULT_AXIOM_LINT_PATTERNS, (Object)loader.getAxiomLintPatterns());
        Assert.assertEquals((Object)LintPatternLoader.DEFAULT_ONTOLOGY_LINT_PATTERNS, (Object)loader.getOntologyLintPatterns());
    }

    @Test
    public void testParamNotFound() {
        Properties prop = new Properties();
        prop.setProperty(MOCK_AXIOM_LINT_PATTERN_NAME, "ON");
        prop.setProperty(MOCK_AXIOM_LINT_PATTERN_NAME + "." + "foo", "10");
        prop.setProperty(MOCK_ONTOLOGY_LINT_PATTERN_NAME, "ON");
        prop.setProperty(MOCK_ONTOLOGY_LINT_PATTERN_NAME + "." + "foo", "X");
        LintPatternLoader loader = new LintPatternLoader(prop);
        Assert.assertEquals((long)1L, (long)loader.getAxiomLintPatterns().size());
        Assert.assertEquals((long)1L, (long)loader.getOntologyLintPatterns().size());
        MockAxiomLintPattern axiomPattern = (MockAxiomLintPattern)((Object)loader.getAxiomLintPatterns().get(0));
        Assert.assertEquals((long)0L, (long)axiomPattern.getIntParam());
        Assert.assertNull((Object)axiomPattern.getStringParam());
        MockOntologyLintPattern ontologyPattern = (MockOntologyLintPattern)loader.getOntologyLintPatterns().get(0);
        Assert.assertEquals((long)0L, (long)ontologyPattern.getIntParam());
        Assert.assertNull((Object)ontologyPattern.getStringParam());
    }

    @Test
    public void testParamWrongType1() {
        Properties prop = new Properties();
        prop.setProperty(MOCK_AXIOM_LINT_PATTERN_NAME, "ON");
        prop.setProperty(MOCK_AXIOM_LINT_PATTERN_NAME + "." + INT_PARAM, "XXX");
        LintPatternLoader loader = new LintPatternLoader(prop);
        MockAxiomLintPattern axiomPattern = (MockAxiomLintPattern)((Object)loader.getAxiomLintPatterns().get(0));
        Assert.assertEquals((long)0L, (long)axiomPattern.getIntParam());
    }

    @Test
    public void testParamWrongType2() {
        Properties prop = new Properties();
        prop.setProperty(MOCK_AXIOM_LINT_PATTERN_NAME, "ON");
        prop.setProperty(MOCK_AXIOM_LINT_PATTERN_NAME + "." + INT_PARAM, "5.5");
        LintPatternLoader loader = new LintPatternLoader(prop);
        MockAxiomLintPattern axiomPattern = (MockAxiomLintPattern)((Object)loader.getAxiomLintPatterns().get(0));
        Assert.assertEquals((long)0L, (long)axiomPattern.getIntParam());
    }
}

