/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import java.util.Collections;
import org.junit.Before;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class PellintTestCase {
    protected static final double DOUBLE_DELTA = 1.0E-6;
    protected OWLOntologyManager m_Manager;
    protected OWLOntology m_Ontology;
    protected OWLClass[] m_Cls;
    protected OWLObjectProperty[] m_Pro;
    protected OWLIndividual[] m_Ind;
    protected OWLClassExpression m_P0AllC0;
    protected OWLClassExpression m_P0SomeC1;

    @Before
    public void setUp() throws OWLOntologyCreationException {
        int i;
        this.m_Manager = OWLManager.createOWLOntologyManager();
        IRI ontologyURI = IRI.create((String)"tag:clarkparsia.com,2008:pellint:test");
        this.m_Ontology = this.m_Manager.createOntology(ontologyURI);
        this.m_Cls = new OWLClass[5];
        for (i = 0; i < this.m_Cls.length; ++i) {
            this.m_Cls[i] = OWL.Class((String)(ontologyURI + "#C" + i));
        }
        this.m_Pro = new OWLObjectProperty[5];
        for (i = 0; i < this.m_Pro.length; ++i) {
            this.m_Pro[i] = OWL.ObjectProperty((String)(ontologyURI + "#R" + i));
        }
        this.m_Ind = new OWLIndividual[5];
        for (i = 0; i < this.m_Ind.length; ++i) {
            this.m_Ind[i] = OWL.Individual((String)(ontologyURI + "#I" + i));
        }
        this.m_P0AllC0 = OWL.all((OWLObjectPropertyExpression)this.m_Pro[0], (OWLClassExpression)this.m_Cls[0]);
        this.m_P0SomeC1 = OWL.some((OWLObjectPropertyExpression)this.m_Pro[0], (OWLClassExpression)this.m_Cls[1]);
    }

    protected void addAxiom(OWLAxiom axiom) throws OWLException {
        OntologyUtils.addAxioms((OWLOntology)this.m_Ontology, Collections.singleton(axiom));
    }
}

