/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.transtree;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.OWLAPILoader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.taxonomy.POTaxonomyBuilder;
import org.mindswap.pellet.taxonomy.SubsumptionComparator;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.printer.ClassTreePrinter;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.PartialOrderComparator;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import pellet.PelletTransTree;

public class TransTreeTest {
    @Test
    public void testDiscoveryOntology() {
        this.testProperty("test/data/trans-tree-tests/discovery.owl", "http://purl.org/vocab/relationship/ancestorOf");
    }

    private void testProperty(String ontologyURI, String propertyURI) {
        OWLAPILoader loader = new OWLAPILoader();
        KnowledgeBase kb = loader.createKB(new String[]{ontologyURI});
        OWLEntity entity = OntologyUtils.findEntity((String)propertyURI, (Set)loader.getAllOntologies());
        if (entity == null) {
            throw new IllegalArgumentException("Property not found: " + propertyURI);
        }
        if (!(entity instanceof OWLObjectProperty)) {
            throw new IllegalArgumentException("Not an object property: " + propertyURI);
        }
        if (!((OWLObjectProperty)entity).isTransitive(loader.getAllOntologies())) {
            throw new IllegalArgumentException("Not a transitive property: " + propertyURI);
        }
        ATermAppl p = ATermUtils.makeTermAppl((String)entity.getIRI().toString());
        POTaxonomyBuilder builder = null;
        builder = new POTaxonomyBuilder(kb, (PartialOrderComparator)new PartClassesComparator(kb, p));
        builder.classify();
        Taxonomy taxonomy = builder.getTaxonomy();
        ClassTreePrinter printer = new ClassTreePrinter();
        printer.print(taxonomy);
    }

    @Test
    public void filter1() {
        PelletTransTree cli = new PelletTransTree();
        cli.parseArgs(new String[]{"trans-tree", "-p", "http://clarkparsia.com/pellet/tutorial/pops#subProjectOf", "-f", "http://clarkparsia.com/pellet/tutorial/pops#Employee", "test/data/trans-tree-tests/ontology-010.ttl"});
        cli.run();
        Taxonomy taxonomy = cli.publicTaxonomy;
        Assert.assertEquals((long)5L, (long)taxonomy.getClasses().size());
        Set subclasses = taxonomy.getSubs((Object)ATermUtils.TOP);
        Assert.assertEquals((long)4L, (long)subclasses.size());
        Iterator iterator = subclasses.iterator();
        HashSet elements = new HashSet(4);
        while (iterator.hasNext()) {
            Set subclass = (Set)iterator.next();
            Assert.assertEquals((long)1L, (long)subclass.size());
            elements.add(subclass.iterator().next());
        }
        Assert.assertTrue((boolean)elements.contains(ATermUtils.makeNot((ATerm)ATermUtils.TOP)));
        Assert.assertTrue((boolean)elements.contains(ATermUtils.makeTermAppl((String)"http://clarkparsia.com/pellet/tutorial/pops#Employee")));
        Assert.assertTrue((boolean)elements.contains(ATermUtils.makeTermAppl((String)"http://clarkparsia.com/pellet/tutorial/pops#CivilServant")));
        Assert.assertTrue((boolean)elements.contains(ATermUtils.makeTermAppl((String)"http://clarkparsia.com/pellet/tutorial/pops#Contractor")));
    }

    @Test
    public void filter2() {
        PelletTransTree cli = new PelletTransTree();
        cli.parseArgs(new String[]{"trans-tree", "-p", "http://clarkparsia.com/pellet/tutorial/pops#subProjectOf", "-f", "http://clarkparsia.com/pellet/tutorial/pops#Employee", "--individuals", "test/data/trans-tree-tests/ontology-010.ttl"});
        cli.run();
        Taxonomy taxonomy = cli.publicTaxonomy;
        Set classes = taxonomy.getClasses();
        Assert.assertEquals((long)3L, (long)classes.size());
        Assert.assertTrue((boolean)classes.contains(ATermUtils.makeTermAppl((String)"http://clarkparsia.com/pellet/tutorial/pops#Employee1")));
    }

    @Test
    public void filter3() {
        PelletTransTree cli = new PelletTransTree();
        cli.parseArgs(new String[]{"trans-tree", "-p", "http://clarkparsia.com/pellet/tutorial/pops#subProjectOf", "-f", "http://clarkparsia.com/pellet/tutorial/pops#Contractor", "--individuals", "test/data/trans-tree-tests/ontology-010.ttl"});
        cli.run();
        Taxonomy taxonomy = cli.publicTaxonomy;
        Assert.assertEquals((long)2L, (long)taxonomy.getClasses().size());
    }

    private static class PartIndividualsComparator
    extends SubsumptionComparator {
        private ATermAppl p;

        public PartIndividualsComparator(KnowledgeBase kb, ATermAppl p) {
            super(kb);
            this.p = p;
        }

        protected boolean isSubsumedBy(ATermAppl a, ATermAppl b) {
            return this.kb.hasPropertyValue(a, this.p, b);
        }
    }

    private static class PartClassesComparator
    extends SubsumptionComparator {
        private ATermAppl p;

        public PartClassesComparator(KnowledgeBase kb, ATermAppl p) {
            super(kb);
            this.p = p;
        }

        protected boolean isSubsumedBy(ATermAppl a, ATermAppl b) {
            ATermAppl someB = ATermUtils.makeSomeValues((ATerm)this.p, (ATerm)b);
            return this.kb.isSubClassOf(a, someB);
        }
    }
}

