/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatypes;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtomFactory;
import com.clarkparsia.pellet.sparqldl.parser.ARQParser;
import com.clarkparsia.pellet.test.query.AbstractQueryTest;
import com.clarkparsia.pellet.utils.TermFactory;
import org.junit.Test;

public class TestMiscQueries
extends AbstractQueryTest {
    @Test
    public void domainQuery1() {
        this.classes(C, D);
        this.objectProperties(p, q);
        this.dataProperties(r);
        this.kb.addSubProperty((ATerm)q, p);
        this.kb.addDomain((ATerm)p, C);
        ATermAppl pv = TermFactory.var((String)"pv");
        ATermAppl cv = TermFactory.var((String)"cv");
        Query query = this.query(this.select(pv, cv), this.where(QueryAtomFactory.DomainAtom((ATermAppl)pv, (ATermAppl)cv)));
        this.testQuery(query, {p, TermFactory.TOP}, {q, TermFactory.TOP}, {r, TermFactory.TOP}, {TermFactory.TOP_OBJECT_PROPERTY, TermFactory.TOP}, {TermFactory.TOP_DATA_PROPERTY, TermFactory.TOP}, {TermFactory.BOTTOM_OBJECT_PROPERTY, TermFactory.TOP}, {TermFactory.BOTTOM_DATA_PROPERTY, TermFactory.TOP}, {TermFactory.BOTTOM_DATA_PROPERTY, TermFactory.BOTTOM}, {TermFactory.BOTTOM_OBJECT_PROPERTY, TermFactory.BOTTOM}, {p, C}, {q, C}, {TermFactory.BOTTOM_DATA_PROPERTY, C}, {TermFactory.BOTTOM_OBJECT_PROPERTY, C}, {TermFactory.BOTTOM_DATA_PROPERTY, D}, {TermFactory.BOTTOM_OBJECT_PROPERTY, D});
    }

    @Test
    public void domainQuery2() {
        this.classes(C, D);
        this.objectProperties(p, q);
        this.dataProperties(r);
        this.kb.addSubProperty((ATerm)q, p);
        this.kb.addDomain((ATerm)p, C);
        ATermAppl cv = TermFactory.var((String)"cv");
        Query query = this.query(this.select(cv), this.where(QueryAtomFactory.DomainAtom((ATermAppl)q, (ATermAppl)cv)));
        this.testQuery(query, {TermFactory.TOP}, {C});
    }

    @Test
    public void domainQuery3() {
        this.classes(C, D);
        this.objectProperties(p, q);
        this.dataProperties(r);
        this.kb.addSubProperty((ATerm)q, p);
        this.kb.addDomain((ATerm)p, C);
        ATermAppl pv = TermFactory.var((String)"pv");
        Query query = this.query(this.select(pv), this.where(QueryAtomFactory.DomainAtom((ATermAppl)pv, (ATermAppl)C)));
        this.testQuery(query, {p}, {q}, {TermFactory.BOTTOM_OBJECT_PROPERTY}, {TermFactory.BOTTOM_DATA_PROPERTY});
    }

    @Test
    public void rangeQuery1() {
        this.classes(C, D);
        this.objectProperties(p, q);
        this.dataProperties(r);
        this.kb.addSubProperty((ATerm)q, p);
        this.kb.addRange((ATerm)p, C);
        ATermAppl pv = TermFactory.var((String)"pv");
        ATermAppl cv = TermFactory.var((String)"cv");
        Query query = this.query(this.select(pv, cv), this.where(QueryAtomFactory.RangeAtom((ATermAppl)pv, (ATermAppl)cv), QueryAtomFactory.ObjectPropertyAtom((ATermAppl)pv)));
        this.testQuery(query, {p, TermFactory.TOP}, {q, TermFactory.TOP}, {TermFactory.TOP_OBJECT_PROPERTY, TermFactory.TOP}, {TermFactory.BOTTOM_OBJECT_PROPERTY, TermFactory.TOP}, {TermFactory.BOTTOM_OBJECT_PROPERTY, TermFactory.BOTTOM}, {p, C}, {q, C}, {TermFactory.BOTTOM_OBJECT_PROPERTY, C}, {TermFactory.BOTTOM_OBJECT_PROPERTY, D});
    }

    @Test
    public void rangeQuery2() {
        this.classes(C, D);
        this.objectProperties(p, q);
        this.dataProperties(r);
        this.kb.addSubProperty((ATerm)q, p);
        this.kb.addRange((ATerm)p, C);
        ATermAppl cv = TermFactory.var((String)"cv");
        Query query = this.query(this.select(cv), this.where(QueryAtomFactory.RangeAtom((ATermAppl)q, (ATermAppl)cv)));
        this.testQuery(query, {TermFactory.TOP}, {C});
    }

    @Test
    public void datatypeQuery() {
        this.dataProperties(p);
        this.individuals(a, b, c);
        this.kb.addPropertyValue(p, a, TermFactory.literal((int)3));
        this.kb.addPropertyValue(p, b, TermFactory.literal((int)300));
        this.kb.addPropertyValue(p, b, TermFactory.literal((String)"3"));
        Query query1 = this.query(this.select(x), this.where(QueryAtomFactory.PropertyValueAtom((ATermAppl)x, (ATermAppl)p, (ATermAppl)y), QueryAtomFactory.DatatypeAtom((ATermAppl)y, (ATermAppl)Datatypes.INTEGER)));
        this.testQuery(query1, {a}, {b});
        Query query2 = this.query(this.select(x), this.where(QueryAtomFactory.PropertyValueAtom((ATermAppl)x, (ATermAppl)p, (ATermAppl)y), QueryAtomFactory.DatatypeAtom((ATermAppl)y, (ATermAppl)Datatypes.BYTE)));
        this.testQuery(query2, new ATermAppl[][]{{a}});
    }

    @Test
    public void classQuery() {
        this.classes(A, B, C);
        Query query1 = new ARQParser().parse("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX owl: <http://www.w3.org/2002/07/owl#> SELECT ?c WHERE { ?c rdf:type owl:Class }", this.kb);
        this.testQuery(query1, {A}, {B}, {C}, {TermFactory.TOP}, {TermFactory.BOTTOM});
    }

    @Test
    public void inverseQuery() {
        this.classes(C, D);
        this.objectProperties(p, q, r);
        this.kb.addInverseProperty(q, p);
        this.kb.addSymmetricProperty(r);
        ATermAppl v = TermFactory.var((String)"v");
        Query query = this.query(this.select(v), this.where(QueryAtomFactory.InverseOfAtom((ATermAppl)q, (ATermAppl)v)));
        this.testQuery(query, new ATermAppl[][]{{p}});
    }

    @Test
    public void symmetricQuery() {
        this.classes(C, D);
        this.objectProperties(p, q, r);
        this.kb.addInverseProperty(q, p);
        this.kb.addSymmetricProperty(r);
        ATermAppl v = TermFactory.var((String)"v");
        Query query = this.query(this.select(v), this.where(QueryAtomFactory.InverseOfAtom((ATermAppl)v, (ATermAppl)v)));
        this.testQuery(query, {r}, {TermFactory.TOP_OBJECT_PROPERTY}, {TermFactory.BOTTOM_OBJECT_PROPERTY});
    }
}

