/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryImpl;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.mindswap.pellet.test.AbstractKBTests;
import org.mindswap.pellet.utils.ATermUtils;

public abstract class AbstractQueryTest
extends AbstractKBTests {
    protected static final ATermAppl x = ATermUtils.makeVar((String)"x");
    protected static final ATermAppl y = ATermUtils.makeVar((String)"y");
    protected static final ATermAppl z = ATermUtils.makeVar((String)"z");

    protected ATermAppl[] select(ATermAppl ... vars) {
        return vars;
    }

    protected QueryAtom[] where(QueryAtom ... atoms) {
        return atoms;
    }

    protected Query ask(QueryAtom ... atoms) {
        return this.query(new ATermAppl[0], atoms);
    }

    protected Query query(ATermAppl[] vars, QueryAtom[] atoms) {
        QueryImpl q = new QueryImpl(this.kb, true);
        for (ATermAppl aTermAppl : vars) {
            q.addResultVar(aTermAppl);
        }
        for (ATermAppl aTermAppl : atoms) {
            q.add((QueryAtom)aTermAppl);
        }
        for (ATermAppl var : q.getUndistVars()) {
            q.addDistVar(var, Query.VarType.INDIVIDUAL);
        }
        return q;
    }

    protected void testQuery(Query query, boolean expected) {
        QueryResult result = QueryEngine.exec((Query)query);
        Assert.assertEquals((Object)expected, (Object)(!result.isEmpty() ? 1 : 0));
    }

    protected void testQuery(Query query, ATermAppl[] ... values) {
        List resultVars = query.getResultVars();
        HashMap<List<Object>, Integer> answers = new HashMap<List<Object>, Integer>();
        for (int i = 0; i < values.length; ++i) {
            List<ATermAppl> answer = Arrays.asList(values[i]);
            Integer count = (Integer)answers.get(answer);
            if (count == null) {
                answers.put(answer, 1);
                continue;
            }
            answers.put(answer, count + 1);
        }
        QueryResult result = QueryEngine.exec((Query)query);
        for (ResultBinding binding : result) {
            ArrayList<ATermAppl> list = new ArrayList<ATermAppl>(resultVars.size());
            for (ATermAppl var : resultVars) {
                list.add(binding.getValue(var));
            }
            Integer count = (Integer)answers.get(list);
            if (count == null) {
                junit.framework.Assert.fail((String)("Unexpected binding in the result: " + list));
                continue;
            }
            if (count == 1) {
                answers.remove(list);
                continue;
            }
            answers.put(list, count - 1);
        }
        junit.framework.Assert.assertTrue((String)("Unfound bindings: " + answers.keySet()), (boolean)answers.isEmpty());
    }
}

