/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.el;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.el.SimplifiedELClassifier;
import com.clarkparsia.pellet.utils.PropertiesBuilder;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.Properties;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.JenaLoader;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyBuilder;
import org.mindswap.pellet.test.AbstractKBTests;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.mindswap.pellet.utils.progress.SilentProgressMonitor;

public class ELTests
extends AbstractKBTests {
    private static final ATermAppl[] X = new ATermAppl[5];
    private final Class<? extends TaxonomyBuilder> builderClass = SimplifiedELClassifier.class;

    @BeforeClass
    public static void initTerms() {
        for (int i = 0; i < X.length; ++i) {
            ELTests.X[i] = TermFactory.term((String)("X" + i));
        }
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(ELTests.class);
    }

    public Taxonomy<ATermAppl> getHierarchy() {
        Assert.assertTrue((String)"Expressivity is not EL", (boolean)this.kb.getExpressivity().isEL());
        TaxonomyBuilder builder = null;
        try {
            builder = this.builderClass.newInstance();
            builder.setKB(this.kb);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        builder.setProgressMonitor((ProgressMonitor)new SilentProgressMonitor());
        builder.classify();
        Taxonomy taxonomy = builder.getTaxonomy();
        return taxonomy;
    }

    @Test
    public void testEL1() {
        this.classes(A, B, C, D, E);
        this.objectProperties(p);
        this.kb.addSubClass(A, TermFactory.and((ATermAppl)B, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)C)));
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)ATermUtils.TOP), D);
        this.kb.addSubClass(TermFactory.and((ATermAppl)B, (ATermAppl)D), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(A), (Object)hierarchy.getSubs((Object)B, true));
    }

    @Test
    public void testEL2() {
        this.classes(A, C, D, E);
        this.objectProperties(p);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)C));
        this.kb.addSubClass(C, D);
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)D), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(D), (Object)hierarchy.getSupers((Object)C, true));
        Assert.assertEquals(ELTests.singletonSets(E), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testEL3a() {
        this.classes(A, C, D, E, F);
        this.objectProperties(p);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)C));
        this.kb.addSubClass(C, D);
        this.kb.addSubClass(C, E);
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)D, (ATermAppl)E)), F);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(D, E), (Object)hierarchy.getSupers((Object)C, true));
        Assert.assertEquals(ELTests.singletonSets(F), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testEL3b() {
        this.classes(A, C, D, E, F, G);
        this.objectProperties(p);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)C));
        this.kb.addSubClass(C, D);
        this.kb.addSubClass(C, E);
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)G), F);
        this.kb.addEquivalentClass(G, TermFactory.and((ATermAppl)D, (ATermAppl)E));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(D, E), (Object)hierarchy.getSupers((Object)G, true));
        Assert.assertEquals(ELTests.singletonSets(F), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testEL3c() {
        this.classes(A, C, D, E);
        this.objectProperties(p);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)C, (ATermAppl)D)));
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)C), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(E), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testEL4() {
        this.classes(A, B, C, D, E);
        this.kb.addSubClass(A, TermFactory.and((ATermAppl[])new ATermAppl[]{B, C, D}));
        this.kb.addSubClass(TermFactory.and((ATermAppl)C, (ATermAppl)D), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(A), (Object)hierarchy.getSubs((Object)B, true));
    }

    @Test
    public void testEL5a() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p);
        this.kb.addSubClass(TermFactory.and((ATermAppl)A, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)B), (ATermAppl)C))), D);
        this.kb.addSubClass(E, A);
        this.kb.addSubClass(E, F);
        this.kb.addSubClass(F, TermFactory.some((ATermAppl)p, (ATermAppl)G));
        this.kb.addSubClass(G, C);
        this.kb.addSubClass(G, TermFactory.some((ATermAppl)p, (ATermAppl)B));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(A, D, F), (Object)hierarchy.getSupers((Object)E, true));
    }

    @Test
    public void testEL5b() {
        this.classes(A, B, C, D, E, F, G, X[1], X[2], X[3]);
        this.objectProperties(p);
        this.kb.addSubClass(TermFactory.and((ATermAppl)A, (ATermAppl)X[1]), D);
        this.kb.addEquivalentClass(X[1], TermFactory.some((ATermAppl)p, (ATermAppl)X[2]));
        this.kb.addEquivalentClass(X[2], TermFactory.and((ATermAppl)X[3], (ATermAppl)C));
        this.kb.addEquivalentClass(X[3], TermFactory.some((ATermAppl)p, (ATermAppl)B));
        this.kb.addSubClass(E, A);
        this.kb.addSubClass(E, F);
        this.kb.addSubClass(F, TermFactory.some((ATermAppl)p, (ATermAppl)G));
        this.kb.addSubClass(G, C);
        this.kb.addSubClass(G, TermFactory.some((ATermAppl)p, (ATermAppl)B));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(A, D, F), (Object)hierarchy.getSupers((Object)E, true));
    }

    @Test
    public void testEL6() {
        this.classes(A, B, C, D, E, G);
        this.objectProperties(p);
        this.kb.addSubClass(TermFactory.and((ATermAppl)A, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)B, (ATermAppl)C))), D);
        this.kb.addSubClass(E, A);
        this.kb.addSubClass(E, TermFactory.some((ATermAppl)p, (ATermAppl)G));
        this.kb.addSubClass(G, B);
        this.kb.addSubClass(G, C);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(A, D), (Object)hierarchy.getSupers((Object)E, true));
    }

    @Test
    public void testEL7() {
        this.classes(A, B, C, D, E);
        this.kb.addSubClass(A, B);
        this.kb.addSubClass(TermFactory.and((ATermAppl)A, (ATermAppl)B), TermFactory.and((ATermAppl[])new ATermAppl[]{C, D, ATermUtils.TOP}));
        this.kb.addSubClass(TermFactory.and((ATermAppl)A, (ATermAppl)C), E);
        this.kb.addSubClass(TermFactory.and((ATermAppl[])new ATermAppl[]{A, D, ATermUtils.TOP}), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(B, C, D, E), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testEL8() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)B));
        this.kb.addSubClass(B, C);
        this.kb.addSubClass(C, D);
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)D, (ATermAppl)ATermUtils.TOP)), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(E), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testELNormalization1() {
        this.classes(A, B, C, D);
        this.objectProperties(p);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)B, (ATermAppl)C)));
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)C, (ATermAppl)B)), D);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(D), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testELNormalization2() {
        this.classes(A, B, C, D, E);
        this.kb.addSubClass(A, TermFactory.and((ATermAppl)B, (ATermAppl)TermFactory.and((ATermAppl)C, (ATermAppl)D)));
        this.kb.addSubClass(TermFactory.and((ATermAppl)C, (ATermAppl)TermFactory.and((ATermAppl)B, (ATermAppl)D)), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(B, C, D, E), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testELNormalization3() {
        this.classes(A, B, C, D, E, F, G);
        this.kb.addSubClass(A, TermFactory.and((ATermAppl)B, (ATermAppl)TermFactory.and((ATermAppl[])new ATermAppl[]{C, D, TermFactory.and((ATermAppl)E, (ATermAppl)F)})));
        this.kb.addSubClass(TermFactory.and((ATermAppl)TermFactory.and((ATermAppl)C, (ATermAppl)F), (ATermAppl)TermFactory.and((ATermAppl[])new ATermAppl[]{B, D, E})), G);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(B, C, D, E, F, G), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testBottom1() {
        this.classes(A, B, C, D);
        this.kb.addSubClass(A, ATermUtils.BOTTOM);
        this.kb.addSubClass(C, TermFactory.and((ATermAppl)A, (ATermAppl)B));
        this.kb.addSubClass(ATermUtils.BOTTOM, D);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{A, C}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @Test
    public void testBottom2() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)B));
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)B), C);
        this.kb.addSubClass(C, ATermUtils.BOTTOM);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{A, C}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @Test
    public void testTop1() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addSubClass(ATermUtils.TOP, A);
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)B));
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)A), D);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(D), (Object)hierarchy.getSupers((Object)C, true));
    }

    @Test
    public void testBottomWithSome1() {
        this.classes(A, B);
        this.objectProperties(p);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)B));
        this.kb.addSubClass(B, ATermUtils.BOTTOM);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{A, B}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @Test
    public void testBottomWithSome2() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addSubClass(B, TermFactory.some((ATermAppl)p, (ATermAppl)A));
        this.kb.addSubClass(A, ATermUtils.BOTTOM);
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)q, (ATermAppl)B));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{A, B, C}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @Test
    public void testDisjoint() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addSubClass(TermFactory.and((ATermAppl)A, (ATermAppl)B), ATermUtils.BOTTOM);
        this.kb.addSubClass(A, B);
        this.kb.addDisjointClass(C, D);
        this.kb.addEquivalentClass(C, D);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{A, C, D}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @Test
    public void testDisjointWithSome1() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addSubProperty((ATerm)p, q);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)B));
        this.kb.addSubClass(A, D);
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)B), TermFactory.some((ATermAppl)p, (ATermAppl)C));
        this.kb.addDisjointClass(TermFactory.some((ATermAppl)q, (ATermAppl)C), D);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{A}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @Test
    public void testDisjointWithSome2() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)B, (ATermAppl)C)));
        this.kb.addDisjointClass(B, C);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{A}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @Test
    public void testRoles1a() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addSubProperty((ATerm)p, q);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)B));
        this.kb.addSubClass(TermFactory.some((ATermAppl)q, (ATermAppl)B), C);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(C), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testRoles1b() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addSubProperty((ATerm)p, q);
        this.kb.addSubClass(A, TermFactory.and((ATermAppl)D, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)B)));
        this.kb.addSubClass(TermFactory.and((ATermAppl)D, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)B)), C);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(C, D), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testRoles2a() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, p}), p);
        this.kb.addSubProperty((ATerm)q, p);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)B)));
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)B), C);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(C), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testRoles2b() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), p);
        this.kb.addSubProperty((ATerm)r, q);
        this.kb.addSubClass(A, TermFactory.and((ATermAppl)F, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)B)));
        this.kb.addSubClass(B, TermFactory.and((ATermAppl)G, (ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)C)));
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)q, (ATermAppl)D));
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)D), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(E, F), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testRoles2c() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), p);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), r);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)B));
        this.kb.addSubClass(B, TermFactory.some((ATermAppl)q, (ATermAppl)C));
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)q, (ATermAppl)D));
        this.kb.addSubClass(TermFactory.some((ATermAppl)r, (ATermAppl)D), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(E), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testRoles3a() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q, r}), p);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)B));
        this.kb.addSubClass(B, TermFactory.some((ATermAppl)q, (ATermAppl)C));
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)r, (ATermAppl)D));
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)D), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(E), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testRoles3b() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q, r}), p);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q, s}), s);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)B));
        this.kb.addSubClass(B, TermFactory.some((ATermAppl)q, (ATermAppl)C));
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)r, (ATermAppl)D));
        this.kb.addSubClass(D, TermFactory.some((ATermAppl)q, (ATermAppl)E));
        this.kb.addSubClass(E, TermFactory.some((ATermAppl)s, (ATermAppl)F));
        this.kb.addSubClass(TermFactory.some((ATermAppl)s, (ATermAppl)F), G);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(G), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testRoles4() {
        this.classes(A, B, C, D, E, F, G, X[0], X[1]);
        this.objectProperties(p, q, r, s);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{q, r}), s);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q, r, s}), p);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, s}), p);
        this.kb.addSubClass(X[0], X[1]);
        this.kb.addSubClass(A, TermFactory.and((ATermAppl)X[0], (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)B)));
        this.kb.addSubClass(B, TermFactory.and((ATermAppl)X[1], (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)C)));
        this.kb.addSubClass(C, TermFactory.and((ATermAppl)X[2], (ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)D)));
        this.kb.addSubClass(D, TermFactory.and((ATermAppl)X[1], (ATermAppl)TermFactory.some((ATermAppl)s, (ATermAppl)E)));
        this.kb.addSubClass(TermFactory.and((ATermAppl)X[0], (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)E)), F);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(X[0], F), (Object)hierarchy.getSupers((Object)A, true));
    }

    @Test
    public void testHeart() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb = new KnowledgeBase();
        ATermAppl endocardium = TermFactory.term((String)"Endocardium");
        ATermAppl tissue = TermFactory.term((String)"Tissue");
        ATermAppl heartWall = TermFactory.term((String)"HeartWall");
        ATermAppl heartValve = TermFactory.term((String)"HeartValve");
        ATermAppl bodyWall = TermFactory.term((String)"BodyWall");
        ATermAppl bodyValve = TermFactory.term((String)"BodyValve");
        ATermAppl heart = TermFactory.term((String)"Heart");
        ATermAppl endocarditis = TermFactory.term((String)"Endocarditis");
        ATermAppl inflammation = TermFactory.term((String)"Inflammation");
        ATermAppl disease = TermFactory.term((String)"Disease");
        ATermAppl heartDisease = TermFactory.term((String)"HeartDisease");
        ATermAppl criticalDisease = TermFactory.term((String)"CriticalDisease");
        ATermAppl contIn = TermFactory.term((String)"cont-in");
        ATermAppl partOf = TermFactory.term((String)"part-of");
        ATermAppl hasLoc = TermFactory.term((String)"has-loc");
        ATermAppl actsOn = TermFactory.term((String)"acts-on");
        this.kb.addClass(endocardium);
        this.kb.addClass(tissue);
        this.kb.addClass(heartWall);
        this.kb.addClass(heartValve);
        this.kb.addClass(bodyWall);
        this.kb.addClass(bodyValve);
        this.kb.addClass(heart);
        this.kb.addClass(endocarditis);
        this.kb.addClass(inflammation);
        this.kb.addClass(disease);
        this.kb.addClass(heartDisease);
        this.kb.addClass(criticalDisease);
        this.kb.addObjectProperty((ATerm)contIn);
        this.kb.addObjectProperty((ATerm)partOf);
        this.kb.addObjectProperty((ATerm)hasLoc);
        this.kb.addObjectProperty((ATerm)actsOn);
        this.kb.addSubClass(endocardium, TermFactory.and((ATermAppl[])new ATermAppl[]{tissue, TermFactory.some((ATermAppl)contIn, (ATermAppl)heartWall), TermFactory.some((ATermAppl)contIn, (ATermAppl)heartValve)}));
        this.kb.addSubClass(heartWall, TermFactory.and((ATermAppl)bodyWall, (ATermAppl)TermFactory.some((ATermAppl)partOf, (ATermAppl)heart)));
        this.kb.addSubClass(heartValve, TermFactory.and((ATermAppl)bodyValve, (ATermAppl)TermFactory.some((ATermAppl)partOf, (ATermAppl)heart)));
        this.kb.addSubClass(endocarditis, TermFactory.and((ATermAppl)inflammation, (ATermAppl)TermFactory.some((ATermAppl)hasLoc, (ATermAppl)endocardium)));
        this.kb.addSubClass(inflammation, TermFactory.and((ATermAppl)disease, (ATermAppl)TermFactory.some((ATermAppl)actsOn, (ATermAppl)tissue)));
        this.kb.addSubClass(TermFactory.and((ATermAppl)heartDisease, (ATermAppl)TermFactory.some((ATermAppl)hasLoc, (ATermAppl)heartValve)), criticalDisease);
        this.kb.addEquivalentClass(heartDisease, TermFactory.and((ATermAppl)disease, (ATermAppl)TermFactory.some((ATermAppl)hasLoc, (ATermAppl)heart)));
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{partOf, partOf}), partOf);
        this.kb.addSubProperty((ATerm)partOf, contIn);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{hasLoc, contIn}), hasLoc);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(ATermUtils.TOP, inflammation, disease, heartDisease, criticalDisease), (Object)hierarchy.getSupers((Object)endocarditis));
    }

    @Test
    public void testDomain1() {
        this.classes(A, B);
        this.objectProperties(p);
        this.kb.addDomain((ATerm)p, A);
        this.kb.addSubClass(B, TermFactory.some((ATermAppl)p, (ATermAppl)ATermUtils.TOP));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(A), (Object)hierarchy.getSupers((Object)B, true));
    }

    @Test
    public void testDomain2() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addDomain((ATerm)p, TermFactory.and((ATermAppl)A, (ATermAppl)B));
        this.kb.addDomain((ATerm)p, C);
        this.kb.addSubClass(B, TermFactory.some((ATermAppl)p, (ATermAppl)ATermUtils.TOP));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(A, C), (Object)hierarchy.getSupers((Object)B, true));
    }

    @Test
    public void testDomainAbsorption() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addDomain((ATerm)p, A);
        this.kb.addSubClass(TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)B), (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)ATermUtils.TOP)), C);
        this.kb.addSubClass(E, TermFactory.some((ATermAppl)p, (ATermAppl)D));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(A), (Object)hierarchy.getSupers((Object)E, true));
    }

    @Test
    public void testDomainBottom() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addDomain((ATerm)p, ATermUtils.BOTTOM);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)B));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{A}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @Test
    public void testReflexiveRole() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addReflexiveProperty(p);
        this.kb.addRange((ATerm)p, A);
        this.kb.addRange((ATerm)p, TermFactory.and((ATermAppl)B, (ATermAppl)C));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{A, B, C}), (Object)hierarchy.getEquivalents((Object)ATermUtils.TOP));
    }

    @Test
    public void testRange1() {
        this.classes(A, B, C, D);
        this.objectProperties(p);
        this.kb.addRange((ATerm)p, A);
        this.kb.addSubClass(B, TermFactory.some((ATermAppl)p, (ATermAppl)C));
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)A), D);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(D), (Object)hierarchy.getSupers((Object)B, true));
    }

    @Test
    public void testRange2() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addRange((ATerm)p, TermFactory.and((ATermAppl)A, (ATermAppl)B));
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)D));
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)A, (ATermAppl)B)), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(E), (Object)hierarchy.getSupers((Object)C, true));
    }

    @Test
    public void testRange3() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addRange((ATerm)p, TermFactory.and((ATermAppl)A, (ATermAppl)B));
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)D));
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)A), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(E), (Object)hierarchy.getSupers((Object)C, true));
    }

    @Test
    public void testRange5() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addRange((ATerm)p, A);
        this.kb.addSubClass(B, TermFactory.and((ATermAppl)A, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)C)));
        this.kb.addSubClass(C, A);
        this.kb.addEquivalentClass(D, TermFactory.some((ATermAppl)p, (ATermAppl)C));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(B, C), (Object)hierarchy.getSubs((Object)A, true));
    }

    @Test
    public void testDomainNormalization1() {
        this.classes(A, B, C, D, E, F, G, X[1]);
        this.objectProperties(p, q, r, s);
        this.kb.addDomain((ATerm)p, TermFactory.some((ATermAppl)q, (ATermAppl)C));
        this.kb.addDomain((ATerm)p, TermFactory.and((ATermAppl)B, (ATermAppl)C));
        this.kb.addSubClass(D, TermFactory.some((ATermAppl)p, (ATermAppl)X[1]));
        this.kb.addSubClass(TermFactory.some((ATermAppl)q, (ATermAppl)C), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(B, C, E), (Object)hierarchy.getSupers((Object)D, true));
    }

    @Test
    public void testRangeNormalization1() {
        this.classes(A, B, C, D, E, F, G, X[1]);
        this.objectProperties(p, q, r, s);
        this.kb.addRange((ATerm)p, A);
        this.kb.addRange((ATerm)p, TermFactory.and((ATermAppl)B, (ATermAppl)C));
        this.kb.addSubClass(D, TermFactory.some((ATermAppl)p, (ATermAppl)X[1]));
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)TermFactory.and((ATermAppl)A, (ATermAppl)B), (ATermAppl)C)), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(E), (Object)hierarchy.getSupers((Object)D, true));
    }

    @Test
    public void testRangeNormalization2() {
        this.classes(A, B, C, D, E, F, G, X[0]);
        this.objectProperties(p, q, r, s);
        this.kb.addRange((ATerm)p, TermFactory.some((ATermAppl)q, (ATermAppl)A));
        this.kb.addSubClass(B, TermFactory.some((ATermAppl)p, (ATermAppl)X[0]));
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)A)), C);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(C), (Object)hierarchy.getSupers((Object)B, true));
    }

    @Test
    public void testDomainAndRange() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addRange((ATerm)p, A);
        this.kb.addDomain((ATerm)q, B);
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)ATermUtils.TOP));
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)A), TermFactory.some((ATermAppl)q, (ATermAppl)ATermUtils.TOP));
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(B), (Object)hierarchy.getSupers((Object)C, true));
    }

    @Test
    public void testRange4() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addRange((ATerm)p, C);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)B));
        this.kb.addSubClass(TermFactory.and((ATermAppl)B, (ATermAppl)C), D);
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)D), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(A), (Object)hierarchy.getSubs((Object)E, true));
    }

    @Test
    public void testSomeConjunction() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl[])new ATermAppl[]{B, C, D})));
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)B, (ATermAppl)C)), E);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(A), (Object)hierarchy.getSubs((Object)E, true));
    }

    @Test
    public void testDisjointRange() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addRange((ATerm)p, C);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)B));
        this.kb.addDisjointClass(B, C);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{A}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @Test
    public void testDisjointRangeSuper() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addRange((ATerm)p, C);
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)B));
        this.kb.addSubClass(B, D);
        this.kb.addDisjointClass(D, C);
        this.kb.addSubClass(A, E);
        this.kb.addSubClass(B, F);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals((Object)SetUtils.create((Object[])new ATermAppl[]{A}), (Object)hierarchy.getEquivalents((Object)ATermUtils.BOTTOM));
    }

    @Test
    public void testTicket424() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        JenaLoader loader = new JenaLoader();
        KnowledgeBase kb = loader.createKB(new String[]{"file:" + PelletTestSuite.base + "misc/ticket-424-test-case.owl"});
        Taxonomy toldTaxonomy = kb.getToldTaxonomy();
        try {
            for (ATermAppl aTerm : kb.getClasses()) {
                Assert.assertNotNull((Object)toldTaxonomy.getNode((Object)aTerm));
                toldTaxonomy.getFlattenedSubs((Object)TermFactory.TOP, false);
            }
        }
        catch (NullPointerException e) {
            Assert.fail((String)"Caught NullPointerException when querying the told taxonomy: ticket #424");
        }
    }

    @Test
    public void testTicket465() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        this.kb.addSubClass(B, A);
        this.kb.addSubClass(C, B);
        this.kb.addSubClass(F, C);
        this.kb.addSubClass(F, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)G), (ATermAppl)E)));
        this.kb.addEquivalentClass(D, TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)E), (ATermAppl)A));
        this.kb.addSubProperty((ATerm)p, q);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(F), (Object)hierarchy.getSubs((Object)D, true));
    }

    @Test
    public void testNestedSubProperty() {
        this.classes(A, B, C);
        this.objectProperties(p, q, r);
        this.kb.addEquivalentClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)C)));
        this.kb.addEquivalentClass(B, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)C)));
        this.kb.addSubProperty((ATerm)q, r);
        Taxonomy<ATermAppl> hierarchy = this.getHierarchy();
        Assert.assertEquals(ELTests.singletonSets(A), (Object)hierarchy.getSubs((Object)B, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testELClassifierEnabled() {
        this.classes(A, B, C, D, E, F, G);
        this.objectProperties(p, q, r, s);
        boolean savedValue = PelletOptions.DISABLE_EL_CLASSIFIER;
        try {
            PelletOptions.DISABLE_EL_CLASSIFIER = false;
            JenaLoader loader = new JenaLoader();
            KnowledgeBase kb = loader.createKB(new String[]{"file:" + PelletTestSuite.base + "misc/ticket-424-test-case.owl"});
            Assert.assertEquals(SimplifiedELClassifier.class, kb.getTaxonomyBuilder().getClass());
        }
        finally {
            PelletOptions.DISABLE_EL_CLASSIFIER = savedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testELClassifierDisabled() {
        boolean savedValue = PelletOptions.DISABLE_EL_CLASSIFIER;
        try {
            PelletOptions.DISABLE_EL_CLASSIFIER = true;
            JenaLoader loader = new JenaLoader();
            KnowledgeBase kb = loader.createKB(new String[]{"file:" + PelletTestSuite.base + "misc/ticket-424-test-case.owl"});
            Assert.assertFalse((boolean)SimplifiedELClassifier.class.equals(kb.getTaxonomyBuilder().getClass()));
        }
        finally {
            PelletOptions.DISABLE_EL_CLASSIFIER = savedValue;
        }
    }

    @Test
    public void testDisableELClassifierOptionRead() {
        Properties newOptions = new PropertiesBuilder().set("DISABLE_EL_CLASSIFIER", "true").build();
        Properties savedOptions = PelletOptions.setOptions((Properties)newOptions);
        try {
            Assert.assertTrue((boolean)PelletOptions.DISABLE_EL_CLASSIFIER);
            newOptions = new PropertiesBuilder().set("DISABLE_EL_CLASSIFIER", "false").build();
            PelletOptions.setOptions((Properties)newOptions);
            Assert.assertFalse((boolean)PelletOptions.DISABLE_EL_CLASSIFIER);
        }
        finally {
            PelletOptions.setOptions((Properties)savedOptions);
        }
    }

    @Test
    public void testELExpressivityAnonymousInverseRestriction() {
        this.classes(C, D);
        this.objectProperties(p);
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)D));
        Assert.assertFalse((boolean)this.kb.getExpressivity().isEL());
        Assert.assertFalse((boolean)SimplifiedELClassifier.class.equals(this.kb.getTaxonomyBuilder().getClass()));
    }

    @Test
    public void testELExpressivityAnonymousInverseChain() {
        this.classes(C, D);
        this.objectProperties(p, q, r);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, TermFactory.inv((ATermAppl)q)}), r);
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)D));
        Assert.assertFalse((boolean)this.kb.getExpressivity().isEL());
        Assert.assertFalse((boolean)SimplifiedELClassifier.class.equals(this.kb.getTaxonomyBuilder().getClass()));
    }
}

