/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.classification;

import com.clarkparsia.pellet.test.classification.AbstractClassificationTest;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.ArrayList;
import org.junit.Assert;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class JenaClassificationTest
extends AbstractClassificationTest {
    @Override
    public void testClassification(String inputOnt, String classifiedOnt) {
        OntModel premise = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        premise.read(inputOnt);
        premise.prepare();
        Model conclusion = ModelFactory.createDefaultModel();
        conclusion.read(classifiedOnt);
        StmtIterator stmtIter = conclusion.listStatements();
        ArrayList<String> nonEntailments = new ArrayList<String>();
        while (stmtIter.hasNext()) {
            Statement stmt = stmtIter.nextStatement();
            boolean entailed = true;
            if (stmt.getPredicate().equals(RDFS.subClassOf)) {
                entailed = premise.contains(stmt.getSubject(), ReasonerVocabulary.directSubClassOf, stmt.getObject());
            } else if (stmt.getPredicate().equals(OWL.equivalentClass)) {
                entailed = premise.contains(stmt);
            }
            if (entailed) continue;
            if (AbstractClassificationTest.FAIL_AT_FIRST_ERROR) {
                Assert.fail((String)("Not entailed: " + JenaClassificationTest.format(stmt)));
                continue;
            }
            nonEntailments.add(JenaClassificationTest.format(stmt));
        }
        Assert.assertTrue((String)((Object)nonEntailments).toString(), (boolean)nonEntailments.isEmpty());
    }

    private static String format(Statement stmt) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            sb.append(stmt.getSubject().getLocalName());
            sb.append(',');
            sb.append(stmt.getPredicate().getLocalName());
            sb.append(',');
            sb.append(stmt.getResource().getLocalName());
            sb.append(']');
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return stmt.toString();
        }
    }
}

