/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.annotations;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.HashSet;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class TestReasoningWithAnnotationAxioms {
    KnowledgeBase kb = new KnowledgeBase();
    ATermAppl i = ATermUtils.makeTermAppl((String)"i");
    ATermAppl p1 = ATermUtils.makeTermAppl((String)"p1");
    ATermAppl o1 = ATermUtils.makePlainLiteral((String)"o1");
    ATermAppl o2 = ATermUtils.makePlainLiteral((String)"o2");
    ATermAppl p2 = ATermUtils.makeTermAppl((String)"p2");
    ATermAppl p3 = ATermUtils.makeTermAppl((String)"p3");
    OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    OWLNamedIndividual oi = this.manager.getOWLDataFactory().getOWLNamedIndividual(IRI.create((String)"i"));
    OWLAnnotationProperty op1 = this.manager.getOWLDataFactory().getOWLAnnotationProperty(IRI.create((String)"p1"));
    OWLAnnotationProperty op2 = this.manager.getOWLDataFactory().getOWLAnnotationProperty(IRI.create((String)"p2"));
    OWLAnnotationProperty op3 = this.manager.getOWLDataFactory().getOWLAnnotationProperty(IRI.create((String)"p3"));
    OWLAnnotationValue oo1 = this.manager.getOWLDataFactory().getOWLStringLiteral("o1");
    OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
    Resource ji = ResourceFactory.createResource((String)"http://example.org#i");
    Property jp1 = ResourceFactory.createProperty((String)"http://example.org#p1");
    Property jp2 = ResourceFactory.createProperty((String)"http://example.org#p2");
    Literal jo1 = ResourceFactory.createPlainLiteral((String)"o1");
    private boolean USE_ANNOTATION_SUPPORT_DEFAULT_VALUE = PelletOptions.USE_ANNOTATION_SUPPORT;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestReasoningWithAnnotationAxioms.class);
    }

    @Before
    public void setUp() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
    }

    @After
    public void cleanUp() {
        PelletOptions.USE_ANNOTATION_SUPPORT = this.USE_ANNOTATION_SUPPORT_DEFAULT_VALUE;
    }

    @Test
    public void testSubAnnotationPropertyOfAxiom1() {
        this.kb.addIndividual(this.i);
        this.kb.addAnnotationProperty((ATerm)this.p1);
        this.kb.addAnnotationProperty((ATerm)this.p2);
        this.kb.addSubProperty((ATerm)this.p1, this.p2);
        this.kb.addAnnotation(this.i, this.p1, this.o1);
        Assert.assertEquals((Object)this.kb.getPropertyValues(this.p1), (Object)this.kb.getPropertyValues(this.p2));
    }

    @Test
    public void testSubAnnotationPropertyOfAxiom2() {
        this.kb.addIndividual(this.i);
        this.kb.addAnnotationProperty((ATerm)this.p1);
        this.kb.addAnnotationProperty((ATerm)this.p2);
        this.kb.addAnnotationProperty((ATerm)this.p3);
        this.kb.addSubProperty((ATerm)this.p1, this.p2);
        this.kb.addSubProperty((ATerm)this.p2, this.p3);
        this.kb.addAnnotation(this.i, this.p1, this.o1);
        Assert.assertEquals((Object)this.kb.getPropertyValues(this.p1), (Object)this.kb.getPropertyValues(this.p3));
    }

    @Test
    public void testSubAnnotationPropertyOfAxiom3() {
        this.kb.addIndividual(this.i);
        this.kb.addAnnotationProperty((ATerm)this.p1);
        this.kb.addAnnotationProperty((ATerm)this.p2);
        this.kb.addAnnotationProperty((ATerm)this.p3);
        this.kb.addSubProperty((ATerm)this.p1, this.p2);
        this.kb.addSubProperty((ATerm)this.p2, this.p3);
        this.kb.addAnnotation(this.i, this.p1, this.o1);
        this.kb.addAnnotation(this.i, this.p2, this.o2);
        Assert.assertEquals((Object)this.kb.getPropertyValues(this.p2), (Object)this.kb.getPropertyValues(this.p3));
    }

    @Test
    public void testOWLAPILoader1() throws OWLOntologyCreationException, OWLOntologyChangeException {
        HashSet<Object> axioms = new HashSet<Object>();
        axioms.add(this.manager.getOWLDataFactory().getOWLSubAnnotationPropertyOfAxiom(this.op1, this.op2));
        axioms.add(this.manager.getOWLDataFactory().getOWLAnnotationAssertionAxiom(this.op1, (OWLAnnotationSubject)this.oi.getIRI(), this.oo1));
        OWLOntology ontology = this.manager.createOntology(axioms);
        PelletReasoner reasoner = com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory.getInstance().createReasoner(ontology);
        Assert.assertEquals((Object)reasoner.getAnnotationPropertyValues(this.oi, this.op1), (Object)reasoner.getAnnotationPropertyValues(this.oi, this.op2));
    }

    @Test
    public void testOWLAPILoader2() throws OWLOntologyCreationException, OWLOntologyChangeException {
        HashSet<Object> axioms = new HashSet<Object>();
        axioms.add(this.manager.getOWLDataFactory().getOWLSubAnnotationPropertyOfAxiom(this.op1, this.op2));
        axioms.add(this.manager.getOWLDataFactory().getOWLSubAnnotationPropertyOfAxiom(this.op2, this.op3));
        axioms.add(this.manager.getOWLDataFactory().getOWLAnnotationAssertionAxiom(this.op1, (OWLAnnotationSubject)this.oi.getIRI(), this.oo1));
        OWLOntology ontology = this.manager.createOntology(axioms);
        PelletReasoner reasoner = com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory.getInstance().createReasoner(ontology);
        Assert.assertEquals((Object)reasoner.getAnnotationPropertyValues(this.oi, this.op1), (Object)reasoner.getAnnotationPropertyValues(this.oi, this.op3));
    }

    @Test
    public void testJenaLoader1() {
        this.model.add((Resource)this.jp1, RDF.type, (RDFNode)OWL.AnnotationProperty);
        this.model.add(this.ji, this.jp1, (RDFNode)this.jo1);
        this.model.add((Resource)this.jp1, RDFS.subPropertyOf, (RDFNode)RDFS.label);
        this.model.prepare();
        this.kb = ((PelletInfGraph)this.model.getGraph()).getKB();
        ATermAppl st = ATermUtils.makeTermAppl((String)"http://example.org#i");
        ATermAppl pt = ATermUtils.makeTermAppl((String)RDFS.label.getURI());
        ATermAppl ot = ATermUtils.makePlainLiteral((String)"o1");
        Set actual = this.kb.getAnnotations(st, pt);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(ot);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testJenaLoader2() {
        this.model.add((Resource)this.jp1, RDF.type, (RDFNode)OWL.AnnotationProperty);
        this.model.add(this.ji, this.jp1, (RDFNode)this.jo1);
        this.model.add((Resource)this.jp2, RDF.type, (RDFNode)OWL.AnnotationProperty);
        this.model.add((Resource)this.jp1, RDFS.subPropertyOf, (RDFNode)this.jp2);
        this.model.prepare();
        ATermAppl st = ATermUtils.makeTermAppl((String)"http://example.org#i");
        ATermAppl pt = ATermUtils.makeTermAppl((String)this.jp2.getURI());
        ATermAppl ot = ATermUtils.makePlainLiteral((String)"o1");
        this.kb = ((PelletInfGraph)this.model.getGraph()).getKB();
        Set actual = this.kb.getAnnotations(st, pt);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(ot);
        Assert.assertEquals(expected, (Object)actual);
    }
}

