/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.TermFactory;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.mindswap.pellet.test.AbstractKBTests;

public class CacheSafetyTests
extends AbstractKBTests {
    public static Test suite() {
        return new JUnit4TestAdapter(CacheSafetyTests.class);
    }

    @org.junit.Test
    public void somePallInvP() {
        this.classes(C, D);
        this.objectProperties(p);
        this.kb.addSubClass(D, TermFactory.some((ATermAppl)p, (ATermAppl)C));
        this.kb.addSubClass(C, TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)TermFactory.not((ATermAppl)D)));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(D));
    }

    @org.junit.Test
    public void someSubPallInvP() {
        this.classes(C, D);
        this.objectProperties(p, q);
        this.kb.addSubProperty((ATerm)q, p);
        this.kb.addSubClass(D, TermFactory.some((ATermAppl)q, (ATermAppl)C));
        this.kb.addSubClass(C, TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)TermFactory.not((ATermAppl)D)));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(D));
    }

    @org.junit.Test
    public void somePallInvPwithReflexivity() {
        this.classes(C, D);
        this.objectProperties(p, r);
        this.kb.addReflexiveProperty(r);
        this.kb.addSubClass(D, TermFactory.some((ATermAppl)p, (ATermAppl)C));
        this.kb.addSubClass(C, TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)TermFactory.not((ATermAppl)D)));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(D));
    }

    @org.junit.Test
    public void somePallInvPSubClass() {
        this.classes(B, C, D, E);
        this.objectProperties(p);
        this.kb.addSubClass(D, E);
        this.kb.addEquivalentClass(E, TermFactory.some((ATermAppl)p, (ATermAppl)C));
        this.kb.addSubClass(C, B);
        this.kb.addSubClass(B, TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)TermFactory.not((ATermAppl)D)));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(D));
    }

    @org.junit.Test
    public void somePallInvSubP() {
        this.classes(C, D);
        this.objectProperties(p, q);
        this.kb.addSubProperty((ATerm)p, q);
        this.kb.addSubClass(D, TermFactory.some((ATermAppl)p, (ATermAppl)C));
        this.kb.addSubClass(C, TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)q), (ATermAppl)TermFactory.not((ATermAppl)D)));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(D));
    }

    @org.junit.Test
    public void someFunctionalP() {
        this.classes(C, D);
        this.objectProperties(p);
        this.kb.addFunctionalProperty(p);
        this.kb.addSubClass(D, TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)C));
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.not((ATermAppl)D)));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(D));
    }

    @org.junit.Test
    public void functionalInv() {
        this.classes(C, D);
        this.objectProperties(f);
        this.kb.addFunctionalProperty(f);
        this.kb.addSubClass(D, TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)f), (ATermAppl)C));
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)f, (ATermAppl)TermFactory.not((ATermAppl)D)));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(D));
    }

    @org.junit.Test
    public void max1Inv() {
        this.classes(C, D);
        this.objectProperties(f);
        this.kb.addSubClass(D, TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)f), (ATermAppl)C));
        this.kb.addSubClass(C, TermFactory.and((ATermAppl)TermFactory.some((ATermAppl)f, (ATermAppl)TermFactory.not((ATermAppl)D)), (ATermAppl)TermFactory.max((ATermAppl)f, (int)1, (ATermAppl)TermFactory.TOP)));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(D));
    }

    @org.junit.Test
    public void functionalInvTrans() {
        ATermAppl invF = TermFactory.term((String)"invF");
        ATermAppl invR = TermFactory.term((String)"invR");
        this.classes(C, D);
        this.objectProperties(r, f, invF, invR);
        this.kb.addFunctionalProperty(f);
        this.kb.addInverseFunctionalProperty((ATerm)f);
        this.kb.addInverseProperty(f, invF);
        this.kb.addTransitiveProperty(r);
        this.kb.addInverseProperty(r, invR);
        this.kb.addSubProperty((ATerm)f, r);
        this.kb.addEquivalentClass(D, TermFactory.and((ATermAppl)C, (ATermAppl)TermFactory.some((ATermAppl)f, (ATermAppl)TermFactory.not((ATermAppl)C))));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
        Assert.assertTrue((boolean)this.kb.isSatisfiable(TermFactory.not((ATermAppl)C)));
        Assert.assertTrue((boolean)this.kb.isSatisfiable(D));
        Assert.assertTrue((boolean)this.kb.isSatisfiable(TermFactory.not((ATermAppl)D)));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.and((ATermAppl[])new ATermAppl[]{TermFactory.not((ATermAppl)C), TermFactory.some((ATermAppl)invF, (ATermAppl)D), TermFactory.all((ATermAppl)invR, (ATermAppl)TermFactory.some((ATermAppl)invF, (ATermAppl)D))})));
    }

    @org.junit.Test
    public void maxCardinalityInvTrans() {
        ATermAppl invF = TermFactory.term((String)"invF");
        ATermAppl invR = TermFactory.term((String)"invR");
        this.classes(C, D);
        this.objectProperties(r, f, invF, invR);
        this.kb.addSubClass(TermFactory.TOP, TermFactory.max((ATermAppl)f, (int)1, (ATermAppl)TermFactory.TOP));
        this.kb.addInverseProperty(f, invF);
        this.kb.addTransitiveProperty(r);
        this.kb.addInverseProperty(r, invR);
        this.kb.addSubProperty((ATerm)f, r);
        this.kb.addEquivalentClass(D, TermFactory.and((ATermAppl)C, (ATermAppl)TermFactory.some((ATermAppl)f, (ATermAppl)TermFactory.not((ATermAppl)C))));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.and((ATermAppl[])new ATermAppl[]{TermFactory.not((ATermAppl)C), TermFactory.some((ATermAppl)invF, (ATermAppl)D), TermFactory.all((ATermAppl)invR, (ATermAppl)TermFactory.some((ATermAppl)invF, (ATermAppl)D))})));
    }

    @org.junit.Test
    public void maxCardinalitySub() {
        this.classes(C, D);
        this.objectProperties(p, r, f);
        this.kb.addSubClass(TermFactory.TOP, TermFactory.max((ATermAppl)f, (int)1, (ATermAppl)TermFactory.TOP));
        this.kb.addSubProperty((ATerm)p, f);
        this.kb.addSubProperty((ATerm)r, f);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
        Assert.assertTrue((boolean)this.kb.isSatisfiable(TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)TermFactory.not((ATermAppl)C))));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.and((ATermAppl[])new ATermAppl[]{C, TermFactory.some((ATermAppl)r, (ATermAppl)TermFactory.TOP), TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)TermFactory.not((ATermAppl)C)))})));
    }

    @org.junit.Test
    public void functionalSubTrans() {
        this.classes(A);
        this.objectProperties(r, f);
        this.kb.addFunctionalProperty(f);
        this.kb.addTransitiveProperty(r);
        this.kb.addSubProperty((ATerm)f, r);
        this.kb.addEquivalentClass(D, TermFactory.and((ATermAppl)C, (ATermAppl)TermFactory.some((ATermAppl)f, (ATermAppl)TermFactory.not((ATermAppl)C))));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(TermFactory.and((ATermAppl[])new ATermAppl[]{TermFactory.not((ATermAppl)A), TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)f), (ATermAppl)A), TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)f), (ATermAppl)A))})));
    }

    @org.junit.Test
    public void maxCardinalitySubTrans() {
        this.classes(A);
        this.objectProperties(r, f);
        this.kb.addSubClass(TermFactory.TOP, TermFactory.max((ATermAppl)f, (int)1, (ATermAppl)TermFactory.TOP));
        this.kb.addTransitiveProperty(r);
        this.kb.addSubProperty((ATerm)f, r);
        this.kb.addEquivalentClass(D, TermFactory.and((ATermAppl)C, (ATermAppl)TermFactory.some((ATermAppl)f, (ATermAppl)TermFactory.not((ATermAppl)C))));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(TermFactory.and((ATermAppl[])new ATermAppl[]{TermFactory.not((ATermAppl)A), TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)f), (ATermAppl)A), TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)f), (ATermAppl)A))})));
    }

    @org.junit.Test
    public void somePQallInvR() {
        this.classes(C, D);
        this.objectProperties(p, q, r);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), r);
        this.kb.addSubClass(D, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)C)));
        this.kb.addSubClass(C, TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)TermFactory.not((ATermAppl)D)));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(D));
    }

    @org.junit.Test
    public void somePQallAnonInvR1() {
        this.classes(C);
        this.objectProperties(p, q, r);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), r);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
        Assert.assertTrue((boolean)this.kb.isSatisfiable(TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)TermFactory.not((ATermAppl)C))));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.and((ATermAppl)C, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)TermFactory.not((ATermAppl)C)))))));
    }

    @org.junit.Test
    public void somePQallAnonInvR2() {
        this.classes(C);
        this.objectProperties(p, q, r);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), r);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
        Assert.assertTrue((boolean)this.kb.isSatisfiable(TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)TermFactory.not((ATermAppl)C)))));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.and((ATermAppl)C, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)TermFactory.not((ATermAppl)C)))))));
    }

    @org.junit.Test
    public void nestedPropertyChains() {
        this.classes(C);
        this.objectProperties(p, q, r, f);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), r);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{r, q}), f);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
        Assert.assertTrue((boolean)this.kb.isSatisfiable(TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)f), (ATermAppl)TermFactory.not((ATermAppl)C))));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.and((ATermAppl)C, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)f), (ATermAppl)TermFactory.not((ATermAppl)C))))))));
    }

    @org.junit.Test
    public void cachedIntersectionUnsat() {
        this.classes(B, C, D);
        this.objectProperties(p);
        this.kb.addDisjointClass(C, D);
        this.kb.addSubClass(B, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)TermFactory.and((ATermAppl)C, (ATermAppl)D))));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSatisfiable(C));
        Assert.assertTrue((boolean)this.kb.isSatisfiable(D));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(B));
    }

    @org.junit.Test
    public void cachedIntersectionWithTop1() {
        this.classes(B, C, D);
        this.objectProperties(p);
        this.kb.addEquivalentClass(C, TermFactory.TOP);
        this.kb.addSubClass(B, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)C, (ATermAppl)D)));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.not((ATermAppl)C)));
        Assert.assertTrue((boolean)this.kb.isSatisfiable(D));
        Assert.assertTrue((boolean)this.kb.isSatisfiable(B));
    }

    @org.junit.Test
    public void cachedIntersectionWithTop2() {
        this.classes(B, C, D);
        this.objectProperties(p);
        this.kb.addEquivalentClass(C, TermFactory.TOP);
        this.kb.addEquivalentClass(D, TermFactory.TOP);
        this.kb.addSubClass(B, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl)C, (ATermAppl)D)));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.not((ATermAppl)C)));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.not((ATermAppl)D)));
        Assert.assertTrue((boolean)this.kb.isSatisfiable(B));
    }

    @org.junit.Test
    public void cachedIntersectionWithTop3() {
        this.classes(B, C, D, E);
        this.objectProperties(p);
        this.kb.addEquivalentClass(C, TermFactory.TOP);
        this.kb.addEquivalentClass(D, TermFactory.TOP);
        this.kb.addSubClass(B, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.and((ATermAppl[])new ATermAppl[]{C, D, E})));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.not((ATermAppl)C)));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(TermFactory.not((ATermAppl)D)));
        Assert.assertTrue((boolean)this.kb.isSatisfiable(B));
        Assert.assertTrue((boolean)this.kb.isSatisfiable(E));
        Assert.assertTrue((boolean)this.kb.isSatisfiable(B));
    }
}

