/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.test;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import com.clarkparsia.pellet.datatypes.types.real.ContinuousRealInterval;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import com.clarkparsia.pellet.datatypes.types.real.Rational;
import com.clarkparsia.pellet.datatypes.types.real.RestrictedRealDatatype;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class RestrictedRealDatatypeTests {
    private static final Datatype<Number> dt = new Datatype<Number>(){

        public RestrictedDatatype<Number> asDataRange() {
            throw new UnsupportedOperationException();
        }

        public ATermAppl getCanonicalRepresentation(ATermAppl literal) {
            throw new UnsupportedOperationException();
        }

        public ATermAppl getLiteral(Object value) {
            throw new UnsupportedOperationException();
        }

        public ATermAppl getName() {
            throw new UnsupportedOperationException();
        }

        public Datatype<?> getPrimitiveDatatype() {
            throw new UnsupportedOperationException();
        }

        public Number getValue(ATermAppl literal) {
            throw new UnsupportedOperationException();
        }

        public boolean isPrimitive() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "StubDt";
        }
    };

    private static BigDecimal decimal(String s) {
        return new BigDecimal(s);
    }

    private static Rational rational(Number n, Number d) {
        return new Rational(n, d);
    }

    @Test
    public void containsCon() {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        Assert.assertTrue((boolean)dr.contains((Object)0));
        Assert.assertTrue((boolean)dr.contains((Object)-128));
        Assert.assertTrue((boolean)dr.contains((Object)127));
        Assert.assertTrue((boolean)dr.contains((Object)0));
        Assert.assertTrue((boolean)dr.contains((Object)Short.MIN_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)Short.MAX_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)0));
        Assert.assertTrue((boolean)dr.contains((Object)Integer.MIN_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)Integer.MAX_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)0L));
        Assert.assertTrue((boolean)dr.contains((Object)Long.MIN_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)Long.MAX_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)BigInteger.ZERO));
        Assert.assertTrue((boolean)dr.contains((Object)BigInteger.ONE));
        Assert.assertTrue((boolean)dr.contains((Object)BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(Long.MAX_VALUE))));
        Assert.assertTrue((boolean)dr.contains((Object)BigInteger.ZERO.subtract(BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(Long.MAX_VALUE)))));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.ZERO));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.ONE));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.TEN));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(1.1))));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(0.1))));
        Assert.assertFalse((boolean)dr.contains((Object)Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)dr.contains((Object)Float.valueOf(Float.MAX_VALUE)));
        Assert.assertFalse((boolean)dr.contains((Object)Float.valueOf(Float.MIN_VALUE)));
        Assert.assertFalse((boolean)dr.contains((Object)0.0));
        Assert.assertFalse((boolean)dr.contains((Object)Double.MAX_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)Double.MIN_VALUE));
        Assert.assertFalse((boolean)dr.contains(new Object()));
    }

    @Test
    public void containsInt() {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        Assert.assertTrue((boolean)dr.contains((Object)0));
        Assert.assertTrue((boolean)dr.contains((Object)-128));
        Assert.assertTrue((boolean)dr.contains((Object)127));
        Assert.assertTrue((boolean)dr.contains((Object)0));
        Assert.assertTrue((boolean)dr.contains((Object)Short.MIN_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)Short.MAX_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)0));
        Assert.assertTrue((boolean)dr.contains((Object)Integer.MIN_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)Integer.MAX_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)0L));
        Assert.assertTrue((boolean)dr.contains((Object)Long.MIN_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)Long.MAX_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)BigInteger.ZERO));
        Assert.assertTrue((boolean)dr.contains((Object)BigInteger.ONE));
        Assert.assertTrue((boolean)dr.contains((Object)BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(Long.MAX_VALUE))));
        Assert.assertTrue((boolean)dr.contains((Object)BigInteger.ZERO.subtract(BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(Long.MAX_VALUE)))));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.ZERO));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.ONE));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.TEN));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(1L))));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(2L))));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(1.1))));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(0.1))));
        Assert.assertFalse((boolean)dr.contains((Object)Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)dr.contains((Object)Float.valueOf(Float.MAX_VALUE)));
        Assert.assertFalse((boolean)dr.contains((Object)Float.valueOf(Float.MIN_VALUE)));
        Assert.assertFalse((boolean)dr.contains((Object)0.0));
        Assert.assertFalse((boolean)dr.contains((Object)Double.MAX_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)Double.MIN_VALUE));
        Assert.assertFalse((boolean)dr.contains(new Object()));
    }

    @Test
    public void containsNoI() {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        dr = dr.intersect((RestrictedDatatype)new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null), true);
        Assert.assertFalse((boolean)dr.contains((Object)0));
        Assert.assertFalse((boolean)dr.contains((Object)-128));
        Assert.assertFalse((boolean)dr.contains((Object)127));
        Assert.assertFalse((boolean)dr.contains((Object)0));
        Assert.assertFalse((boolean)dr.contains((Object)Short.MIN_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)Short.MAX_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)0));
        Assert.assertFalse((boolean)dr.contains((Object)Integer.MIN_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)Integer.MAX_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)0L));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MIN_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MAX_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)BigInteger.ZERO));
        Assert.assertFalse((boolean)dr.contains((Object)BigInteger.ONE));
        Assert.assertFalse((boolean)dr.contains((Object)BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(Long.MAX_VALUE))));
        Assert.assertFalse((boolean)dr.contains((Object)BigInteger.ZERO.subtract(BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(Long.MAX_VALUE)))));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.ZERO));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.ONE));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.TEN));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(1L))));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(2L))));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(1.1))));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(0.1))));
        Assert.assertFalse((boolean)dr.contains((Object)Float.valueOf(0.0f)));
        Assert.assertFalse((boolean)dr.contains((Object)Float.valueOf(Float.MAX_VALUE)));
        Assert.assertFalse((boolean)dr.contains((Object)Float.valueOf(Float.MIN_VALUE)));
        Assert.assertFalse((boolean)dr.contains((Object)0.0));
        Assert.assertFalse((boolean)dr.contains((Object)Double.MAX_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)Double.MIN_VALUE));
        Assert.assertFalse((boolean)dr.contains(new Object()));
    }

    @Test
    public void emptyIntersectionConCon1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr1 = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr1 = dr1.applyConstrainingFacet(Facet.XSD.MIN_INCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("2.5"));
        dr1 = dr1.applyConstrainingFacet(Facet.XSD.MAX_INCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("3.5"));
        RestrictedRealDatatype dr2 = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr2 = dr2.applyConstrainingFacet(Facet.XSD.MIN_INCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("4.5"));
        dr2 = dr2.applyConstrainingFacet(Facet.XSD.MAX_INCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("5.5"));
        RestrictedDatatype dr = dr1.intersect((RestrictedDatatype)dr2, false);
        Assert.assertTrue((boolean)dr.isEmpty());
        Assert.assertTrue((boolean)dr.isFinite());
        Assert.assertTrue((boolean)dr.isEnumerable());
        Assert.assertTrue((boolean)dr.containsAtLeast(0));
        Assert.assertFalse((boolean)dr.containsAtLeast(1));
    }

    @Test
    public void emptyRangeCon1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.applyConstrainingFacet(Facet.XSD.MAX_INCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("2.5"));
        dr = dr.applyConstrainingFacet(Facet.XSD.MIN_INCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("3.5"));
        Assert.assertFalse((boolean)dr.contains((Object)2));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.4999")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.5")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.5001")));
        Assert.assertFalse((boolean)dr.contains((Object)3));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.4999")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5001")));
        Assert.assertFalse((boolean)dr.contains((Object)4));
        Assert.assertTrue((boolean)dr.isEmpty());
        Assert.assertTrue((boolean)dr.isFinite());
        Assert.assertTrue((boolean)dr.isEnumerable());
        Assert.assertTrue((boolean)dr.containsAtLeast(0));
        Assert.assertFalse((boolean)dr.containsAtLeast(1));
    }

    @Test
    public void excludeConInt1() {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.exclude(Collections.singleton(1));
        Assert.assertFalse((boolean)dr.contains((Object)1));
        Assert.assertTrue((boolean)dr.contains((Object)0));
        Assert.assertTrue((boolean)dr.contains((Object)2));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("0.99999")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("1.00001")));
        Assert.assertFalse((boolean)dr.isEmpty());
        Assert.assertFalse((boolean)dr.isEnumerable());
        Assert.assertFalse((boolean)dr.isFinite());
    }

    @Test
    public void excludeConInt2() {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.exclude(Arrays.asList(1, 2, 3));
        Assert.assertFalse((boolean)dr.contains((Object)1));
        Assert.assertFalse((boolean)dr.contains((Object)2));
        Assert.assertFalse((boolean)dr.contains((Object)3));
        Assert.assertTrue((boolean)dr.contains((Object)0));
        Assert.assertTrue((boolean)dr.contains((Object)4));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("0.5")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("1.5")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.5")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5")));
        Assert.assertFalse((boolean)dr.isEmpty());
        Assert.assertFalse((boolean)dr.isEnumerable());
        Assert.assertFalse((boolean)dr.isFinite());
    }

    @Test
    public void excludeConNoI1() {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.exclude(Collections.singleton(RestrictedRealDatatypeTests.decimal("1.1")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("1.1")));
        Assert.assertTrue((boolean)dr.contains((Object)1));
        Assert.assertTrue((boolean)dr.contains((Object)2));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("1.09999")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("1.10001")));
        Assert.assertFalse((boolean)dr.isEmpty());
        Assert.assertFalse((boolean)dr.isEnumerable());
        Assert.assertFalse((boolean)dr.isFinite());
    }

    @Test
    public void excludeConNoI2() {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.exclude(Arrays.asList(RestrictedRealDatatypeTests.decimal("1.1"), RestrictedRealDatatypeTests.decimal("2.2"), RestrictedRealDatatypeTests.decimal("3.3")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("1.1")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.2")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.3")));
        Assert.assertTrue((boolean)dr.contains((Object)2));
        Assert.assertTrue((boolean)dr.contains((Object)3));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("1.09999")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("1.10001")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.19999")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.20001")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.29999")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.30001")));
        Assert.assertFalse((boolean)dr.isEmpty());
        Assert.assertFalse((boolean)dr.isEnumerable());
        Assert.assertFalse((boolean)dr.isFinite());
    }

    @Test
    public void excludeIntInt1() {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        dr = dr.exclude(Collections.singleton(1));
        Assert.assertFalse((boolean)dr.contains((Object)1));
        Assert.assertTrue((boolean)dr.contains((Object)0));
        Assert.assertTrue((boolean)dr.contains((Object)2));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("0.99999")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("1.00001")));
        Assert.assertFalse((boolean)dr.isEmpty());
        Assert.assertTrue((boolean)dr.isEnumerable());
        Assert.assertFalse((boolean)dr.isFinite());
    }

    @Test
    public void excludeIntInt2() {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        dr = dr.exclude(Arrays.asList(1, 2, 3));
        Assert.assertFalse((boolean)dr.contains((Object)1));
        Assert.assertFalse((boolean)dr.contains((Object)2));
        Assert.assertFalse((boolean)dr.contains((Object)3));
        Assert.assertTrue((boolean)dr.contains((Object)0));
        Assert.assertTrue((boolean)dr.contains((Object)4));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("0.5")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("1.5")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.5")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5")));
        Assert.assertFalse((boolean)dr.isEmpty());
        Assert.assertTrue((boolean)dr.isEnumerable());
        Assert.assertFalse((boolean)dr.isFinite());
    }

    @Test
    public void excludeIrrelevant1() {
        String value = "A String, not a Number";
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.exclude(Collections.singleton("A String, not a Number"));
        Assert.assertFalse((boolean)dr.contains((Object)"A String, not a Number"));
        Assert.assertFalse((boolean)dr.isEmpty());
        Assert.assertFalse((boolean)dr.isEnumerable());
        Assert.assertFalse((boolean)dr.isFinite());
    }

    @Test
    public void integerEnumeration1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        dr = dr.applyConstrainingFacet(Facet.XSD.MIN_INCLUSIVE.getName(), (Object)-250);
        dr = dr.applyConstrainingFacet(Facet.XSD.MAX_INCLUSIVE.getName(), (Object)350);
        Iterator it = dr.valueIterator();
        for (int i = -250; i <= 350; ++i) {
            Assert.assertEquals((long)0L, (long)OWLRealUtils.compare((Number)i, (Number)((Number)it.next())));
        }
    }

    @Test
    public void integerEnumeration2a() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        dr = dr.applyConstrainingFacet(Facet.XSD.MIN_INCLUSIVE.getName(), (Object)-250);
        dr = dr.applyConstrainingFacet(Facet.XSD.MAX_INCLUSIVE.getName(), (Object)350);
        RestrictedRealDatatype neg = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        neg = neg.applyConstrainingFacet(Facet.XSD.MIN_INCLUSIVE.getName(), (Object)-5);
        neg = neg.applyConstrainingFacet(Facet.XSD.MAX_INCLUSIVE.getName(), (Object)-2);
        dr = dr.intersect((RestrictedDatatype)neg, true);
        Iterator it = dr.valueIterator();
        for (int i = -250; i <= 350; ++i) {
            if (i >= -5 && i <= -2) continue;
            Assert.assertEquals((long)0L, (long)OWLRealUtils.compare((Number)i, (Number)((Number)it.next())));
        }
    }

    @Test
    public void integerEnumeration2b() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        dr = dr.applyConstrainingFacet(Facet.XSD.MIN_INCLUSIVE.getName(), (Object)-250);
        dr = dr.applyConstrainingFacet(Facet.XSD.MAX_EXCLUSIVE.getName(), (Object)-5);
        RestrictedRealDatatype b = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        b = b.applyConstrainingFacet(Facet.XSD.MIN_EXCLUSIVE.getName(), (Object)-2);
        b = b.applyConstrainingFacet(Facet.XSD.MAX_INCLUSIVE.getName(), (Object)350);
        dr = dr.union((RestrictedDatatype)b);
        Iterator it = dr.valueIterator();
        for (int i = -250; i <= 350; ++i) {
            if (i >= -5 && i <= -2) continue;
            Assert.assertEquals((long)0L, (long)OWLRealUtils.compare((Number)i, (Number)((Number)it.next())));
        }
    }

    @Test
    public void intersectToRationalOnly() {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        Assert.assertTrue((boolean)dr.contains((Object)0));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("0.33")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.rational(1, 3)));
        dr = dr.intersect((RestrictedDatatype)new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), null), true);
        Assert.assertFalse((boolean)dr.contains((Object)0));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("0.33")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.rational(1, 3)));
    }

    @Test
    public void maxExclusiveFacetCon1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.applyConstrainingFacet(Facet.XSD.MAX_EXCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("3.5"));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(0.1))));
        Assert.assertTrue((boolean)dr.contains((Object)Long.MIN_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)0));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.4999")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5001")));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MAX_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(0.1))));
    }

    @Test
    public void maxExclusiveFacetInt1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        dr = dr.applyConstrainingFacet(Facet.XSD.MAX_EXCLUSIVE.getName(), (Object)3);
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(0.1))));
        Assert.assertTrue((boolean)dr.contains((Object)Long.MIN_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)0));
        Assert.assertTrue((boolean)dr.contains((Object)2));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.9999")));
        Assert.assertFalse((boolean)dr.contains((Object)3));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.0001")));
        Assert.assertFalse((boolean)dr.contains((Object)4));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MAX_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(0.1))));
    }

    @Test
    public void maxExclusiveFacetNoI1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.intersect((RestrictedDatatype)new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null), true);
        dr = dr.applyConstrainingFacet(Facet.XSD.MAX_EXCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("3.5"));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(0.1))));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MIN_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)0));
        Assert.assertFalse((boolean)dr.contains((Object)2));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.4999")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5001")));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MAX_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(0.1))));
    }

    @Test
    public void maxInclusiveFacetCon1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.applyConstrainingFacet(Facet.XSD.MAX_INCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("3.5"));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(0.1))));
        Assert.assertTrue((boolean)dr.contains((Object)Long.MIN_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)0));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.4999")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5001")));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MAX_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(0.1))));
    }

    @Test
    public void maxInclusiveFacetInt1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        dr = dr.applyConstrainingFacet(Facet.XSD.MAX_INCLUSIVE.getName(), (Object)3);
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(0.1))));
        Assert.assertTrue((boolean)dr.contains((Object)Long.MIN_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)0));
        Assert.assertTrue((boolean)dr.contains((Object)2));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.9999")));
        Assert.assertTrue((boolean)dr.contains((Object)3));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.0001")));
        Assert.assertFalse((boolean)dr.contains((Object)4));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MAX_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(0.1))));
    }

    @Test
    public void maxInclusiveFacetNoI1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.intersect((RestrictedDatatype)new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null), true);
        dr = dr.applyConstrainingFacet(Facet.XSD.MAX_INCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("3.5"));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(0.1))));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MIN_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)0));
        Assert.assertFalse((boolean)dr.contains((Object)2));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.4999")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5001")));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MAX_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(0.1))));
    }

    @Test
    public void minExclusiveFacetCon1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.applyConstrainingFacet(Facet.XSD.MIN_EXCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("3.5"));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(0.1))));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MIN_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)0));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.4999")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5001")));
        Assert.assertTrue((boolean)dr.contains((Object)Long.MAX_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(0.1))));
    }

    @Test
    public void minExclusiveFacetInt1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        dr = dr.applyConstrainingFacet(Facet.XSD.MIN_EXCLUSIVE.getName(), (Object)3);
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(0.1))));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MIN_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)0));
        Assert.assertFalse((boolean)dr.contains((Object)2));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.9999")));
        Assert.assertFalse((boolean)dr.contains((Object)3));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.0001")));
        Assert.assertTrue((boolean)dr.contains((Object)4));
        Assert.assertTrue((boolean)dr.contains((Object)Long.MAX_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(0.1))));
    }

    @Test
    public void minExclusiveFacetNoI1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.intersect((RestrictedDatatype)new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null), true);
        dr = dr.applyConstrainingFacet(Facet.XSD.MIN_EXCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("3.5"));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(0.1))));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MIN_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)0));
        Assert.assertFalse((boolean)dr.contains((Object)2));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.4999")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5001")));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MAX_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(0.1))));
    }

    @Test
    public void minInclusiveFacetCon1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.applyConstrainingFacet(Facet.XSD.MIN_INCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("3.5"));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(0.1))));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MIN_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)0));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.4999")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5001")));
        Assert.assertTrue((boolean)dr.contains((Object)Long.MAX_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(0.1))));
    }

    @Test
    public void minInclusiveFacetInt1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        dr = dr.applyConstrainingFacet(Facet.XSD.MIN_INCLUSIVE.getName(), (Object)3);
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(0.1))));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MIN_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)0));
        Assert.assertFalse((boolean)dr.contains((Object)2));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.9999")));
        Assert.assertTrue((boolean)dr.contains((Object)3));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.0001")));
        Assert.assertTrue((boolean)dr.contains((Object)4));
        Assert.assertTrue((boolean)dr.contains((Object)Long.MAX_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(0.1))));
    }

    @Test
    public void minInclusiveFacetNoI1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.intersect((RestrictedDatatype)new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null), true);
        dr = dr.applyConstrainingFacet(Facet.XSD.MIN_INCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("3.5"));
        Assert.assertFalse((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.valueOf(0.1))));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MIN_VALUE));
        Assert.assertFalse((boolean)dr.contains((Object)0));
        Assert.assertFalse((boolean)dr.contains((Object)2));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.4999")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5001")));
        Assert.assertFalse((boolean)dr.contains((Object)Long.MAX_VALUE));
        Assert.assertTrue((boolean)dr.contains((Object)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(0.1))));
    }

    @Test
    public void minMaxIncIncCon1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.applyConstrainingFacet(Facet.XSD.MIN_INCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("2.5"));
        dr = dr.applyConstrainingFacet(Facet.XSD.MAX_INCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("3.5"));
        Assert.assertFalse((boolean)dr.contains((Object)2));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.4999")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.5")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.5001")));
        Assert.assertTrue((boolean)dr.contains((Object)3));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.4999")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5001")));
        Assert.assertFalse((boolean)dr.contains((Object)4));
    }

    @Test
    public void minMaxIncIncInt1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        dr = dr.applyConstrainingFacet(Facet.XSD.MIN_INCLUSIVE.getName(), (Object)25);
        dr = dr.applyConstrainingFacet(Facet.XSD.MAX_INCLUSIVE.getName(), (Object)35);
        Assert.assertFalse((boolean)dr.contains((Object)24));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("24.999")));
        Assert.assertTrue((boolean)dr.contains((Object)25));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("25.001")));
        Assert.assertTrue((boolean)dr.contains((Object)30));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("34.999")));
        Assert.assertTrue((boolean)dr.contains((Object)35));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5001")));
        Assert.assertFalse((boolean)dr.contains((Object)36));
    }

    @Test
    public void minMaxIncIncNoI1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), ContinuousRealInterval.allReals());
        dr = dr.intersect((RestrictedDatatype)new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null), true);
        dr = dr.applyConstrainingFacet(Facet.XSD.MIN_INCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("2.5"));
        dr = dr.applyConstrainingFacet(Facet.XSD.MAX_INCLUSIVE.getName(), (Object)RestrictedRealDatatypeTests.decimal("3.5"));
        Assert.assertFalse((boolean)dr.contains((Object)2));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.4999")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.5")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("2.5001")));
        Assert.assertFalse((boolean)dr.contains((Object)3));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.4999")));
        Assert.assertTrue((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("3.5001")));
        Assert.assertFalse((boolean)dr.contains((Object)4));
    }

    @Test
    public void unionIntInt1() throws InvalidConstrainingFacetException {
        RestrictedRealDatatype dr1 = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        dr1 = dr1.applyConstrainingFacet(Facet.XSD.MIN_INCLUSIVE.getName(), (Object)-10);
        dr1 = dr1.applyConstrainingFacet(Facet.XSD.MAX_INCLUSIVE.getName(), (Object)-2);
        RestrictedRealDatatype dr2 = new RestrictedRealDatatype(dt, IntegerInterval.allIntegers(), null, null);
        dr2 = dr2.applyConstrainingFacet(Facet.XSD.MIN_INCLUSIVE.getName(), (Object)12);
        dr2 = dr2.applyConstrainingFacet(Facet.XSD.MAX_INCLUSIVE.getName(), (Object)13);
        RestrictedDatatype dr = dr1.union((RestrictedDatatype)dr2);
        Assert.assertFalse((boolean)dr.isEmpty());
        Assert.assertTrue((boolean)dr.isFinite());
        Assert.assertTrue((boolean)dr.isEnumerable());
        Iterator it = dr.valueIterator();
        for (int i = -10; i <= 13; ++i) {
            if (i > -2 && i < 12) continue;
            Assert.assertEquals((long)0L, (long)OWLRealUtils.compare((Number)i, (Number)((Number)it.next())));
        }
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("-10.1")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("-2.1")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("0.1")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("12.5")));
        Assert.assertFalse((boolean)dr.contains((Object)RestrictedRealDatatypeTests.decimal("13.1")));
    }
}

