/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.test.AbstractModularityTest;
import com.clarkparsia.modularity.test.TestUtils;
import com.clarkparsia.owlapiv3.OWL;
import java.util.Arrays;
import org.junit.Test;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public abstract class AbstractIncrementalClassifierTest
extends AbstractModularityTest {
    private void updateTest(OWLAxiom[] axioms, OWLAxiom[] additions, OWLAxiom[] deletions) throws OWLException {
        this.createOntology(axioms);
        TestUtils.runUpdateTest(this.ontology, this.createModuleExtractor(), Arrays.asList(additions), Arrays.asList(deletions));
    }

    private void disjointnessTest(OWLAxiom[] axioms) {
        this.createOntology(axioms);
        TestUtils.runDisjointnessTest(this.ontology, this.createModuleExtractor());
    }

    private void disjointnessUpdateTest(OWLAxiom[] axioms, OWLAxiom[] additions, OWLAxiom[] deletions) {
        this.createOntology(axioms);
        TestUtils.runDisjointnessUpdateTest(this.ontology, this.createModuleExtractor(), Arrays.asList(additions), Arrays.asList(deletions));
    }

    private void instancesTest(OWLAxiom[] axioms) {
        this.createOntology(axioms);
        TestUtils.runInstancesTest(this.ontology, this.createModuleExtractor());
    }

    private void typesTest(OWLAxiom[] axioms) {
        this.createOntology(axioms);
        TestUtils.runTypesTest(this.ontology, this.createModuleExtractor());
    }

    private void instancesUpdateTest(OWLAxiom[] axioms, OWLAxiom[] additions, OWLAxiom[] deletions) {
        this.createOntology(axioms);
        TestUtils.runInstancesUpdateTest(this.ontology, this.createModuleExtractor(), Arrays.asList(additions), Arrays.asList(deletions));
    }

    private void typesUpdateTest(OWLAxiom[] axioms, OWLAxiom[] additions, OWLAxiom[] deletions) {
        this.createOntology(axioms);
        TestUtils.runTypesUpdateTest(this.ontology, this.createModuleExtractor(), Arrays.asList(additions), Arrays.asList(deletions));
    }

    @Test
    public void unsatisfiableTest1() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.C), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)OWL.Thing)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.disjointClasses((OWLClassExpression)this.B, (OWLClassExpression)this.C)};
        OWLAxiom[] deletions = new OWLAxiom[]{};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void unsatisfiableTest2() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.A), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)OWL.Thing)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)OWL.not((OWLClassExpression)this.A))};
        OWLAxiom[] deletions = new OWLAxiom[]{};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void indirectSubClassTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.Thing), OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.C)), OWL.equivalentClasses((OWLClassExpression)this.B, (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.D)), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.C), OWL.subClassOf((OWLClassExpression)this.E, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.F, (OWLClassExpression)this.E)};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.C)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void leafAddTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.B)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.A)};
        OWLAxiom[] deletions = new OWLAxiom[]{};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void makeSatisfiable() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.C), OWL.disjointClasses((OWLClassExpression)this.B, (OWLClassExpression)this.C)};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void annotationOnlyTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.A), OWL.label((OWLEntity)this.B, (String)"B label")};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.A)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void internalAddTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)OWL.Thing)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.B)};
        OWLAxiom[] deletions = new OWLAxiom[]{};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void internalDeleteTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.B)};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.B)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void internalMergeTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.A), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.C), OWL.subClassOf((OWLClassExpression)this.E, (OWLClassExpression)this.B)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.C)};
        OWLAxiom[] deletions = new OWLAxiom[]{};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void internalSplitTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.A), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.C), OWL.subClassOf((OWLClassExpression)this.E, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.C)};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.C)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void addAndRename() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)OWL.Thing)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.declaration((OWLEntity)this.C), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.A), OWL.declaration((OWLEntity)this.D), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.A)};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.declaration((OWLEntity)this.C), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.A)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void switchSubTreeTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.A), OWL.subClassOf((OWLClassExpression)this.E, (OWLClassExpression)this.A), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.C), OWL.subClassOf((OWLClassExpression)this.F, (OWLClassExpression)this.E), OWL.subClassOf((OWLClassExpression)this.G, (OWLClassExpression)this.F)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.E), OWL.subClassOf((OWLClassExpression)this.F, (OWLClassExpression)this.B)};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.F, (OWLClassExpression)this.E)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void indirectModuleTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.and((OWLClassExpression[])new OWLClassExpression[]{this.B, this.C, OWL.some((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.C)})), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{OWL.all((OWLObjectPropertyExpression)this.p, (OWLClassExpression)OWL.not((OWLClassExpression)this.C)), this.D})), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.E)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.not((OWLClassExpression)this.E))};
        OWLAxiom[] deletions = new OWLAxiom[]{};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void deleteAllAxiomsInModuleTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.all((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.C))};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void deleteUnsatisfiable() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.C), OWL.disjointClasses((OWLClassExpression)this.B, (OWLClassExpression)this.C)};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.C)};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void addNonLocal() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.declaration((OWLEntity)this.A)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.equivalentClasses((OWLClassExpression)this.B, (OWLClassExpression)OWL.all((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.B))};
        OWLAxiom[] deletions = new OWLAxiom[]{};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void deleteNonLocal() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)OWL.all((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.B)), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)OWL.all((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.B)), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)OWL.all((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.B)), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.C)};
        OWLAxiom[] additions = new OWLAxiom[]{};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)OWL.all((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.B))};
        this.updateTest(axioms, additions, deletions);
    }

    @Test
    public void basicDisjointnessTest() {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.disjointClasses((OWLClassExpression)this.A, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.A), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.B), OWL.equivalentClasses((OWLClassExpression)this.E, (OWLClassExpression)this.A)};
        this.disjointnessTest(axioms);
    }

    @Test
    public void basicDisjointnessUpdateTest() {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.disjointClasses((OWLClassExpression)this.A, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.A), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.B), OWL.equivalentClasses((OWLClassExpression)this.E, (OWLClassExpression)this.A)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.disjointClasses((OWLClassExpression)this.D, (OWLClassExpression)this.C)};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.disjointClasses((OWLClassExpression)this.A, (OWLClassExpression)this.B)};
        this.disjointnessUpdateTest(axioms, additions, deletions);
    }

    @Test
    public void basicInstancesTest() {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), OWL.classAssertion((OWLIndividual)this.b, (OWLClassExpression)this.B), OWL.domain((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.C), OWL.range((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.D), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b)};
        this.instancesTest(axioms);
    }

    @Test
    public void basicInstancesUpdateTest() {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), OWL.classAssertion((OWLIndividual)this.b, (OWLClassExpression)this.B), OWL.domain((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.C), OWL.range((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.D), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.range((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.E)};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.range((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.D)};
        this.instancesUpdateTest(axioms, additions, deletions);
    }

    @Test
    public void basicTypesTest() {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), OWL.classAssertion((OWLIndividual)this.b, (OWLClassExpression)this.B), OWL.domain((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.C), OWL.range((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.D), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b)};
        this.typesTest(axioms);
    }

    @Test
    public void basicTypesUpdateTest() {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), OWL.classAssertion((OWLIndividual)this.b, (OWLClassExpression)this.B), OWL.domain((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.C), OWL.range((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.D), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.range((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.E)};
        OWLAxiom[] deletions = new OWLAxiom[]{OWL.range((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.D)};
        this.typesUpdateTest(axioms, additions, deletions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void importsTest() throws OWLException {
        OWLAxiom[] axioms1 = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B)};
        OWLAxiom[] axioms2 = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.C), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.E)};
        OWLAxiom[] additions = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.D)};
        OWLAxiom[] deletions = new OWLAxiom[]{};
        OWLOntology ontology1 = OWL.Ontology((OWLAxiom[])axioms1);
        OWLOntology ontology2 = OWL.Ontology((OWLAxiom[])axioms2);
        try {
            OWL.manager.applyChange((OWLOntologyChange)new AddImport(ontology1, OWL.factory.getOWLImportsDeclaration(ontology2.getOntologyID().getOntologyIRI())));
            TestUtils.runUpdateTest(ontology1, this.createModuleExtractor(), Arrays.asList(additions), Arrays.asList(deletions));
        }
        finally {
            OWL.manager.removeOntology(ontology1);
            OWL.manager.removeOntology(ontology2);
        }
    }
}

