/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.test;

import com.clarkparsia.owlapi.explanation.io.manchester.BlockWriter;
import com.clarkparsia.owlapi.explanation.io.manchester.ManchesterSyntaxObjectRenderer;
import com.clarkparsia.owlapi.explanation.io.manchester.TextBlockWriter;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.XSD;
import java.io.StringWriter;
import java.io.Writer;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;

public class ExplanationRendererTest {
    private static final OWLClass A = OWL.Class((String)"A");
    private static final OWLClass B = OWL.Class((String)"B");
    private static final OWLObjectProperty p = OWL.ObjectProperty((String)"p");
    private static final OWLObjectProperty q = OWL.ObjectProperty((String)"q");
    private static final OWLIndividual a = OWL.Individual((String)"a");

    protected void assertRendering(String expected, OWLObject obj) {
        StringWriter sw = new StringWriter();
        ManchesterSyntaxObjectRenderer renderer = new ManchesterSyntaxObjectRenderer((BlockWriter)new TextBlockWriter((Writer)sw));
        obj.accept((OWLObjectVisitor)renderer);
        String actual = sw.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void classAssertion() throws Exception {
        this.assertRendering("a type A", (OWLObject)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)A));
    }

    @Test
    public void subClassOf() throws Exception {
        this.assertRendering("A subClassOf B", (OWLObject)OWL.subClassOf((OWLClassExpression)A, (OWLClassExpression)B));
    }

    @Test
    public void subPropertyOf() throws Exception {
        OWLObjectPropertyExpression[] a = new OWLObjectPropertyExpression[]{p, q};
        this.assertRendering("p o q subPropertyOf p", (OWLObject)OWL.subPropertyOf((OWLObjectPropertyExpression[])a, (OWLObjectPropertyExpression)p));
    }

    @Test
    public void qualifiedExactCardinality() throws Exception {
        this.assertRendering("p exactly 1 A", (OWLObject)OWL.exactly((OWLObjectProperty)p, (int)1, (OWLClassExpression)A));
    }

    @Test
    public void exactCardinality() throws Exception {
        this.assertRendering("p exactly 1", (OWLObject)OWL.exactly((OWLObjectProperty)p, (int)1));
    }

    @Test
    public void someValuesFrom() throws Exception {
        this.assertRendering("p some A", (OWLObject)OWL.some((OWLObjectPropertyExpression)p, (OWLClassExpression)A));
    }

    @Test
    public void allValuesFrom() throws Exception {
        this.assertRendering("p only A", (OWLObject)OWL.all((OWLObjectPropertyExpression)p, (OWLClassExpression)A));
    }

    @Test
    public void maxExclusive() throws Exception {
        this.assertRendering("double[< \"2.0\"^^double]", (OWLObject)OWL.restrict((OWLDatatype)XSD.DOUBLE, (OWLFacetRestriction[])new OWLFacetRestriction[]{OWL.maxExclusive((double)2.0)}));
    }

    @Test
    public void minExclusive() throws Exception {
        this.assertRendering("double[> \"2.0\"^^double]", (OWLObject)OWL.restrict((OWLDatatype)XSD.DOUBLE, (OWLFacetRestriction[])new OWLFacetRestriction[]{OWL.minExclusive((double)2.0)}));
    }

    @Test
    public void maxInclusive() throws Exception {
        this.assertRendering("double[<= \"2.0\"^^double]", (OWLObject)OWL.restrict((OWLDatatype)XSD.DOUBLE, (OWLFacetRestriction[])new OWLFacetRestriction[]{OWL.maxInclusive((double)2.0)}));
    }

    @Test
    public void minInclusive() throws Exception {
        this.assertRendering("double[>= \"2.0\"^^double]", (OWLObject)OWL.restrict((OWLDatatype)XSD.DOUBLE, (OWLFacetRestriction[])new OWLFacetRestriction[]{OWL.minInclusive((double)2.0)}));
    }
}

