/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.Datatypes;
import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.builtins.BooleanOperators;
import com.clarkparsia.pellet.rules.builtins.ComparisonTesters;
import com.clarkparsia.pellet.rules.builtins.DateTimeOperators;
import com.clarkparsia.pellet.rules.builtins.Function;
import com.clarkparsia.pellet.rules.builtins.FunctionApplicationVisitor;
import com.clarkparsia.pellet.rules.builtins.GeneralFunction;
import com.clarkparsia.pellet.rules.builtins.NumericFunction;
import com.clarkparsia.pellet.rules.builtins.NumericOperators;
import com.clarkparsia.pellet.rules.builtins.NumericPromotion;
import com.clarkparsia.pellet.rules.builtins.NumericVisitor;
import com.clarkparsia.pellet.rules.builtins.StringOperators;
import com.clarkparsia.pellet.rules.builtins.Tester;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.utils.TermFactory;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.test.rules.SWRLTestSuite;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.NumberUtils;

public class BuiltInTests {
    private ABox abox;
    private KnowledgeBase kb;
    private ATermAppl li_1 = TermFactory.literal((String)"-1", (ATermAppl)Datatypes.INTEGER);
    private ATermAppl li0 = TermFactory.literal((String)"0", (ATermAppl)Datatypes.NON_NEGATIVE_INTEGER);
    private ATermAppl lf0 = TermFactory.literal((String)"0.0", (ATermAppl)Datatypes.FLOAT);
    private ATermAppl lf00 = TermFactory.literal((String)"0.00", (ATermAppl)Datatypes.FLOAT);
    private ATermAppl lp0 = TermFactory.literal((String)"0");
    private ATermAppl ls0 = TermFactory.literal((String)"0", (ATermAppl)Datatypes.STRING);
    private ATermAppl len0 = TermFactory.literal((String)"0", (String)"en");

    private static BigInteger bigint(long l) {
        return new BigInteger(String.valueOf(l));
    }

    private static BigDecimal bigdec(double d) {
        return new BigDecimal(String.valueOf(d));
    }

    @Before
    public void setUp() {
        this.kb = new KnowledgeBase();
        this.abox = this.kb.getABox();
    }

    private boolean equal(Literal l1, Literal l2) {
        if (l1 == null && l2 == null) {
            return true;
        }
        if (l1 == null) {
            return false;
        }
        if (l2 == null) {
            return false;
        }
        return ComparisonTesters.equal.test(new Literal[]{l1, l2});
    }

    private void generalFunc(GeneralFunction func, ATermAppl ... args) {
        Literal[] litArgs = new Literal[args.length];
        for (int i = 0; i < args.length; ++i) {
            litArgs[i] = this.abox.addLiteral(args[i]);
            Assert.assertNotNull((String)("Invalid iteral value: " + args[i]), (Object)litArgs[i].getValue());
        }
        this.generalFunc(func, litArgs);
    }

    private void generalFunc(GeneralFunction func, Literal ... args) {
        Assert.assertTrue((String)"Full binding not accepted", (boolean)func.apply(this.abox, args));
        for (int i = 0; i < args.length; ++i) {
            Literal[] copy = (Literal[])args.clone();
            copy[i] = null;
            boolean[] bound = new boolean[args.length];
            Arrays.fill(bound, true);
            bound[i] = false;
            if (!func.isApplicable(bound)) continue;
            Assert.assertTrue((String)("Function not accepted without argument " + i), (boolean)func.apply(this.abox, copy));
            Assert.assertTrue((String)("Results not equal: Expected " + args[i] + ", got " + copy[i]), (boolean)this.equal(args[i], copy[i]));
        }
    }

    private boolean greaterThan(Literal l1, Literal l2) {
        return ComparisonTesters.greaterThan.test(new Literal[]{l1, l2});
    }

    private boolean greaterThanOrEqual(Literal l1, Literal l2) {
        return ComparisonTesters.greaterThanOrEqual.test(new Literal[]{l1, l2});
    }

    private boolean lessThan(Literal l1, Literal l2) {
        return ComparisonTesters.lessThan.test(new Literal[]{l1, l2});
    }

    private boolean lessThanOrEqual(Literal l1, Literal l2) {
        return ComparisonTesters.lessThanOrEqual.test(new Literal[]{l1, l2});
    }

    private boolean notEqual(Literal l1, Literal l2) {
        return ComparisonTesters.notEqual.test(new Literal[]{l1, l2});
    }

    private void numeric(NumericFunction f, Number expected, Number ... args) {
        NumericPromotion promoter = new NumericPromotion();
        promoter.promote(args);
        FunctionApplicationVisitor visitor = new FunctionApplicationVisitor(f);
        promoter.accept((NumericVisitor)visitor);
        Number result = visitor.getResult();
        if (expected == null) {
            Assert.assertNull((Object)result);
        } else {
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((String)(expected + " not equal to " + result), (NumberUtils.compare((Number)expected, (Number)result) == 0 ? 1 : 0) != 0);
        }
        if (result != null) {
            Assert.assertEquals((String)"Wrong numeric type from function.", expected.getClass(), result.getClass());
        }
    }

    private void stringFunc(Function func, String expected, String ... args) {
        ATermAppl expectedTerm = TermFactory.literal((String)expected);
        this.stringFunc(func, expectedTerm, args);
    }

    private void stringFunc(Function func, ATermAppl term, String ... args) {
        Literal expected = this.abox.addLiteral(term);
        this.stringFunc(func, expected, args);
    }

    private void stringFunc(Function func, Literal expected, String ... args) {
        Literal[] litArgs = new Literal[args.length];
        for (int i = 0; i < args.length; ++i) {
            litArgs[i] = this.abox.addLiteral(TermFactory.literal((String)args[i]));
        }
        this.stringFunc(func, expected, litArgs);
    }

    private void stringFunc(Function func, Literal expected, Literal ... args) {
        Literal result = func.apply(this.abox, null, args);
        if (expected == null || result == null) {
            Assert.assertEquals((String)"Unexpected function result.", (Object)expected, (Object)result);
        } else {
            Assert.assertTrue((String)("Unexcepted resturn value. Expected " + expected + " but saw " + result), (boolean)ComparisonTesters.equal.test(new Literal[]{expected, result}));
        }
        Assert.assertEquals((String)"Wrong return value", (Object)expected, (Object)func.apply(this.abox, expected, args));
        Assert.assertEquals((String)"Unexpected equality", null, (Object)func.apply(this.abox, this.abox.addLiteral(DependencySet.INDEPENDENT), args));
    }

    private boolean stringTest(Tester tester, String ... args) {
        Literal[] litArgs = new Literal[args.length];
        for (int i = 0; i < args.length; ++i) {
            litArgs[i] = this.abox.addLiteral(TermFactory.literal((String)args[i]));
        }
        return tester.test(litArgs);
    }

    @Test
    public void testBooleans() {
        Literal trueLit = this.abox.addLiteral(TermFactory.literal((boolean)true));
        Literal falseLit = this.abox.addLiteral(TermFactory.literal((boolean)false));
        this.generalFunc(BooleanOperators.booleanNot, trueLit, falseLit);
        this.generalFunc(BooleanOperators.booleanNot, falseLit, trueLit);
        Assert.assertFalse((boolean)BooleanOperators.booleanNot.apply(this.abox, new Literal[]{trueLit, trueLit}));
        Assert.assertFalse((boolean)BooleanOperators.booleanNot.apply(this.abox, new Literal[]{falseLit, falseLit}));
        Assert.assertFalse((boolean)BooleanOperators.booleanNot.apply(this.abox, new Literal[]{null, null}));
    }

    @Test
    public void testComparisons() {
        Literal l1 = this.abox.addLiteral(this.li_1);
        Literal l2 = this.abox.addLiteral(this.li0);
        Assert.assertFalse((boolean)this.equal(l1, l2));
        Assert.assertFalse((boolean)this.greaterThan(l1, l2));
        Assert.assertTrue((boolean)this.greaterThan(l2, l1));
        Assert.assertFalse((boolean)this.greaterThanOrEqual(l1, l2));
        Assert.assertTrue((boolean)this.lessThan(l1, l2));
        Assert.assertFalse((boolean)this.lessThan(l2, l1));
        Assert.assertTrue((boolean)this.notEqual(l1, l2));
        l1 = this.abox.addLiteral(this.lf0);
        l2 = this.abox.addLiteral(this.lf00);
        Assert.assertTrue((boolean)this.equal(l1, l2));
        Assert.assertFalse((boolean)this.greaterThan(l1, l2));
        Assert.assertTrue((boolean)this.greaterThanOrEqual(l1, l2));
        Assert.assertFalse((boolean)this.lessThan(l1, l2));
        Assert.assertTrue((boolean)this.lessThanOrEqual(l1, l2));
        Assert.assertFalse((boolean)this.notEqual(l1, l2));
        l1 = this.abox.addLiteral(this.lf0);
        l2 = this.abox.addLiteral(this.li0);
        Assert.assertTrue((boolean)this.equal(l1, l2));
        Assert.assertFalse((boolean)this.greaterThan(l1, l2));
        Assert.assertTrue((boolean)this.greaterThanOrEqual(l1, l2));
        Assert.assertFalse((boolean)this.lessThan(l1, l2));
        Assert.assertTrue((boolean)this.lessThanOrEqual(l1, l2));
        Assert.assertFalse((boolean)this.notEqual(l1, l2));
        l1 = this.abox.addLiteral(this.lp0);
        l2 = this.abox.addLiteral(this.li0);
        Assert.assertFalse((boolean)this.equal(l1, l2));
        Assert.assertFalse((boolean)this.greaterThan(l1, l2));
        Assert.assertFalse((boolean)this.greaterThanOrEqual(l1, l2));
        Assert.assertFalse((boolean)this.lessThan(l1, l2));
        Assert.assertFalse((boolean)this.lessThanOrEqual(l1, l2));
        Assert.assertTrue((boolean)this.notEqual(l1, l2));
        l1 = this.abox.addLiteral(this.lp0);
        l2 = this.abox.addLiteral(this.ls0);
        Assert.assertTrue((boolean)this.equal(l1, l2));
        Assert.assertFalse((boolean)this.greaterThan(l1, l2));
        Assert.assertTrue((boolean)this.greaterThanOrEqual(l1, l2));
        Assert.assertFalse((boolean)this.lessThan(l1, l2));
        Assert.assertTrue((boolean)this.lessThanOrEqual(l1, l2));
        Assert.assertFalse((boolean)this.notEqual(l1, l2));
        l1 = this.abox.addLiteral(this.lp0);
        l2 = this.abox.addLiteral(this.len0);
        Assert.assertFalse((boolean)this.equal(l1, l2));
        Assert.assertFalse((boolean)this.greaterThan(l1, l2));
        Assert.assertFalse((boolean)this.greaterThanOrEqual(l1, l2));
        Assert.assertFalse((boolean)this.lessThan(l1, l2));
        Assert.assertFalse((boolean)this.lessThanOrEqual(l1, l2));
        Assert.assertTrue((boolean)this.notEqual(l1, l2));
        l1 = this.abox.addLiteral(TermFactory.literal((String)"2000-01-01", (ATermAppl)Datatypes.DATE));
        l2 = this.abox.addLiteral(TermFactory.literal((String)"2010-01-01", (ATermAppl)Datatypes.DATE));
        Assert.assertFalse((boolean)this.equal(l1, l2));
        Assert.assertFalse((boolean)this.greaterThan(l1, l2));
        Assert.assertTrue((boolean)this.greaterThan(l2, l1));
        Assert.assertFalse((boolean)this.greaterThanOrEqual(l1, l2));
        Assert.assertTrue((boolean)this.lessThan(l1, l2));
        Assert.assertFalse((boolean)this.lessThan(l2, l1));
        Assert.assertTrue((boolean)this.notEqual(l1, l2));
        l1 = this.abox.addLiteral(TermFactory.literal((String)"2010-01-01T01:00:00Z", (ATermAppl)Datatypes.DATE_TIME));
        l2 = this.abox.addLiteral(TermFactory.literal((String)"2010-01-01T02:00:00Z", (ATermAppl)Datatypes.DATE_TIME));
        Assert.assertFalse((boolean)this.equal(l1, l2));
        Assert.assertFalse((boolean)this.greaterThan(l1, l2));
        Assert.assertTrue((boolean)this.greaterThan(l2, l1));
        Assert.assertFalse((boolean)this.greaterThanOrEqual(l1, l2));
        Assert.assertTrue((boolean)this.lessThan(l1, l2));
        Assert.assertFalse((boolean)this.lessThan(l2, l1));
        Assert.assertTrue((boolean)this.notEqual(l1, l2));
    }

    @Test
    public void testDateTimes() {
        System.out.println("Starting date time tests");
        this.generalFunc(DateTimeOperators.date, TermFactory.literal((String)"2008-01-28", (ATermAppl)Datatypes.DATE), TermFactory.literal((String)"2008", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"1", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"28", (ATermAppl)Datatypes.INTEGER));
        this.generalFunc(DateTimeOperators.date, TermFactory.literal((String)"2008-01-28Z", (ATermAppl)Datatypes.DATE), TermFactory.literal((String)"2008", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"1", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"28", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"Z"));
        this.generalFunc(DateTimeOperators.dateTime, TermFactory.literal((String)"2008-01-28T00:01:03.1", (ATermAppl)Datatypes.DATE_TIME), TermFactory.literal((String)"2008", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"1", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"28", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"00", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"01", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"03.1", (ATermAppl)Datatypes.DECIMAL));
        this.generalFunc(DateTimeOperators.dateTime, TermFactory.literal((String)"2008-01-28T00:01:03.1Z", (ATermAppl)Datatypes.DATE_TIME), TermFactory.literal((String)"2008", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"1", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"28", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"00", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"01", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"03.1", (ATermAppl)Datatypes.DECIMAL), TermFactory.literal((String)"Z"));
        this.generalFunc(DateTimeOperators.time, TermFactory.literal((String)"00:01:03.1", (ATermAppl)Datatypes.TIME), TermFactory.literal((String)"00", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"01", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"03.1", (ATermAppl)Datatypes.DECIMAL));
        this.generalFunc(DateTimeOperators.time, TermFactory.literal((String)"00:01:03.1Z", (ATermAppl)Datatypes.TIME), TermFactory.literal((String)"00", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"01", (ATermAppl)Datatypes.INTEGER), TermFactory.literal((String)"03.1", (ATermAppl)Datatypes.DECIMAL), TermFactory.literal((String)"Z"));
    }

    @Ignore(value="Duration datatypes are not supported")
    @Test
    public void testDurations() {
        this.stringFunc(DateTimeOperators.dayTimeDuration, TermFactory.literal((String)"P1DT1H", (ATermAppl)Datatypes.DURATION), "1", "01");
        this.stringFunc(DateTimeOperators.dayTimeDuration, TermFactory.literal((String)"P1DT1H", (ATermAppl)Datatypes.DURATION), "1", "1");
        this.stringFunc(DateTimeOperators.yearMonthDuration, TermFactory.literal((String)"P3Y", (ATermAppl)Datatypes.DURATION), "1", "24");
    }

    @Test
    public void testNumerics() {
        this.numeric(NumericOperators.abs, BuiltInTests.bigint(5000L), BuiltInTests.bigint(-5000L));
        this.numeric(NumericOperators.abs, BuiltInTests.bigdec(500.0), BuiltInTests.bigdec(-500.0));
        this.numeric(NumericOperators.abs, Float.valueOf(500.0f), Float.valueOf(-500.0f));
        this.numeric(NumericOperators.abs, 500.0, -500.0);
        this.numeric(NumericOperators.add, BuiltInTests.bigint(10000L), 7500, 2500);
        this.numeric(NumericOperators.add, BuiltInTests.bigdec(10000.25), BuiltInTests.bigdec(7500.25), 2500);
        this.numeric(NumericOperators.add, Float.valueOf(500.5f), Float.valueOf(250.5f), 250);
        this.numeric(NumericOperators.add, 500.25, 250.125, 250.125);
        this.numeric(NumericOperators.ceiling, BuiltInTests.bigint(1000L), 1000);
        this.numeric(NumericOperators.ceiling, BuiltInTests.bigdec(500.0), BuiltInTests.bigdec(499.1));
        this.numeric(NumericOperators.ceiling, Float.valueOf(500.0f), Float.valueOf(499.01f));
        this.numeric(NumericOperators.ceiling, 500.0, 499.01);
        this.numeric(NumericOperators.cos, Math.cos(25.0), 25);
        this.numeric(NumericOperators.cos, Math.cos(25.0), BuiltInTests.bigdec(25.0));
        this.numeric(NumericOperators.cos, Math.cos(25.0), Float.valueOf(25.0f));
        this.numeric(NumericOperators.cos, Math.cos(25.0), 25.0);
        this.numeric(NumericOperators.divide, BuiltInTests.bigdec(2.5), 5, 2);
        this.numeric(NumericOperators.divide, BuiltInTests.bigdec(2.25), BuiltInTests.bigdec(4.5), 2);
        this.numeric(NumericOperators.divide, Float.valueOf(4.125f), Float.valueOf(16.5f), 4);
        this.numeric(NumericOperators.divide, 4.125, 16.5, 4);
        this.numeric(NumericOperators.floor, BuiltInTests.bigint(1000L), 1000);
        this.numeric(NumericOperators.floor, BuiltInTests.bigdec(499.0), BuiltInTests.bigdec(499.1));
        this.numeric(NumericOperators.floor, null, BuiltInTests.bigdec(500.45), BuiltInTests.bigdec(1.5));
        this.numeric(NumericOperators.floor, Float.valueOf(499.0f), Float.valueOf(499.01f));
        this.numeric(NumericOperators.floor, 499.0, 499.01);
        this.numeric(NumericOperators.integerDivide, BuiltInTests.bigint(500L), 1001, 2);
        this.numeric(NumericOperators.integerDivide, BuiltInTests.bigint(500L), BuiltInTests.bigdec(1001.1), 2);
        this.numeric(NumericOperators.integerDivide, BuiltInTests.bigint(500L), Float.valueOf(1001.125f), 2);
        this.numeric(NumericOperators.integerDivide, BuiltInTests.bigint(500L), 1001.125, 2.0);
        this.numeric(NumericOperators.mod, BuiltInTests.bigint(1L), 10, 3);
        this.numeric(NumericOperators.mod, BuiltInTests.bigint(-1L), -10, 3);
        this.numeric(NumericOperators.mod, BuiltInTests.bigint(0L), 6, -2);
        this.numeric(NumericOperators.mod, BuiltInTests.bigdec(0.9), BuiltInTests.bigdec(4.5), BuiltInTests.bigdec(1.2));
        this.numeric(NumericOperators.mod, BuiltInTests.bigdec(0.9), BuiltInTests.bigdec(4.5), BuiltInTests.bigdec(-1.2));
        this.numeric(NumericOperators.mod, BuiltInTests.bigdec(-0.9), BuiltInTests.bigdec(-4.5), BuiltInTests.bigdec(1.2));
        this.numeric(NumericOperators.mod, BuiltInTests.bigdec(-0.9), BuiltInTests.bigdec(-4.5), BuiltInTests.bigdec(-1.2));
        this.numeric(NumericOperators.mod, Float.valueOf(3.0f), Float.valueOf(123.0f), Float.valueOf(6.0f));
        this.numeric(NumericOperators.mod, Float.valueOf(3.0f), Float.valueOf(123.0f), Float.valueOf(-6.0f));
        this.numeric(NumericOperators.mod, Float.valueOf(-3.0f), Float.valueOf(-123.0f), Float.valueOf(6.0f));
        this.numeric(NumericOperators.mod, Float.valueOf(-3.0f), Float.valueOf(-123.0f), Float.valueOf(-6.0f));
        this.numeric(NumericOperators.mod, 3.0, 123.0, 6.0);
        this.numeric(NumericOperators.mod, 3.0, 123.0, -6.0);
        this.numeric(NumericOperators.mod, -3.0, -123.0, 6.0);
        this.numeric(NumericOperators.mod, -3.0, -123.0, -6.0);
        this.numeric(NumericOperators.multiply, BuiltInTests.bigint(18750000L), 7500, 2500);
        this.numeric(NumericOperators.multiply, BuiltInTests.bigdec(1.8750625E7), BuiltInTests.bigdec(7500.25), 2500);
        this.numeric(NumericOperators.multiply, Float.valueOf(62625.0f), Float.valueOf(250.5f), 250);
        this.numeric(NumericOperators.multiply, 62562.515625, 250.125, 250.125);
        this.numeric(NumericOperators.pow, BuiltInTests.bigint(Long.MAX_VALUE).pow(99), Long.MAX_VALUE, 99);
        this.numeric(NumericOperators.pow, null, BuiltInTests.bigdec(Math.PI), BuiltInTests.bigdec(3.5));
        this.numeric(NumericOperators.pow, Float.valueOf((float)Math.pow(40.0, 5.125)), Float.valueOf(40.0f), Float.valueOf(5.125f));
        this.numeric(NumericOperators.pow, Math.pow(40.0, 5.125), 40.0, 5.125);
        this.numeric(NumericOperators.round, BuiltInTests.bigdec(3.0), BuiltInTests.bigdec(2.5));
        this.numeric(NumericOperators.round, BuiltInTests.bigdec(2.0), BuiltInTests.bigdec(2.49999));
        this.numeric(NumericOperators.round, BuiltInTests.bigdec(-2.0), BuiltInTests.bigdec(-2.5));
        this.numeric(NumericOperators.round, 3.0, 2.5);
        this.numeric(NumericOperators.round, 2.0, 2.49999);
        this.numeric(NumericOperators.round, -2.0, -2.5);
        this.numeric(NumericOperators.round, Float.valueOf(3.0f), Float.valueOf(2.5f));
        this.numeric(NumericOperators.round, Float.valueOf(2.0f), Float.valueOf(2.49999f));
        this.numeric(NumericOperators.round, Float.valueOf(-2.0f), Float.valueOf(-2.5f));
        this.numeric(NumericOperators.round, BuiltInTests.bigint(1000L), 1000);
        this.numeric(NumericOperators.round, BuiltInTests.bigdec(500.0), BuiltInTests.bigdec(499.5));
        this.numeric(NumericOperators.round, Float.valueOf(499.0f), Float.valueOf(499.04f));
        this.numeric(NumericOperators.round, 499.0, 499.01);
        this.numeric(NumericOperators.roundHalfToEven, BuiltInTests.bigdec(0.0), BuiltInTests.bigdec(0.5));
        this.numeric(NumericOperators.roundHalfToEven, BuiltInTests.bigdec(2.0), BuiltInTests.bigdec(1.5));
        this.numeric(NumericOperators.roundHalfToEven, BuiltInTests.bigdec(2.0), BuiltInTests.bigdec(2.5));
        this.numeric(NumericOperators.roundHalfToEven, BuiltInTests.bigdec(3567.81), BuiltInTests.bigdec(3567.812), 2);
        this.numeric(NumericOperators.roundHalfToEven, BuiltInTests.bigdec(35600.0), BuiltInTests.bigdec(35612.25), -2);
        this.numeric(NumericOperators.roundHalfToEven, BuiltInTests.bigint(1000L), 1000);
        this.numeric(NumericOperators.roundHalfToEven, BuiltInTests.bigint(1000L), 1000, 2);
        this.numeric(NumericOperators.roundHalfToEven, BuiltInTests.bigdec(500.0), BuiltInTests.bigdec(499.5));
        this.numeric(NumericOperators.roundHalfToEven, BuiltInTests.bigdec(500.0), BuiltInTests.bigdec(500.5));
        this.numeric(NumericOperators.roundHalfToEven, BuiltInTests.bigdec(500.4), BuiltInTests.bigdec(500.44), 1);
        this.numeric(NumericOperators.roundHalfToEven, null, BuiltInTests.bigdec(500.45), BuiltInTests.bigdec(1.5));
        this.numeric(NumericOperators.roundHalfToEven, Float.valueOf(499.0f), Float.valueOf(499.04f));
        this.numeric(NumericOperators.roundHalfToEven, Float.valueOf(499.02f), Float.valueOf(499.015f), 2);
        this.numeric(NumericOperators.roundHalfToEven, Float.valueOf(499.02f), Float.valueOf(499.025f), 2);
        this.numeric(NumericOperators.roundHalfToEven, 499.0, 499.01);
        this.numeric(NumericOperators.roundHalfToEven, 499.02, 499.015, 2);
        this.numeric(NumericOperators.roundHalfToEven, 499.02, 499.025, 2);
        this.numeric(NumericOperators.sin, Math.sin(25.0), 25);
        this.numeric(NumericOperators.sin, Math.sin(25.0), BuiltInTests.bigdec(25.0));
        this.numeric(NumericOperators.sin, Math.sin(25.0), Float.valueOf(25.0f));
        this.numeric(NumericOperators.sin, Math.sin(25.0), 25.0);
        this.numeric(NumericOperators.subtract, BuiltInTests.bigint(5000L), 7500, 2500);
        this.numeric(NumericOperators.subtract, BuiltInTests.bigdec(5000.25), BuiltInTests.bigdec(7500.25), 2500);
        this.numeric(NumericOperators.subtract, Float.valueOf(0.5f), Float.valueOf(250.5f), 250);
        this.numeric(NumericOperators.subtract, 0.125, 250.25, 250.125);
        this.numeric(NumericOperators.tan, Math.tan(25.0), 25);
        this.numeric(NumericOperators.tan, Math.tan(25.0), BuiltInTests.bigdec(25.0));
        this.numeric(NumericOperators.tan, Math.tan(25.0), Float.valueOf(25.0f));
        this.numeric(NumericOperators.tan, Math.tan(25.0), 25.0);
        this.numeric(NumericOperators.unaryMinus, BuiltInTests.bigint(25L), -25);
        this.numeric(NumericOperators.unaryMinus, BuiltInTests.bigdec(25.0), BuiltInTests.bigdec(-25.0));
        this.numeric(NumericOperators.unaryMinus, Float.valueOf(25.0f), Float.valueOf(-25.0f));
        this.numeric(NumericOperators.unaryMinus, 25.0, -25.0);
        this.numeric(NumericOperators.unaryPlus, BuiltInTests.bigint(25L), 25);
        this.numeric(NumericOperators.unaryPlus, BuiltInTests.bigdec(25.0), BuiltInTests.bigdec(25.0));
        this.numeric(NumericOperators.unaryPlus, Float.valueOf(25.0f), Float.valueOf(25.0f));
        this.numeric(NumericOperators.unaryPlus, 25.0, 25.0);
    }

    @Test
    public void testStrings() {
        Assert.assertFalse((boolean)this.stringTest(StringOperators.contains, "defg", "abcdefghij"));
        Assert.assertTrue((boolean)this.stringTest(StringOperators.contains, "abcdefghij", "defg"));
        Assert.assertFalse((boolean)this.stringTest(StringOperators.containsIgnoreCase, "defG", "abcDefghij"));
        Assert.assertTrue((boolean)this.stringTest(StringOperators.containsIgnoreCase, "abcDefghij", "defG"));
        Assert.assertFalse((boolean)this.stringTest(StringOperators.endsWith, "defg", "abcdefg"));
        Assert.assertTrue((boolean)this.stringTest(StringOperators.endsWith, "abcdefg", "defg"));
        this.stringFunc(StringOperators.lowerCase, "abcdefg", "AbCDefg");
        this.stringFunc(StringOperators.lowerCase, (Literal)null, "abc", "deF");
        this.stringFunc(StringOperators.lowerCase, "", "");
        Assert.assertTrue((boolean)this.stringTest(StringOperators.matches, "abcdefg", ".*cs*.+"));
        Assert.assertFalse((boolean)this.stringTest(StringOperators.matches, "abcdefg", "s+"));
        Assert.assertTrue((boolean)this.stringTest(StringOperators.matches, "abcdefg", "^abc+.*g$"));
        this.stringFunc(StringOperators.normalizeSpace, "ab cd efg", "\tab cd   efg\t    ");
        this.stringFunc(StringOperators.replace, "ba", "aaa", "aa", "b");
        this.stringFunc(StringOperators.replace, "aab", "aab", "cc", "b");
        Assert.assertTrue((boolean)this.stringTest(StringOperators.startsWith, "abcdefg", "abc"));
        Assert.assertFalse((boolean)this.stringTest(StringOperators.startsWith, "abc", "abcdefg"));
        this.stringFunc(StringOperators.stringConcat, "", new String[0]);
        this.stringFunc(StringOperators.stringConcat, "abcdefg", "ab", "cde", "f", "g", "");
        Assert.assertTrue((boolean)this.stringTest(StringOperators.stringEqualIgnoreCase, "abCdEfG", "ABcDeFg"));
        Assert.assertFalse((boolean)this.stringTest(StringOperators.stringEqualIgnoreCase, "abCd", "abCde"));
        this.stringFunc(StringOperators.stringLength, TermFactory.literal((String)"5", (ATermAppl)Datatypes.INTEGER), "abcde");
        this.stringFunc(StringOperators.stringLength, (Literal)null, "abcde", "fgh");
        this.stringFunc(StringOperators.substring, " car", "motor car", "6");
        this.stringFunc(StringOperators.substring, "ada", "metadata", "4", "3");
        this.stringFunc(StringOperators.substring, "234", "12345", "1.5", "2.6");
        this.stringFunc(StringOperators.substring, "12", "12345", "0", "3");
        this.stringFunc(StringOperators.substring, "", "12345", "5", "-3");
        this.stringFunc(StringOperators.substring, "1", "12345", "-3", "5");
        this.stringFunc(StringOperators.substring, "", "12345", "NaN", "3");
        this.stringFunc(StringOperators.substring, "", "12345", "1", "NaN");
        this.stringFunc(StringOperators.substring, "", "", "1", "3");
        this.stringFunc(StringOperators.substring, "12345", "12345", "-42", new Double(Double.POSITIVE_INFINITY).toString());
        this.stringFunc(StringOperators.substring, "", "12345", new Double(Double.NEGATIVE_INFINITY).toString(), new Double(Double.POSITIVE_INFINITY).toString());
        this.stringFunc(StringOperators.substring, "g", "abcdefg", "7", "9");
        this.stringFunc(StringOperators.substringAfter, "fg", "abcdefg", "de");
        this.stringFunc(StringOperators.substringAfter, "", "abcdefg", "");
        this.stringFunc(StringOperators.substringAfter, "", "abcdefg", "zzz");
        this.stringFunc(StringOperators.substringBefore, "abc", "abcdefg", "de");
        this.stringFunc(StringOperators.substringBefore, "", "abcdefg", "");
        this.stringFunc(StringOperators.substringBefore, "", "abcdefg", "zzz");
        this.stringFunc(StringOperators.translate, "acdefgh", "abcdefg", "bcdefg", "cdefgh");
        this.stringFunc(StringOperators.translate, "acdegh", "abcdefg", "abcdfge", "acdegh");
        this.stringFunc(StringOperators.upperCase, "ABCDEFG", "abcDefG");
    }

    @Test
    public void testQuery() {
        String ns = "http://owldl.com/ontologies/swrl/tests/builtIns/007#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read("file:" + SWRLTestSuite.base + "builtIns/007-premise.n3", null, "N3");
        model.prepare();
        Resource a = model.createResource("http://owldl.com/ontologies/swrl/tests/builtIns/007#a");
        Resource b = model.createResource("http://owldl.com/ontologies/swrl/tests/builtIns/007#b");
        Property feet = model.createProperty("http://owldl.com/ontologies/swrl/tests/builtIns/007#lengthInFeet");
        Property inches = model.createProperty("http://owldl.com/ontologies/swrl/tests/builtIns/007#lengthInInches");
        com.hp.hpl.jena.rdf.model.Literal lit12 = model.createTypedLiteral(12.0f);
        com.hp.hpl.jena.rdf.model.Literal lit24 = model.createTypedLiteral(24.0f);
        Model inferences = ModelFactory.createDefaultModel();
        PelletTestCase.addStatements(inferences, a, feet, new RDFNode[]{model.createTypedLiteral(1.0f)});
        PelletTestCase.addStatements(inferences, b, feet, new RDFNode[]{model.createTypedLiteral(2.0f)});
        PelletTestCase.assertPropertyValues((Model)model, feet, inferences);
        inferences = ModelFactory.createDefaultModel();
        PelletTestCase.addStatements(inferences, a, inches, new RDFNode[]{lit12});
        PelletTestCase.addStatements(inferences, b, inches, new RDFNode[]{lit24});
        PelletTestCase.assertPropertyValues((Model)model, inches, inferences);
    }

    @Test
    public void testTokenizeBinding() {
        KnowledgeBase kb = new KnowledgeBase();
        AtomDConstant data = new AtomDConstant(TermFactory.literal((String)"hi;bye;foo;bar"));
        AtomDVariable x = new AtomDVariable("x");
        AtomDConstant semicolan = new AtomDConstant(TermFactory.literal((String)";"));
        Set emptyCollection = Collections.emptySet();
        Set<AtomDVariable> xSingleton = Collections.singleton(x);
        BuiltInAtom oneVarAtom = new BuiltInAtom("http://www.w3.org/2003/11/swrlb#tokenize", new AtomDObject[]{x, data, semicolan});
        BindingHelper sharedVarHelper = StringOperators.tokenize.createHelper(oneVarAtom);
        Assert.assertTrue((boolean)sharedVarHelper.getBindableVars(emptyCollection).equals(xSingleton));
        VariableBinding emptyBinding = new VariableBinding(kb.getABox());
        sharedVarHelper.rebind(emptyBinding);
        VariableBinding fillBinding = new VariableBinding(kb.getABox());
        List<String> expected = Arrays.asList("hi", "bye", "foo", "bar");
        ArrayList<String> tokens = new ArrayList<String>();
        while (sharedVarHelper.selectNextBinding()) {
            sharedVarHelper.setCurrentBinding(fillBinding);
            String token = ATermUtils.getLiteralValue((ATermAppl)fillBinding.get((AtomDObject)x).getTerm());
            tokens.add(token);
        }
        Assert.assertEquals((String)"String tokenizer returned unexpected sequence of tokens", expected, tokens);
    }

    @Test
    public void testTokenizeBindingEmpty() {
        KnowledgeBase kb = new KnowledgeBase();
        AtomDConstant data = new AtomDConstant(TermFactory.literal((String)"hi;bye;foo;bar"));
        AtomDVariable x = new AtomDVariable("x");
        AtomDConstant comma = new AtomDConstant(TermFactory.literal((String)","));
        Set emptyCollection = Collections.emptySet();
        Set<AtomDVariable> xSingleton = Collections.singleton(x);
        BuiltInAtom oneVarAtom = new BuiltInAtom("http://www.w3.org/2003/11/swrlb#tokenize", new AtomDObject[]{x, data, comma});
        BindingHelper sharedVarHelper = StringOperators.tokenize.createHelper(oneVarAtom);
        Assert.assertTrue((boolean)sharedVarHelper.getBindableVars(emptyCollection).equals(xSingleton));
        VariableBinding emptyBinding = new VariableBinding(kb.getABox());
        sharedVarHelper.rebind(emptyBinding);
        VariableBinding fillBinding = new VariableBinding(kb.getABox());
        List<String> expected = Collections.singletonList(ATermUtils.getLiteralValue((ATermAppl)data.getValue()));
        ArrayList<String> tokens = new ArrayList<String>();
        while (sharedVarHelper.selectNextBinding()) {
            sharedVarHelper.setCurrentBinding(fillBinding);
            String token = ATermUtils.getLiteralValue((ATermAppl)fillBinding.get((AtomDObject)x).getTerm());
            tokens.add(token);
        }
        Assert.assertEquals((String)"String tokenizer returned unexpected sequence of tokens", expected, tokens);
    }

    @Test
    public void testTokenizeSharedSuccess() {
        KnowledgeBase kb = new KnowledgeBase();
        AtomDConstant data = new AtomDConstant(TermFactory.literal((String)"hi;bye;foo;bar"));
        AtomDVariable x = new AtomDVariable("x");
        AtomDConstant comma = new AtomDConstant(TermFactory.literal((String)","));
        Set emptyCollection = Collections.emptySet();
        Set<AtomDVariable> xSingleton = Collections.singleton(x);
        BuiltInAtom sharedVarAtom = new BuiltInAtom("http://www.w3.org/2003/11/swrlb#tokenize", new AtomDObject[]{x, x, comma});
        BindingHelper sharedVarHelper = StringOperators.tokenize.createHelper(sharedVarAtom);
        Assert.assertTrue((boolean)sharedVarHelper.getBindableVars(emptyCollection).isEmpty());
        Assert.assertTrue((boolean)sharedVarHelper.getBindableVars(xSingleton).isEmpty());
        VariableBinding xdataBinding = new VariableBinding(kb.getABox());
        xdataBinding.set(x, data.getValue());
        sharedVarHelper.rebind(xdataBinding);
        Assert.assertTrue((boolean)sharedVarHelper.selectNextBinding());
        Assert.assertFalse((boolean)sharedVarHelper.selectNextBinding());
    }

    @Test
    public void testTokenizeSharedFailure() {
        KnowledgeBase kb = new KnowledgeBase();
        AtomDConstant data = new AtomDConstant(TermFactory.literal((String)"hi;bye;foo;bar"));
        AtomDVariable x = new AtomDVariable("x");
        AtomDConstant semicolan = new AtomDConstant(TermFactory.literal((String)";"));
        Set emptyCollection = Collections.emptySet();
        Set<AtomDVariable> xSingleton = Collections.singleton(x);
        BuiltInAtom sharedVarAtom = new BuiltInAtom("http://www.w3.org/2003/11/swrlb#tokenize", new AtomDObject[]{x, x, semicolan});
        BindingHelper sharedVarHelper = StringOperators.tokenize.createHelper(sharedVarAtom);
        Assert.assertTrue((boolean)sharedVarHelper.getBindableVars(emptyCollection).isEmpty());
        Assert.assertTrue((boolean)sharedVarHelper.getBindableVars(xSingleton).isEmpty());
        VariableBinding xdataBinding = new VariableBinding(kb.getABox());
        xdataBinding.set(x, data.getValue());
        sharedVarHelper.rebind(xdataBinding);
        Assert.assertFalse((boolean)sharedVarHelper.selectNextBinding());
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(BuiltInTests.class);
    }
}

