/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.TimeoutException;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.test.JenaWebOntTester;
import org.mindswap.pellet.test.OWLTestVocabulary;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.test.WebOntTester;

public class WebOntTest {
    public static Logger log = Logger.getLogger(WebOntTest.class.getName());
    public int timeout = 10;
    public static final int NO_STATS = 0;
    public static final int SHORT_STATS = 1;
    public static final int LONG_STATS = 2;
    public static final int ALL_STATS = 3;
    public int showStats = 3;
    private String base = "http://www.w3.org/2002/03owlt/";
    private String localBase = PelletTestSuite.base;
    private String newBase;
    public static boolean DOUBLE_CHECK_ENTAILMENTS = false;
    static final List TYPES = Arrays.asList(OWLTestVocabulary.NotOwlFeatureTest, OWLTestVocabulary.PositiveEntailmentTest, OWLTestVocabulary.NegativeEntailmentTest, OWLTestVocabulary.TrueTest, OWLTestVocabulary.OWLforOWLTest, OWLTestVocabulary.ConsistencyTest, OWLTestVocabulary.InconsistencyTest, OWLTestVocabulary.ImportEntailmentTest, OWLTestVocabulary.ImportLevelTest, OWLTestVocabulary.ClassificationTest);
    static final List LEVELS = Arrays.asList(OWLTestVocabulary.Lite, OWLTestVocabulary.DL, OWLTestVocabulary.Full);
    static final List STATUS = Arrays.asList(OWLTestVocabulary.Approved, OWLTestVocabulary.Proposed, OWLTestVocabulary.ExtraCredit, OWLTestVocabulary.Obsoleted);
    public boolean avoidFailTests = false;
    static final List AVOID = Arrays.asList(ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/AnnotationProperty/Manifest001#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/AnnotationProperty/Manifest002#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/Class/Manifest005#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/DatatypeProperty/Manifest001#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/description-logic/Manifest661#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/description-logic/Manifest662#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/description-logic/Manifest663#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/description-logic/Manifest664#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/description-logic/Manifest903#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/description-logic/Manifest905#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/description-logic/Manifest906#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/description-logic/Manifest907#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/description-logic/Manifest908#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/description-logic/Manifest909#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/description-logic/Manifest910#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/disjointWith/Manifest010#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/equivalentClass/Manifest008#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/equivalentProperty/Manifest005#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/extra-credit/Manifest002#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/extra-credit/Manifest003#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/extra-credit/Manifest004#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/I4.6/Manifest003#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/I4.6/Manifest005#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/I5.1/Manifest001#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/I5.24/Manifest002#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/I5.26/Manifest006#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/I5.26/Manifest007#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/I5.3/Manifest014#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/I5.3/Manifest015#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/I5.5/Manifest003#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/I5.5/Manifest004#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/I5.5/Manifest006#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/I5.5/Manifest007#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/I5.8/Manifest012#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/I5.8/Manifest017#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/miscellaneous/Manifest202#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/miscellaneous/Manifest205#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/miscellaneous/Manifest302#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/Ontology/Manifest003#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/Restriction/Manifest005#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/Restriction/Manifest006#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/sameAs/Manifest001#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/someValuesFrom/Manifest001#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/someValuesFrom/Manifest003#test"), ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/Thing/Manifest005#test"));
    int syntacticTestCount = 0;
    int syntacticTestPass = 0;
    public static final int TEST_PASS = 0;
    public static final int TEST_FAIL = 1;
    public static final int TEST_SKIP = 2;
    public static final List RESULTS = Arrays.asList("PASS", "FAIL", "SKIP");
    int[][][][] stats = new int[LEVELS.size()][STATUS.size()][TYPES.size()][RESULTS.size()];
    Vector results = new Vector();
    int MAX_TEST_COUNT = Integer.MAX_VALUE;
    WebOntTester[] testers = new WebOntTester[]{new JenaWebOntTester()};

    public static final void main(String[] args) {
        WebOntTest owlTest = new WebOntTest();
        owlTest.run(args);
    }

    public WebOntTest() {
        for (int i = 0; i < this.testers.length; ++i) {
            WebOntTester tester = this.testers[i];
            tester.registerURIMapping("http://www.w3.org/2002/03owlt/imports/support001-A", this.localBase + "owl-test/imports/support001-A.rdf");
            tester.registerURIMapping("http://www.w3.org/2002/03owlt/imports/support003-A", this.localBase + "owl-test/imports/support003-A.rdf");
            tester.registerURIMapping("http://www.w3.org/2002/03owlt/imports/support011-A", this.localBase + "owl-test/imports/support011-A.rdf");
            tester.registerURIMapping("http://www.w3.org/2002/03owlt/imports/support003-B", this.localBase + "owl-test/imports/support003-B.rdf");
            tester.registerURIMapping("http://www.w3.org/2002/03owlt/imports/consistent012", this.localBase + "owl-test/imports/consistent012.rdf");
            tester.registerURIMapping("http://www.w3.org/2002/03owlt/miscellaneous/consistent002", this.localBase + "owl-test/miscellaneous/consistent002.rdf");
            tester.registerURIMapping("http://www.w3.org/2002/03owlt/miscellaneous/consistent001", this.localBase + "owl-test/miscellaneous/consistent001.rdf");
        }
    }

    public List<WebOntTester> getTesters() {
        return Arrays.asList(this.testers);
    }

    public void setTesters(List<WebOntTester> testers) {
        this.testers = testers.toArray(new WebOntTester[0]);
    }

    public String getBase() {
        return this.newBase;
    }

    public void setBase(String newBase) {
        this.setBase(this.base, newBase);
    }

    public void setBase(String base, String newBase) {
        this.base = base;
        this.newBase = newBase;
    }

    public boolean isAvoidFailTests() {
        return this.avoidFailTests;
    }

    public void setAvoidFailTests(boolean avoidFailTests) {
        this.avoidFailTests = avoidFailTests;
    }

    public int getShowStats() {
        return this.showStats;
    }

    public void setShowStats(int showStats) {
        this.showStats = showStats;
    }

    public void run(String[] args) {
        String manifestFile = this.base + "Manifest.rdf";
        for (int i = 0; i < args.length; ++i) {
            String stats;
            String arg = args[i];
            if (arg.equals("-timeout")) {
                this.timeout = Integer.parseInt(args[++i]);
                continue;
            }
            if (arg.equals("-avoidFail")) {
                this.avoidFailTests = true;
                continue;
            }
            if (arg.equals("-manifest")) {
                if ((manifestFile = args[++i]).startsWith("http://")) continue;
                manifestFile = "http://www.w3.org/2002/03owlt/" + manifestFile;
                continue;
            }
            if (arg.equals("-validate")) {
                PelletOptions.VALIDATE_ABOX = true;
                continue;
            }
            if (arg.equals("-n")) {
                try {
                    this.MAX_TEST_COUNT = Integer.parseInt(args[++i]);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
                continue;
            }
            if (!arg.startsWith("-stats")) continue;
            if ((stats = args[++i].toLowerCase()).equals("no")) {
                this.showStats = 0;
                continue;
            }
            if (stats.equals("short")) {
                this.showStats = 1;
                continue;
            }
            if (stats.equals("long")) {
                this.showStats = 2;
                continue;
            }
            if (!stats.equals("all")) continue;
            this.showStats = 3;
        }
        System.out.println("Reading manifest file " + manifestFile);
        System.out.println();
        long time = System.currentTimeMillis();
        this.doTest(manifestFile);
        time = System.currentTimeMillis() - time;
        System.out.println("Total time: " + time);
    }

    public boolean doTest(String manifestFile) {
        boolean allPassed;
        block16: {
            allPassed = true;
            int testCount = 0;
            try {
                Model model = ModelFactory.createDefaultModel();
                Model outputModel = ModelFactory.createDefaultModel();
                Resource system = ResourceFactory.createResource();
                outputModel.add(system, RDFS.label, "Pellet");
                outputModel.add(system, RDFS.comment, "This was generated by the Pellet reasoner which can be found at http://pellet.owldl.com/");
                model.read(manifestFile, "");
                StmtIterator i = model.listStatements(null, RDF.type, (RDFNode)((Resource)null));
                while (i.hasNext() && testCount <= this.MAX_TEST_COUNT) {
                    Statement stmt = i.nextStatement();
                    if (!TYPES.contains(stmt.getObject())) continue;
                    Resource testCase = stmt.getSubject();
                    if (this.avoidFailTests && AVOID.contains(testCase)) continue;
                    Statement levelStmt = testCase.getProperty(OWLTestVocabulary.level);
                    Statement statusStmt = testCase.getProperty(OWLTestVocabulary.status);
                    Vector<String> levels = new Vector<String>();
                    int level = 3;
                    StmtIterator si = testCase.listProperties(OWLTestVocabulary.level);
                    while (si.hasNext()) {
                        Statement s = si.nextStatement();
                        String levelName = s.getResource().getLocalName();
                        if (level <= LEVELS.indexOf(levelName)) continue;
                        levelStmt = s;
                        levels.add(levelName);
                    }
                    Resource testType = stmt.getResource();
                    Resource testLevel = levelStmt.getResource();
                    RDFNode testStatus = statusStmt.getObject();
                    if (testStatus.equals(OWLTestVocabulary.Obsoleted) || testStatus.toString().startsWith("OBSOLETE") || testType.equals((Object)OWLTestVocabulary.OWLforOWLTest)) continue;
                    String fileName = testCase.toString();
                    System.out.println("Test  : " + ++testCount);
                    System.out.println("Name  : " + testCase);
                    System.out.print("Info  : ");
                    System.out.print(testType.getLocalName() + " ");
                    System.out.print(levels + " ");
                    System.out.print(testStatus);
                    System.out.println();
                    Vector<Object> result = new Vector<Object>();
                    result.add(testCount - 1);
                    result.add(fileName.substring(1 + fileName.substring(1, fileName.lastIndexOf("/") - 1).lastIndexOf("/")));
                    result.add(testType.getLocalName());
                    result.add(testLevel.getLocalName());
                    result.add(testStatus);
                    long time = System.currentTimeMillis();
                    int testResult = 1;
                    try {
                        testResult = this.doTestCase(testCase, testType);
                    }
                    catch (UnsupportedFeatureException e) {
                        System.err.println("Skip  : " + e.getMessage());
                    }
                    catch (TimeoutException e1) {
                        System.err.println("Fail  : Timeout - Couldn't find answer after " + this.timeout + " seconds");
                    }
                    catch (Exception e) {
                        System.err.println("Fail  : " + e.getMessage());
                        WebOntTest.printStackTrace(e);
                    }
                    catch (StackOverflowError e) {
                        System.err.println("Fail  : Stack overflow");
                        WebOntTest.printStackTrace(e);
                    }
                    catch (OutOfMemoryError e) {
                        System.err.println("Fail  : Out of Memory");
                    }
                    time = System.currentTimeMillis() - time;
                    Resource testRun = ResourceFactory.createResource();
                    Property type = ResourceFactory.createProperty((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
                    Property tcProp = ResourceFactory.createProperty((String)"http://www.w3.org/2002/03owlt/resultsOntology#test");
                    Resource runtype = ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/resultsOntology#TestRun");
                    Property systemProp = ResourceFactory.createProperty((String)"http://www.w3.org/2002/03owlt/resultsOntology#system");
                    Resource resultType = null;
                    if (testResult == 1) {
                        resultType = time >= (long)(this.timeout * 1000) ? ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/resultsOntology#IncompleteRun") : ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/resultsOntology#FailingRun");
                    } else if (testResult == 0) {
                        resultType = ResourceFactory.createResource((String)"http://www.w3.org/2002/03owlt/resultsOntology#PassingRun");
                    } else if (testResult == 2) {
                        // empty if block
                    }
                    outputModel.add(ResourceFactory.createStatement((Resource)testRun, (Property)type, (RDFNode)runtype));
                    outputModel.add(ResourceFactory.createStatement((Resource)testRun, (Property)tcProp, (RDFNode)testCase));
                    outputModel.add(ResourceFactory.createStatement((Resource)testRun, (Property)systemProp, (RDFNode)system));
                    if (resultType != null) {
                        outputModel.add(ResourceFactory.createStatement((Resource)testRun, (Property)type, (RDFNode)resultType));
                    }
                    Property timeProp = ResourceFactory.createProperty((String)"http://owl.mindswap.org/2003/ont/owlweb.rdf#testTime");
                    Literal timeLiteral = model.createLiteral("" + time);
                    outputModel.add(ResourceFactory.createStatement((Resource)testRun, (Property)timeProp, (RDFNode)timeLiteral));
                    result.add(time);
                    result.add(RESULTS.get(testResult));
                    this.results.add(result);
                    int i1 = LEVELS.indexOf(testLevel);
                    int i2 = STATUS.indexOf(testStatus);
                    int i3 = TYPES.indexOf(testType);
                    int i4 = testResult;
                    int[] nArray = this.stats[i1][i2][i3];
                    int n = i4;
                    nArray[n] = nArray[n] + 1;
                    System.out.println("Result: " + RESULTS.get(testResult));
                    System.out.println("--------------------------------------------------------------------");
                    allPassed &= testResult == 0;
                }
                this.printStatistics();
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
                allPassed = false;
                if (testCount != 2) break block16;
                throw new RuntimeException(e);
            }
        }
        return allPassed;
    }

    public int doSingleTest(String manifestFile) {
        Statement stmt;
        Model model = ModelFactory.createDefaultModel();
        model.read(manifestFile, "");
        StmtIterator i = model.listStatements(null, RDF.type, (RDFNode)((Resource)null));
        while (!TYPES.contains((stmt = i.nextStatement()).getObject())) {
        }
        Resource testCase = stmt.getSubject();
        Statement statusStmt = testCase.getProperty(OWLTestVocabulary.status);
        Resource testType = stmt.getResource();
        RDFNode testStatus = statusStmt.getObject();
        if (this.avoidFailTests && AVOID.contains(testCase)) {
            return 2;
        }
        if (testStatus.equals(OWLTestVocabulary.Obsoleted)) {
            return 2;
        }
        if (testStatus.toString().startsWith("OBSOLETE")) {
            return 2;
        }
        if (testType.equals((Object)OWLTestVocabulary.OWLforOWLTest)) {
            return 2;
        }
        log.fine("Name  : " + testCase);
        int testResult = 1;
        testResult = this.doTestCase(testCase, testType);
        return testResult;
    }

    public void printStatistics() {
        Object[][] data;
        int s;
        ArrayList<Object[][]> dataArray = new ArrayList<Object[][]>();
        for (s = 0; s < STATUS.size() - 1; ++s) {
            data = new Object[LEVELS.size() * (TYPES.size() + 1) + 1][RESULTS.size()];
            for (int r = 0; r < 3; ++r) {
                int columnTotal = 0;
                for (int l = 0; l < LEVELS.size(); ++l) {
                    int total = 0;
                    for (int t = 0; t < TYPES.size(); ++t) {
                        int count = this.stats[l][s][t][r];
                        data[l * (WebOntTest.TYPES.size() + 1) + t + 1][r] = count;
                        total += count;
                    }
                    data[l * (WebOntTest.TYPES.size() + 1)][r] = total;
                    columnTotal += total;
                }
                data[WebOntTest.LEVELS.size() * (WebOntTest.TYPES.size() + 1)][r] = columnTotal;
            }
            dataArray.add(data);
        }
        if (this.showStats >= 2) {
            System.out.println();
            for (int i = 0; i < this.results.size(); ++i) {
                Vector result = (Vector)this.results.get(i);
                boolean fail = result.get(result.size() - 1).equals("FAIL");
                if (!fail) continue;
                for (int j = 0; j < result.size(); ++j) {
                    System.out.print(result.get(j) + " ");
                }
                System.out.println();
            }
        }
        if (this.showStats >= 1) {
            System.out.println();
            for (s = 0; s < STATUS.size() - 1; ++s) {
                data = (Object[][])dataArray.get(s);
                System.out.println(STATUS.get(s).toString());
                for (int c = 0; c < 3; ++c) {
                    System.out.print(data[data.length - 1][c] + " ");
                }
                System.out.println();
            }
        }
        if (this.showStats >= 3) {
            this.showStatistics(dataArray);
        }
    }

    private void showStatistics(ArrayList dataArray) {
        Object[][] types = new String[LEVELS.size() * (TYPES.size() + 1) + 1][1];
        for (int l = 0; l < LEVELS.size(); ++l) {
            types[l * (WebOntTest.TYPES.size() + 1)][0] = ((Resource)LEVELS.get(l)).getLocalName();
            for (int t = 0; t < TYPES.size(); ++t) {
                types[l * (WebOntTest.TYPES.size() + 1) + t + 1][0] = "     " + ((Resource)TYPES.get(t)).getLocalName();
            }
            types[WebOntTest.LEVELS.size() * (WebOntTest.TYPES.size() + 1)][0] = "TOTAL";
        }
        JFrame info = new JFrame("Result");
        info.getContentPane().setLayout(new BoxLayout(info.getContentPane(), 1));
        Box mainPanel = Box.createHorizontalBox();
        final JTable table = new JTable(types, new String[]{"TYPE"});
        Box p1 = Box.createVerticalBox();
        p1.add(new JLabel(" "));
        p1.add(new JScrollPane(table));
        mainPanel.add(p1);
        final JTable[] tables = new JTable[STATUS.size()];
        for (int s = 0; s < STATUS.size() - 1; ++s) {
            Box p = Box.createVerticalBox();
            Object[][] data = (Object[][])dataArray.get(s);
            tables[s] = new JTable(data, RESULTS.toArray());
            JLabel label = new JLabel(STATUS.get(s).toString());
            label.setAlignmentX(0.5f);
            p.add(label);
            p.add(new JScrollPane(tables[s]));
            mainPanel.add(p);
        }
        Box optionsPanel = Box.createVerticalBox();
        final JCheckBox details = new JCheckBox("Show Details", true);
        details.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowHeight = details.isSelected() ? table.getRowHeight(0) : 1;
                for (int l = 0; l < LEVELS.size(); ++l) {
                    for (int t = 0; t < TYPES.size(); ++t) {
                        table.setRowHeight(l * (TYPES.size() + 1) + t + 1, rowHeight);
                        tables[0].setRowHeight(l * (TYPES.size() + 1) + t + 1, rowHeight);
                        tables[1].setRowHeight(l * (TYPES.size() + 1) + t + 1, rowHeight);
                        tables[2].setRowHeight(l * (TYPES.size() + 1) + t + 1, rowHeight);
                    }
                }
            }
        });
        details.doClick();
        optionsPanel.add(details);
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("No");
        columnNames.add("Name");
        columnNames.add("Type");
        columnNames.add("Level");
        columnNames.add("Status");
        columnNames.add("Time (ms)");
        columnNames.add("Result");
        JTable resultsTable = new JTable(this.results, columnNames);
        resultsTable.getColumnModel().getColumn(0).setPreferredWidth(15);
        resultsTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        resultsTable.getColumnModel().getColumn(2).setPreferredWidth(150);
        resultsTable.getColumnModel().getColumn(3).setPreferredWidth(30);
        resultsTable.getColumnModel().getColumn(5).setPreferredWidth(30);
        resultsTable.getColumnModel().getColumn(6).setPreferredWidth(30);
        info.getContentPane().add(mainPanel);
        info.getContentPane().add(optionsPanel);
        info.getContentPane().add(new JScrollPane(resultsTable));
        info.setDefaultCloseOperation(3);
        info.setSize(800, 600);
        info.setVisible(true);
    }

    String getFileName(String fileName) {
        if (this.newBase != null) {
            fileName = fileName.replaceFirst(this.base, this.newBase);
        }
        if (!(fileName.endsWith(".rdf") || fileName.endsWith(".owl") || fileName.endsWith(".n3"))) {
            fileName = fileName + ".rdf";
        }
        return fileName;
    }

    int doConsistencyTest(Resource testCase, boolean isConsistent) {
        String inputFile;
        String string = inputFile = testCase.hasProperty(OWLTestVocabulary.inputDocument) ? testCase.getProperty(OWLTestVocabulary.inputDocument).getObject().toString() : null;
        if (inputFile != null) {
            inputFile = this.getFileName(inputFile);
            log.fine("Input : " + inputFile);
        }
        for (int i = 0; i < this.testers.length; ++i) {
            WebOntTester tester = this.testers[i];
            log.fine("Tester: " + tester.getClass().getName());
            tester.setInputOntology(inputFile);
            if (tester.isConsistent() == isConsistent) continue;
            log.severe("Fail  : Consistency error");
            return 1;
        }
        log.fine("Result: PASS");
        return 0;
    }

    int doEntailmentTest(Resource testCase, boolean isEntailed, boolean classifyFirst) {
        String inputFile = testCase.hasProperty(OWLTestVocabulary.premiseDocument) ? testCase.getProperty(OWLTestVocabulary.premiseDocument).getObject().toString() : null;
        String conclusionsFile = testCase.getProperty(OWLTestVocabulary.conclusionDocument).getObject().toString();
        if (inputFile != null) {
            inputFile = this.getFileName(inputFile);
            log.fine("Input : " + inputFile);
        }
        conclusionsFile = this.getFileName(conclusionsFile);
        log.fine("Conc. : " + conclusionsFile);
        for (int i = 0; i < this.testers.length; ++i) {
            WebOntTester tester = this.testers[i];
            log.fine("Tester: " + tester.getClass().getName());
            tester.setInputOntology(inputFile);
            if (!tester.isConsistent()) {
                log.severe("Fail  : Premises file is not consistent!");
                return 1;
            }
            if (classifyFirst) {
                tester.classify();
            }
            tester.testEntailment(conclusionsFile, isEntailed);
            if (!DOUBLE_CHECK_ENTAILMENTS) continue;
            tester.classify();
            tester.testEntailment(conclusionsFile, isEntailed);
        }
        log.fine("Result: PASS");
        return 0;
    }

    int doTestCase(Resource testCase, Resource testType) {
        if (testType.equals((Object)OWLTestVocabulary.PositiveEntailmentTest)) {
            return this.doEntailmentTest(testCase, true, false);
        }
        if (testType.equals((Object)OWLTestVocabulary.NegativeEntailmentTest)) {
            return this.doEntailmentTest(testCase, false, false);
        }
        if (testType.equals((Object)OWLTestVocabulary.ConsistencyTest)) {
            return this.doConsistencyTest(testCase, true);
        }
        if (testType.equals((Object)OWLTestVocabulary.InconsistencyTest)) {
            return this.doConsistencyTest(testCase, false);
        }
        if (testType.equals((Object)OWLTestVocabulary.ImportEntailmentTest)) {
            return this.doEntailmentTest(testCase, true, false);
        }
        if (testType.equals((Object)OWLTestVocabulary.NotOwlFeatureTest)) {
            return 2;
        }
        if (testType.equals((Object)OWLTestVocabulary.ImportLevelTest)) {
            return 2;
        }
        if (testType.equals((Object)OWLTestVocabulary.OWLforOWLTest)) {
            return 2;
        }
        if (testType.equals((Object)OWLTestVocabulary.ClassificationTest)) {
            return this.doEntailmentTest(testCase, true, true);
        }
        throw new RuntimeException("Unknown test type " + testType.getLocalName() + " for " + testCase);
    }

    public static void printStackTrace(Throwable e) {
        StackTraceElement[] ste = e.getStackTrace();
        System.err.println(e);
        if (ste.length > 25) {
            int i;
            for (i = 0; i < 15 && i < ste.length; ++i) {
                System.err.println("   " + ste[i]);
            }
            System.err.println("   ...");
            for (i = ste.length - 10; i < ste.length; ++i) {
                System.err.println("   " + ste[i]);
            }
        } else {
            for (int i = 0; i < ste.length; ++i) {
                System.err.println("   " + ste[i]);
            }
        }
    }
}

