/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import org.junit.Assert;
import org.mindswap.pellet.test.WebOntTester;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.manchester.cs.owl.owlapi.OWLOntologyIRIMapperImpl;

public class OWLAPIWebOntTester
implements WebOntTester {
    OWLOntologyManager manager = OWL.manager;
    PelletReasoner reasoner;
    OWLOntologyIRIMapperImpl mapper = new OWLOntologyIRIMapperImpl();

    @Override
    public void classify() {
        this.reasoner.getKB().realize();
    }

    @Override
    public boolean isConsistent() {
        return this.reasoner.isConsistent();
    }

    @Override
    public void testEntailment(String entailmentFileURI, boolean positiveEntailment) {
        try {
            OWLOntology ont = this.manager.loadOntology(IRI.create((String)entailmentFileURI));
            for (OWLAxiom axiom : ont.getLogicalAxioms()) {
                if (this.reasoner.isEntailed(axiom)) continue;
                Assert.assertFalse((String)("Entailment failed for " + axiom), (boolean)positiveEntailment);
                return;
            }
            Assert.assertTrue((String)"All axioms entailed in negative entailment test", (boolean)positiveEntailment);
        }
        catch (OWLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setInputOntology(String inputFileURI) {
        OntologyUtils.clearOWLOntologyManager();
        OWLOntology ont = null;
        try {
            this.manager.addIRIMapper((OWLOntologyIRIMapper)this.mapper);
            ont = this.manager.loadOntology(IRI.create((String)inputFileURI));
            this.reasoner = PelletReasonerFactory.getInstance().createReasoner(ont);
            if (ont == null) return;
        }
        catch (OWLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                if (ont == null) throw throwable;
                this.manager.removeOntology(ont);
                throw throwable;
            }
        }
        this.manager.removeOntology(ont);
        return;
    }

    @Override
    public void setTimeout(long timeout) {
        this.reasoner.getKB().setTimeout(timeout);
    }

    @Override
    public void registerURIMapping(String fromURI, String toURI) {
        this.mapper.addMapping(IRI.create((String)fromURI), IRI.create((String)toURI));
    }
}

