/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATermAppl;
import com.clarkparsia.pellet.owlapiv3.ConceptConverter;
import com.clarkparsia.pellet.owlapiv3.PelletVisitor;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.SetUtils;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWLAPIObjectConversionTests {
    public static String base = "file:" + PelletTestSuite.base + "misc/";
    private static String ns = "urn:test:";
    private static OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    private static OWLDataFactory factory = manager.getOWLDataFactory();
    private static OWLClass c1 = factory.getOWLClass(IRI.create((String)(ns + "c1")));
    private static OWLClass c2 = factory.getOWLClass(IRI.create((String)(ns + "c2")));
    private static OWLObjectProperty op1 = factory.getOWLObjectProperty(IRI.create((String)(ns + "op1")));
    private static OWLDataProperty dp1 = factory.getOWLDataProperty(IRI.create((String)(ns + "dp1")));
    private static OWLIndividual ind1 = factory.getOWLNamedIndividual(IRI.create((String)(ns + "ind1")));
    private static OWLIndividual ind2 = factory.getOWLNamedIndividual(IRI.create((String)(ns + "ind2")));
    private static OWLIndividual ind3 = factory.getOWLAnonymousIndividual(ns + "ind3");
    private static OWLLiteral uc1 = factory.getOWLLiteral("lit1");
    private static OWLLiteral uc2 = factory.getOWLLiteral("lit2", "en");
    private static OWLLiteral tc1 = factory.getOWLLiteral("lit3", OWL2Datatype.XSD_STRING);
    private static OWLLiteral tc2 = factory.getOWLLiteral("1", OWL2Datatype.XSD_INTEGER);
    private static OWLDatatype d1 = factory.getOWLDatatype(IRI.create((String)(ns + "d1")));
    private KnowledgeBase kb = new KnowledgeBase();
    private PelletVisitor atermConverter = new PelletVisitor(this.kb);
    private ConceptConverter owlapiConverter = new ConceptConverter(this.kb, factory);

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(OWLAPIObjectConversionTests.class);
    }

    private void testConversion(OWLObject object) {
        try {
            OWLObjectProperty p;
            this.kb.clear();
            this.atermConverter.clear();
            this.atermConverter.setAddAxiom(true);
            object.accept((OWLObjectVisitor)this.atermConverter);
            ATermAppl aterm = this.atermConverter.result();
            OWLSubClassOfAxiom axiom = null;
            if (object instanceof OWLClassExpression) {
                OWLClassExpression c = (OWLClassExpression)object;
                axiom = factory.getOWLSubClassOfAxiom(c, c);
            } else if (object instanceof OWLObjectProperty) {
                p = (OWLObjectProperty)object;
                axiom = factory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)p);
            } else if (object instanceof OWLDataProperty) {
                p = (OWLDataProperty)object;
                axiom = factory.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)p, (OWLDataPropertyExpression)p);
            } else if (object instanceof OWLIndividual) {
                OWLIndividual ind = (OWLIndividual)object;
                axiom = factory.getOWLClassAssertionAxiom((OWLClassExpression)factory.getOWLThing(), ind);
            }
            if (axiom != null) {
                axiom.accept((OWLObjectVisitor)this.atermConverter);
            }
            OWLObject converted = this.owlapiConverter.convert(aterm);
            Assert.assertEquals((Object)object, (Object)converted);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Explanation failed");
        }
    }

    @Test
    public void testClass() {
        this.testConversion((OWLObject)c1);
    }

    @Test
    public void testIntersectionOf() {
        this.testConversion((OWLObject)factory.getOWLObjectIntersectionOf(SetUtils.create((Object[])new OWLClass[]{c1, c2})));
    }

    @Test
    public void testUnionOf() {
        this.testConversion((OWLObject)factory.getOWLObjectUnionOf(SetUtils.create((Object[])new OWLClass[]{c1, c2})));
    }

    @Test
    public void testComplementOf() {
        this.testConversion((OWLObject)factory.getOWLObjectComplementOf((OWLClassExpression)c1));
    }

    @Test
    public void testObjectSomeValuesFrom() {
        this.testConversion((OWLObject)factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)op1, (OWLClassExpression)c1));
        this.testConversion((OWLObject)factory.getOWLObjectSomeValuesFrom(op1.getInverseProperty(), (OWLClassExpression)c1));
    }

    @Test
    public void testObjectAllValuesFrom() {
        this.testConversion((OWLObject)factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)op1, (OWLClassExpression)c1));
        this.testConversion((OWLObject)factory.getOWLObjectAllValuesFrom(op1.getInverseProperty(), (OWLClassExpression)c1));
    }

    public void testObjectValueRestriction() {
        this.testConversion((OWLObject)factory.getOWLObjectHasValue((OWLObjectPropertyExpression)op1, ind1));
        this.testConversion((OWLObject)factory.getOWLObjectHasValue(op1.getInverseProperty(), ind1));
    }

    @Test
    public void testObjectMinCardinality() {
        this.testConversion((OWLObject)factory.getOWLObjectMinCardinality(1, (OWLObjectPropertyExpression)op1));
        this.testConversion((OWLObject)factory.getOWLObjectMinCardinality(1, (OWLObjectPropertyExpression)op1, (OWLClassExpression)c1));
        this.testConversion((OWLObject)factory.getOWLObjectMinCardinality(1, op1.getInverseProperty(), (OWLClassExpression)c1));
    }

    @Test
    public void testObjectExactCardinality() {
        this.testConversion((OWLObject)factory.getOWLObjectExactCardinality(1, (OWLObjectPropertyExpression)op1));
        this.testConversion((OWLObject)factory.getOWLObjectExactCardinality(1, (OWLObjectPropertyExpression)op1, (OWLClassExpression)c1));
        this.testConversion((OWLObject)factory.getOWLObjectExactCardinality(1, op1.getInverseProperty(), (OWLClassExpression)c1));
    }

    @Test
    public void testObjectMaxCardinality() {
        this.testConversion((OWLObject)factory.getOWLObjectMaxCardinality(1, (OWLObjectPropertyExpression)op1));
        this.testConversion((OWLObject)factory.getOWLObjectMaxCardinality(1, (OWLObjectPropertyExpression)op1, (OWLClassExpression)c1));
        this.testConversion((OWLObject)factory.getOWLObjectMaxCardinality(1, op1.getInverseProperty(), (OWLClassExpression)c1));
    }

    @Test
    public void testSelfRestriction() {
        this.testConversion((OWLObject)factory.getOWLObjectHasSelf((OWLObjectPropertyExpression)op1));
        this.testConversion((OWLObject)factory.getOWLObjectHasSelf(op1.getInverseProperty()));
    }

    @Test
    public void testObjectOneOf() {
        this.testConversion((OWLObject)factory.getOWLObjectOneOf(SetUtils.create((Object[])new OWLIndividual[]{ind1, ind2})));
    }

    @Test
    public void testDataSomeValuesFrom() {
        this.testConversion((OWLObject)factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)dp1, (OWLDataRange)d1));
    }

    @Test
    public void testDataAllValuesFrom() {
        this.testConversion((OWLObject)factory.getOWLDataAllValuesFrom((OWLDataPropertyExpression)dp1, (OWLDataRange)d1));
    }

    @Test
    public void testDataValueRestriction() {
        this.testConversion((OWLObject)factory.getOWLDataHasValue((OWLDataPropertyExpression)dp1, uc1));
        this.testConversion((OWLObject)factory.getOWLDataHasValue((OWLDataPropertyExpression)dp1, uc2));
        this.testConversion((OWLObject)factory.getOWLDataHasValue((OWLDataPropertyExpression)dp1, tc1));
        this.testConversion((OWLObject)factory.getOWLDataHasValue((OWLDataPropertyExpression)dp1, tc2));
    }

    @Test
    public void testDataMinCardinality() {
        this.testConversion((OWLObject)factory.getOWLDataMinCardinality(1, (OWLDataPropertyExpression)dp1, (OWLDataRange)d1));
    }

    @Test
    public void testDataExactCardinality() {
        this.testConversion((OWLObject)factory.getOWLDataExactCardinality(1, (OWLDataPropertyExpression)dp1, (OWLDataRange)d1));
    }

    @Test
    public void testDataMaxCardinality() {
        this.testConversion((OWLObject)factory.getOWLDataMaxCardinality(1, (OWLDataPropertyExpression)dp1, (OWLDataRange)d1));
    }

    @Test
    public void testDataType() {
        this.testConversion((OWLObject)d1);
    }

    @Test
    public void testDataComplementOf() {
        this.testConversion((OWLObject)factory.getOWLDataComplementOf((OWLDataRange)d1));
    }

    @Test
    public void testDataOneOf() {
        this.testConversion((OWLObject)factory.getOWLDataOneOf(SetUtils.create((Object[])new OWLLiteral[]{uc1, uc2, tc1, tc2})));
    }

    @Ignore
    @Test
    public void testDataRangeRestriction() {
    }

    @Test
    public void testTypedConstant() {
        this.testConversion((OWLObject)tc1);
        this.testConversion((OWLObject)tc2);
    }

    @Test
    public void testUntypedConstant() {
        this.testConversion((OWLObject)uc1);
        this.testConversion((OWLObject)uc2);
    }

    @Test
    public void testObjectProperty() {
        this.testConversion((OWLObject)op1);
    }

    @Test
    public void testObjectPropertyInverse() {
        this.testConversion((OWLObject)op1.getInverseProperty());
    }

    @Test
    public void testDataProperty() {
        this.testConversion((OWLObject)dp1);
    }

    @Test
    public void testIndividual() {
        this.testConversion((OWLObject)ind1);
    }

    @Test
    public void testAnonymousIndividual() {
        this.testConversion((OWLObject)ind3);
    }
}

