/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.TermFactory;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.mindswap.pellet.test.AbstractKBTests;
import org.mindswap.pellet.test.PelletTestSuite;

public class MergeTests
extends AbstractKBTests {
    public static String base = "file:" + PelletTestSuite.base + "misc/";

    public static Test suite() {
        return new JUnit4TestAdapter(MergeTests.class);
    }

    @org.junit.Test
    public void instanceCheckForMergedNode() {
        this.classes(D, E);
        this.individuals(a, b, c, d, e);
        this.kb.addType(a, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        this.kb.addSubClass(E, TermFactory.not((ATermAppl)D));
        this.kb.addType(a, D);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        ATermAppl mergedTo = this.kb.getABox().getIndividual((ATerm)a).getMergedTo().getName();
        this.kb.addType(mergedTo, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{d, e}));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, TermFactory.not((ATermAppl)E)));
    }

    @org.junit.Test
    public void addTypeToMergedNode() {
        this.classes(A, D);
        this.individuals(a, b, c);
        this.kb.addType(a, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        this.kb.addType(a, A);
        this.kb.addType(b, B);
        this.kb.addType(c, C);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, A));
        Assert.assertFalse((boolean)this.kb.isType(a, B));
        Assert.assertFalse((boolean)this.kb.isType(a, C));
        Assert.assertFalse((boolean)this.kb.isType(a, D));
        this.kb.addType(a, D);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, A));
        Assert.assertFalse((boolean)this.kb.isType(a, B));
        Assert.assertFalse((boolean)this.kb.isType(a, C));
        Assert.assertTrue((boolean)this.kb.isType(a, D));
    }

    @org.junit.Test
    public void removeTypeFromMergedNode() {
        this.classes(A, D);
        this.individuals(a, b, c);
        this.kb.addType(a, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        this.kb.addType(a, A);
        this.kb.addType(b, B);
        this.kb.addType(c, C);
        this.kb.addType(a, D);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, A));
        Assert.assertFalse((boolean)this.kb.isType(a, B));
        Assert.assertFalse((boolean)this.kb.isType(a, C));
        Assert.assertTrue((boolean)this.kb.isType(a, D));
        boolean removed = this.kb.removeType(a, D);
        Assert.assertTrue((boolean)removed);
        Assert.assertFalse((boolean)this.kb.isConsistencyDone());
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, A));
        Assert.assertFalse((boolean)this.kb.isType(a, B));
        Assert.assertFalse((boolean)this.kb.isType(a, C));
        Assert.assertFalse((boolean)this.kb.isType(a, D));
    }

    @org.junit.Test
    public void cannotRemoveInferredType() {
        this.classes(A, D);
        this.individuals(a, b, c, d);
        this.kb.addType(a, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        this.kb.addType(a, A);
        this.kb.addType(b, B);
        this.kb.addType(c, C);
        this.kb.addType(d, D);
        this.kb.addSame(a, d);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, A));
        Assert.assertFalse((boolean)this.kb.isType(a, B));
        Assert.assertFalse((boolean)this.kb.isType(a, C));
        Assert.assertTrue((boolean)this.kb.isType(d, D));
        Assert.assertTrue((boolean)this.kb.isType(a, D));
        boolean removed = this.kb.removeType(a, D);
        Assert.assertTrue((!removed ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, A));
        Assert.assertFalse((boolean)this.kb.isType(a, B));
        Assert.assertFalse((boolean)this.kb.isType(a, C));
        Assert.assertTrue((boolean)this.kb.isType(d, D));
        Assert.assertTrue((boolean)this.kb.isType(a, D));
    }

    @org.junit.Test
    public void addClashingTypeToMergedNode() {
        this.classes(A, B, C, D);
        this.individuals(a, b, c);
        this.kb.addType(a, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        this.kb.addType(a, A);
        this.kb.addType(b, B);
        this.kb.addType(c, C);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, A));
        Assert.assertFalse((boolean)this.kb.isType(a, B));
        Assert.assertFalse((boolean)this.kb.isType(a, C));
        ATermAppl mergedTo = this.kb.getABox().getIndividual((ATerm)a).getMergedTo().getName();
        if (mergedTo.equals(b)) {
            this.kb.addType(a, TermFactory.not((ATermAppl)B));
        } else {
            this.kb.addType(a, TermFactory.not((ATermAppl)C));
        }
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, A));
        if (mergedTo.equals(b)) {
            Assert.assertTrue((boolean)this.kb.isType(a, C));
        } else {
            Assert.assertTrue((boolean)this.kb.isType(a, B));
        }
    }

    @org.junit.Test
    public void addEdgeToMergedSubject() {
        this.objectProperties(p);
        this.individuals(a, b, c, d);
        this.kb.addType(a, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, d));
        this.kb.addPropertyValue(p, a, d);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, d));
    }

    @org.junit.Test
    public void addEdgeToMergedObject() {
        this.objectProperties(p);
        this.individuals(a, b, c, d);
        this.kb.addType(a, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(d, p, a));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(d, p, b));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(d, p, c));
        this.kb.addPropertyValue(p, d, a);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(d, p, a));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(d, p, b));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(d, p, c));
    }

    @org.junit.Test
    public void addEdgeToMergedSubjectObject() {
        this.objectProperties(p);
        this.individuals(a, b, c, d, e, f);
        this.kb.addType(a, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        this.kb.addType(d, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{e, f}));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, e));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, e));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, e));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, f));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, f));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, f));
        this.kb.addPropertyValue(p, a, d);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, e));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, e));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, e));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, f));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, f));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, f));
    }

    @org.junit.Test
    public void addEdgeToMergedSubjectWithExistingEdge() {
        this.objectProperties(p);
        this.individuals(a, b, c, d, e);
        this.kb.addType(a, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        this.kb.addType(b, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.oneOf((ATermAppl[])new ATermAppl[]{d, e})));
        this.kb.addType(c, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.oneOf((ATermAppl[])new ATermAppl[]{d, e})));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, e));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, e));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, e));
        ATermAppl aMergedTo = this.kb.getABox().getIndividual((ATerm)a).getMergedTo().getName();
        ATermAppl aMergedToSucc = this.kb.getABox().getIndividual((ATerm)aMergedTo).getOutEdges().edgeAt(0).getToName();
        ATermAppl aMergedToNotSucc = aMergedToSucc.equals(d) ? e : d;
        this.kb.addPropertyValue(p, a, aMergedToSucc);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, p, aMergedToSucc));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, aMergedToNotSucc));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, e));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, e));
    }

    @org.junit.Test
    public void removeEdgeFromMergedObject() {
        this.objectProperties(p);
        this.individuals(a, b, c, d);
        this.kb.addType(a, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        this.kb.addPropertyValue(p, d, a);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(d, p, a));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(d, p, b));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(d, p, c));
        this.kb.removePropertyValue(p, d, a);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(d, p, a));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(d, p, b));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(d, p, c));
    }

    @org.junit.Test
    public void removeEdgeFromMergedSubject() {
        this.objectProperties(p);
        this.individuals(a, b, c, d);
        this.kb.addType(a, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        this.kb.addPropertyValue(p, a, d);
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, d));
        this.kb.removePropertyValue(p, a, d);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, d));
    }

    @org.junit.Test
    public void removeEdgeFromMergedSubjectObject() {
        this.objectProperties(p);
        this.individuals(a, b, c, d, e, f);
        this.kb.addType(a, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{b, c}));
        this.kb.addType(d, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{e, f}));
        this.kb.addPropertyValue(p, a, d);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, e));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, e));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, e));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, f));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, f));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, f));
        this.kb.removePropertyValue(p, a, d);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, d));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, e));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, e));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, e));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(a, p, f));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(b, p, f));
        Assert.assertFalse((boolean)this.kb.hasPropertyValue(c, p, f));
    }

    @org.junit.Test
    public void mergeManyIndividuals() {
        this.individuals(a);
        this.objectProperties(p);
        int N = 5000;
        ATermAppl[] b = new ATermAppl[N];
        ATermAppl[] c = new ATermAppl[N];
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addFunctionalProperty(p);
        this.kb.addIndividual(a);
        for (int i = 0; i < N; ++i) {
            b[i] = TermFactory.term((String)("b" + i));
            this.kb.addIndividual(b[i]);
            c[i] = TermFactory.term((String)("c" + i));
            this.kb.addIndividual(c[i]);
            if (i == 0) {
                this.kb.addPropertyValue(p, a, b[i]);
                this.kb.addPropertyValue(p, a, c[i]);
                continue;
            }
            this.kb.addPropertyValue(p, b[i - 1], b[i]);
            this.kb.addPropertyValue(p, c[i - 1], c[i]);
        }
        Assert.assertTrue((boolean)this.kb.isConsistent());
    }
}

