/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.test.WebOntTest;
import org.mindswap.pellet.test.WebOntTestCase;
import org.mindswap.pellet.utils.AlphaNumericComparator;

@RunWith(value=Parameterized.class)
public class LiebigTestSuite {
    public static String base = PelletTestSuite.base + "liebig-tests/";
    private static List TIMEOUTS = Arrays.asList("Manifest1b.rdf", "Manifest2b.rdf", "Manifest10a.rdf");
    private final WebOntTestCase test;

    @Parameterized.Parameters
    public static List<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        WebOntTest test = new WebOntTest();
        test.setAvoidFailTests(true);
        test.setBase("http://www.informatik.uni-ulm.de/ki/Liebig/reasoner-eval/", "file:" + base);
        test.setShowStats(0);
        File testDir = new File(base);
        File[] files = testDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().indexOf("Manifest") != -1;
            }
        });
        Arrays.sort(files, AlphaNumericComparator.CASE_INSENSITIVE);
        for (int j = 0; j < files.length; ++j) {
            if (TIMEOUTS.contains(files[j].getName())) continue;
            parameters.add(new Object[]{new WebOntTestCase(test, files[j], "liebig-" + files[j].getName())});
        }
        return parameters;
    }

    public LiebigTestSuite(WebOntTestCase test) {
        this.test = test;
    }

    @Test
    public void run() throws IOException {
        this.test.runTest();
    }
}

