/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.rdfxml;

import com.clarkparsia.pellint.rdfxml.OWLSyntaxChecker;
import com.clarkparsia.pellint.rdfxml.RDFLints;
import com.clarkparsia.pellint.rdfxml.RDFModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OWLSyntaxCheckerTest {
    private static final String NS = "tag:clarkparsia.com,2010:pellint:test#";
    private static final Resource C = ResourceFactory.createResource((String)"tag:clarkparsia.com,2010:pellint:test#C");
    private static final Property p = ResourceFactory.createProperty((String)"tag:clarkparsia.com,2010:pellint:test#P");
    private static final Resource a = ResourceFactory.createResource((String)"tag:clarkparsia.com,2010:pellint:test#a");
    private static final Resource b = ResourceFactory.createResource((String)"tag:clarkparsia.com,2010:pellint:test#b");
    private static final Resource anon = ResourceFactory.createResource();
    private static final Literal lit = ResourceFactory.createPlainLiteral((String)"lit");
    private RDFModel rdfModel;
    private OWLSyntaxChecker checker;

    @Before
    public void before() {
        this.rdfModel = new RDFModel();
        this.checker = new OWLSyntaxChecker();
    }

    protected void addStatement(Resource s, Property p, RDFNode o) {
        this.rdfModel.addStatement(ResourceFactory.createStatement((Resource)s, (Property)p, (RDFNode)o));
    }

    protected RDFLints validate() {
        RDFLints lints = this.checker.validate(this.rdfModel);
        return lints;
    }

    protected void assertValid() {
        Assert.assertTrue((boolean)this.validate().isEmpty());
    }

    protected void assertInvalid() {
        Assert.assertFalse((boolean)this.validate().isEmpty());
    }

    @Test
    public void testLiteralSubClassOf() {
        this.addStatement(C, RDF.type, (RDFNode)OWL.Class);
        this.addStatement(C, RDFS.subClassOf, (RDFNode)lit);
        this.assertInvalid();
    }

    @Test
    public void testLiteralSubPropertyOf() {
        this.addStatement((Resource)p, RDF.type, (RDFNode)OWL.ObjectProperty);
        this.addStatement((Resource)p, RDFS.subPropertyOf, (RDFNode)lit);
        this.assertInvalid();
    }

    @Test
    public void testLiteralEquivalentClass() {
        this.addStatement(C, RDF.type, (RDFNode)OWL.Class);
        this.addStatement(C, OWL.equivalentClass, (RDFNode)lit);
        this.assertInvalid();
    }

    @Test
    public void testRDFPlainLiteral() {
        Resource plainLiteral = ResourceFactory.createResource((String)(RDF.getURI() + "PlainLiteral"));
        this.addStatement((Resource)p, RDF.type, (RDFNode)OWL.DatatypeProperty);
        this.addStatement((Resource)p, RDFS.range, (RDFNode)plainLiteral);
        this.assertValid();
    }

    @Test
    public void testUntypedObject() {
        this.addStatement((Resource)p, RDF.type, (RDFNode)OWL.ObjectProperty);
        this.addStatement(a, RDF.type, (RDFNode)OWL.Thing);
        this.addStatement(a, p, (RDFNode)b);
        this.assertInvalid();
    }

    @Test
    public void testUntypedSubject() {
        this.addStatement((Resource)p, RDF.type, (RDFNode)OWL.ObjectProperty);
        this.addStatement(b, RDF.type, (RDFNode)OWL.Thing);
        this.addStatement(a, p, (RDFNode)b);
        this.assertInvalid();
    }

    @Test
    public void testUntypedSubjectWithLiteralObject() {
        this.addStatement((Resource)p, RDF.type, (RDFNode)OWL.DatatypeProperty);
        this.addStatement(a, p, (RDFNode)lit);
        this.assertInvalid();
    }

    @Test
    public void testLiteralWithObjectProperty() {
        this.addStatement((Resource)p, RDF.type, (RDFNode)OWL.ObjectProperty);
        this.addStatement(a, RDF.type, (RDFNode)OWL.Thing);
        this.addStatement(a, p, (RDFNode)lit);
        this.assertInvalid();
    }

    @Test
    public void testIndividualsWithDataProperty() {
        this.addStatement((Resource)p, RDF.type, (RDFNode)OWL.DatatypeProperty);
        this.addStatement(a, RDF.type, (RDFNode)OWL.Thing);
        this.addStatement(b, RDF.type, (RDFNode)OWL.Thing);
        this.addStatement(a, p, (RDFNode)b);
        this.assertInvalid();
    }

    @Test
    public void testBnodeWithDataProperty() {
        this.addStatement((Resource)p, RDF.type, (RDFNode)OWL.DatatypeProperty);
        this.addStatement(a, RDF.type, (RDFNode)OWL.Thing);
        this.addStatement(anon, RDF.type, (RDFNode)OWL.Thing);
        this.addStatement(a, p, (RDFNode)anon);
        this.assertInvalid();
    }

    @Test
    public void testClassIndividualPunning() {
        this.addStatement(a, RDF.type, (RDFNode)OWL.Class);
        this.addStatement(a, RDF.type, (RDFNode)OWL.Thing);
        this.assertInvalid();
        this.checker.setExcludeValidPunnings(true);
        this.assertValid();
    }

    @Test
    public void testClassPropertyPunning() {
        this.addStatement(a, RDF.type, (RDFNode)OWL.Class);
        this.addStatement(a, RDF.type, (RDFNode)OWL.ObjectProperty);
        this.assertInvalid();
        this.checker.setExcludeValidPunnings(true);
        this.assertValid();
    }

    @Test
    public void testClassDatatypePunning() {
        this.addStatement(a, RDF.type, (RDFNode)OWL.Class);
        this.addStatement(a, RDF.type, (RDFNode)RDFS.Datatype);
        this.assertInvalid();
        this.checker.setExcludeValidPunnings(true);
        this.assertInvalid();
    }

    @Test
    public void testObjectDataPropertyPunning() {
        this.addStatement((Resource)p, RDF.type, (RDFNode)OWL.ObjectProperty);
        this.addStatement((Resource)p, RDF.type, (RDFNode)OWL.DatatypeProperty);
        this.assertInvalid();
        this.checker.setExcludeValidPunnings(true);
        this.assertInvalid();
    }

    @Test
    public void testObjectAnnotationPropertyPunning() {
        this.addStatement((Resource)p, RDF.type, (RDFNode)OWL.ObjectProperty);
        this.addStatement((Resource)p, RDF.type, (RDFNode)OWL.AnnotationProperty);
        this.assertInvalid();
        this.checker.setExcludeValidPunnings(true);
        this.assertInvalid();
    }

    @Test
    public void testDataAnnotationPropertyPunning() {
        this.addStatement((Resource)p, RDF.type, (RDFNode)OWL.DatatypeProperty);
        this.addStatement((Resource)p, RDF.type, (RDFNode)OWL.AnnotationProperty);
        this.assertInvalid();
        this.checker.setExcludeValidPunnings(true);
        this.assertInvalid();
    }
}

