/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern.axiom;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellint.lintpattern.axiom.LargeCardinalityPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.test.PellintTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class LargeCardinalityPatternTest
extends PellintTestCase {
    private LargeCardinalityPattern m_Pattern;

    @Override
    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Pattern = new LargeCardinalityPattern();
    }

    @Test
    public void testNone() throws OWLException {
        this.m_Pattern.setMaxAllowed(3);
        OWLObjectMaxCardinality maxCard = OWL.max((OWLObjectPropertyExpression)this.m_Pro[0], (int)2);
        OWLSubClassOfAxiom axiom = OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)maxCard);
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        Assert.assertFalse((boolean)this.m_Pattern.isFixable());
    }

    @Test
    public void testOneMax() throws OWLException {
        this.m_Pattern.setMaxAllowed(2);
        OWLObjectMaxCardinality maxCard = OWL.max((OWLObjectPropertyExpression)this.m_Pro[0], (int)3);
        OWLDisjointClassesAxiom axiom = OWL.disjointClasses((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)maxCard);
        Lint lint = this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom);
        Assert.assertNotNull((Object)lint);
        Assert.assertSame((Object)this.m_Pattern, (Object)lint.getPattern());
        Assert.assertEquals((long)1L, (long)lint.getParticipatingAxioms().size());
        Assert.assertNull((Object)lint.getLintFixer());
        Assert.assertEquals((double)3.0, (double)lint.getSeverity().doubleValue(), (double)1.0E-6);
        Assert.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
    }

    @Test
    public void testTwoMin() throws OWLException {
        this.m_Pattern.setMaxAllowed(2);
        OWLObjectMinCardinality minCard1 = OWL.min((OWLObjectPropertyExpression)this.m_Pro[0], (int)3, (OWLClassExpression)this.m_Cls[0]);
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLClassExpression)this.m_Cls[1], (OWLClassExpression)minCard1);
        Assert.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        OWLObjectMinCardinality minCard2 = OWL.min((OWLObjectPropertyExpression)this.m_Pro[0], (int)100, (OWLClassExpression)this.m_Cls[2]);
        axiom = OWL.subClassOf((OWLClassExpression)minCard2, (OWLClassExpression)this.m_Cls[3]);
        Assert.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }

    @Test
    public void testNested() throws OWLException {
        this.m_Pattern.setMaxAllowed(2);
        OWLClassExpression exactCard = OWL.exactly((OWLObjectProperty)this.m_Pro[0], (int)3, (OWLClassExpression)this.m_Cls[0]);
        OWLObjectUnionOf and = OWL.or((OWLClassExpression[])new OWLClassExpression[]{this.m_Cls[1], exactCard});
        OWLSubClassOfAxiom axiom = OWL.subClassOf((OWLClassExpression)and, (OWLClassExpression)this.m_Cls[2]);
        Assert.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        OWLObjectMinCardinality minCard = OWL.min((OWLObjectPropertyExpression)this.m_Pro[0], (int)3, (OWLClassExpression)this.m_Cls[0]);
        OWLObjectUnionOf union = OWL.or((OWLClassExpression[])new OWLClassExpression[]{this.m_Cls[1], minCard});
        axiom = OWL.subClassOf((OWLClassExpression)union, (OWLClassExpression)this.m_Cls[2]);
        Assert.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        OWLObjectMaxCardinality maxCard1 = OWL.max((OWLObjectPropertyExpression)this.m_Pro[0], (int)3, (OWLClassExpression)this.m_Cls[1]);
        OWLObjectIntersectionOf and2 = OWL.and((OWLClassExpression[])new OWLClassExpression[]{this.m_Cls[2], maxCard1});
        axiom = OWL.subClassOf((OWLClassExpression)and2, (OWLClassExpression)this.m_Cls[3]);
        Assert.assertNotNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        OWLObjectMaxCardinality maxCard2 = OWL.max((OWLObjectPropertyExpression)this.m_Pro[0], (int)2, (OWLClassExpression)this.m_Cls[2]);
        axiom = OWL.subClassOf((OWLClassExpression)this.m_Cls[4], (OWLClassExpression)maxCard2);
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }
}

