/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern.axiom;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellint.lintpattern.axiom.EquivalentToComplementPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFixer;
import com.clarkparsia.pellint.test.PellintTestCase;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class EquivalentToComplementPatternTest
extends PellintTestCase {
    private EquivalentToComplementPattern m_Pattern;

    @Override
    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Pattern = new EquivalentToComplementPattern();
    }

    @Test
    public void testNone() throws OWLException {
        Assert.assertTrue((boolean)this.m_Pattern.isFixable());
        OWLObjectComplementOf comp = OWL.not((OWLClassExpression)this.m_Cls[0]);
        OWLSubClassOfAxiom axiom = OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)comp);
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        axiom = OWL.equivalentClasses((OWLClassExpression)this.m_P0AllC0, (OWLClassExpression)comp);
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        axiom = OWL.equivalentClasses((Set)CollectionUtil.asSet((Object[])new OWLClassExpression[]{this.m_Cls[0], this.m_Cls[1], comp}));
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
        axiom = OWL.equivalentClasses((OWLClassExpression)OWL.Nothing, (OWLClassExpression)OWL.Thing);
        Assert.assertNull((Object)this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom));
    }

    @Test
    public void testComplementOfItself() throws OWLException {
        OWLObjectComplementOf comp = OWL.not((OWLClassExpression)this.m_Cls[0]);
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)comp);
        Lint lint = this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom);
        Assert.assertNotNull((Object)lint);
        Assert.assertTrue((boolean)lint.getParticipatingClasses().contains(this.m_Cls[0]));
        LintFixer fixer = lint.getLintFixer();
        Assert.assertTrue((boolean)fixer.getAxiomsToRemove().contains(axiom));
        OWLSubClassOfAxiom expectedAxiom = OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)comp);
        Assert.assertTrue((boolean)fixer.getAxiomsToAdd().contains(expectedAxiom));
        Assert.assertNull((Object)lint.getSeverity());
        Assert.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
    }

    @Test
    public void testComplementOfOthers() throws OWLException {
        OWLObjectComplementOf comp = OWL.not((OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{this.m_Cls[1], this.m_Cls[2]}));
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)comp);
        Lint lint = this.m_Pattern.match(this.m_Ontology, (OWLAxiom)axiom);
        Assert.assertNotNull((Object)lint);
        Assert.assertTrue((boolean)lint.getParticipatingClasses().contains(this.m_Cls[0]));
        LintFixer fixer = lint.getLintFixer();
        Assert.assertTrue((boolean)fixer.getAxiomsToRemove().contains(axiom));
        OWLSubClassOfAxiom expectedAxiom = OWL.subClassOf((OWLClassExpression)this.m_Cls[0], (OWLClassExpression)comp);
        Assert.assertTrue((boolean)fixer.getAxiomsToAdd().contains(expectedAxiom));
    }
}

