/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.QuerySolutionMap;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mindswap.pellet.jena.PelletReasonerFactory;

@RunWith(value=Parameterized.class)
public class TestParameterizedQuery {
    private static final String NS = "http://example.org#";
    private static final String PREFIX = "PREFIX : <http://example.org#>";
    private static Dataset dataset;
    private final SparqlDLExecutionFactory.QueryEngineType queryEngine;
    private final Query query;
    private final QuerySolution initialBinding;
    private final QuerySolution expected;

    private static QuerySolutionMap binding(String var, RDFNode value) {
        QuerySolutionMap b = new QuerySolutionMap();
        b.add(var, value);
        return b;
    }

    private static QuerySolutionMap binding(String var1, RDFNode value1, String var2, RDFNode value2) {
        QuerySolutionMap b = new QuerySolutionMap();
        b.add(var1, value1);
        b.add(var2, value2);
        return b;
    }

    @Parameterized.Parameters
    public static List<Object[]> getParameters() {
        Property pred = ResourceFactory.createProperty((String)"http://example.org#p");
        Resource x1 = ResourceFactory.createResource((String)"http://example.org#x1");
        Resource y1 = ResourceFactory.createResource((String)"http://example.org#y1");
        Resource x2 = ResourceFactory.createResource((String)"http://example.org#x2");
        Resource y2 = ResourceFactory.createResource((String)"http://example.org#y2");
        OntModel m = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        m.add(x1, pred, (RDFNode)y1);
        m.add(x2, pred, (RDFNode)y2);
        dataset = DatasetFactory.create((Model)m);
        Query q1 = QueryFactory.create((String)"PREFIX : <http://example.org#>SELECT ?x WHERE { ?x :p ?y }");
        Query q2 = QueryFactory.create((String)"PREFIX : <http://example.org#>SELECT ?x ?y WHERE { ?x :p ?y }");
        Query q3 = QueryFactory.create((String)"PREFIX : <http://example.org#>SELECT * WHERE { ?x :p ?y }");
        Query q4 = QueryFactory.create((String)"PREFIX : <http://example.org#>SELECT * WHERE { :x1 :p ?y }");
        QuerySolutionMap b1 = TestParameterizedQuery.binding("y", (RDFNode)y1);
        QuerySolutionMap b2 = TestParameterizedQuery.binding("x", (RDFNode)x1);
        QuerySolutionMap b3 = TestParameterizedQuery.binding("y", (RDFNode)y1, "x", (RDFNode)x1);
        Object b4 = null;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SparqlDLExecutionFactory.QueryEngineType qe : SparqlDLExecutionFactory.QueryEngineType.values()) {
            params.add(new Object[]{qe, q1, b1, b2});
            params.add(new Object[]{qe, q2, b2, b3});
            params.add(new Object[]{qe, q3, b1, b3});
            params.add(new Object[]{qe, q4, b4, b1});
        }
        return params;
    }

    public TestParameterizedQuery(SparqlDLExecutionFactory.QueryEngineType queryEngine, Query query, QuerySolutionMap initialBinding, QuerySolutionMap expectedResults) {
        this.queryEngine = queryEngine;
        this.query = query;
        this.initialBinding = initialBinding;
        this.expected = expectedResults;
    }

    @Test
    public void test() {
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)this.query, (Dataset)dataset, (QuerySolution)this.initialBinding, (SparqlDLExecutionFactory.QueryEngineType)this.queryEngine);
        ResultSet rs = qe.execSelect();
        if (!rs.hasNext()) {
            Assert.assertTrue((String)"No results found", (boolean)rs.hasNext());
        }
        QuerySolution computed = rs.nextSolution();
        Iterator i = rs.getResultVars().iterator();
        while (i.hasNext()) {
            String var = i.next().toString();
            Assert.assertEquals((String)("Different result for " + var), (Object)this.expected.get(var), (Object)computed.get(var));
        }
        Assert.assertFalse((String)"Extra results found", (boolean)rs.hasNext());
    }
}

