/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.clarkparsia.pellet.test.query.ARQSparqlDawgTester;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.FileManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.utils.URIUtils;

public class PelletSparqlDawgTester
extends ARQSparqlDawgTester {
    public static boolean CLASSIFY_KB_IN_ADVANCE = false;
    private List<String> avoidList = Arrays.asList("open-eq-01", "open-eq-02", "open-eq-05", "open-eq-07", "open-eq-08", "open-eq-09", "open-eq-10", "open-eq-11", "open-eq-12", "term-3", "construct-1", "construct-3", "construct-4", "construct-5", "dawg-sort-builtin", "dawg-sort-function", "list-1", "list-2", "list-3", "list-4", "distinct-2", "no-distinct-2", "join-combo-1", "join-combo-2", "dawg-optional-filter-005-not-simplified", "date-2", "date-3", "unplus-1", "open-eq-03", "var-1", "var-2", "open-eq-04", "nested-opt-1", "nested-opt-2", "opt-filter-1", "opt-filter-2", "filter-scope-1", "dawg-optional-complex-2", "dawg-optional-filter-001", "dawg-optional-filter-002", "dawg-optional-filter-003", "dawg-optional-filter-005-simplified", "dawg-graph-01", "dawg-graph-03", "dawg-graph-05", "dawg-graph-06", "dawg-graph-07", "dawg-graph-08", "dawg-graph-11", "dawg-dataset-01", "dawg-dataset-03", "dawg-dataset-05", "dawg-dataset-06", "dawg-dataset-07", "dawg-dataset-08", "dawg-dataset-11", "dawg-dataset-12", "dawg-dataset-12b", "no-distinct-1", "distinct-1", "dawg-sort-4", "dawg-sort-5", "dawg-sort-7", "dawg-sort-9", "dawg-sort-10", "limit-1", "limit-2", "limit-4", "offset-1", "offset-2", "offset-4", "slice-1", "slice-2", "slice-4", "slice-5");
    protected SparqlDLExecutionFactory.QueryEngineType queryEngineType;
    protected boolean handleVariableSPO = true;

    public PelletSparqlDawgTester(SparqlDLExecutionFactory.QueryEngineType queryEngineType, boolean handleVariableSPO) {
        this.queryEngineType = queryEngineType;
        this.handleVariableSPO = handleVariableSPO;
    }

    @Override
    protected Dataset createDataset() {
        boolean useQueryGraphs = !this.query.getGraphURIs().isEmpty() || !this.query.getNamedGraphURIs().isEmpty();
        Collection graphURIs = useQueryGraphs ? this.query.getGraphURIs() : this.graphURIs;
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        for (String dataURI : graphURIs) {
            FileManager.get().readModel((Model)model, dataURI);
        }
        model.prepare();
        if (CLASSIFY_KB_IN_ADVANCE) {
            ((PelletInfGraph)model.getGraph()).getKB().classify();
        }
        Dataset dataset = DatasetFactory.create((Model)model);
        Collection namedGraphURIs = useQueryGraphs ? this.query.getNamedGraphURIs() : this.namedGraphURIs;
        for (String graphURI : namedGraphURIs) {
            model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
            FileManager.get().readModel((Model)model, graphURI);
            dataset.addNamedModel(graphURI, (Model)model);
        }
        return dataset;
    }

    @Override
    protected QueryExecution createQueryExecution() {
        return SparqlDLExecutionFactory.create((Query)this.query, (Dataset)this.createDataset(), null, (SparqlDLExecutionFactory.QueryEngineType)this.queryEngineType, (boolean)this.handleVariableSPO);
    }

    @Override
    public boolean isApplicable(String uri) {
        return !this.avoidList.contains(URIUtils.getLocalName((String)uri));
    }

    @Override
    public String getName() {
        return this.queryEngineType.toString();
    }
}

