/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.owlapi;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import com.clarkparsia.pellet.test.owlapi.AbstractOWLAPITests;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.SetUtils;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;

public class OWLPrimerTests
extends AbstractOWLAPITests {
    protected static final String NS = "http://example.com/owl/families/";
    protected static final String NS2 = "http://example.org/otherOntologies/families/";
    protected static final OWLNamedIndividual John = OWL.Individual((String)"http://example.com/owl/families/John");
    protected static final OWLNamedIndividual Jack = OWL.Individual((String)"http://example.com/owl/families/Jack");
    protected static final OWLNamedIndividual Bill = OWL.Individual((String)"http://example.com/owl/families/Bill");
    protected static final OWLNamedIndividual Mary = OWL.Individual((String)"http://example.com/owl/families/Mary");
    protected static final OWLNamedIndividual MaryBrown = OWL.Individual((String)"http://example.org/otherOntologies/families/MaryBrown");
    protected static final OWLObjectProperty hasParent = OWL.ObjectProperty((String)"http://example.com/owl/families/hasParent");
    protected static final OWLObjectProperty hasSpouse = OWL.ObjectProperty((String)"http://example.com/owl/families/hasSpouse");
    protected static final OWLObjectProperty hasWife = OWL.ObjectProperty((String)"http://example.com/owl/families/hasWife");
    protected static final OWLObjectProperty hasChild = OWL.ObjectProperty((String)"http://example.com/owl/families/hasChild");
    protected static final OWLObjectProperty child = OWL.ObjectProperty((String)"http://example.org/otherOntologies/families/child");
    protected static final OWLObjectProperty parentOf = OWL.ObjectProperty((String)"http://example.org/otherOntologies/families/parentOf");

    public static Test suite() {
        return new JUnit4TestAdapter(OWLPrimerTests.class);
    }

    @Override
    public void resetOntologyManager() {
        super.resetOntologyManager();
        this.ontology = OntologyUtils.loadOntology((String)("file:" + PelletTestSuite.base + "modularity/OWL2Primer.owl"));
        this.reasoner = PelletReasonerFactory.getInstance().createReasoner(this.ontology);
    }

    protected <T> Set<T> node(T ... inds) {
        return SetUtils.create((Object[])inds);
    }

    protected Set<OWLObjectPropertyExpression> nodeOP(OWLObjectPropertyExpression ... inds) {
        return SetUtils.create((Object[])inds);
    }

    protected <E extends OWLObject> void assertEquals(NodeSet<E> actual, Set<E> ... expected) {
        Set expectedSet = SetUtils.create((Object[])expected);
        for (Node node : actual.getNodes()) {
            Assert.assertTrue((String)("Unexpected value: " + node.getEntities()), (boolean)expectedSet.remove(node.getEntities()));
        }
        Assert.assertTrue((String)("Missing values: " + expectedSet), (boolean)expectedSet.isEmpty());
    }

    @org.junit.Test
    public void testJackDifferents() {
        this.assertEquals(this.reasoner.getDifferentIndividuals(John), this.node(Jack), this.node(Bill), this.node(Mary, MaryBrown));
    }

    @org.junit.Test
    public void testHasParentDisjoints() {
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.disjointProperties((OWLObjectPropertyExpression)hasParent, (OWLObjectPropertyExpression)hasSpouse)));
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.disjointProperties((OWLObjectPropertyExpression)hasParent, (OWLObjectPropertyExpression)hasWife)));
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.disjointProperties((OWLObjectPropertyExpression)hasParent, (OWLObjectPropertyExpression)child)));
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.disjointProperties((OWLObjectPropertyExpression)hasParent, (OWLObjectPropertyExpression)hasChild)));
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.disjointProperties((OWLObjectPropertyExpression)hasParent, (OWLObjectPropertyExpression)OWL.bottomObjectProperty)));
        this.assertEquals(this.reasoner.getDisjointObjectProperties((OWLObjectPropertyExpression)hasParent), this.nodeOP(new OWLObjectPropertyExpression[]{hasSpouse}), this.nodeOP(new OWLObjectPropertyExpression[]{OWL.bottomObjectProperty}), this.nodeOP(new OWLObjectPropertyExpression[]{hasWife}), this.nodeOP(new OWLObjectPropertyExpression[]{hasChild, child}));
    }
}

