/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.classification;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import com.clarkparsia.pellet.test.classification.AbstractClassificationTest;
import java.util.ArrayList;
import org.junit.Assert;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class OWLAPIClassificationTest
extends AbstractClassificationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testClassification(String inputOnt, String classifiedOnt) throws OWLOntologyCreationException {
        OWLOntology premise = OWL.manager.loadOntology(IRI.create((String)inputOnt));
        OWLOntology conclusion = OWL.manager.loadOntology(IRI.create((String)classifiedOnt));
        try {
            boolean entailed;
            PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(premise);
            reasoner.getKB().classify();
            ArrayList<OWLSubClassOfAxiom> nonEntailments = new ArrayList<OWLSubClassOfAxiom>();
            for (OWLSubClassOfAxiom axiom : conclusion.getAxioms(AxiomType.SUBCLASS_OF)) {
                entailed = reasoner.getSubClasses(axiom.getSuperClass(), true).containsEntity((OWLObject)((OWLClass)axiom.getSubClass()));
                if (entailed) continue;
                if (AbstractClassificationTest.FAIL_AT_FIRST_ERROR) {
                    Assert.fail((String)("Not entailed: " + axiom));
                    continue;
                }
                nonEntailments.add(axiom);
            }
            for (OWLSubClassOfAxiom axiom : conclusion.getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
                entailed = reasoner.isEntailed((OWLAxiom)axiom);
                if (entailed) continue;
                if (AbstractClassificationTest.FAIL_AT_FIRST_ERROR) {
                    Assert.fail((String)("Not entailed: " + axiom));
                    continue;
                }
                nonEntailments.add(axiom);
            }
            for (OWLSubClassOfAxiom axiom : conclusion.getAxioms(AxiomType.CLASS_ASSERTION)) {
                entailed = reasoner.getInstances(axiom.getClassExpression(), true).containsEntity((OWLObject)((OWLNamedIndividual)axiom.getIndividual()));
                if (entailed) continue;
                if (AbstractClassificationTest.FAIL_AT_FIRST_ERROR) {
                    Assert.fail((String)("Not entailed: " + axiom));
                    continue;
                }
                nonEntailments.add(axiom);
            }
            Assert.assertTrue((String)(nonEntailments.size() + " " + ((Object)nonEntailments).toString()), (boolean)nonEntailments.isEmpty());
        }
        finally {
            OWL.manager.removeOntology(premise);
            OWL.manager.removeOntology(conclusion);
        }
    }
}

