/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.test;

import com.clarkparsia.pellet.datatypes.IntervalRelations;
import com.clarkparsia.pellet.datatypes.types.real.ContinuousRealInterval;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;

public class ContinuousRealIntervalTests {
    public static ContinuousRealInterval interval(Double l, Double u, boolean il, boolean iu) {
        return new ContinuousRealInterval((Number)(l == null ? null : BigDecimal.valueOf(l)), (Number)(u == null ? null : BigDecimal.valueOf(u)), il, iu);
    }

    @Test
    public void exclusiveEndpoints() {
        ContinuousRealInterval interval = ContinuousRealIntervalTests.interval(-1.3, 2.5, false, false);
        Assert.assertFalse((boolean)interval.contains((Number)BigDecimal.valueOf(-1.3)));
        Assert.assertFalse((boolean)interval.contains((Number)BigDecimal.valueOf(2.5)));
        Assert.assertTrue((boolean)interval.contains((Number)0));
    }

    @Test
    public void inclusiveEndpoints() {
        ContinuousRealInterval interval = ContinuousRealIntervalTests.interval(-1.3, 2.5, true, true);
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(-1.3)));
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(2.5)));
        Assert.assertTrue((boolean)interval.contains((Number)0));
    }

    @Test
    public void intersectionEmpty() {
        ContinuousRealInterval a = ContinuousRealIntervalTests.interval(null, 0.0, false, true);
        ContinuousRealInterval b = ContinuousRealIntervalTests.interval(1.0, null, true, false);
        Assert.assertNull((Object)a.intersection(b));
        Assert.assertNull((Object)b.intersection(a));
        Assert.assertEquals((Object)IntervalRelations.PRECEDES, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.PRECEDED_BY, (Object)b.compare(a));
    }

    @Test
    public void intersectionMeets() {
        ContinuousRealInterval a = ContinuousRealIntervalTests.interval(null, 2.1, false, false);
        ContinuousRealInterval b = ContinuousRealIntervalTests.interval(2.1, null, true, false);
        Assert.assertNull((Object)a.intersection(b));
        Assert.assertNull((Object)b.intersection(a));
        Assert.assertEquals((Object)IntervalRelations.MEETS, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.MET_BY, (Object)b.compare(a));
    }

    @Test
    public void intersectionOverlap1() {
        ContinuousRealInterval a = ContinuousRealIntervalTests.interval(null, 0.51, false, false);
        ContinuousRealInterval b = ContinuousRealIntervalTests.interval(0.49, null, false, false);
        ContinuousRealInterval expected = ContinuousRealIntervalTests.interval(0.49, 0.51, false, false);
        Assert.assertEquals((Object)expected, (Object)a.intersection(b));
        Assert.assertEquals((Object)expected, (Object)b.intersection(a));
        Assert.assertTrue((boolean)a.intersection(b).contains((Number)BigDecimal.valueOf(0.5)));
        Assert.assertTrue((boolean)b.intersection(a).contains((Number)BigDecimal.valueOf(0.5)));
        Assert.assertFalse((boolean)a.intersection(b).contains((Number)BigDecimal.valueOf(0.49)));
        Assert.assertFalse((boolean)b.intersection(a).contains((Number)BigDecimal.valueOf(0.49)));
        Assert.assertFalse((boolean)a.intersection(b).contains((Number)BigDecimal.valueOf(0.51)));
        Assert.assertFalse((boolean)b.intersection(a).contains((Number)BigDecimal.valueOf(0.51)));
        Assert.assertEquals((Object)IntervalRelations.OVERLAPS, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.OVERLAPPED_BY, (Object)b.compare(a));
    }

    @Test
    public void intersectionOverlap2() {
        ContinuousRealInterval a = ContinuousRealIntervalTests.interval(null, 0.51, false, true);
        ContinuousRealInterval b = ContinuousRealIntervalTests.interval(0.49, null, true, false);
        ContinuousRealInterval expected = ContinuousRealIntervalTests.interval(0.49, 0.51, true, true);
        Assert.assertEquals((Object)expected, (Object)a.intersection(b));
        Assert.assertEquals((Object)expected, (Object)b.intersection(a));
        Assert.assertTrue((boolean)a.intersection(b).contains((Number)BigDecimal.valueOf(0.5)));
        Assert.assertTrue((boolean)b.intersection(a).contains((Number)BigDecimal.valueOf(0.5)));
        Assert.assertTrue((boolean)a.intersection(b).contains((Number)BigDecimal.valueOf(0.49)));
        Assert.assertTrue((boolean)b.intersection(a).contains((Number)BigDecimal.valueOf(0.49)));
        Assert.assertTrue((boolean)a.intersection(b).contains((Number)BigDecimal.valueOf(0.51)));
        Assert.assertTrue((boolean)b.intersection(a).contains((Number)BigDecimal.valueOf(0.51)));
        Assert.assertEquals((Object)IntervalRelations.OVERLAPS, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.OVERLAPPED_BY, (Object)b.compare(a));
    }

    @Test
    public void intersectionPoint() {
        ContinuousRealInterval a = ContinuousRealIntervalTests.interval(null, 2.1, false, true);
        ContinuousRealInterval b = ContinuousRealIntervalTests.interval(2.1, null, true, false);
        ContinuousRealInterval expected = new ContinuousRealInterval((Number)BigDecimal.valueOf(2.1));
        Assert.assertEquals((Object)expected, (Object)a.intersection(b));
        Assert.assertEquals((Object)expected, (Object)b.intersection(a));
        Assert.assertTrue((boolean)a.intersection(b).isPoint());
        Assert.assertTrue((boolean)b.intersection(a).isPoint());
        Assert.assertTrue((boolean)a.intersection(b).contains((Number)BigDecimal.valueOf(2.1)));
        Assert.assertTrue((boolean)b.intersection(a).contains((Number)BigDecimal.valueOf(2.1)));
        Assert.assertEquals((Object)IntervalRelations.OVERLAPS, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.OVERLAPPED_BY, (Object)b.compare(a));
    }

    @Test
    public void intersectionStarts1() {
        ContinuousRealInterval a = ContinuousRealIntervalTests.interval(2.1, 3.1, true, true);
        ContinuousRealInterval b = ContinuousRealIntervalTests.interval(2.1, null, true, false);
        Assert.assertEquals((Object)a, (Object)a.intersection(b));
        Assert.assertEquals((Object)a, (Object)b.intersection(a));
        Assert.assertEquals((Object)IntervalRelations.STARTS, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.STARTED_BY, (Object)b.compare(a));
    }

    @Test
    public void intersectionStarts2() {
        ContinuousRealInterval a = ContinuousRealIntervalTests.interval(2.1, 3.1, false, true);
        ContinuousRealInterval b = ContinuousRealIntervalTests.interval(2.1, null, false, false);
        Assert.assertEquals((Object)a, (Object)a.intersection(b));
        Assert.assertEquals((Object)a, (Object)b.intersection(a));
        Assert.assertEquals((Object)IntervalRelations.STARTS, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.STARTED_BY, (Object)b.compare(a));
    }

    @Test
    public void intersectionStarts3() {
        ContinuousRealInterval a = ContinuousRealIntervalTests.interval(2.1, 3.1, false, true);
        ContinuousRealInterval b = ContinuousRealIntervalTests.interval(2.1, null, true, false);
        Assert.assertEquals((Object)a, (Object)a.intersection(b));
        Assert.assertEquals((Object)a, (Object)b.intersection(a));
        Assert.assertEquals((Object)IntervalRelations.DURING, (Object)a.compare(b));
        Assert.assertEquals((Object)IntervalRelations.CONTAINS, (Object)b.compare(a));
    }

    @Test
    public void isPointFalse() {
        ContinuousRealInterval a = ContinuousRealIntervalTests.interval(0.1, 0.2, true, true);
        Assert.assertFalse((boolean)a.isPoint());
    }

    @Test
    public void isPointTrue() {
        ContinuousRealInterval a = new ContinuousRealInterval((Number)BigDecimal.valueOf(0.1));
        Assert.assertTrue((boolean)a.isPoint());
        ContinuousRealInterval b = ContinuousRealIntervalTests.interval(0.1, 0.1, true, true);
        Assert.assertTrue((boolean)b.isPoint());
        Assert.assertEquals((Object)a, (Object)b);
    }

    @Test
    public void unboundContainsAll() {
        ContinuousRealInterval interval = new ContinuousRealInterval(null, null, false, false);
        Assert.assertFalse((boolean)interval.boundLower());
        Assert.assertFalse((boolean)interval.boundUpper());
        Assert.assertFalse((boolean)interval.isPoint());
        Assert.assertTrue((boolean)interval.contains((Number)-1));
        Assert.assertTrue((boolean)interval.contains((Number)0));
        Assert.assertTrue((boolean)interval.contains((Number)1));
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(-0.31)));
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(0.13)));
        Assert.assertTrue((boolean)interval.contains((Number)BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(Long.MAX_VALUE)).add(BigDecimal.valueOf(0.123))));
    }
}

