/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.test.AbstractModularityTest;
import com.clarkparsia.modularity.test.TestUtils;
import com.clarkparsia.owlapiv3.OWL;
import java.util.Set;
import org.junit.Test;
import org.mindswap.pellet.utils.MultiValueMap;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public abstract class SimpleModularityTest
extends AbstractModularityTest {
    private MultiValueMap<OWLEntity, OWLEntity> modules;

    @Override
    public abstract ModuleExtractor createModuleExtractor();

    private void extractModules(OWLAxiom[] axioms) throws OWLException {
        this.createOntology(axioms);
        this.modExtractor.addOntology(this.ontology);
        this.modules = this.modExtractor.extractModules();
    }

    private void testModule(OWLEntity entity, OWLEntity ... expectedModule) {
        OWLEntity[] computedModule = ((Set)this.modules.get((Object)entity)).toArray(new OWLEntity[0]);
        String msg = "Extractor " + this.modExtractor.getClass().getSimpleName() + " failed for " + entity;
        TestUtils.assertToStringEquals(msg, expectedModule, computedModule);
    }

    @Test
    public void intersectionTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)OWL.and((OWLClassExpression[])new OWLClassExpression[]{this.B, this.C}))};
        this.extractModules(axioms);
        this.testModule((OWLEntity)this.A, new OWLEntity[]{this.A, this.B, this.C});
        this.testModule((OWLEntity)this.B, new OWLEntity[]{this.B});
        this.testModule((OWLEntity)this.C, new OWLEntity[]{this.C});
    }

    @Test
    public void unionTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{this.B, this.C}))};
        this.extractModules(axioms);
        this.testModule((OWLEntity)this.A, new OWLEntity[]{this.A, this.B, this.C});
        this.testModule((OWLEntity)this.B, new OWLEntity[]{this.A, this.B, this.C});
        this.testModule((OWLEntity)this.C, new OWLEntity[]{this.A, this.B, this.C});
    }

    @Test
    public void nestedUnionTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)OWL.and((OWLClassExpression[])new OWLClassExpression[]{this.B, OWL.or((OWLClassExpression[])new OWLClassExpression[]{this.C, this.D})})), OWL.equivalentClasses((OWLClassExpression)this.E, (OWLClassExpression)OWL.and((OWLClassExpression[])new OWLClassExpression[]{this.B, this.C}))};
        this.extractModules(axioms);
        this.testModule((OWLEntity)this.A, new OWLEntity[]{this.A, this.B, this.C, this.D, this.E});
        this.testModule((OWLEntity)this.B, new OWLEntity[]{this.B});
        this.testModule((OWLEntity)this.C, new OWLEntity[]{this.C});
        this.testModule((OWLEntity)this.D, new OWLEntity[]{this.D});
        this.testModule((OWLEntity)this.E, new OWLEntity[]{this.A, this.B, this.C, this.D, this.E});
    }

    @Test
    public void someValuesTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.B))};
        this.extractModules(axioms);
        this.testModule((OWLEntity)this.A, new OWLEntity[]{this.A, this.p, this.B});
        this.testModule((OWLEntity)this.B, new OWLEntity[]{this.B});
    }

    @Test
    public void allValuesTest() throws OWLException {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)OWL.all((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.B))};
        this.extractModules(axioms);
        this.testModule((OWLEntity)this.A, new OWLEntity[]{this.A, this.p, this.B});
        this.testModule((OWLEntity)this.B, new OWLEntity[]{this.A, this.p, this.B});
    }
}

