/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.AxiomBasedModuleExtractor;
import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.io.IncrementalClassifierPersistence;
import com.clarkparsia.modularity.test.TestUtils;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.test.PelletTestSuite;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class PersistenceRealizationTest {
    public static final String base = PelletTestSuite.base + "modularity/";
    private static final String TEST_FILE = "test-persistence-realization.zip";

    public ModuleExtractor createModuleExtractor() {
        return new AxiomBasedModuleExtractor();
    }

    public void testFile(String fileName) throws IOException {
        String common = "file:" + base + fileName;
        this.testRealization(common + ".owl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRealization(String inputOnt) throws IOException {
        File testFile = new File(TEST_FILE);
        OWLOntology ontology = OntologyUtils.loadOntology((String)inputOnt);
        try {
            PelletReasoner unified = PelletReasonerFactory.getInstance().createReasoner(ontology);
            ModuleExtractor moduleExtractor = this.createModuleExtractor();
            IncrementalClassifier modular = new IncrementalClassifier(unified, moduleExtractor);
            modular.classify();
            Assert.assertFalse((boolean)modular.isRealized());
            FileOutputStream fos = new FileOutputStream(testFile);
            IncrementalClassifierPersistence.save((IncrementalClassifier)modular, (OutputStream)fos);
            fos.close();
            FileInputStream fis = new FileInputStream(testFile);
            IncrementalClassifier modular2 = IncrementalClassifierPersistence.load((InputStream)fis);
            fis.close();
            Assert.assertTrue((boolean)testFile.delete());
            Assert.assertFalse((boolean)modular.isRealized());
            TestUtils.assertInstancesEquals((OWLReasoner)unified, (OWLReasoner)modular2);
            TestUtils.assertTypesEquals((OWLReasoner)unified, (OWLReasoner)modular2);
            Assert.assertTrue((boolean)modular2.isRealized());
            fos = new FileOutputStream(testFile);
            IncrementalClassifierPersistence.save((IncrementalClassifier)modular2, (OutputStream)fos);
            fos.close();
            fis = new FileInputStream(testFile);
            IncrementalClassifier modular3 = IncrementalClassifierPersistence.load((InputStream)fis);
            fis.close();
            Assert.assertTrue((boolean)testFile.delete());
            Assert.assertTrue((boolean)modular3.isRealized());
            TestUtils.assertInstancesEquals((OWLReasoner)unified, (OWLReasoner)modular3);
            TestUtils.assertTypesEquals((OWLReasoner)unified, (OWLReasoner)modular3);
            unified.dispose();
            modular.dispose();
            modular2.dispose();
            modular3.dispose();
        }
        finally {
            OWL.manager.removeOntology(ontology);
        }
    }

    @Test
    public void koalaPersistenceRealizationTest() throws IOException {
        this.testFile("koala");
    }

    @Test
    public void sumoPersistenceRealizationTest() throws IOException {
        this.testFile("SUMO");
    }

    @Test
    public void sweetPersistenceRealizationTest() throws IOException {
        this.testFile("SWEET");
    }
}

