/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.test;

import com.clarkparsia.explanation.test.AbstractExplanationTest;
import com.clarkparsia.owlapiv3.OWL;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasoner;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.semanticweb.owlapi.formats.TurtleDocumentFormat;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.StringDocumentSource;
import org.semanticweb.owlapi.io.StringDocumentTarget;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;

@RunWith(value=Parameterized.class)
public class JenaExplanationTest
extends AbstractExplanationTest {
    private static final Logger log = Logger.getLogger(JenaExplanationTest.class.getName());
    private PelletInfGraph pellet;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{false});
        parameters.add(new Object[]{true});
        return parameters;
    }

    public JenaExplanationTest(boolean classify) {
        super(classify);
    }

    private Graph convertOntology(Collection<OWLAxiom> axioms, boolean filterTypes) throws Exception {
        return this.convertOntology(OWL.Ontology(axioms), filterTypes);
    }

    private Graph convertOntology(OWLOntology ontology, boolean filterTypes) throws Exception {
        StringDocumentTarget output = new StringDocumentTarget();
        manager.saveOntology(ontology, (OWLDocumentFormat)new TurtleDocumentFormat(), (OWLOntologyDocumentTarget)output);
        Model model = ModelFactory.createDefaultModel();
        model.read((Reader)new StringReader(output.toString()), ontologyURI.toString(), "TTL");
        if (filterTypes) {
            Resource[] builtinTypes;
            for (Resource builtinType : builtinTypes = new Resource[]{com.hp.hpl.jena.vocabulary.OWL.Ontology, com.hp.hpl.jena.vocabulary.OWL.Class, com.hp.hpl.jena.vocabulary.OWL.ObjectProperty, com.hp.hpl.jena.vocabulary.OWL.DatatypeProperty, com.hp.hpl.jena.vocabulary.OWL.Thing, RDF.List}) {
                model.removeAll(null, RDF.type, (RDFNode)builtinType);
            }
        }
        return model.getGraph();
    }

    @Override
    public void setupGenerators(Collection<OWLAxiom> ontologyAxioms) throws Exception {
        OWLOntology ontology = OWL.Ontology(ontologyAxioms);
        Graph data = this.convertOntology(ontology, false);
        PelletReasoner reasoner = PelletReasonerFactory.theInstance().create();
        this.pellet = (PelletInfGraph)reasoner.bind(data);
        KnowledgeBase kb = this.pellet.getKB();
        if (this.classify) {
            kb.setDoExplanation(true);
            this.pellet.prepare();
            kb.setDoExplanation(false);
            kb.realize();
        }
    }

    @Override
    public void testInconsistencyExplanations(int max, OWLAxiom[] ... explanations) throws Exception {
    }

    @Override
    public void testExplanations(OWLAxiom axiom, int max, Set<Set<OWLAxiom>> expectedExplanations) throws Exception {
        Triple triple = null;
        if (axiom != null) {
            Graph graph = this.convertOntology(Collections.singletonList(axiom), true);
            Assume.assumeTrue((graph.size() == 1 ? 1 : 0) != 0);
            triple = (Triple)graph.find((TripleMatch)Triple.ANY).next();
        }
        Graph actual = triple == null ? this.pellet.explainInconsistency().getGraph() : this.pellet.explain(triple);
        Assert.assertNotNull((String)("Triple " + triple + "cannot be explained"), (Object)actual);
        boolean success = this.testExplanationWithJena(triple, actual, expectedExplanations);
        Assert.assertTrue((String)"Error in explanation, see the log file for details", (boolean)success);
    }

    private boolean testExplanationWithJena(Triple triple, Graph actual, Set<Set<OWLAxiom>> expectedExplanations) throws Exception {
        boolean success = false;
        for (Set<OWLAxiom> expectedExplanation : expectedExplanations) {
            Graph graph = this.convertOntology(expectedExplanation, true);
            if (!graph.isIsomorphicWith(actual)) continue;
            success = true;
            break;
        }
        if (!success) {
            StringWriter sw = new StringWriter();
            sw.getBuffer().append("\nTriple: " + triple);
            sw.getBuffer().append("\nExpected (" + expectedExplanations.size() + "):\n");
            for (Set set : expectedExplanations) {
                Graph expected = this.convertOntology(set, true);
                ModelFactory.createModelForGraph((Graph)expected).write((Writer)sw, "TTL");
                sw.getBuffer().append("\n=====================");
            }
            sw.getBuffer().append("\nActual:\n");
            Model m = ModelFactory.createModelForGraph((Graph)actual);
            m.setNsPrefixes(PrefixMapping.Extended);
            m.setNsPrefix("swrl", "http://www.w3.org/2003/11/swrl#");
            m.write((Writer)sw, "TTL");
            log.severe("Error in explanation: " + sw);
        }
        return success;
    }

    private boolean testExplanationWithOWLAPI(Triple triple, Graph actual, Set<Set<OWLAxiom>> expectedExplanations) throws Exception {
        boolean success = true;
        Assert.assertEquals((String)"Multiple explanations cannot be tested", (long)1L, (long)expectedExplanations.size());
        Set<OWLAxiom> expectedExplanation = expectedExplanations.iterator().next();
        StringWriter sw = new StringWriter();
        ModelFactory.createModelForGraph((Graph)actual).write((OutputStream)System.out, "TTL");
        ModelFactory.createModelForGraph((Graph)actual).write((Writer)sw, "RDF/XML");
        OWLOntology ont = manager.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)new StringDocumentSource(sw.toString()));
        Set actualExplanation = ont.getLogicalAxioms();
        System.out.println(actualExplanation);
        StringBuilder sb = new StringBuilder();
        sb.append("\nTriple: " + triple);
        sb.append("\nUnexpected :\n");
        for (OWLAxiom actualAxiom : actualExplanation) {
            if (expectedExplanation.remove(actualAxiom)) continue;
            success = false;
            sb.append(actualAxiom);
        }
        sb.append("\nNot found:\n");
        for (OWLAxiom expectedAxiom : expectedExplanation) {
            success = false;
            sb.append(expectedAxiom);
        }
        if (!success) {
            log.severe("Error in explanation: " + sb);
        }
        return success;
    }

    public static void main(String[] args) throws Exception {
        JenaExplanationTest test = new JenaExplanationTest(true);
        test.createEntities();
        test.anonymousIndividualPropertyAssertion();
    }
}

