/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia;

import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.TermFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.mindswap.pellet.output.ATermManchesterSyntaxRenderer;

public class TestATermManchesterSyntaxRenderer {
    public static Test suite() {
        return new JUnit4TestAdapter(TestATermManchesterSyntaxRenderer.class);
    }

    @org.junit.Test
    public void testAll() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        r.visit(TermFactory.all((ATermAppl)p, (ATermAppl)C));
        String expected = "(p only C)";
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testAnd() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        r.visit(TermFactory.and((ATermAppl[])new ATermAppl[]{C, D, E}));
        String expected = "(C and D and E)";
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testHasValue() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl l = TermFactory.literal((String)"foobar");
        ATermAppl p = TermFactory.term((String)"p");
        r.visit(TermFactory.hasValue((ATermAppl)p, (ATermAppl)l));
        String expected = "(p value \"foobar\")";
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testInverse() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl p = TermFactory.term((String)"p");
        r.visit(TermFactory.inv((ATermAppl)p));
        String expected = "inverse p";
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testMax() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        r.visit(TermFactory.max((ATermAppl)p, (int)3, (ATermAppl)C));
        String expected = "(p max 3 C)";
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testMin() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        r.visit(TermFactory.min((ATermAppl)p, (int)3, (ATermAppl)C));
        String expected = "(p min 3 C)";
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testNot() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = TermFactory.term((String)"C");
        r.visit(TermFactory.not((ATermAppl)C));
        String expected = "not C";
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testOneOf() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        r.visit(TermFactory.oneOf((ATermAppl[])new ATermAppl[]{C, D, E}));
        String expected = "{E D C}";
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testOr() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        r.visit(TermFactory.or((ATermAppl[])new ATermAppl[]{C, D, E}));
        String expected = "(C or D or E)";
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testSelf() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl p = TermFactory.term((String)"p");
        r.visit(TermFactory.self((ATermAppl)p));
        String expected = "(p Self)";
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void testSome() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        r.visit(TermFactory.some((ATermAppl)p, (ATermAppl)C));
        String expected = "(p some C)";
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @org.junit.Test
    public void test1() {
        StringWriter s = new StringWriter();
        ATermManchesterSyntaxRenderer r = new ATermManchesterSyntaxRenderer();
        r.setWriter(new PrintWriter(s));
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        r.visit(TermFactory.and((ATermAppl)C, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)D)));
        String expected = "(C and (p some D))";
        String actual = s.toString();
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

