/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.service.messages;

import com.clarkparsia.owlapiv3.ImmutableNode;
import com.clarkparsia.owlapiv3.ImmutableNodeSet;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellet.service.reasoner.SchemaQuery;
import com.clarkparsia.pellet.service.reasoner.SchemaQueryType;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLogicalEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;

public class JsonMessage {
    private static JsonFactory FACTORY = new JsonFactory();

    private JsonMessage() {
        throw new AssertionError();
    }

    public static void writeSchemaQuery(SchemaQuery query, OutputStream out) throws IOException {
        JsonGenerator g = FACTORY.createGenerator(out, JsonEncoding.UTF8);
        JsonMessage.writeSchemaQuery(g, query);
        g.close();
    }

    private static void writeSchemaQuery(JsonGenerator g, SchemaQuery query) throws IOException {
        g.writeStartObject();
        g.writeStringField(Field.QUERY.toString(), query.getType().name());
        g.writeFieldName(Field.ENTITY.toString());
        JsonMessage.writeEntity(g, (OWLEntity)query.getEntity());
        g.writeEndObject();
    }

    public static void writeNodeSet(NodeSet<? extends OWLObject> nodeSet, OutputStream out) throws IOException {
        JsonGenerator g = FACTORY.createGenerator(out, JsonEncoding.UTF8);
        JsonMessage.writeNodeSet(g, nodeSet);
        g.close();
    }

    private static void writeNodeSet(JsonGenerator g, NodeSet<? extends OWLObject> nodeSet) throws IOException {
        g.writeStartObject();
        g.writeArrayFieldStart(Field.NODE.toString());
        for (Node node : nodeSet) {
            JsonMessage.writeNode(g, (Node<? extends OWLObject>)node);
        }
        g.writeEndArray();
        g.writeEndObject();
    }

    private static void writeNode(JsonGenerator g, Node<? extends OWLObject> node) throws IOException {
        g.writeStartObject();
        g.writeArrayFieldStart(Field.ENTITY.toString());
        for (OWLObject obj : node) {
            JsonMessage.writeEntity(g, (OWLEntity)obj);
        }
        g.writeEndArray();
        g.writeEndObject();
    }

    private static void writeEntity(JsonGenerator g, OWLEntity entity) throws IOException {
        g.writeStartObject();
        g.writeStringField(Field.IRI.toString(), entity.getIRI().toString());
        g.writeStringField(Field.TYPE.toString(), entity.getEntityType().getName());
        g.writeEndObject();
    }

    private static void assertNextToken(JsonToken expected, JsonParser jp) throws IOException {
        JsonMessage.assertRead(expected, jp.nextToken());
    }

    private static void assertCurrentToken(JsonToken expected, JsonParser jp) throws IOException {
        JsonMessage.assertRead(expected, jp.getCurrentToken());
    }

    private static <T> void assertRead(T expected, T actual) throws IOException {
        if (!actual.equals(expected)) {
            JsonMessage.throwUnexpected(expected, actual);
        }
    }

    private static void throwUnexpected(Object expected, Object actual) throws IOException {
        throw new IOException("Expecting " + expected + " but got " + actual);
    }

    private static void throwUnexpectedField(String actual, Field ... fields) throws IOException {
        JsonMessage.throwUnexpected("one of " + Arrays.toString((Object[])fields), actual);
    }

    public static SchemaQuery readQuery(InputStream in) throws IOException {
        JsonParser jp = FACTORY.createParser(in);
        JsonMessage.assertNextToken(JsonToken.START_OBJECT, jp);
        SchemaQueryType queryType = null;
        OWLLogicalEntity entity = null;
        while (jp.nextToken() == JsonToken.FIELD_NAME) {
            String field = jp.getCurrentName();
            if (field.equals(Field.QUERY.toString())) {
                queryType = SchemaQueryType.valueOf(jp.nextTextValue());
                continue;
            }
            if (field.equals(Field.ENTITY.toString())) {
                entity = (OWLLogicalEntity)JsonMessage.readEntity(jp);
                continue;
            }
            JsonMessage.throwUnexpectedField(field, Field.QUERY, Field.ENTITY);
        }
        JsonMessage.assertCurrentToken(JsonToken.END_OBJECT, jp);
        return new SchemaQuery(queryType, entity);
    }

    public static <T extends OWLObject> NodeSet<T> readNodeSet(InputStream in) throws IOException {
        JsonParser jp = FACTORY.createParser(in);
        JsonMessage.assertNextToken(JsonToken.START_OBJECT, jp);
        JsonMessage.assertNextToken(JsonToken.FIELD_NAME, jp);
        JsonMessage.assertRead(jp.getCurrentName(), Field.NODE.toString());
        JsonMessage.assertNextToken(JsonToken.START_ARRAY, jp);
        HashSet nodes = Sets.newHashSet();
        while (jp.nextToken() == JsonToken.START_OBJECT) {
            Node<T> node = JsonMessage.readNode(jp);
            nodes.add(node);
        }
        JsonMessage.assertCurrentToken(JsonToken.END_ARRAY, jp);
        JsonMessage.assertNextToken(JsonToken.END_OBJECT, jp);
        return ImmutableNodeSet.of((Set)nodes);
    }

    private static <T extends OWLObject> Node<T> readNode(JsonParser jp) throws IOException {
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            JsonMessage.assertNextToken(JsonToken.START_OBJECT, jp);
        }
        JsonMessage.assertNextToken(JsonToken.FIELD_NAME, jp);
        JsonMessage.assertRead(jp.getCurrentName(), Field.ENTITY.toString());
        JsonMessage.assertNextToken(JsonToken.START_ARRAY, jp);
        HashSet entities = Sets.newHashSet();
        while (jp.nextToken() == JsonToken.START_OBJECT) {
            T entity = JsonMessage.readEntity(jp);
            entities.add(entity);
        }
        JsonMessage.assertCurrentToken(JsonToken.END_ARRAY, jp);
        JsonMessage.assertNextToken(JsonToken.END_OBJECT, jp);
        return ImmutableNode.of((Set)entities);
    }

    private static <T extends OWLObject> T readEntity(JsonParser jp) throws IOException {
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            JsonMessage.assertNextToken(JsonToken.START_OBJECT, jp);
        }
        String entityIRI = null;
        String entityType = null;
        while (jp.nextToken() == JsonToken.FIELD_NAME) {
            String field = jp.getCurrentName();
            if (field.equals(Field.IRI.toString())) {
                entityIRI = jp.nextTextValue();
                continue;
            }
            if (field.equals(Field.TYPE.toString())) {
                entityType = jp.nextTextValue();
                continue;
            }
            JsonMessage.throwUnexpectedField(field, Field.IRI, Field.TYPE);
        }
        JsonMessage.assertCurrentToken(JsonToken.END_OBJECT, jp);
        return (T)JsonMessage.createEntity(entityType, IRI.create(entityIRI));
    }

    private static OWLLogicalEntity createEntity(String entityType, IRI entityIRI) {
        if (entityType.equalsIgnoreCase(EntityType.CLASS.getName())) {
            return OWL.Class((IRI)entityIRI);
        }
        if (entityType.equalsIgnoreCase(EntityType.OBJECT_PROPERTY.getName())) {
            return OWL.ObjectProperty((IRI)entityIRI);
        }
        if (entityType.equalsIgnoreCase(EntityType.DATA_PROPERTY.getName())) {
            return OWL.DataProperty((IRI)entityIRI);
        }
        throw new IllegalArgumentException("Invalid entity type: " + entityType);
    }

    private static enum Field {
        QUERY,
        ENTITY,
        NODE,
        IRI,
        TYPE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

