/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.service.reasoner;

import com.clarkparsia.owlapiv3.ImmutableNodeSet;
import com.clarkparsia.pellet.service.reasoner.SchemaReasoner;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLLogicalEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class SchemaReasonerUtil {
    private static final Map<EntityType<?>, EntityQueryEvaluator> QUERY_EVALUATORS = ImmutableMap.builder().put((Object)EntityType.CLASS, (Object)new ClassQueryEvaluator()).put((Object)EntityType.OBJECT_PROPERTY, (Object)new ObjectPropertyQueryEvaluator()).put((Object)EntityType.DATA_PROPERTY, (Object)new DataPropertyQueryEvaluator()).build();

    public static <T extends OWLObject> NodeSet<T> query(OWLReasoner reasoner, SchemaReasoner.QueryType theQueryType, OWLLogicalEntity input) {
        EntityQueryEvaluator evaluator = QUERY_EVALUATORS.get(input.getEntityType());
        return evaluator.query(reasoner, theQueryType, input);
    }

    private static class DataPropertyQueryEvaluator
    implements EntityQueryEvaluator {
        private DataPropertyQueryEvaluator() {
        }

        @Override
        public NodeSet<?> query(OWLReasoner reasoner, SchemaReasoner.QueryType theQueryType, OWLLogicalEntity input) {
            OWLDataProperty pe = (OWLDataProperty)input;
            switch (theQueryType) {
                case EQUIVALENT: {
                    return ImmutableNodeSet.of((Node)reasoner.getEquivalentDataProperties(pe));
                }
                case CHILD: {
                    return reasoner.getSubDataProperties(pe, true);
                }
                case DESCENDANT: {
                    return reasoner.getSubDataProperties(pe, false);
                }
                case PARENT: {
                    return reasoner.getSuperDataProperties(pe, true);
                }
                case ANCESTOR: {
                    return reasoner.getSuperDataProperties(pe, false);
                }
                case DISJOINT: {
                    return reasoner.getDisjointDataProperties((OWLDataPropertyExpression)pe);
                }
                case DOMAIN: {
                    return reasoner.getDataPropertyDomains(pe, true);
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class ObjectPropertyQueryEvaluator
    implements EntityQueryEvaluator {
        private ObjectPropertyQueryEvaluator() {
        }

        @Override
        public NodeSet<?> query(OWLReasoner reasoner, SchemaReasoner.QueryType theQueryType, OWLLogicalEntity input) {
            OWLObjectProperty pe = (OWLObjectProperty)input;
            switch (theQueryType) {
                case EQUIVALENT: {
                    return ImmutableNodeSet.of((Node)reasoner.getEquivalentObjectProperties((OWLObjectPropertyExpression)pe));
                }
                case CHILD: {
                    return reasoner.getSubObjectProperties((OWLObjectPropertyExpression)pe, true);
                }
                case DESCENDANT: {
                    return reasoner.getSubObjectProperties((OWLObjectPropertyExpression)pe, false);
                }
                case PARENT: {
                    return reasoner.getSuperObjectProperties((OWLObjectPropertyExpression)pe, true);
                }
                case ANCESTOR: {
                    return reasoner.getSuperObjectProperties((OWLObjectPropertyExpression)pe, false);
                }
                case DISJOINT: {
                    return reasoner.getDisjointObjectProperties((OWLObjectPropertyExpression)pe);
                }
                case DOMAIN: {
                    return reasoner.getObjectPropertyDomains((OWLObjectPropertyExpression)pe, true);
                }
                case RANGE: {
                    return reasoner.getObjectPropertyRanges((OWLObjectPropertyExpression)pe, true);
                }
                case INVERSE: {
                    return ImmutableNodeSet.of((Node)reasoner.getInverseObjectProperties((OWLObjectPropertyExpression)pe));
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    private static class ClassQueryEvaluator
    implements EntityQueryEvaluator {
        private ClassQueryEvaluator() {
        }

        public NodeSet<OWLClass> query(OWLReasoner reasoner, SchemaReasoner.QueryType theQueryType, OWLLogicalEntity input) {
            OWLClass cls = (OWLClass)input;
            switch (theQueryType) {
                case EQUIVALENT: {
                    return ImmutableNodeSet.of((Node)reasoner.getEquivalentClasses((OWLClassExpression)cls));
                }
                case CHILD: {
                    return reasoner.getSubClasses((OWLClassExpression)cls, true);
                }
                case DESCENDANT: {
                    return reasoner.getSubClasses((OWLClassExpression)cls, false);
                }
                case PARENT: {
                    return reasoner.getSuperClasses((OWLClassExpression)cls, true);
                }
                case ANCESTOR: {
                    return reasoner.getSuperClasses((OWLClassExpression)cls, false);
                }
                case DISJOINT: {
                    return reasoner.getDisjointClasses((OWLClassExpression)cls);
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    private static interface EntityQueryEvaluator {
        public NodeSet<?> query(OWLReasoner var1, SchemaReasoner.QueryType var2, OWLLogicalEntity var3);
    }
}

