/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.service.proto;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellet.service.io.SerializableNode;
import com.clarkparsia.pellet.service.io.SerializableNodeSet;
import com.clarkparsia.pellet.service.proto.Messages;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormat;
import org.semanticweb.owlapi.functional.parser.OWLFunctionalSyntaxOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.StringDocumentSource;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;

public final class ProtoTools {
    private static final OWLOntologyManager MANAGER = OWL.manager;
    private static final OWLDataFactory FACTORY = OWL.factory;
    private static final FunctionalSyntaxDocumentFormat FORMAT = new FunctionalSyntaxDocumentFormat();

    public static Messages.OwlObject toOwlObject(OWLObject theObj) throws IOException {
        ByteArrayOutputStream dataOutput = new ByteArrayOutputStream();
        return ProtoTools.toOwlObject((OWLAxiom)FACTORY.getOWLDeclarationAxiom((OWLEntity)theObj));
    }

    public static Messages.OwlObject toOwlObject(OWLAxiom theObj) throws IOException {
        Messages.OwlObject owlObject;
        block5: {
            OWLOntology aOnt = null;
            try {
                ByteArrayOutputStream dataOutput = new ByteArrayOutputStream();
                aOnt = OWL.Ontology((OWLAxiom[])new OWLAxiom[]{theObj});
                MANAGER.setOntologyFormat(aOnt, (OWLDocumentFormat)FORMAT);
                aOnt.saveOntology((OWLDocumentFormat)FORMAT, (OutputStream)dataOutput);
                owlObject = Messages.OwlObject.newBuilder().setBytes(ByteString.copyFrom((byte[])dataOutput.toByteArray())).build();
                if (aOnt == null) break block5;
            }
            catch (OWLException e) {
                try {
                    throw new IOException(e);
                }
                catch (Throwable throwable) {
                    if (aOnt != null) {
                        MANAGER.removeOntology(aOnt);
                    }
                    throw throwable;
                }
            }
            MANAGER.removeOntology(aOnt);
        }
        return owlObject;
    }

    public static <T extends OWLEntity> T fromOwlObject(Messages.OwlObject theRawObject) throws IOException {
        return (T)((OWLDeclarationAxiom)ProtoTools.fromOwlAxiom(theRawObject)).getEntity();
    }

    public static OWLAxiom fromOwlAxiom(Messages.OwlObject theRawObject) throws IOException {
        OWLFunctionalSyntaxOWLParser aParser = new OWLFunctionalSyntaxOWLParser();
        OWLOntology aOnt = OWL.Ontology((OWLAxiom[])new OWLAxiom[0]);
        aParser.parse((OWLOntologyDocumentSource)new StringDocumentSource(theRawObject.getBytes().toStringUtf8()), aOnt, MANAGER.getOntologyLoaderConfiguration());
        return (OWLAxiom)Iterables.getOnlyElement((Iterable)aOnt.getAxioms());
    }

    public static Messages.AxiomSet toAxiomSet(Set<OWLAxiom> theAxiomSet) throws IOException {
        Messages.AxiomSet.Builder aAxiomSet = Messages.AxiomSet.newBuilder();
        int i = 0;
        for (OWLAxiom aTheAxiomSet : theAxiomSet) {
            aAxiomSet.addAxioms(i++, ProtoTools.toOwlObject(aTheAxiomSet));
        }
        return aAxiomSet.build();
    }

    public static Set<OWLAxiom> fromAxiomSet(Messages.AxiomSet theAxiomSet) throws IOException {
        ImmutableSet.Builder axioms = ImmutableSet.builder();
        for (Messages.OwlObject aRawObject : theAxiomSet.getAxiomsList()) {
            axioms.add((Object)ProtoTools.fromOwlAxiom(aRawObject));
        }
        return axioms.build();
    }

    public static Messages.Node toNode(Node<? extends OWLObject> theNode) throws IOException {
        Messages.Node.Builder aNode = Messages.Node.newBuilder();
        int i = 0;
        for (OWLObject owlObject : theNode) {
            aNode.addOwlObject(i++, ProtoTools.toOwlObject(owlObject));
        }
        return aNode.build();
    }

    public static Node<OWLObject> fromNode(Messages.Node theNode) throws IOException {
        LinkedHashSet theObjects = Sets.newLinkedHashSet();
        for (Messages.OwlObject aObject : theNode.getOwlObjectList()) {
            theObjects.add(ProtoTools.fromOwlObject(aObject));
        }
        return new SerializableNode<OWLObject>(theObjects);
    }

    public static Messages.NodeSet toNodeSet(NodeSet<? extends OWLObject> theNodeSet) throws IOException {
        Messages.NodeSet.Builder aNodeSet = Messages.NodeSet.newBuilder();
        int i = 0;
        for (Node node : theNodeSet) {
            aNodeSet.addNodes(i++, ProtoTools.toNode((Node<? extends OWLObject>)node));
        }
        return aNodeSet.build();
    }

    public static NodeSet<OWLObject> fromNodeSet(Messages.NodeSet theNodeSet) throws IOException {
        LinkedHashSet aNodeSet = Sets.newLinkedHashSet();
        for (Messages.Node aNode : theNodeSet.getNodesList()) {
            aNodeSet.add(ProtoTools.fromNode(aNode));
        }
        return SerializableNodeSet.create(aNodeSet);
    }

    static {
        FORMAT.setAddMissingTypes(false);
        FORMAT.clear();
    }
}

