/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.service.proto;

import com.clarkparsia.pellet.service.MessageEncoder;
import com.clarkparsia.pellet.service.ServiceEncoder;
import com.clarkparsia.pellet.service.io.EncodingException;
import com.clarkparsia.pellet.service.messages.ExplainRequest;
import com.clarkparsia.pellet.service.messages.ExplainResponse;
import com.clarkparsia.pellet.service.messages.QueryRequest;
import com.clarkparsia.pellet.service.messages.QueryResponse;
import com.clarkparsia.pellet.service.messages.UpdateRequest;
import com.clarkparsia.pellet.service.proto.Messages;
import com.clarkparsia.pellet.service.proto.ProtoTools;
import java.io.IOException;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

public class ProtoServiceEncoder
implements ServiceEncoder {
    private final String MEDIA_TYPE = "application/x-protobuf";

    @Override
    public String getMediaType() {
        return "application/x-protobuf";
    }

    @Override
    public boolean canEncode(String theMediaType) {
        return "application/x-protobuf".equals(theMediaType);
    }

    @Override
    public byte[] encode(QueryRequest theQueryRequest) throws EncodingException {
        return new QueryRequestEncoder().encode(theQueryRequest);
    }

    @Override
    public byte[] encode(ExplainRequest theExplainRequest) throws EncodingException {
        return new ExplainRequestEncoder().encode(theExplainRequest);
    }

    @Override
    public byte[] encode(UpdateRequest theUpdateRequest) throws EncodingException {
        return new UpdateRequestEncoder().encode(theUpdateRequest);
    }

    @Override
    public byte[] encode(QueryResponse theQueryResponse) throws EncodingException {
        return new QueryResponseEncoder().encode(theQueryResponse);
    }

    @Override
    public byte[] encode(ExplainResponse theExplainResponse) throws EncodingException {
        return new ExplainResponseEncoder().encode(theExplainResponse);
    }

    private static final class ExplainResponseEncoder
    implements MessageEncoder<ExplainResponse> {
        private ExplainResponseEncoder() {
        }

        @Override
        public byte[] encode(ExplainResponse theObject) throws EncodingException {
            try {
                Messages.ExplainResponse.Builder aExplainResp = Messages.ExplainResponse.newBuilder();
                int i = 0;
                for (Set<OWLAxiom> aAxiomSet : theObject.getAxiomSets()) {
                    aExplainResp.addAxiomsets(i++, ProtoTools.toAxiomSet(aAxiomSet));
                }
                return aExplainResp.build().toByteArray();
            }
            catch (IOException theE) {
                throw new EncodingException(theE);
            }
        }
    }

    private static final class QueryResponseEncoder
    implements MessageEncoder<QueryResponse> {
        private QueryResponseEncoder() {
        }

        @Override
        public byte[] encode(QueryResponse theObject) throws EncodingException {
            try {
                Messages.QueryResponse aQueryResponse = Messages.QueryResponse.newBuilder().setResult(ProtoTools.toNodeSet(theObject.getResults())).build();
                return aQueryResponse.toByteArray();
            }
            catch (IOException theE) {
                throw new EncodingException(theE);
            }
        }
    }

    private static final class UpdateRequestEncoder
    implements MessageEncoder<UpdateRequest> {
        private UpdateRequestEncoder() {
        }

        @Override
        public byte[] encode(UpdateRequest theObject) throws EncodingException {
            try {
                Messages.UpdateRequest aUpdateReq = Messages.UpdateRequest.newBuilder().setAdditions(ProtoTools.toAxiomSet(theObject.getAdditions())).setRemovals(ProtoTools.toAxiomSet(theObject.getRemovals())).build();
                return aUpdateReq.toByteArray();
            }
            catch (IOException theE) {
                throw new EncodingException(theE);
            }
        }
    }

    private static final class ExplainRequestEncoder
    implements MessageEncoder<ExplainRequest> {
        private ExplainRequestEncoder() {
        }

        @Override
        public byte[] encode(ExplainRequest theObject) throws EncodingException {
            try {
                Messages.ExplainRequest aExplainRequest = Messages.ExplainRequest.newBuilder().setAxiom(ProtoTools.toOwlObject(theObject.getAxiom())).build();
                return aExplainRequest.toByteArray();
            }
            catch (IOException theE) {
                throw new EncodingException(theE);
            }
        }
    }

    private static final class QueryRequestEncoder
    implements MessageEncoder<QueryRequest> {
        private QueryRequestEncoder() {
        }

        @Override
        public byte[] encode(QueryRequest theQueryRequest) throws EncodingException {
            try {
                Messages.QueryRequest aProtoReq = Messages.QueryRequest.newBuilder().setInput(ProtoTools.toOwlObject((OWLObject)theQueryRequest.getInput())).build();
                return aProtoReq.toByteArray();
            }
            catch (IOException theE) {
                throw new EncodingException(theE);
            }
        }
    }
}

