/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.service.proto;

import com.clarkparsia.pellet.service.MessageDecoder;
import com.clarkparsia.pellet.service.ServiceDecoder;
import com.clarkparsia.pellet.service.messages.ExplainRequest;
import com.clarkparsia.pellet.service.messages.ExplainResponse;
import com.clarkparsia.pellet.service.messages.QueryRequest;
import com.clarkparsia.pellet.service.messages.QueryResponse;
import com.clarkparsia.pellet.service.messages.UpdateRequest;
import com.clarkparsia.pellet.service.proto.Messages;
import com.clarkparsia.pellet.service.proto.ProtoTools;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLLogicalEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.reasoner.NodeSet;

public final class ProtoServiceDecoder
implements ServiceDecoder {
    private final String MEDIA_TYPE = "application/x-protobuf";

    @Override
    public String getMediaType() {
        return "application/x-protobuf";
    }

    @Override
    public boolean canDecode(String theMediaType) {
        return "application/x-protobuf".equals(theMediaType);
    }

    @Override
    public QueryRequest queryRequest(byte[] theBytes) {
        return new QueryRequestDecoder().decode(theBytes);
    }

    @Override
    public ExplainRequest explainRequest(byte[] theBytes) {
        return new ExplainRequestDecoder().decode(theBytes);
    }

    @Override
    public UpdateRequest updateRequest(byte[] theBytes) {
        return new UpdateRequestDecoder().decode(theBytes);
    }

    @Override
    public QueryResponse queryResponse(byte[] theBytes) {
        return new QueryResponseDecoder().decode(theBytes);
    }

    @Override
    public ExplainResponse explainResponse(byte[] theBytes) {
        return new ExplainResponseDecoder().decode(theBytes);
    }

    private static final class ExplainResponseDecoder
    implements MessageDecoder<ExplainResponse> {
        private ExplainResponseDecoder() {
        }

        @Override
        public ExplainResponse decode(byte[] theBytes) {
            try {
                Messages.ExplainResponse aExplainResp = Messages.ExplainResponse.parseFrom(theBytes);
                HashSet axioms = Sets.newHashSet();
                for (Messages.AxiomSet aAxiomSet : aExplainResp.getAxiomsetsList()) {
                    axioms.add(ProtoTools.fromAxiomSet(aAxiomSet));
                }
                return new ExplainResponse(axioms);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }
    }

    private static final class QueryResponseDecoder
    implements MessageDecoder<QueryResponse> {
        private QueryResponseDecoder() {
        }

        @Override
        public QueryResponse decode(byte[] theBytes) {
            try {
                Messages.QueryResponse aQueryResp = Messages.QueryResponse.parseFrom(theBytes);
                NodeSet<OWLObject> nodeSet = ProtoTools.fromNodeSet(aQueryResp.getResult());
                return new QueryResponse(nodeSet);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }
    }

    private static final class UpdateRequestDecoder
    implements MessageDecoder<UpdateRequest> {
        private UpdateRequestDecoder() {
        }

        @Override
        public UpdateRequest decode(byte[] theBytes) {
            try {
                Messages.UpdateRequest aProtoReq = Messages.UpdateRequest.parseFrom(theBytes);
                Set<OWLAxiom> additions = ProtoTools.fromAxiomSet(aProtoReq.getAdditions());
                Set<OWLAxiom> removals = ProtoTools.fromAxiomSet(aProtoReq.getRemovals());
                return new UpdateRequest(additions, removals);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }
    }

    private static final class ExplainRequestDecoder
    implements MessageDecoder<ExplainRequest> {
        private ExplainRequestDecoder() {
        }

        @Override
        public ExplainRequest decode(byte[] theBytes) {
            try {
                Messages.ExplainRequest aProtoReq = Messages.ExplainRequest.parseFrom(theBytes);
                OWLAxiom anAxiom = ProtoTools.fromOwlAxiom(aProtoReq.getAxiom());
                return new ExplainRequest(anAxiom);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }
    }

    private static final class QueryRequestDecoder
    implements MessageDecoder<QueryRequest> {
        private QueryRequestDecoder() {
        }

        @Override
        public QueryRequest decode(byte[] theBytes) {
            try {
                Messages.QueryRequest aProtoReq = Messages.QueryRequest.parseFrom(theBytes);
                OWLLogicalEntity anEntity = (OWLLogicalEntity)ProtoTools.fromOwlObject(aProtoReq.getInput());
                return new QueryRequest(anEntity);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }
    }
}

