/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.service.messages;

import com.clarkparsia.pellet.service.ServiceDecoder;
import com.clarkparsia.pellet.service.ServiceEncoder;
import com.clarkparsia.pellet.service.io.EncodingException;
import com.clarkparsia.pellet.service.messages.ExplainRequest;
import com.clarkparsia.pellet.service.messages.ExplainResponse;
import com.clarkparsia.pellet.service.messages.QueryRequest;
import com.clarkparsia.pellet.service.messages.QueryResponse;
import com.clarkparsia.pellet.service.messages.UpdateRequest;
import com.clarkparsia.pellet.service.proto.ProtoServiceDecoder;
import com.clarkparsia.pellet.service.proto.ProtoServiceEncoder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLLogicalEntity;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;

public class SerializationTests {
    private ServiceEncoder anEncoder = new ProtoServiceEncoder();
    private ServiceDecoder aDecoder = new ProtoServiceDecoder();

    @Test
    public void testQueryRequestRoundTrip() throws EncodingException {
        OWLClassImpl entity = new OWLClassImpl(IRI.create((String)"urn:test:iri"));
        QueryRequest originalQR = new QueryRequest((OWLLogicalEntity)entity);
        ByteString encodedQR = ByteString.copyFrom((byte[])this.anEncoder.encode(originalQR));
        Assert.assertTrue((encodedQR.size() > 0 ? 1 : 0) != 0);
        QueryRequest decodedQR = this.aDecoder.queryRequest(encodedQR.toByteArray());
        Assert.assertEquals((Object)originalQR, (Object)decodedQR);
    }

    private OWLAxiom generateAxiom(int i) {
        return new OWLAnnotationAssertionAxiomImpl((OWLAnnotationSubject)IRI.create((String)("urn:test:s" + i)), (OWLAnnotationProperty)new OWLAnnotationPropertyImpl(IRI.create((String)("urn:test:p" + i))), (OWLAnnotationValue)IRI.create((String)("urn:test:o" + i)), Collections.emptyList());
    }

    private Collection<OWLAxiom> generateAxioms(int n) {
        LinkedList axioms = Lists.newLinkedList();
        for (int i = 0; i < n; ++i) {
            axioms.add(this.generateAxiom(i));
        }
        return axioms;
    }

    @Test
    public void testExplainRequestRoundTrip() throws EncodingException {
        OWLAxiom axiom = this.generateAxiom(0);
        ExplainRequest originalER = new ExplainRequest(axiom);
        byte[] encodedER = this.anEncoder.encode(originalER);
        Assert.assertTrue((encodedER.length > 0 ? 1 : 0) != 0);
        ExplainRequest decodedER = this.aDecoder.explainRequest(encodedER);
        Assert.assertEquals((Object)originalER, (Object)decodedER);
    }

    @Test
    public void testUpdateRequestRoundTrip() throws EncodingException {
        HashSet removals;
        HashSet additions = Sets.newHashSet(this.generateAxioms(100));
        UpdateRequest originalUR = new UpdateRequest((Set)additions, (Set)(removals = Sets.newHashSet(this.generateAxioms(50))));
        byte[] encodedUR = this.anEncoder.encode(originalUR);
        Assert.assertTrue((encodedUR.length > 0 ? 1 : 0) != 0);
        UpdateRequest decodedUR = this.aDecoder.updateRequest(encodedUR);
        Assert.assertEquals((Object)originalUR, (Object)decodedUR);
        Assert.assertEquals((long)100L, (long)decodedUR.getAdditions().size());
        Assert.assertEquals((long)50L, (long)decodedUR.getRemovals().size());
    }

    @Test
    public void testQueryResponseRoundTrip() throws EncodingException {
        OWLClassNodeSet classes = new OWLClassNodeSet((OWLClass)new OWLClassImpl(IRI.create((String)"http://xmlns.com/foaf/0.1/Agent")));
        QueryResponse originalQR = new QueryResponse((NodeSet)classes);
        byte[] encodedUR = this.anEncoder.encode(originalQR);
        Assert.assertTrue((encodedUR.length > 0 ? 1 : 0) != 0);
        QueryResponse decodedQR = this.aDecoder.queryResponse(encodedUR);
        Assert.assertEquals((Object)originalQR, (Object)decodedQR);
    }

    @Test
    public void testExplainResponseRoundTrip() throws EncodingException {
        int n = 4;
        int cardinality = 50;
        HashSet axiomSets = Sets.newHashSetWithExpectedSize((int)n);
        for (int i = 0; i < n; ++i) {
            axiomSets.add(Sets.newHashSet(this.generateAxioms(cardinality)));
        }
        ExplainResponse originalER = new ExplainResponse((Set)axiomSets);
        byte[] encodedER = this.anEncoder.encode(originalER);
        Assert.assertTrue((encodedER.length > 0 ? 1 : 0) != 0);
        ExplainResponse decodedUR = this.aDecoder.explainResponse(encodedER);
        Assert.assertEquals((Object)originalER, (Object)decodedUR);
        for (Set aAxioms : decodedUR.getAxiomSets()) {
            Assert.assertEquals((long)cardinality, (long)aAxioms.size());
        }
    }
}

