/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.sparqlowl.parser.arq;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;
import org.mindswap.pellet.jena.vocabulary.OWL2;

public class ARQParserUtilities {
    private static final Set<Node> OWL2_DATATYPES;
    public static final Node XSD_BOOLEAN_FALSE;
    public static final Node XSD_BOOLEAN_TRUE;

    public static Node createNonNegativeInteger(String s) {
        return NodeFactory.createLiteral((String)s, null, (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
    }

    public static boolean isOWL2Datatype(Node n) {
        return OWL2_DATATYPES.contains(n);
    }

    public static Node listToTriples(List<Node> nodes, Collection<Triple> triples) {
        Node list = RDF.Nodes.nil;
        for (int i = nodes.size() - 1; i >= 0; --i) {
            Node oldList = list;
            Node first = nodes.get(i);
            list = NodeFactory.createBlankNode();
            triples.add(new Triple(list, RDF.Nodes.first, first));
            triples.add(new Triple(list, RDF.Nodes.rest, oldList));
        }
        return list;
    }

    static {
        XSD_BOOLEAN_FALSE = NodeFactory.createLiteral((String)Boolean.FALSE.toString(), null, (RDFDatatype)XSDDatatype.XSDboolean);
        XSD_BOOLEAN_TRUE = NodeFactory.createLiteral((String)Boolean.TRUE.toString(), null, (RDFDatatype)XSDDatatype.XSDboolean);
        OWL2_DATATYPES = Collections.unmodifiableSet(new HashSet<Node>(Arrays.asList(NodeFactory.createURI((String)(OWL2.getURI() + "real")), NodeFactory.createURI((String)(OWL2.getURI() + "rational")), XSD.decimal.asNode(), XSD.integer.asNode(), XSD.nonNegativeInteger.asNode(), XSD.nonPositiveInteger.asNode(), XSD.negativeInteger.asNode(), XSD.positiveInteger.asNode(), XSD.xlong.asNode(), XSD.xint.asNode(), XSD.xshort.asNode(), XSD.xbyte.asNode(), XSD.unsignedLong.asNode(), XSD.unsignedInt.asNode(), XSD.unsignedShort.asNode(), XSD.unsignedByte.asNode(), XSD.xdouble.asNode(), XSD.xfloat.asNode(), XSD.xstring.asNode(), XSD.normalizedString.asNode(), XSD.token.asNode(), XSD.language.asNode(), XSD.Name.asNode(), XSD.NCName.asNode(), XSD.xboolean.asNode(), XSD.hexBinary.asNode(), XSD.base64Binary.asNode(), XSD.anyURI.asNode(), XSD.dateTime.asNode(), NodeFactory.createURI((String)(XSD.getURI() + "dateTimeStamp")), NodeFactory.createURI((String)(RDF.getURI() + "XMLLiteral")))));
    }
}

