/*
 * Decompiled with CFR 0.152.
 */
package profiler.statistical;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import profiler.ProfileKB;
import profiler.Result;

public class ReleaseStatistics {
    private ProfileKB.Task task;
    private Map<String, Double> memStats;
    private Map<String, Double> timeStats;

    public ReleaseStatistics(ProfileKB.Task task) {
        this.task = task;
        this.memStats = new LinkedHashMap<String, Double>();
        this.timeStats = new LinkedHashMap<String, Double>();
    }

    public ReleaseStatistics(Result<ProfileKB.Task> task) {
        this(task.getTask());
        DescriptiveStatistics mem = task.getMemory();
        this.addMemStat("avg", mem.getMean());
        this.addMemStat("var", mem.getVariance());
        this.addMemStat("n", mem.getN());
        DescriptiveStatistics time = task.getTime();
        this.addTimeStat("avg", time.getMean());
        this.addTimeStat("var", mem.getVariance());
        this.addTimeStat("n", mem.getN());
    }

    public ProfileKB.Task getTask() {
        return this.task;
    }

    public double getMemStat(String name) {
        return this.memStats.get(name);
    }

    public double getTimeStat(String name) {
        return this.timeStats.get(name);
    }

    public Map<String, Double> getMemStats() {
        return this.memStats;
    }

    public Map<String, Double> getTimeStats() {
        return this.timeStats;
    }

    public void addMemStat(String name, double value) {
        this.memStats.put(name, value);
    }

    public void addTimeStat(String name, double value) {
        this.timeStats.put(name, value);
    }
}

