/*
 * Decompiled with CFR 0.152.
 */
package profiler.statistical;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.utils.VersionInfo;
import profiler.statistical.ReleaseStatistics;

public class Release {
    private String version;
    private Long releaseDate;
    private Map<String, List<ReleaseStatistics>> statistics;

    public Release(String version, Long releaseDate) {
        this.version = version;
        this.releaseDate = releaseDate;
        this.statistics = new LinkedHashMap<String, List<ReleaseStatistics>>();
    }

    public Release() {
        this(VersionInfo.getInstance().getVersionString(), System.currentTimeMillis());
    }

    public String getVersion() {
        return this.version;
    }

    public Long getReleaseDate() {
        return this.releaseDate;
    }

    public List<ReleaseStatistics> getStatistics(String ontology) {
        return this.statistics.get(ontology);
    }

    public void addStatistics(String ontology, List<ReleaseStatistics> statistics) {
        this.statistics.put(ontology, statistics);
    }

    public Map<String, List<ReleaseStatistics>> getAllStatistics() {
        return this.statistics;
    }

    public String toString() {
        return this.version;
    }
}

