/*
 * Decompiled with CFR 0.152.
 */
package profiler;

import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Node;

public class ProfileUtils {
    public static void error(String msg) {
        System.err.println("ERROR: " + msg);
        System.exit(0);
    }

    public static String formatFileName(String fileName, int length) {
        int lastSlash = fileName.lastIndexOf(47) + 1;
        int lastDot = fileName.lastIndexOf(46);
        fileName = lastDot < lastSlash ? fileName.substring(lastSlash) : (lastSlash - lastDot > length ? fileName.substring(lastSlash, lastSlash + length) : fileName.substring(lastSlash, lastDot));
        return fileName;
    }

    public static double mb(long bytes) {
        return (double)bytes / 1048576.0;
    }

    public static void printCounts(ABox abox) {
        if (abox == null) {
            System.out.println("NO ABOX");
            return;
        }
        int typeCount = 0;
        int edgeCount = 0;
        int literalCount = 0;
        for (Node node : abox.getNodes()) {
            if (node.isLiteral()) {
                ++literalCount;
                continue;
            }
            edgeCount += ((Individual)node).getOutEdges().size();
            typeCount += node.getTypes().size();
        }
        int individualCount = abox.getNodes().size() - literalCount;
        System.out.println("Individuals    : " + individualCount);
        System.out.println("Literals       : " + literalCount);
        System.out.println("Types          : " + typeCount);
        System.out.println("Edges          : " + edgeCount);
        System.out.println();
    }

    public static void printCounts(KnowledgeBase kb) {
        int classCount = kb.getClasses().size();
        int objPropertyCount = kb.getObjectProperties().size();
        int dataPropertyCount = kb.getDataProperties().size();
        System.out.println("Expressivity   : " + kb.getExpressivity());
        System.out.println("Classes        : " + classCount);
        System.out.println("Obj Properties : " + objPropertyCount);
        System.out.println("Data Properties: " + dataPropertyCount);
        ProfileUtils.printCounts(kb.getABox());
    }
}

