/*
 * Decompiled with CFR 0.152.
 */
package profiler.statistical;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import profiler.ProfileKB;
import profiler.Result;
import profiler.statistical.MathStatUtils;
import profiler.statistical.Release;
import profiler.statistical.ReleaseManager;
import profiler.statistical.ReleaseStatistics;
import profiler.statistical.ReleaseTests;
import profiler.statistical.ReleaseUtils;

@RunWith(value=Parameterized.class)
@Category(value={ReleaseTests.class})
@Ignore(value="Enable to test release performance")
public class ReleasePerformanceTest {
    private static final int PARSE = ProfileKB.Task.Parse.ordinal();
    private static final int LOAD = ProfileKB.Task.Load.ordinal();
    private static final int CONSISTENCY = ProfileKB.Task.Consistency.ordinal();
    private static final int CLASSIFY = ProfileKB.Task.Classify.ordinal();
    private static final int REALIZE = ProfileKB.Task.Realize.ordinal();
    private static final MathStatUtils math = new MathStatUtils();
    private static String ONTOLOGIES = "";
    private static int[] RELEASES_TO_COMPARE = new int[]{0, 1, 2};
    private static int ITERATIONS = 30;
    private static double ALPHA = 0.001;
    private static double MAX_PERFORMANCE_DECREASE = 0.05;
    private static String RELEASE_REPOSITORY = "profiler/releases";
    private static ProfileKB.Task TASK = ProfileKB.Task.Realize;
    private static ProfileKB.LoaderType LOADER = ProfileKB.LoaderType.JENA;
    private static boolean WARMUP = true;
    private List<ReleaseStatistics> current;
    private List<ReleaseStatistics> previous;
    private final String message;

    @Parameterized.Parameters
    public static List<Object[]> params() throws IOException {
        ReleasePerformanceTest.loadProperties("profiler/releasetesting.properties");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ReleaseManager manager = new ReleaseManager();
        manager.load(RELEASE_REPOSITORY);
        Release current = ReleasePerformanceTest.getCurrentRelease();
        List previousReleases = manager.getReleases();
        if (!previousReleases.isEmpty()) {
            for (int revNumber : RELEASES_TO_COMPARE) {
                if (revNumber < 0 || revNumber >= previousReleases.size()) continue;
                Release previous = (Release)previousReleases.get(revNumber);
                for (Map.Entry currStats : current.getAllStatistics().entrySet()) {
                    List previousStats = previous.getStatistics((String)currStats.getKey());
                    if (previousStats == null) continue;
                    System.out.println("Comparing with [" + revNumber + "]: " + previous.getVersion());
                    params.add(new Object[]{currStats.getValue(), previousStats, previous.getVersion(), currStats.getKey()});
                }
            }
        }
        try {
            ReleaseUtils.writeToFile((Release)current, (String)new File(RELEASE_REPOSITORY, current.getVersion() + "_" + current.getReleaseDate()).getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    private static void loadProperties(String filename) {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(filename));
            RELEASE_REPOSITORY = properties.getProperty("REPOSITORY", "profiler/releases");
            ITERATIONS = Integer.parseInt(properties.getProperty("ITERATIONS", "30"));
            double perfdec = Double.parseDouble(properties.getProperty("MAX_PERFORMANCE_DECREASE", "0.05"));
            if (perfdec < 0.0 || perfdec > 1.0) {
                System.err.println("Invalid maximum performance decrease: " + perfdec);
            } else {
                MAX_PERFORMANCE_DECREASE = perfdec;
            }
            double _alpha = 1.0 - Double.parseDouble(properties.getProperty("CONFIDENCE_LEVEL", "0.999"));
            if (_alpha <= 0.0 || _alpha > 0.5) {
                System.err.println("Invalid confidence level: " + (1.0 - _alpha));
            } else {
                ALPHA = _alpha;
            }
            String[] rels = properties.getProperty("RELEASES_TO_COMPARE", "0,5,10").split(",\\s*");
            RELEASES_TO_COMPARE = new int[rels.length];
            for (int i = 0; i < rels.length; ++i) {
                ReleasePerformanceTest.RELEASES_TO_COMPARE[i] = Integer.parseInt(rels[i]);
            }
            ONTOLOGIES = properties.getProperty("ONTOLOGIES", "");
            String tsk = properties.getProperty("TASK", "Realize");
            if (tsk.equalsIgnoreCase("Realize")) {
                TASK = ProfileKB.Task.Realize;
            } else if (tsk.equalsIgnoreCase("Classify")) {
                TASK = ProfileKB.Task.Classify;
            } else if (tsk.equalsIgnoreCase("Consistency")) {
                TASK = ProfileKB.Task.Consistency;
            } else if (tsk.equalsIgnoreCase("Load")) {
                TASK = ProfileKB.Task.Load;
            } else if (tsk.equalsIgnoreCase("Parse")) {
                TASK = ProfileKB.Task.Parse;
            } else {
                System.err.println("Invalid task: " + tsk);
            }
            String _loader = properties.getProperty("LOADER", "Jena");
            if (_loader.equalsIgnoreCase("Jena")) {
                LOADER = ProfileKB.LoaderType.JENA;
            } else if (_loader.equalsIgnoreCase("OWLAPI")) {
                LOADER = ProfileKB.LoaderType.OWLAPI;
            } else {
                System.err.println("Invalid loader: " + _loader);
            }
            WARMUP = Boolean.parseBoolean(properties.getProperty("WARMUP", "True"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Release getCurrentRelease() throws IOException {
        String line;
        Release current = new Release();
        ProfileKB pkb = new ProfileKB();
        pkb.setMemoryProfiling(ProfileKB.MemoryProfiling.ALL_SIZE);
        pkb.setLoaderType(LOADER);
        pkb.setTask(TASK);
        LinkedHashMap results = new LinkedHashMap();
        BufferedReader reader = new BufferedReader(new FileReader(ONTOLOGIES));
        while ((line = reader.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            String[] files = line.split(" ");
            String name = new File(files[0]).getName();
            if (WARMUP) {
                double estimatedTime = 0.0;
                for (Result result : pkb.profile(files)) {
                    estimatedTime += result.getAvgTime();
                }
                int nWarmupIterations = ReleasePerformanceTest.getNumberOfWarmupIterations(estimatedTime) - 1;
                for (int i = 0; i < nWarmupIterations; ++i) {
                    pkb.profile(files);
                }
            }
            for (int i = 0; i < ITERATIONS; ++i) {
                ArrayList res = new ArrayList(pkb.profile(files));
                List previousRes = (List)results.get(name);
                if (previousRes == null) {
                    results.put(name, res);
                    continue;
                }
                for (int j = 0; j < res.size() && j < previousRes.size(); ++j) {
                    ((Result)previousRes.get(j)).addIteration((Result)res.get(j));
                }
            }
        }
        for (Map.Entry entry : results.entrySet()) {
            ArrayList<ReleaseStatistics> stats = new ArrayList<ReleaseStatistics>();
            for (Result task : (List)entry.getValue()) {
                stats.add(new ReleaseStatistics(task));
            }
            current.addStatistics((String)entry.getKey(), stats);
        }
        return current;
    }

    private static int getNumberOfWarmupIterations(double estimatedTime) {
        int n = (int)Math.round(36.0 - 11.0 * Math.log(estimatedTime));
        return n > 0 ? n : 1;
    }

    public ReleasePerformanceTest(List<ReleaseStatistics> current, List<ReleaseStatistics> previous, String previousReleaseVersion, String ontology) {
        this.current = current;
        this.previous = previous;
        this.message = "\tOntology: " + ontology + "\tRelease: " + previousReleaseVersion;
    }

    @Test
    public void parseTimeTest() {
        this.timeIncrease(PARSE);
    }

    @Test
    public void parseMemoryTest() {
        this.memoryIncrease(PARSE);
    }

    @Test
    public void loadTimeTest() {
        this.timeIncrease(LOAD);
    }

    @Test
    public void loadMemoryTest() {
        this.memoryIncrease(LOAD);
    }

    @Test
    public void consistencyTimeTest() {
        this.timeIncrease(CONSISTENCY);
    }

    @Test
    public void consistencyMemoryTest() {
        this.memoryIncrease(CONSISTENCY);
    }

    @Test
    public void classificationTimeTest() {
        this.timeIncrease(CLASSIFY);
    }

    @Test
    public void classificationMemoryTest() {
        this.memoryIncrease(CLASSIFY);
    }

    @Test
    public void realizationTimeTest() {
        this.timeIncrease(REALIZE);
    }

    @Test
    public void realizationMemoryTest() {
        this.memoryIncrease(REALIZE);
    }

    private void timeIncrease(int task) {
        Assume.assumeTrue((this.current.size() > task && this.previous.size() > task ? 1 : 0) != 0);
        ReleaseStatistics curr = this.current.get(task);
        ReleaseStatistics prev = this.previous.get(task);
        boolean isSignificant = this.changeIsStatisticallySignificant(curr.getTimeStat("avg"), prev.getTimeStat("avg"), curr.getTimeStat("var"), prev.getTimeStat("var"), curr.getTimeStat("n"), prev.getTimeStat("n"));
        if (isSignificant) {
            Assert.fail((String)(ProfileKB.Task.values()[task] + " Time regression (from " + prev.getTimeStat("avg") + " to " + curr.getTimeStat("avg") + "). " + this.message));
        }
    }

    private void memoryIncrease(int task) {
        Assume.assumeTrue((this.current.size() > task && this.previous.size() > task ? 1 : 0) != 0);
        ReleaseStatistics curr = this.current.get(task);
        ReleaseStatistics prev = this.previous.get(task);
        boolean isSignificant = this.changeIsStatisticallySignificant(curr.getMemStat("avg"), prev.getMemStat("avg"), curr.getMemStat("var"), prev.getMemStat("var"), curr.getMemStat("n"), prev.getMemStat("n"));
        if (isSignificant) {
            Assert.fail((String)(ProfileKB.Task.values()[task] + " Memory regression (from " + prev.getMemStat("avg") + " to " + curr.getMemStat("avg") + "). " + this.message));
        }
    }

    private boolean changeIsStatisticallySignificant(double m1, double m2, double v1, double v2, double n1, double n2) {
        if (m1 > m2 && m1 > 0.01) {
            try {
                if (m1 > math.confidenceInterval(m2, v2, n2, ALPHA)[1] * (1.0 + MAX_PERFORMANCE_DECREASE)) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

