/*
 * Decompiled with CFR 0.152.
 */
package profiler.statistical;

import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.TDistribution;
import org.apache.commons.math.distribution.TDistributionImpl;
import org.apache.commons.math.stat.StatUtils;
import org.apache.commons.math.stat.inference.TTestImpl;

public class MathStatUtils
extends TTestImpl {
    private TDistribution distribution = new TDistributionImpl(1.0);

    public boolean tTest(double m1, double m2, double v1, double v2, double n1, double n2, double alpha) throws MathException {
        this.checkSignificanceLevel(alpha);
        return this.tTest(m1, m2, v1, v2, n1, n2) < alpha;
    }

    public boolean tTest(double m, double mu, double v, double n, double alpha) throws MathException {
        this.checkSignificanceLevel(alpha);
        return this.tTest(m, mu, v, n) < alpha;
    }

    public double[] confidenceInterval(double[] sample, double alpha) throws MathException {
        return this.confidenceInterval(StatUtils.mean((double[])sample), StatUtils.variance((double[])sample), sample.length, alpha);
    }

    public double[] confidenceInterval(double m, double v, double n, double alpha) throws MathException {
        this.checkSignificanceLevel(alpha);
        this.distribution.setDegreesOfFreedom(n - 1.0);
        double t = Math.abs(this.distribution.inverseCumulativeProbability(alpha / 2.0));
        double val = t * Math.sqrt(v / n);
        return new double[]{m - val, m + val};
    }

    private void checkSignificanceLevel(double alpha) throws IllegalArgumentException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw MathRuntimeException.createIllegalArgumentException((String)"out of bounds significance level {0}, must be between {1} and {2}", (Object[])new Object[]{alpha, 0.0, 0.5});
        }
    }
}

