/*
 * Decompiled with CFR 0.152.
 */
package profiler;

import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

public class Result<Task> {
    private Task task;
    private DescriptiveStatistics memory;
    private DescriptiveStatistics time;

    public Result(Task task, double time) {
        this(task, -1.0, time);
    }

    public Result(Task task, double memory, double time) {
        this.task = task;
        this.memory = new DescriptiveStatistics();
        this.memory.addValue(memory);
        this.time = new DescriptiveStatistics();
        this.time.addValue(time);
    }

    public void addIteration(double memory, double time) {
        this.memory.addValue(memory);
        this.time.addValue(time);
    }

    public void addIteration(Result<Task> other) {
        if (!this.task.equals(other.task)) {
            throw new IllegalArgumentException(this.task + " != " + other.task);
        }
        for (double mem : other.getMemory().getValues()) {
            this.memory.addValue(mem);
        }
        for (double t : other.getTime().getValues()) {
            this.time.addValue(t);
        }
    }

    public int getIterations() {
        return (int)this.memory.getN();
    }

    public double getAvgMemory() {
        return this.memory.getMean();
    }

    public Task getTask() {
        return this.task;
    }

    public double getAvgTime() {
        return this.time.getMean();
    }

    public DescriptiveStatistics getTime() {
        return this.time;
    }

    public DescriptiveStatistics getMemory() {
        return this.memory;
    }
}

