/*
 * Decompiled with CFR 0.152.
 */
package profiler;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.resultset.ResultSetMem;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.FileReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.JenaLoader;
import org.mindswap.pellet.utils.FileUtils;
import org.mindswap.pellet.utils.MemUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import org.mindswap.pellet.utils.VersionInfo;
import profiler.ProfileKB;
import profiler.ProfileUtils;
import profiler.Result;
import profiler.ResultList;

public class ProfileQuery {
    private boolean detailedTime = false;
    private boolean printQueryResults = false;
    private boolean classify = false;
    private boolean realize = false;
    private boolean printQuery = false;
    private boolean sizeEstimateAll = false;
    private int maxIteration = 1;
    private Timers timers = new Timers();
    private JenaLoader loader = new JenaLoader();
    private OntModel model = null;
    private ResultList<String> results = new ResultList(1, 8);

    public boolean isPrintQuery() {
        return this.printQuery;
    }

    public void setPrintQuery(boolean printQuery) {
        this.printQuery = printQuery;
    }

    public boolean isClassify() {
        return this.classify;
    }

    public void setClassify(boolean classify) {
        this.classify = classify;
    }

    public boolean isRealize() {
        return this.realize;
    }

    public void setRealize(boolean realize) {
        this.realize = realize;
    }

    public boolean isPrintQueryResults() {
        return this.printQueryResults;
    }

    public void setPrintQueryResults(boolean quiet) {
        this.printQueryResults = quiet;
    }

    public boolean isDetailedTime() {
        return this.detailedTime;
    }

    public void setDetailedTime(boolean detailedTime) {
        this.detailedTime = detailedTime;
    }

    public boolean isSizeEstimateAll() {
        return this.sizeEstimateAll;
    }

    public void setSizeEstimateAll(boolean sizeEstimateAll) {
        this.sizeEstimateAll = sizeEstimateAll;
    }

    public int getMaxIteration() {
        return this.maxIteration;
    }

    public void setMaxIteration(int maxIteration) {
        this.maxIteration = maxIteration;
    }

    public void profile(String[] dataset, String queryset) throws Exception {
        Timer t = null;
        String dataName = dataset[0];
        Map<String, Query> queries = this.readQueries(queryset);
        KnowledgeBase kb = this.loadData(dataset);
        double parseTime = (double)this.timers.getTimerTotal("parse") / 1000.0;
        double consTime = (double)this.timers.getTimerTotal("consistency") / 1000.0;
        double classifyTime = 0.0;
        double realizeTime = 0.0;
        double sizeEstimateTime = 0.0;
        if (this.isSizeEstimateAll()) {
            t = this.timers.startTimer("sizeEstimateAll");
            kb.getSizeEstimate().computeAll();
            t.stop();
        }
        System.out.println("Parsing/Loading  : " + parseTime);
        System.out.println("Consistency      : " + consTime);
        if (this.isClassify()) {
            classifyTime = (double)this.timers.getTimerTotal("classify") / 1000.0;
            System.out.println("Classify         : " + classifyTime);
        }
        if (this.isRealize()) {
            realizeTime = (double)this.timers.getTimerTotal("realize") / 1000.0;
            System.out.println("Realize         : " + realizeTime);
        }
        if (this.isSizeEstimateAll()) {
            sizeEstimateTime = (double)this.timers.getTimerTotal("sizeEstimateAll") / 1000.0;
            System.out.println("Size Estimate   : " + sizeEstimateTime);
        }
        double totalSetupTime = consTime + sizeEstimateTime + classifyTime + realizeTime;
        System.out.println("Total Setup      : " + totalSetupTime);
        for (int i = 0; i < this.maxIteration; ++i) {
            System.out.println("\n\n\nITERATION: " + (i + 1) + "\n\n\n");
            ArrayList currResult = new ArrayList();
            currResult.add(new Result<String>("consistency", consTime));
            if (this.isClassify()) {
                currResult.add(new Result<String>("classify", classifyTime));
            }
            if (this.isRealize()) {
                currResult.add(new Result<String>("realize", realizeTime));
            }
            if (this.isSizeEstimateAll()) {
                currResult.add(new Result<String>("estimate", sizeEstimateTime));
            }
            for (Map.Entry<String, Query> entry : queries.entrySet()) {
                String queryName = entry.getKey();
                Query query = entry.getValue();
                if (queries.size() > 1) {
                    System.out.println("Query: " + queryName);
                }
                if (this.printQuery) {
                    System.out.println(query);
                }
                t = this.timers.startTimer("query");
                QueryExecution queryExec = SparqlDLExecutionFactory.create((Query)query, (Model)this.model);
                ResultSet queryResults = queryExec.execSelect();
                ResultSetMem resultMem = new ResultSetMem(queryResults);
                int count = resultMem.size();
                t.stop();
                double queryTime = (double)t.getLast() / 1000.0;
                if (this.printQueryResults) {
                    ResultSetFormatter.out((ResultSet)resultMem, (PrefixMapping)this.model);
                }
                System.out.println("Query time: " + queryTime);
                System.out.println("Number of results: " + count);
                System.out.println();
                currResult.add(new Result<String>(queryName, queryTime));
            }
            this.results.addResult(dataName, currResult);
            System.out.println("\n\n\nRESULT " + (i + 1) + ":");
            System.out.println("Version: " + VersionInfo.getInstance().getVersionString());
            this.results.print();
        }
        if (this.detailedTime) {
            System.out.println();
            System.out.println("Detailed timing about reasoner internals:");
            kb.timers.print();
        }
    }

    public KnowledgeBase loadData(String[] dataset) throws Exception {
        Timer t = this.timers.startTimer("parse");
        this.loader.parse(dataset);
        this.model = this.loader.getModel();
        System.out.println();
        System.out.println("Triples        : " + this.model.getBaseModel().size());
        t.stop();
        KnowledgeBase kb = this.loader.getKB();
        t = this.timers.startTimer("load");
        this.model.prepare();
        t.stop();
        ProfileUtils.printCounts(kb);
        t = this.timers.startTimer("consistency");
        kb.isConsistent();
        t.stop();
        ProfileUtils.printCounts(kb.getABox());
        if (this.classify) {
            t = this.timers.startTimer("classify");
            kb.classify();
            t.stop();
        }
        if (this.realize) {
            t = this.timers.startTimer("realize");
            kb.realize();
            t.stop();
        }
        return kb;
    }

    public Map<String, Query> readQueries(String loc) throws Exception {
        LinkedHashMap<String, Query> queries = new LinkedHashMap<String, Query>();
        Collection files = FileUtils.getFileURIsFromRegex((String[])new String[]{loc});
        System.out.print("Parsing (" + files.size() + ") query files...");
        for (String queryFile : files) {
            String queryName = ProfileUtils.formatFileName(queryFile, 10);
            String queryStr = FileUtils.readURL((URL)new URL(queryFile));
            Query query = QueryFactory.create((String)queryStr);
            queries.put(queryName, query);
            System.out.print(".");
        }
        System.out.println("done.");
        return queries;
    }

    public static void usage() {
        System.out.println("PelletQuery");
        System.out.println("");
        System.out.println("Profile the query answering time on a set of datasets. For each");
        System.out.println("daaset, data is loaded once and then all queries are");
        System.out.println("executed consecutively.");
        System.out.println("");
        System.out.println("usage: java ProfileQuery OPTIONS ");
        System.out.println("  -p            Print the query before printing answers");
        System.out.println("  -n            Print only the number of answers not the actual answers");
        System.out.println("  -t            Print detailed time information");
        System.out.println("  -c            Classify the KB before answering queries.");
        System.out.println("  -r            Classify and realize all the instances");
        System.out.println("  {-h,-help}    Print this information");
    }

    public int parseArgs(String[] args) throws Exception {
        LongOpt[] longopts = new LongOpt[7];
        longopts[0] = new LongOpt("help", 0, null, 104);
        longopts[1] = new LongOpt("print-query", 0, null, 113);
        longopts[1] = new LongOpt("print-results", 0, null, 82);
        longopts[3] = new LongOpt("timing", 0, null, 116);
        longopts[4] = new LongOpt("classify", 0, null, 99);
        longopts[4] = new LongOpt("realize", 0, null, 114);
        longopts[5] = new LongOpt("estimate-all", 0, null, 101);
        longopts[6] = new LongOpt("max-iteration", 1, null, 109);
        Getopt g = new Getopt(ProfileKB.class.toString(), args, "hqRtcrem:", longopts);
        try {
            int c;
            block13: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 104: {
                        ProfileQuery.usage();
                        System.exit(0);
                    }
                    case 113: {
                        this.setPrintQuery(true);
                        continue block13;
                    }
                    case 82: {
                        this.setPrintQueryResults(true);
                        continue block13;
                    }
                    case 116: {
                        this.setDetailedTime(true);
                        continue block13;
                    }
                    case 99: {
                        this.setClassify(true);
                        continue block13;
                    }
                    case 114: {
                        this.setClassify(true);
                        this.setRealize(true);
                        continue block13;
                    }
                    case 101: {
                        this.setSizeEstimateAll(true);
                        continue block13;
                    }
                    case 109: {
                        this.setMaxIteration(Integer.parseInt(g.getOptarg()));
                        continue block13;
                    }
                    case 63: {
                        ProfileUtils.error("The option '" + (char)g.getOptopt() + "' is not valid");
                    }
                }
                ProfileUtils.error("Unrecognized option: " + (char)c);
            }
        }
        catch (NumberFormatException e) {
            ProfileUtils.error("Invalid number: " + e);
        }
        return g.getOptind();
    }

    public static void main(String[] args) throws Exception {
        try {
            ProfileQuery profiler = new ProfileQuery();
            int nextArg = profiler.parseArgs(args);
            BufferedReader in = new BufferedReader(new FileReader(args[nextArg]));
            String line = null;
            while ((line = in.readLine()) != null && line.length() > 0) {
                String[] dataset = line.split(" ");
                String queries = in.readLine();
                profiler.profile(dataset, queries);
            }
            MemUtils.runGC();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

