/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.rdfxml;

import com.clarkparsia.pellint.rdfxml.RDFModel;
import java.io.OutputStream;
import java.net.URI;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;

public class RDFModelWriter {
    private static final String ANON_URI = "#anon";
    private static final URI TMP_URI = URI.create("tag:clarkparsia.com,2008:pellint:tmp");

    private static String toString(RDFNode v) {
        if (v.isLiteral()) {
            return ((Literal)v).getLexicalForm();
        }
        if (v.isAnon()) {
            return ANON_URI + v.asNode().getBlankNodeLabel();
        }
        return ((Resource)v).getURI();
    }

    public void write(OutputStream out, RDFModel m) {
        Model model = ModelFactory.createDefaultModel();
        for (Statement stmt : m.getStatements()) {
            model.add(stmt);
        }
        model.write(out);
    }
}

