/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.rdfxml;

import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.rdf.model.Statement;

public class RDFLints {
    private Map<String, List<String>> m_Report = new LinkedHashMap<String, List<String>>();
    private List<Statement> m_MissingStatements = CollectionUtil.makeList();

    public void add(String category, List<String> msgs) {
        if (!msgs.isEmpty()) {
            this.m_Report.put(category, msgs);
        }
    }

    public void addMissingStatements(List<Statement> stmts) {
        this.m_MissingStatements.addAll(stmts);
    }

    public List<Statement> getMissingStatements() {
        return this.m_MissingStatements;
    }

    public boolean isEmpty() {
        return this.m_Report.isEmpty();
    }

    public String toString() {
        if (this.m_Report.isEmpty()) {
            return "No RDF lints found.";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.m_Report.entrySet()) {
            String category = entry.getKey();
            List<String> msgs = entry.getValue();
            if (msgs.isEmpty()) continue;
            builder.append("[").append(category).append("]\n");
            for (String msg : msgs) {
                builder.append("- ").append(msg).append("\n");
            }
            builder.append("\n");
        }
        return builder.toString();
    }
}

